
#define ExtLinkBody_MaxLength (256)

#define ExtLinkBody_ID (0x30545845) // EXT0

static void AssignGBAGlobals_From_MoonShell2_ExtLink(void)
{
  SetARM9_REG_WaitCR();
  
  consolePrintf("Start disk driver.\n");
  
  if(FAT_InitFiles()==false){
    consolePrintf("DLDI init error.\n");
    ShowLogHalt();
  }
  
  static char FullAlias[256];
  
  {
    const char *pfn="/moonshl2/extlink.dat";
    FILE *pf=FAT_fopen(pfn,"r");
    if(pf==NULL){
      consolePrintf("File not found. [%s]\n",pfn);
      ShowLogHalt();
    }
    
    u32 ID;
    u32 idsize=FAT_fread(&ID,1,4,pf);
    if((idsize==0)||(ID==0)){
      consolePrintf("Please call this application from MoonShell2 by way of the extend link. [%s]\n",pfn);
      ShowLogHalt();
    }
    if(ExtLinkBody_ID!=ID){
      consolePrintf("Extend link file ID error. (0x%08x!=0x%08x)\n",ExtLinkBody_ID,ID);
      ShowLogHalt();
    }
    
    u32 Dummy;
    FAT_fread(Dummy,1,4,pf);
    FAT_fread(Dummy,1,4,pf);
    FAT_fread(Dummy,1,4,pf);
    
    FAT_fseek(pf,16,SEEK_SET);
    FAT_fread(FullAlias,1,256,pf);
    FAT_fclose(pf);
  }
  
  u8 *pnesrombuf=NULL;
  u32 nesromsize=0;
  
  {
    const char *pfn=FullAlias;
    consolePrintf("ROM : %s\n",pfn);
    FILE *pf=FAT_fopen(pfn,"r");
    if(pf==NULL){
      consolePrintf("File not found. [%s]\n",pfn);
      ShowLogHalt();
    }
    FAT_fseek(pf,0,SEEK_END);
    nesromsize=FAT_ftell(pf);
    FAT_fseek(pf,0,SEEK_SET);
    pnesrombuf=malloc(nesromsize);
    consolePrintf("Size: %dbyte. (%dkbits)\n",nesromsize,nesromsize*8/1024);
    if(pnesrombuf==NULL){
      consolePrintf("NES rom buffer overflow.\n");
      ShowLogHalt();
    }
    if(FAT_fread(pnesrombuf,1,nesromsize,pf)!=nesromsize){
      consolePrintf("ROM read error.\n");
      ShowLogHalt();
    }
    FAT_fclose(pf);
  }
  
  AssignGBAGlobals(FullAlias,nesromsize,pnesrombuf);
}


