#if ENABLE_PDF
#include <memory_fz.h>
#include <memory_ft2.h>
//#include <memory_jpeg.h>
#endif

#include <DrvMemMgr.h>
#include <debugoff.h>
#include "MemMgr.h"

#define MEM_FREE_FORCE 			1 //Ƿǿͷй¶ڴ
#define MEM_DEMO 				0//ӡڴй¶ͷ


//-----------------------------------------
//ڴй¶ر
//-----------------------------------------
static unsigned int mem_argc[MEM_ID_MAX];//ڴܴ
static unsigned int mem_free_argc[MEM_ID_MAX];//ͷڴܴ
static unsigned int mem_all[MEM_ID_MAX];//ڴ
static unsigned int mem_free_all[MEM_ID_MAX];//ͷڴ
#if MEM_DEMO
static unsigned int mem_argc_left[MEM_ID_MAX]; //ʣûͷŵڴ
static unsigned int mem_left[MEM_ID_MAX]; //ʣûͷŵڴ
#endif

int mem_effective = 1;

static MEM_ST *mem_first[MEM_ID_MAX];
static MEM_ST *mem_cur[MEM_ID_MAX];


int MEMM( unsigned int size,void* buffer, void* (*my_malloc)(int n), int id );
int MEMR( unsigned int size,void* buffer_old, void* buffer_new, void* (*my_malloc)(int n), int id );
int MEMF( void* buffer, void (*myfree)(void*), int id );


 
int mem_con_init( int id )
{
	mem_effective = 0;

//	for( i=0; i<MEM_ID_MAX; i++ )
	{
		mem_argc[id] = 0;//ڴܴ
	 	mem_free_argc[id] = 0;//ͷڴܴ
		mem_all[id] = 0;//ڴ
	 	mem_free_all[id] = 0;//ͷڴ

#if MEM_DEMO
		mem_argc_left[id] = 0;
		mem_left[id] = 0;
#endif

		mem_first[id] = (MEM_ST*)malloc_pdf( sizeof( MEM_ST ) );

		mem_first[id]->size   = 0;
		mem_first[id]->buffer = 0;
		mem_first[id]->next   = 0;
		mem_cur[id] = mem_first[id];
		if( mem_cur[id] == 0 )
		{
			dprintf( "\n\n++mem_con_init err: %s,%s,%d\n", __FILE__, __FUNCTION__, __LINE__ );
			return -1;
		}
	}
	mem_effective = 1;
	return 0;
}


int mem_con_init_all( void )
{
	int i;

#if ENABLE_PDF
	mem_con_init( PDF_MEM_ID );
	dprintf( "\n\n" );
	mem_con_init( FT2_MEM_ID );
	dprintf( "\n\n" );
	mem_con_init( JPEG_MEM_ID );
#endif

	for( i=0; i<MEM_ID_MAX; i++ )
	{

	}
	return 0;
}

#if MEM_DEMO
extern void mem_demo( int id )
{
	dprintf( "\n\n-----------------------------------------------------\n" );
	dprintf( "mem_argc[%d] = %d\n", id, mem_argc[id] );
	dprintf( "mem_free_argc[%d] = %d\n",id, mem_free_argc[id] );
	dprintf( "mem_all[%d] = %d\n", id, mem_all[id] );
	dprintf( "mem_free_all[%d] = %d\n", id, mem_free_all[id] );
	dprintf( "-----------------------------------------------------\n\n" );
}

extern void mem_demo_all( int id )
{
	mem_demo( id );

	MEM_ST *mem_curp = mem_first[id];

	int j = 0;
	mem_left[id] = 0;
	mem_argc_left[id] = 0;
	while( mem_curp )
	{
		if( mem_curp->buffer != 0 )
		{
			mem_left[id] += mem_curp->size;
			dprintf( "%08X ", mem_curp->buffer );
			if( (j+1)%8 == 0 )
				dprintf( "\n" );
			j++;
		}
		mem_curp = mem_curp->next;
	}

	mem_argc_left[id] = mem_argc[id] - mem_free_argc[id];

	dprintf("\n\n     mem_left[%d]  = %d", id, mem_left[id] );
	dprintf(  "\nmem_argc_left[%d]  = %d", id, mem_argc_left[id] );
	dprintf( "\n-----------------------------------------------------\n\n" );
}
#endif

extern void mem_con_free_force( void(*my_free)(void*), int id )
{
#if MEM_DEMO
	int i = 0;
#endif
	MEM_ST *mem_curp = mem_first[id];

	while( mem_curp )
	{
		if( mem_curp->buffer != 0 )
		{
			mem_effective = 0;
			MEMF( (void*)mem_curp->buffer, my_free, id );
			mem_effective = 1;
#if MEM_DEMO
			dprintf( "%08X ", mem_curp->buffer );
			if( ++i%8 == 0 )
				dprintf( "\n" );
#endif
		}
		mem_curp = mem_curp->next;
	}
#if MEM_DEMO
	dprintf( "\n" );
#endif
}


//static
void mem_con_free( void (*my_free)(void*), int id )
{
	dprintf( "\n\nstep0: mem_con_free_force\n\n" );
#if MEM_FREE_FORCE
	mem_con_free_force( my_free, id  );
#endif

#if MEM_DEMO
	dprintf( "\n\nstep1: mem_demo_all\n\n" );
	mem_demo_all( id );
#endif

	dprintf( "\n\nstep2: release mem_first and mem_cur\n\n" );
//	int i;
	mem_effective = 0;
//	for( i=0; i<MEM_ID_MAX; i++ )
	{
		if( mem_first[id] )
		{
			if( mem_first[id] == mem_cur[id] )
			{
//				my_free( mem_first[id] );
				free_pdf( mem_first[id] );//ǰķ亯malloc_pdfӦ(ȱݣmem_first[id]ģģmy_malloc䣬亯ͬһʱ)
				mem_effective = 1;
				return;
//				continue;
			}
			else
			{
//				my_free( mem_first[id] );
					free_pdf( mem_first[id] );//ǰķ亯malloc_pdfӦ(ȱݣmem_first[id]ģģmy_malloc䣬亯ͬһʱ)
			}
			mem_first[id] = 0;
		}
		if( mem_cur[id] )
		{
//			my_free( mem_cur[id] );
			free_pdf( mem_first[id] );//ǰķ亯malloc_pdfӦ(ȱݣmem_first[id]ģģmy_malloc䣬亯ͬһʱ)
			mem_cur[id] = 0;
		}
	}
	mem_effective = 1;
}

extern void mem_con_free_all( void )
{
#if ENABLE_PDF
	mem_con_free( fz_free, PDF_MEM_ID );
	dprintf( "\n\n" );
	mem_con_free( ft_sfree2, FT2_MEM_ID );
	dprintf( "\n\n" );
//	mem_con_free( jpeg_free2, JPEG_MEM_ID );
#endif
}

int MEMM( unsigned int size,void* buffer, void* (*my_malloc)(int n), int id )
{
	if( !buffer )
		return -2;
	mem_all[id] += size;

	if( mem_first[id] == 0 )
	{
		mem_effective = 0;
		mem_first[id] = (MEM_ST*)my_malloc( sizeof( MEM_ST ) );
		mem_effective = 1;
		mem_cur[id] = mem_first[id];
		if( mem_first[id] == 0 )
		{
			dprintf( "\n\n++malloc mem_first err: %s,%s,%d\n", __FILE__, __FUNCTION__, __LINE__ );
			return -1;
		}
	}

	if( mem_cur[id] == 0 )
	{
		mem_effective = 0;
		mem_cur[id] = (MEM_ST*)my_malloc( sizeof( MEM_ST ) );
		mem_effective = 1;
		if( mem_cur[id] == 0 )
		{
			dprintf( "\n\n++malloc mem_cur err: %s,%s,%d\n", __FILE__, __FUNCTION__, __LINE__ );
			return -1;
		}
		mem_cur[id]->size   = 0;
		mem_cur[id]->buffer = 0;
		mem_cur[id]->next   = 0;
	}

	mem_cur[id]->size = (unsigned int)size;
	mem_cur[id]->buffer = (unsigned int)buffer;

	mem_effective = 0;
	mem_cur[id]->next = (MEM_ST*)my_malloc( sizeof( MEM_ST ) );
	mem_effective = 1;
	mem_cur[id] = mem_cur[id]->next;
	mem_cur[id]->size   = 0;
	mem_cur[id]->buffer = 0;
	mem_cur[id]->next   = 0;


	mem_argc[id]++;
//	dprintf( "\n\nmem_argc = %d\n\n", mem_argc[id] );
	return 0;
}

int MEMR( unsigned int size,void* buffer_old, void* buffer_new, void* (*my_malloc)(int n), int id )
{
	if( /*!buffer_old || */!buffer_new  )//Ϊbuffer_oldпΪ0
		return -2;

	unsigned int i = 0;
	if( buffer_old )
	{
		MEM_ST *mem_curp = mem_first[id];
		while( mem_curp )
		{
			if( mem_curp->buffer == (unsigned int)buffer_old )
			{
				mem_all[id] -= mem_curp->size;
				mem_all[id] += size;

				mem_curp->size = size;
				mem_curp->buffer = (unsigned int)buffer_new;
				break;
			}
			mem_curp = mem_curp->next;
		}

		if( !mem_curp )
		{
			dprintf( "\nsize = %d", size );
			dprintf( "\n\n++realloc err: %s,%s,%d: %08X %08X\n", __FILE__, __FUNCTION__, __LINE__, buffer_old, buffer_new );

			//----------Ѿڴ------------
#if MEM_DEMO
			mem_demo( id );
#endif
			mem_curp = mem_first[id];
			i = 0;
			while( mem_curp )
			{
				dprintf( "%08X ",mem_curp->buffer );
				if( (i+1)%8 == 0 )
					dprintf( "\n" );
				i++;
				mem_curp = mem_curp->next;
			}
//			while( 1 );
			return -1;
		}
	}
	else //൱һµڴ
	{
			mem_cur[id]->size = (unsigned int)size;
			mem_cur[id]->buffer = (unsigned int)buffer_new;

			mem_effective = 0;
			mem_cur[id]->next = (MEM_ST*)my_malloc( sizeof( MEM_ST ) );
			mem_effective = 1;
			mem_cur[id] = mem_cur[id]->next;
			mem_cur[id]->size   = 0;
			mem_cur[id]->buffer = 0;
			mem_cur[id]->next   = 0;

			mem_argc[id]++;
	}
	return 0;
}

int MEMF( void* buffer, void (*myfree)(void*), int id )
{
	if( !buffer )
		return -2;
	unsigned int i = 0;

	MEM_ST *mem_curp = mem_first[id];
	MEM_ST *mem_pre = mem_first[id];
	while( mem_curp )
	{
		if( mem_curp->buffer == (unsigned int)buffer )
		{
			mem_free_all[id] += mem_curp->size;

			if( mem_curp == mem_first[id] )
			{
				mem_first[id] = mem_curp->next;
			}
			else
			{
				mem_pre->next = mem_curp->next;
			}
			mem_effective = 0;
			myfree( mem_curp );
			mem_effective = 1;
			break;
		}
		mem_pre = mem_curp;
		mem_curp = mem_curp->next;
	}
	if( !mem_curp )
	{
			dprintf( "\n\n++free err: %s,%s,%d: %08X\n", __FILE__, __FUNCTION__, __LINE__, buffer );

			//----------Ѿڴ------------
#if MEM_DEMO
			mem_demo( id );
#endif

			mem_curp = mem_first[id];
			i = 0;
			while( mem_curp )
			{
				dprintf( "%08X ",mem_curp->buffer );
				if( (i+1)%8 == 0 )
					dprintf( "\n" );
				i++;
				mem_curp = mem_curp->next;
			}
//			while( 1 );
			return -1;
		}
	else
	{
		mem_free_argc[id]++;//ͷڴܴ
//		dprintf( "\n\nmem_free_argc = %d\n\n", mem_free_argc[id] );
	}
	return 0;
}
