#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>
#include <font.h>
#include <scene.h>
#include <FontSet.h>
#include <BacklightSet.h>
#include <ReadingMode.h>
#include <MainMenuSettings.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <SettingsFrame.h>
#include <FontSet.h>
#include <strsafe.h>
#include <language.h>
#include <debugoff.h>
 
enum{
	ITEM_START	= 0,
	BRIGHTNESS_BAR_ID = 0,
	LANGUAGE_BAR_ID,
	ITEM_MAX 	= LANGUAGE_BAR_ID,
	ITEM_INVALID,
};

#undef		BAR_COUNT
#define		BAR_COUNT					5

#define		ITEM_COUNT					2//ֱ֧ʱΪ3
#define		ALL_MASK_BIT				0x0003

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

static char *lang_title_str = NULL;
static char *lang_item_str[ITEM_COUNT];

#define		MENU_ITEM_SPACE_BACKLIGHT	(MENU_ITEM_SPACE+20)

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
U32 BacklightSet( BACKLIGHT_s *backlight )
{
	U32 RetValue = 0;

	U8	 brightness = backlight->brightness;//
//	U8	 BacklightUp = backlight->BacklightUp;//
//	U8	 BacklightDown = backlight->BacklightDown;//

	pixel ScreenBuf[SCREEN_W * SCREEN_H];

	byte  *TextValue[ITEM_COUNT];
	POS ItemPos[ITEM_COUNT];
	AJUST_KEY_BUF AjustKey;
	KEY_BUF inputkey;
	int result;

	int x,y;
	U16 key;

	int i;
	int SelectBar = 0;
	int SelectBar_old = 0;

	U16 mask;
	U16 maskFocus;

	int cur_lang_index;

	if( (config.cur_lang_index >=0) && (config.cur_lang_index < SUPPORT_LANG_MAX_COUNT) )
	{
		cur_lang_index = config.cur_lang_index;
	}
	else
	{
		config.cur_lang_index = LANG_INDEX_EN;
		cur_lang_index = LANG_INDEX_EN;
	}

	DrawSettingsFrame( true );
	MenuKeyHintDraw( 0 );

	SaveVram( ScreenBuf, DOWN_SCREEN );

	lang_title_str = lang_item[LANG_BRIGHTNESS_TITLE_ID];

	i = 0;
	lang_item_str[i++] = lang_item[LANG_BRIGHTNESS_ID];
	lang_item_str[i++] = lang_item[LANG_LANGUAGE_ID];

//	x = MENU_ITEM_RECT_X + MENU_ITEM_BAR_OFFSET_X;
	x = 0;
	y = MENU_ITEM_RECT_Y + MENU_ITEM_BAR_OFFSET_Y;
	for( i = 0; i < ITEM_COUNT; i++ )
	{
		ItemPos[i].x =  x;
		ItemPos[i].y =  y;
		y += MENU_ITEM_SPACE_BACKLIGHT;
	}

	mask = ALL_MASK_BIT;
	maskFocus = BIT( 0 );
	i = 0;
	TextValue[i++] = &brightness;
	TextValue[i++] = (byte*)lang_item[LANG_LANG0_ID+cur_lang_index];

	BacklightSetDraw(  mask, maskFocus, (const byte **)TextValue );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	Flush( DOWN_SCREEN );

	while ( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_START )
				SelectBar = ITEM_MAX;
			else
				SelectBar--;
		}
		else if( key == KEY_DOWN )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_MAX )
				SelectBar = ITEM_START;
			else
				SelectBar++;
		}
		else if( key == KEY_LEFT )
		{
			SelectBar_old = SelectBar;
			switch( SelectBar )
			{
				case BRIGHTNESS_BAR_ID:

					if( brightness	<= BRIGHTNESSVALUE_MIN )
						brightness = BRIGHTNESSVALUE_MAX;
					else
						brightness--;

					break;

				case LANGUAGE_BAR_ID:

					if( cur_lang_index <= 0 )
						cur_lang_index = SUPPORT_LANG_MAX_COUNT-1;
					else
						cur_lang_index--;

					break;

				default:
					break;
			}
		}
		else if( key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			switch( SelectBar )
			{
				case BRIGHTNESS_BAR_ID:

					if( brightness	>= BRIGHTNESSVALUE_MAX )
						brightness = BRIGHTNESSVALUE_MIN;
					else
						brightness++;

					break;

				case LANGUAGE_BAR_ID:

					if( cur_lang_index >= (SUPPORT_LANG_MAX_COUNT-1) )
						cur_lang_index = 0;
					else
						cur_lang_index++;

					break;

				default:
					break;
			}
		}
		else if( key == KEY_A )
		{
			if( brightness != backlight->brightness )
			{
				backlight->brightness = brightness;
				RetValue = bmBRIGHTNESS;
			}
#if 0
			if( BacklightUp != backlight->BacklightUp || BacklightDown != backlight->BacklightDown )
			{
				backlight->BacklightUp = BacklightUp;
				backlight->BacklightDown = BacklightDown;
				RetValue |= bmBACKLIGHT;
			}
#endif

			if( cur_lang_index != config.cur_lang_index )
			{
				config.cur_lang_index = cur_lang_index;
				Curlang_config_save( config.cur_lang_index );
				conf_save( &config );//ñ޸,
				language_free();
				language_load_utf8();

				RetValue |= bmLANGUAGE;
			}

			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_B )
		{
 			RetValue = 0;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = 0; i < ITEM_COUNT; i++ )
			{
				AjustKey.Min_x = ItemPos[i].x;
				AjustKey.Max_x = AjustKey.Min_x + SCREEN_W - 1;

				AjustKey.Min_y = ItemPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + MENU_ITEM_BAR_LOGO_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					SelectBar_old = SelectBar;

					SelectBar = i;
					key = KEY_TOUCH | KEY_A;
					break;
				}
			}
		}
		else if( key == KEY_L )
		{
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) )
		{
			i = 0;
			if( SelectBar_old == SelectBar )
			{
				mask = BIT( SelectBar );
				i = 0;
				TextValue[i++] = &brightness;
				TextValue[i++] = (byte*)lang_item[LANG_LANG0_ID+cur_lang_index];
			}
			else
			{
				LoadVram( ScreenBuf, DOWN_SCREEN );
				mask = ALL_MASK_BIT;
				maskFocus = BIT( SelectBar );
				i = 0;
				TextValue[i++] = &brightness;
				TextValue[i++] = (byte*)lang_item[LANG_LANG0_ID+cur_lang_index];
			}
			BacklightSetDraw( mask, maskFocus, (const byte **)TextValue );
			Flush( DOWN_SCREEN );
		}
	}

	return RetValue;
}

void BacklightSetDraw( U16 mask,  U16 maskFocus, const byte **ItemValue )
{
	int i;
	int x,y,w;
	int x0,y0;
	byte str[2];

	char ItemStr[20];
	pixel *Vram = GetVram( DOWN_SCREEN );
	int x_adjust = 0;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif
	int need_redraw = maskFocus & ALL_MASK_BIT;
	int fontCoding_type = GetlanguageCodingType();

	if( need_redraw )//»Ʊ
	{
		w = CB_text_get_string_width_sys( (const byte*)lang_title_str, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		x = ( SCREEN_W - w ) >> 1;
		TextOut( x, MENU_TITLE_Y, (const byte*)lang_title_str, MENU_TITLE_FCOLOR, DOWN_SCREEN );

		TextOut( MENU_ITEM_RECT_X+MENU_ITEMNAME_OFFSET_X - 5+CONFIG_FONTW_SYS/2, MENU_ITEM_RECT_Y+MENU_ITEM_RECT_H, (const byte*)lang_item[LANG_BRIGHTNESS_NOTE_ID], MENU_TITLE_FCOLOR, DOWN_SCREEN );
	}


	x = MENU_ITEM_RECT_X;
	y = MENU_ITEM_RECT_Y;
	for( i=0; i<ITEM_COUNT; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				FillRect( x, y, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
				bitBltFC( LArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_LARROW_OFFSET_X, y + MENU_LARROW_OFFSET_Y, COLOR_GREEN );
				bitBltFC( RArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_RARROW_OFFSET_X, y + MENU_RARROW_OFFSET_Y, COLOR_GREEN );
			}

			if( need_redraw )
			{
				SPRINTF_S( ItemStr, "%d.", i + 1 );
#if USE_UNICODE_FONTLIB
				memset( ucs2, 0x00, 8 );
				utf8_ucs2( ItemStr, ucs2 );
				TextOut( x + MENU_ITEMNAME_OFFSET_X - 5, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)ucs2, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
				x_adjust = CONFIG_FONTW_SYS;
#else
				TextOut( x + MENU_ITEMNAME_OFFSET_X - 5, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)ItemStr, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
#endif
				TextOut( x + MENU_ITEMNAME_OFFSET_X - 5 + x_adjust, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)lang_item_str[i], MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );

			}

			bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x + MENU_ITEM_BAR_OFFSET_X, y + MENU_ITEM_BAR_OFFSET_Y );

			y0 = y + MENU_ITEM_BAR_OFFSET_Y + ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) / 2;
			if( i == 0 )
			{
				intToString( (char *)str, 2, ItemValue[i][0] );
				x0 = x + MENU_ITEM_BAR_OFFSET_X + MENU_ITEM_BAR_LOGO_W / 2 - ( DISP_FONTSIZE >> 2 );
#if USE_UNICODE_FONTLIB
				memset( ucs2, 0x00, 8 );
				utf8_ucs2( str, ucs2 );
				CB_putnstringhorz_sys( x0, y0, 0, (const byte *)ucs2, INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#else
				CB_putnstringhorz_sys( x0, y0, 0, (const byte *)str, INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
			}
			else if( i == 1 )
			{
				w = CB_text_get_string_width_sys( (const byte *)ItemValue[i], 0, CONFIG_FONTW_SYS, fontCoding_type );
				x0 = x + MENU_ITEM_BAR_OFFSET_X + ( MENU_ITEM_BAR_LOGO_W - w ) / 2;
				CB_putnstringhorz_sys( x0, y0, 0, (const byte *)ItemValue[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
			}
			else
			{
				break;
			}
		}

		y += MENU_ITEM_SPACE_BACKLIGHT;
		mask >>= 1;
		maskFocus >>= 1;
	}
}
