#include <BookmarkSet.h>
#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>
#include <fs_api.h>
#include <scene.h>
#include <scene_text.h>
#include <bookmark.h>
#include <MainMenuSettings.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <text.h>
#include <strsafe.h>
#include <FontSet.h>
#include "SettingsFrame.h"
#include <strsafe.h>
#include <language.h>
#include <debugoff.h>

static char *lang_title_str = NULL;
static char *lang_item_str[2];
static char *lang_item_str_Del[2];
static char *lang_msg_str[3];

#define				DISPLAY_BM_ID					1
#define				DISPLAY_BM_PERCENTAGE			1
#define				SUPPORT_DELETE_BM				1

#undef  	ITEM_COUNT
#define		ITEM_COUNT			2

static pixel *ManageBarbak = NULL;
static pixel *DelRectBarbak = NULL;
static pixel *SlideBufBm = NULL;
static pixel *SlideBufBarBm = NULL;

int BookmarkManage( BMSETTINGS_s *bmsettings, BOOL needp_LR )
{
#if SUPPORT_DELETE_BM
	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;

	int i;
	int result = 0;
	int RetValue = -3;//-12L Rռ,>=0к
	U16 key;
	int SelectBar = 0;
	int SelectBar_old = 0;
	int x,y;
	POS ItemPos[ITEM_COUNT];

	U16 mask;
	U16 maskFocus;

	pixel *screenbuf = NULL;

	DrawSettingsFrame( needp_LR );
	MenuKeyHintDraw( 0 );

	i = 0;
	lang_item_str[i++] = lang_item[LANG_ADDBM_ID];
	lang_item_str[i++] = lang_item[LANG_VIEWBMLIST_ID];

	i = 0;
	lang_item_str_Del[i++] = lang_item[LANG_DELETE_ID];
	lang_item_str_Del[i++] = lang_item[LANG_DELETEALL_ID];

	lang_title_str = lang_item[LANG_BM_TITLE_ID];

	x = MENU_ITEM_RECT_X + MENU_ITEM_BAR_OFFSET_X;
	y = MENU_ITEM_RECT_Y + MENU_ITEM_BAR_OFFSET_Y;
	for( i = 0; i < ITEM_COUNT; i++ )
	{
		ItemPos[i].x =  x;
		ItemPos[i].y =  y;
		y += MENU_ITEM_SPACE;
	}

	mask = 0x03;
	maskFocus = 0;
	BookmarkManageDraw( mask, maskFocus );

	mask 	  = BIT( SelectBar );
	maskFocus = BIT( SelectBar );
	BookmarkManageDraw( mask, maskFocus );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ADD_BM )
				SelectBar = LOOK_BM;
			else
				SelectBar = ADD_BM;
		}
		else if( key == KEY_A )
		{
_BM_KEY_OK_PRESS:
			if( !screenbuf )
				screenbuf = memalign( sizeof( pixel ), SCREEN_W * SCREEN_H * sizeof( pixel ) );
			if( screenbuf )
			{
				SaveVram( screenbuf, DOWN_SCREEN );
			}
			if( SelectBar == ADD_BM )
			{
				bookmark_Manualsave( bmsettings->bm_name, bmsettings->row );
			}
			{
				result = Bookmak_list( bmsettings->bm_name );
				if( result >= 0 )//к
				{
					RetValue = result;
					goto _BookmarkManage_Exit;
				}
			}

			if( screenbuf )
			{
				LoadVram( screenbuf, DOWN_SCREEN );
			}
			else
			{
				DrawSettingsFrame( needp_LR );
				MenuKeyHintDraw( 0 );

				mask = 0x03;
				maskFocus = 0;
				BookmarkManageDraw( mask, maskFocus );

				mask 	  = BIT( SelectBar );
				maskFocus = BIT( SelectBar );
				BookmarkManageDraw( mask, maskFocus );
			}
			Flush( DOWN_SCREEN );
			continue;
		}
		else if( key == KEY_B )
		{
			RetValue = -3;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = 0; i < ITEM_COUNT; i++ )
			{
				AjustKey.Min_x = ItemPos[i].x;
				AjustKey.Max_x = AjustKey.Min_x + MENU_ITEM_BAR_LOGO_W;

				AjustKey.Min_y = ItemPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + MENU_ITEM_BAR_LOGO_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					if( SelectBar != i )
					{
						SelectBar_old = SelectBar;
						SelectBar = i;

						mask = BIT( SelectBar ) | ( BIT( SelectBar_old ) << 8 );
						maskFocus = BIT( SelectBar );
						BookmarkManageDraw( mask, maskFocus );
						Flush( DOWN_SCREEN );
					}

					key = KEY_TOUCH | KEY_A;
					goto _BM_KEY_OK_PRESS;
				}
			}
		}
		else if( key == KEY_L )
		{
			if( needp_LR == false )
				continue;
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			if( needp_LR == false )
				continue;

			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_Y )
		{
			if( needp_LR == true )
				continue;
			RetValue = -3;
			break;
		}
		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) )
		{
			mask = BIT( SelectBar ) | ( BIT( SelectBar_old ) << 8 );
			maskFocus = BIT( SelectBar );
			BookmarkManageDraw( mask, maskFocus );
			Flush( DOWN_SCREEN );
		}
	}
#endif

_BookmarkManage_Exit:

	if( screenbuf )
	{
		free( screenbuf );
	}

	if( ManageBarbak )
	{
		free( ManageBarbak );
		ManageBarbak = NULL;
	}

	if( DelRectBarbak )
	{
		free( DelRectBarbak );
		DelRectBarbak = NULL;
	}

	return RetValue;
}

void BookmarkManageDraw( U16 mask,  U16 maskFocus )
{
	int i;
	int x,y;
	int x0,y0;
	int w = 0;
	int w1 = 0;

	char ItemStr[2][24];
	pixel *Vram = GetVram( DOWN_SCREEN );
	BOOL FirstDrawFlag = false;
	U16 maskTemp;
	const byte *pStr[2] = {NULL,NULL};
#if USE_UNICODE_FONTLIB
	byte ucs2[2][8];
#endif

	int fontCoding_type = GetlanguageCodingType();

	if( mask == 0 )
		return;

	if( ManageBarbak == NULL )
	{
		ManageBarbak = memalign( sizeof( pixel ), sizeof( pixel ) * MENU_ITEM_RECT_W * MENU_ITEM_RECT_H );
	}

	if( mask == 0x03 )
		FirstDrawFlag = true;

	if( FirstDrawFlag )//»Ʊ
	{
		w = CB_text_get_string_width_sys( (const byte*)lang_title_str, 0, CONFIG_FONTW_SYS, fontCoding_type );
		x = ( SCREEN_W - w ) >> 1;
		CB_putnstringhorz_sys( x, MENU_TITLE_Y, 0, (const byte *)lang_title_str, INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
	}

	if( FirstDrawFlag == false && ManageBarbak != NULL )
	{
		maskTemp = mask;
		maskTemp >>= 8;
		x = MENU_ITEM_RECT_X;
		y = MENU_ITEM_RECT_Y;
		for( i=0; i<2; i++ )
		{
			if( maskTemp == 0 )
				break;
			if( maskTemp & 0x1 )
			{
				bitBlt1( ManageBarbak, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, Vram, SCREEN_W, SCREEN_H, x, y );
			}
			maskTemp >>= 1;
			y += MENU_ITEM_SPACE;
		}
	}

	for( i=0; i<2; i++ )
	{
		SPRINTF_S( ItemStr[i], "%d.", i + 1 );
#if USE_UNICODE_FONTLIB
		memset( ucs2[i], 0x00, 8 );
		utf8_to_ucs( ucs2[i], 8, (const byte*)ItemStr[i], INVALID_LEN );
		pStr[i] = (byte*)ucs2[i];
#else
		pStr[i] = (byte*)ItemStr[i];
#endif
	}

	w1 = CB_text_get_string_width_sys( (const byte*)pStr[0], 0, CONFIG_FONTW_SYS, fontCoding_type );
	w = CB_text_get_string_width_sys( (const byte*)pStr[1], 0, CONFIG_FONTW_SYS, fontCoding_type );

	w1 += CB_text_get_string_width_sys( (const byte*)lang_item_str[0], 0, CONFIG_FONTW_SYS, fontCoding_type );
	w += CB_text_get_string_width_sys( (const byte*)lang_item_str[1], 0, CONFIG_FONTW_SYS, fontCoding_type );

	w = MAX( w, w1 );

	x0 = ( SCREEN_W - MENU_ITEM_BAR_LOGO_W ) >> 1;//
	x = MENU_ITEM_RECT_X;
	y = MENU_ITEM_RECT_Y;
	for( i=0; i<2; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				//
				if( ManageBarbak )
					bitBlt2( Vram, SCREEN_W, SCREEN_H, x, y, ManageBarbak, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, 0, 0 );

				//ػ
				FillRect( x, y, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
			}
			bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x0, y + MENU_ITEM_BAR_OFFSET_Y );

			y0 = y + MENU_ITEM_BAR_OFFSET_Y + ( ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) >> 1 );

			CB_putnstringhorz_sys( x0 + (( MENU_ITEM_BAR_LOGO_W - w ) >> 1), y0, 0, (const byte *)pStr[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
			CB_putnstringhorz_sys( x0 + (( MENU_ITEM_BAR_LOGO_W - w ) >> 1) + CONFIG_FONTW_SYS, y0, 0, (const byte *)lang_item_str[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
		}

		y += MENU_ITEM_SPACE;
		mask >>= 1;
		maskFocus >>= 1;
	}
}


//------------------------------------------------------
//------------------------------------------------------
void DrawBookmarkManageFrame()
{
	int x,w;

	DrawSettingsFrame( false );

	w = CB_text_get_string_width_sys( (const byte*)lang_title_str, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
	x = ( SCREEN_W - w ) >> 1;
	CB_putnstringhorz_sys( x, MENU_TITLE_Y, 0, (const byte *)lang_title_str, INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
}


void DrawBmSlide( dword index, dword count, SCREEN_ID engine  )//
{
	int y0;
	pixel *Vram = GetVram( engine );

	if( count >= 2 )
	{
		y0 = BM_SLIDE_Y + (BM_SLIDE_MAX_Y - BM_SLIDE_Y) * index / (count-1);
	}
	else
	{
		y0 = BM_SLIDE_Y;
	}

	if( SlideBufBarBm )
		bitBlt1( SlideBufBarBm, BM_SLIDEBAR_W, BM_SLIDEBAR_H, Vram, SCREEN_W, SCREEN_H, BM_SLIDEBAR_X, BM_SLIDEBAR_Y );

	if( SlideBufBm )
		bitBlt1( SlideBufBm, BM_SLIDE_W, BM_SLIDE_H, Vram, SCREEN_W, SCREEN_H, BM_SLIDE_X, y0 );
}



#undef  	BTN_COUNT2
#define		BTN_COUNT2			3

//------------------------------------------------------
//ʧܣ-2
//Aǩıڵк
//B-1
//------------------------------------------------------
int Bookmak_list( char *bookmarkname )
{
	pixel *Vram = GetVram( DOWN_SCREEN );
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	int result = -2;
	int i,j;
	int count = 0;

	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	U16 key;

	int x,y,w;
	U32 index = 0, topindex, botindex;
	U32 max_height = BM_ITEM_COUNT;
	BOOL needrp = true;
	BOOL needrp_bg = true;//ػ
	pixel Bgcolor,Textcolor;

	POS MenuPos[BM_ITEM_COUNT];
	char str[20];
	const char str_bm_empty[] = "Bookmark empty!";
	p_textrow *TextRow = NULL;
	p_bookmark bm = NULL;
	p_bookmark cur_bm = NULL;
	p_bookmark_dis dis_bm = NULL;
	p_textrow tr = NULL;
	RTC rtc;
	BOOL FirstEnter = true;
#if USE_UNICODE_FONTLIB
#define			BUFFER_LEN			256
	U16 buffer[BUFFER_LEN>>1];
	byte *pstr = NULL;
	int outLen = 0;
#endif

	i = 0;
	lang_msg_str[i++] = lang_item[LANG_BM_JUMP_ID];
	lang_msg_str[i++] = lang_item[LANG_BM_RETURN_ID];
	lang_msg_str[i++] = lang_item[LANG_BM_DEL_ID];

	for( i=0; i<BM_ITEM_COUNT; i++ )
	{
		MenuPos[i].x = 0;
		MenuPos[i].y = BM_LINE_RECT_START_Y + i *  BM_LINE_RECT_H;
	}
	bm = bookmark_Lookup( bookmarkname );
	if( bm == NULL )
	{
		if( lang_item[LANG_BM_EMPTY_ID] )
		{
			pstr = (byte*)lang_item[LANG_BM_EMPTY_ID];
		}
		else
		{
			pstr = (byte*)str_bm_empty;
		}
		DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char*)pstr, DOWN_SCREEN, MB_OK | MB_CANCEL, TRUE );
		result = -2;
		goto _Bookmakeset_Exit;
	}

//---------------------------------------ͻ-------------------------------------------------------
	result = image_read_sys( CONFIG_BMSLIDEBAR, fs_file_get_type( CONFIG_BMSLIDEBAR ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		SlideBufBarBm = memalign( sizeof( pixel ), sizeof( pixel ) * width * height );
		if( SlideBufBarBm )
			bitBlt( imgdata, width, height, SlideBufBarBm, width, height );//ݻ
	}
	result = image_read_sys( CONFIG_BMSLIDE, fs_file_get_type( CONFIG_BMSLIDE ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		SlideBufBm = memalign( sizeof( pixel ), sizeof( pixel ) * width * height );
		if( SlideBufBm )
			bitBlt( imgdata, width, height, SlideBufBm, width, height );//ݻ
	}

	if( imgdata )
	{
		free((void *) imgdata);
		imgdata = NULL;
	}

	index = 0;//index: ѡ
	topindex = 0;

_Bookmark_ReDraw:
	count = 0;
	cur_bm = bm;
	while( cur_bm )
	{
		for( i = 0; i < BM_GROUP_INDEX_MAX_COUNT; i++ )
		{
			if( cur_bm->row[i] != 0xFFFFFFFF )
			{
				count++;
			}
		}
		cur_bm = cur_bm->next;
	}

	if( count == 0 )
	{
		//ʾ
		if( lang_item[LANG_BM_EMPTY_ID] )
		{
			pstr = (byte*)lang_item[LANG_BM_EMPTY_ID];
		}
		else
		{
			pstr = (byte*)str_bm_empty;
		}
		DrawMessageBox( lang_Notice, CENTER_ALIGN, pstr, DOWN_SCREEN, MB_OK | MB_CANCEL, TRUE );

		result = -2;
		goto _Bookmakeset_Exit;
	}
	else
	{
		if( dis_bm == NULL )
		{
			dis_bm = (p_bookmark_dis) malloc( sizeof(t_bookmark_dis) * count );
			if( dis_bm == NULL )
				goto _Bookmakeset_Exit;
		}
	}

	if( TextRow == NULL )
	{
		TextRow = (p_textrow*)malloc( count * sizeof( t_bm_index ) );
		if( TextRow )
		{
			for( i = 0; i < count; i++ )
				TextRow[i] = 0;
		}
		else
		{
			result = -2;
			goto _Bookmakeset_Exit;
		}
	}

	j = count - 1;
	cur_bm = bm;
	while( cur_bm )
	{
		for( i = 0; i < BM_GROUP_INDEX_MAX_COUNT && j >= 0; i++ )
		{
			if( cur_bm->row[i] != 0xFFFFFFFF )
			{
				dis_bm[j].row = cur_bm->row[i];//ʾ
				dis_bm[j].bmtime = cur_bm->bmtime[i];
				j--;
			}
		}
		cur_bm = cur_bm->next;
	}
	if( bm->row[0] != 0xFFFFFFFF )//ԶλǷλк
	{
		for( i = 0; i < count-1; i++ )
		{
			if( dis_bm[i].row == bm->row[BM_AUTO_SAVE_POSITION] )
			{
				count--;
				break;
			}
		}
	}

	for( i=j=0; i < count; i++ )
	{
		tr = scene_book_LookupBuffer( dis_bm[i].row );
		if( tr != NULL )
		{
			TextRow[j++] = tr;
		}
	}

	count = j;

	max_height = MIN( max_height, count );

	if( index >= count )
		index = count - 1;

	if( count <= max_height )//count:Ŀ
	{
		topindex = 0;
		botindex = count - 1;
	}
	else
	{
		botindex = topindex + max_height - 1;
		if( botindex >= count )
		{
			botindex = count - 1;
			topindex = botindex + 1 - max_height;
		}
	}
	while ( 1 )
	{
		if( needrp_bg )
		{
			DrawBookmarkManageFrame();
			needrp_bg = false;

#define		KEY_START_X		38
#define		KEY_BANK		55
			y = 170;
			x = KEY_START_X;
			result = image_read_sys( CONFIG_AKEY, fs_file_get_type( CONFIG_AKEY ), &width, &height, &imgdata, &bgc );
			if( result == 0 )
			{
				bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );//
			}

			x += KEY_BANK;
			result = image_read_sys( CONFIG_BKEY, fs_file_get_type( CONFIG_BKEY ), &width, &height, &imgdata, &bgc );
			if( result == 0 )
			{
				bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );//
			}

			x += KEY_BANK;
			result = image_read_sys( CONFIG_XKEY, fs_file_get_type( CONFIG_XKEY ), &width, &height, &imgdata, &bgc );
			if( result == 0 )
			{
				bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );//
			}

			x = KEY_START_X;
			for( i = 0; i < 3; i++ )
			{
				w = CB_text_get_string_width_sys( (const byte*)lang_msg_str[i], 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
				CB_putnstringhorz_sys( x - w - 2, y, 0, (const byte *)lang_msg_str[i], INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
				x += KEY_BANK;
			}

			if( imgdata )
			{
				free((void *) imgdata);
				imgdata = NULL;
			}
		}

		if( needrp ) //--------------ػǰѡ֮е
		{
			y = BM_LINE_RECT_START_Y;
			for ( i = topindex; i <= botindex; i++ )
			{
				if (i == index)
				{
					Bgcolor = BM_BAR_BG_COLOR_FOCUS;
					Textcolor = BM_TEXT_COLOR_FOCUS;
				}
				else
				{
					Bgcolor = BM_BAR_BG_COLOR;
					Textcolor = BM_TEXT_COLOR;
				}

				FillRect( BM_LINE_RECT_START_X, y, BM_LINE_RECT_W, BM_LINE_RECT_H, Bgcolor, DOWN_SCREEN );

#if DISPLAY_BM_ID
				if( config.cur_lang_index == LANG_INDEX_CN )
				{
					SPRINTF_S( str, "ǩ%d:", count - 1 - i );
#if USE_UNICODE_FONTLIB
					gbk_to_ucs_Fast( buffer, BUFFER_LEN, (const byte*)str, INVALID_LEN );
#endif
				}
				else if( config.cur_lang_index == LANG_INDEX_TW )
				{
					SPRINTF_S( str, "`%d:", count - 1 - i );
#if USE_UNICODE_FONTLIB
					gbk_to_ucs_Fast( buffer, BUFFER_LEN, (const byte*)str, INVALID_LEN );
#endif
				}
				else //if( config.cur_lang_index == LANG_INDEX_EN )
				{
					SPRINTF_S( str, "BM%d:", count - 1 - i );
#if USE_UNICODE_FONTLIB
					utf8_to_ucs_Fast( buffer, BUFFER_LEN, (const byte*)str, INVALID_LEN );
#endif
				}
#if USE_UNICODE_FONTLIB
				CB_putnstringhorz_sys( BM_ID_TEXT_X, y + BM_ID_TEXT_OFFSET_Y, 0, (const byte *)buffer, INVALID_LEN, BM_BAR_STATICTEXT_COLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#else
				CB_putnstringhorz_sys( BM_ID_TEXT_X, y + BM_ID_TEXT_OFFSET_Y, 0, (const byte *)str, INVALID_LEN, BM_BAR_STATICTEXT_COLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
#endif
				rtc = bookmark_timetran( dis_bm[i].bmtime );
				ShowDateTime(  &rtc, 75, y + BM_PERCENTAGE_OFFSET_Y, BM_BAR_STATICTEXT_COLOR, font_in_book, DOWN_SCREEN, false, 0, '.' );
#if DISPLAY_BM_PERCENTAGE
				DisplayPercentage( scene_book_GetPercentage( scene_book_WordToRow( dis_bm[i].row ), ROWMODE ), BM_PERCENTAGE_X, y + BM_PERCENTAGE_OFFSET_Y, BM_BAR_STATICTEXT_COLOR, DOWN_SCREEN  );
#endif

#if USE_UNICODE_FONTLIB
				pstr = (byte*)buffer;
				outLen = BUFFER_LEN;
				Proc_Fontdecode( &pstr, &outLen, (const byte *)(TextRow[i]->start), (int)TextRow[i]->count );
#else
				pstr = (byte *)TextRow[i]->start;
				outLen = (int)TextRow[i]->count;
#endif
				CB_putnstringhorz_sys( BM_TEXT_X, y + BM_TEXT_OFFSET_Y, config.wordspace, (const byte *)pstr, outLen, Textcolor, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );

				FillRect( BM_LINE_SEPERATOR_X, y + BM_LINE_SEPERATOR_OFFSET_Y, BM_LINE_SEPERATOR_W, BM_LINE_SEPERATOR_H, BM_LINE_SEPERATOR_COLOR, DOWN_SCREEN );

				y += BM_LINE_H;
			}
#if 1
			i = botindex - topindex + 1;//ǩ
			y = BM_LINE_RECT_START_Y + i * BM_LINE_H;//׼ַ
			for( ; i < BM_ITEM_COUNT; i++ )//ǩСBM_ITEM_COUNT,ҪػĿ
			{
				FillRect( BM_LINE_RECT_START_X, y, BM_LINE_RECT_W, BM_LINE_RECT_H, BM_BAR_BG_COLOR, DOWN_SCREEN );
				FillRect( BM_LINE_SEPERATOR_X, y + BM_LINE_SEPERATOR_OFFSET_Y, BM_LINE_SEPERATOR_W, BM_LINE_SEPERATOR_H, BM_LINE_SEPERATOR_COLOR, DOWN_SCREEN );
				y += BM_LINE_H;
			}
#endif
			DrawBmSlide( index, count, DOWN_SCREEN );

			needrp = false;
		}

		Flush( DOWN_SCREEN );

		if( FirstEnter == true )
		{
			FirstEnter = false;
			ctrl_waitrelease_anykey();
		}


		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_DOWN )
		{
			if( index == (count-1) )
				index = 0;
			else
				index++;
		}
		else if( key == KEY_UP )
		{
			if( index == 0 )
				index = count - 1;
			else
				index--;
		}
		else if ( key == KEY_LEFT )
		{
			if (index < max_height - 1)
				index = 0;
			else
				index -= max_height - 1;
		}
		else if ( key == KEY_RIGHT )
		{
			if (index + (max_height - 1) >= count)
				index = count - 1;
			else
				index += max_height - 1;
		}
		else if( key == KEY_A )
		{
_BMLIST_PROCESS_KEY_OK_PRESS:
			result = scene_book_WordToRow( dis_bm[index].row );
			break;
		}
		else if( key == KEY_B )
		{
			result = -1;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷѡ״̬
			AjustKey.Min_x = BM_SLIDEBAR_X - 10;
			AjustKey.Min_y = BM_SLIDEBAR_Y;
			AjustKey.Max_x = SCREEN_W - 1;
			AjustKey.Max_y = BM_SLIDE_MAX_Y;

			result = CheckValidxy( AjustKey, inputkey );
			if( result == 0 )
			{
				if( inputkey.y > BM_SLIDE_MAX_Y )
					inputkey.y = BM_SLIDE_MAX_Y;

				i = (inputkey.y - BM_SLIDE_Y) * (count - 1) / (BM_SLIDE_MAX_Y - BM_SLIDE_Y);

				if( i >= 0 && i < count )
				{
					index = i;
					needrp = true;
					goto _BOOKMAK_LIST_NEXT;
				}
			}

			//жǷѡĳһ
			for( i = 0; i < BM_ITEM_COUNT; i++ )
			{
				AjustKey.Min_x = MenuPos[i].x;
				AjustKey.Max_x = MenuPos[i].x + BM_LINE_RECT_W - 10;

				AjustKey.Min_y = MenuPos[i].y;
				AjustKey.Max_y = MenuPos[i].y + BM_LINE_RECT_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					if( topindex + i <= botindex )
					{
						index = topindex + i;
						goto _BMLIST_PROCESS_KEY_OK_PRESS;
					}
				}
			}
		}
#if 	SUPPORT_DELETE_BM
		else if( key == KEY_X )
		{
			result = Bookmark_DelInterface( bm, dis_bm[index].row, DEL_BM );
			if( result == 0 )//ȡ
			{
				needrp = true;
			}
			else if( result == 1 )//ɾɹ
			{
				needrp = true;
				goto _Bookmark_ReDraw;
			}
			else if( result == 2 )//ȫɾ
			{
				//ʾڣʾǩΪ
				count = 0;
				result = -2;
				goto _Bookmakeset_Exit;
			}
		}
#endif
		else
		{
			continue;
		}
_BOOKMAK_LIST_NEXT:

		if ( index > botindex )
		{
			botindex = index;
			topindex = botindex - max_height + 1;
		}
		else if (index < topindex)
		{
			topindex = index;
			botindex = topindex + max_height - 1;
		}

		needrp = true;
	}

_Bookmakeset_Exit:
	if( SlideBufBarBm )
	{
		free( SlideBufBarBm );
		SlideBufBarBm = NULL;
	}

	if( SlideBufBm )
	{
		free( SlideBufBm );
		SlideBufBm = NULL;
	}

	if( dis_bm )
	{
		free( dis_bm );
		dis_bm = NULL;
	}

	if( TextRow )
		free( (void*)TextRow );

	bookmark_close(bm);

	return result;
}

extern dword Bookmark_encode( const char *filename )
{
	register dword h;

	for (h = 5381; *filename != 0; ++filename)
	{
		h += h << 5;
		h ^= *filename;
	}
	return h;
}

void Bookmark_Init( const char *fn )//ʼǩļÿļӦһǩļ
{
	FILE *fp = fopen( fn, "rb" );
	if(  fp == NULL )
	{
		fp = fopen( fn, "wb" );
		if( fp )
		{
			fclose( fp );
		}
	}
	else
	{
		fclose( fp );
	}
}

#define			MENU_NUM_DISTANCE			1
void DisplayPercentage( U16 percentage, int x, int y, pixel color, SCREEN_ID engine )//ʾٷֱ
{
#if !DISPLAY_BM_PERCENTAGE
	return;
#endif

	U8  Percentage_p1;//ٷֱ
	U8  Percentage_p2;//ٷֱС
	char str[6];
	int i;
	int n = 0;
	int fontw,fonth;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif

	if( font_in_book == false )
	{
		fontw = CONFIG_FONTW_SYS;
		fonth = CONFIG_FONTH_SYS;
	}
	else
	{
		fontw = DISP_BOOK_FONTSIZE;
		fonth = DISP_BOOK_FONTSIZE;
	}

	Percentage_p1 = percentage / 100;//
	Percentage_p2 = percentage % 100 / 10;//С

	if( Percentage_p1 == 100 )
	{
		dwordToString( (char *)(str), 4, Percentage_p1 );
		n += 3;
	}
	else
	{
		if( Percentage_p1 < 10 )
		{
			dwordToString( (char *)(str+n), 2, Percentage_p1 );
			n++;
		}
		else
		{
			dwordToString( (char *)(str), 3, Percentage_p1 );
			n += 2;
		}
		str[n++] = '.';
		if( Percentage_p2 == 0 )
		{
			str[n++] = '0';
		}
		else
		{
			dwordToString( (char *)( str + n ), 2, Percentage_p2 );
			n++;
		}
	}
	str[n++] = '%';
	str[n++] = '\0';
	for( i = 0; i < n; i++ )
	{
#if USE_UNICODE_FONTLIB
		memset( ucs2, 0x00, 8 );
		utf8decode( str+i, ucs2 );
		CB_disp_putcharhorz( x, y,  fontw, fonth, (const byte *)ucs2, color, engine );
#else
		CB_disp_putcharhorz( x, y,  fontw, fonth, (const byte *)(str+i), color, engine );
#endif
		x += (DISP_FONTSIZE >> 1) + MENU_NUM_DISTANCE;
	}
}


#undef		BAR_COUNT
#define		BAR_COUNT					2

//-------------------------------------------------------------------
//أ0:ȡɾ
//		1:ɾĿ
//		2:ȫɾ
//		-1ɾʧ/ȡӻ鿴ǩ
//-------------------------------------------------------------------
int Bookmark_DelInterface( p_bookmark bm, U32 row, int SelectBar )
{
#if SUPPORT_DELETE_BM
	int result = 0;
	U16 key;
	int logo_x = -1,logo_y = -1;
	int x0,y0;
	int x1,y1;
	int i;

	int SelectBar_old = SelectBar;
	U16 mask,maskFocus;

	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	POS BarPos[BAR_COUNT];

	if( bm == NULL && ( SelectBar != DEL_BM && SelectBar != DELALL_BM ) )
		return 0;

	DrawMessageBox( lang_Notice, CENTER_ALIGN, "", DOWN_SCREEN, MB_OK | MB_CANCEL, false );

	mask = 0x03;
	maskFocus = 0;
	BookmarkDelDraw( mask, maskFocus );

	mask = BIT( 0 );
	maskFocus = BIT( 0 );
	BookmarkDelDraw( mask, maskFocus );

//	Flush( DOWN_SCREEN );
//	while( 1 );

	logo_x = MSG_X;
	logo_y = MSG_Y;

	x0 = logo_x + ( HINT2_BG_RECT_W - MENU_SETTINGS_BAR_W ) / 2;
	y0 = logo_y + 30;

	x1 = x0;
	y1 = y0 + 30;

	i = 0;
	BarPos[i].x = x0;
	BarPos[i++].y = y0;

	BarPos[i].x = x1;
	BarPos[i++].y = y1;

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( key );

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == DEL_BM )
				SelectBar = DELALL_BM;
			else if( SelectBar == DELALL_BM )
				SelectBar = DEL_BM;
		}
		else if( key == KEY_A )
		{
			ctrl_waitrelease( key );
_KEY_OK_PRESS_DEL:
			if( SelectBar == DEL_BM )
			{
				if( bookmark_deleteOp( bm, row ) >= 0 )//ɾɹ
				{
					return 1;
				}
				else
				{
					//ɾʧܣʾ
					return -1;
				}
			}
			else if( SelectBar == DELALL_BM )
			{
				if( bookmark_deleteAll( bm ) == 1 )//ɾɹ
				{
					return 2;
				}
				else
				{
					//ɾʧܣʾ
					return -1;
				}
			}
		}
		else if( key == KEY_B )
		{
_EXIT_PROCESS_DEL:
			ctrl_waitrelease( key );
			if( SelectBar == DEL_BM || SelectBar == DELALL_BM )
				return 0;
		}
		else if( key == KEY_TOUCH )
		{
			ctrl_waitrelease( key );
			AjustKey.Min_x = BM_CLOSE_MIN_X;
			AjustKey.Min_y = BM_CLOSE_MIN_Y;
			AjustKey.Max_x = BM_CLOSE_MAX_X;
			AjustKey.Max_y = BM_CLOSE_MAX_Y;

			if( !CheckValidxy( AjustKey, inputkey ) )//ر
			{
				goto _EXIT_PROCESS_DEL;
			}

			//жǷĸѡ
			for( i = 0; i < BAR_COUNT; i++ )
			{
				AjustKey.Min_x = BarPos[i].x;
				AjustKey.Max_x = BarPos[i].x + MENU_SETTINGS_BAR_W;

				AjustKey.Min_y = BarPos[i].y;
				AjustKey.Max_y = BarPos[i].y + MENU_SETTINGS_BAR_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
//					SelectBar_old = SelectBar;
					SelectBar = i;
					key = KEY_TOUCH | KEY_A;
					goto _KEY_OK_PRESS_DEL;
				}
			}
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) )
		{
			mask = BIT( SelectBar ) | ( BIT( SelectBar_old ) << 8 );
			maskFocus = BIT( SelectBar );
			BookmarkDelDraw( mask, maskFocus );
			Flush( DOWN_SCREEN );
		}
	}
#endif
	return -1;
}

void BookmarkDelDraw( U16 mask,  U16 maskFocus )
{
	int i;
	int x,y;
	int x0,y0;
	int w,w1;

	char ItemStr[2][20];
	pixel *Vram = GetVram( DOWN_SCREEN );
	BOOL FirstDrawFlag = false;
	U16 maskTemp;
	int fontCoding_type = GetlanguageCodingType();
	const byte *pStr[2] = {NULL,NULL};
#if USE_UNICODE_FONTLIB
	byte ucs2[2][8];
#endif

	if( mask == 0 )
		return;

	if( DelRectBarbak == NULL )
	{
		DelRectBarbak = memalign( sizeof( pixel ), sizeof( pixel ) * MSG_ITEM_RECT_W * MSG_ITEM_RECT_H );
	}

	if( mask == 0x03 )
		FirstDrawFlag = true;

	if( FirstDrawFlag == false && DelRectBarbak != NULL )
	{
		maskTemp = mask;
		maskTemp >>= 8;
		x = MSG_ITEM_RECT_X;
		y = MSG_ITEM_RECT_Y;
		for( i=0; i<2; i++ )
		{
			if( maskTemp == 0 )
				break;
			if( maskTemp & 0x1 )
			{
				bitBlt1( DelRectBarbak, MSG_ITEM_RECT_W, MSG_ITEM_RECT_H, Vram, SCREEN_W, SCREEN_H, x, y );
			}
			maskTemp >>= 1;
			y += MSG_ITEM_SPACE;
		}
	}

	for( i=0; i<2; i++ )
	{
		SPRINTF_S( ItemStr[i], "%d.", i + 1 );
#if USE_UNICODE_FONTLIB
		memset( ucs2[i], 0x00, 8 );
		utf8_to_ucs( ucs2[i], 8, (const byte*)ItemStr[i], INVALID_LEN );
		pStr[i] = (byte*)ucs2[i];
#else
		pStr[i] = (byte*)ItemStr[i];
#endif
	}

	w1 = CB_text_get_string_width_sys( (const byte*)pStr[0], 0, CONFIG_FONTW_SYS, fontCoding_type );
	w = CB_text_get_string_width_sys( (const byte*)pStr[1], 0, CONFIG_FONTW_SYS, fontCoding_type );

	w1 += CB_text_get_string_width_sys( (const byte*)lang_item_str_Del[0], 0, CONFIG_FONTW_SYS, fontCoding_type );
	w += CB_text_get_string_width_sys( (const byte*)lang_item_str_Del[1], 0, CONFIG_FONTW_SYS, fontCoding_type );

	w = MAX( w, w1 );

	x = MSG_ITEM_RECT_X;
	y = MSG_ITEM_RECT_Y;
	for( i=0; i<2; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				//
				if( DelRectBarbak )
					bitBlt2( Vram, SCREEN_W, SCREEN_H, x, y, DelRectBarbak, MSG_ITEM_RECT_W, MSG_ITEM_RECT_H, 0, 0 );

				//ػ
				FillRect( x, y, MSG_ITEM_RECT_W, MSG_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
			}

			x0 = x + MSG_ITEM_BAR_OFFSET_X;//
			y0 = y + MSG_ITEM_BAR_OFFSET_Y;
			bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x0, y0 );

			y0 += ( ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) >> 1 );

			CB_putnstringhorz_sys( x0 + ((MENU_ITEM_BAR_LOGO_W - w) >> 1), y0, 0, (const byte *)pStr[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
			CB_putnstringhorz_sys( x0 + ((MENU_ITEM_BAR_LOGO_W - w) >> 1) + CONFIG_FONTW_SYS, y0, 0, (const byte *)lang_item_str_Del[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
		}

		y += MSG_ITEM_SPACE;
		mask >>= 1;
		maskFocus >>= 1;
	}
}
