#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>
#include <font.h>
#include <scene.h>
#include <FontSet.h>
#include <MainMenuSettings.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <SettingsFrame.h>
#include <strsafe.h>
#include <language.h>
#include <debugoff.h>

static char *lang_item_str[5];
static bool select = false;
static pixel *select_logo_buf = NULL;
static bool stylefcolor_inUse = true;
static bool stylefontbgcolor_inUse = false;

#define		SELECT_LOGO_W 		6
#define		SELECT_LOGO_H 		6


#define		RGB_ITEM_BAR_W ( MENU_ITEM_BAR_LOGO_W/2 - 15 )
#define		RGB_ITEM_BAR_X ( MENU_ITEM_RECT_X + MENU_ITEM_BAR_OFFSET_X )

#define		RGB_ITEM_BAR_X2 (RGB_ITEM_BAR_X+RGB_ITEM_BAR_W+30)


#define		R_LARROW_X ( RGB_ITEM_BAR_X - 3 - MENU_ARROW_LR_W )
#define		R_RARROW_X ( RGB_ITEM_BAR_X + RGB_ITEM_BAR_W + 3 )

#define		R_LARROW_X2 ( RGB_ITEM_BAR_X2 - 3 - MENU_ARROW_LR_W )
#define		R_RARROW_X2 ( RGB_ITEM_BAR_X2 + RGB_ITEM_BAR_W + 3 )

#define		COLOR_BROWSE_W	(RGB_ITEM_BAR_W) //( 30 )
#define		COLOR_BROWSE_H	(MENU_ITEM_BAR_LOGO_H+MENU_ITEM_BAR_LOGO_H/2)//( 30 )
#define		COLOR_BROWSE_X	(RGB_ITEM_BAR_X)//( RGB_ITEM_BAR_X +  RGB_ITEM_BAR_W + 15 )
//#define		COLOR_BROWSE_Y	( MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 3 + ( MENU_ITEM_SPACE_FONT * 2 + MENU_ITEM_BAR_LOGO_H - COLOR_BROWSE_H ) / 2 )
//#define		COLOR_BROWSE_Y	( MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_BAR_OFFSET_Y + MENU_ITEM_SPACE_FONT * 3 + ( MENU_ITEM_SPACE_FONT * 2 + MENU_ITEM_BAR_LOGO_H - COLOR_BROWSE_H ) / 2 )
#define		COLOR_BROWSE_Y	  (MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_BAR_OFFSET_Y + MENU_ITEM_SPACE_FONT * 6)

#define		COLOR_BROWSE_X2  RGB_ITEM_BAR_X2
#define		COLOR_BROWSE_Y2  COLOR_BROWSE_Y

enum
{
	ITEM_START	= 0,
	FONTSIZE_ID = 0,
	ROWSPACE_ID,
	WORDSPACE_ID,
	FONT_RCOLOR_ID,
	FONT_GCOLOR_ID,
	FONT_BCOLOR_ID,
	BG_RCOLOR_ID,
	BG_GCOLOR_ID,
	BG_BCOLOR_ID,
	ITEM_MAX 	= BG_BCOLOR_ID,
	ITEM_INVALID,
};

#define		ITEM_COUNT					9
#define		ALL_MASK_BIT				0x1FF

#define		MENU_ITEM_RECT_Y_FONTSET			(MENU_ITEM_RECT_Y-5)

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
U32 FontSet( FONTSET_s *Font )
{
	U32 RetValue = 0;
	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	POS ItemPos[ITEM_COUNT+2];
	int FontSize;
	int bookfontindex = Font->bookfontindex;
	U8 rowspace = Font->rowspace;
	U8 wordspace = Font->wordspace;
	int fontcolor = Font->fontcolor;
	int fontbgcolor = Font->fontbgcolor;
	pixel ScreenBuf[SCREEN_W * SCREEN_H];
	U16   TextValue[ITEM_COUNT];
	int x,y,y0;
	int result;
	U16 key;

	int i;
	int SelectBar = 0;
	int SelectBar_old = 0;

	U16 mask;
	U16 maskFocus;

	U16 Itemw[2];
	int w;
	int fontCoding_type = GetlanguageCodingType();
	POS select_logo_pos[2];

	stylefcolor_inUse = Font->stylefcolor_inUse;
	stylefontbgcolor_inUse = Font->stylefontbgcolor_inUse;

	U8 font_r,font_g,font_b;
	U8 bg_r,bg_g,bg_b;

	DrawSettingsFrame( true );
	MenuKeyHintDraw( 2 );
	SaveVram( ScreenBuf, DOWN_SCREEN );

	i = 0;
	lang_item_str[i++] = lang_item[LANG_FONTSIZE_ID];
	lang_item_str[i++] = lang_item[LANG_ROWSPACE_ID];
	lang_item_str[i++] = lang_item[LANG_WORDSPAC_ID];
	lang_item_str[i++] = lang_item[LANG_FONTCOLOR_ID];
	lang_item_str[i++] = lang_item[LANG_FONTBGCOLOR_ID];


	x = 0;
	y = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_BAR_OFFSET_Y;

	for( i = 0; i < ITEM_COUNT; i++ )
	{
		ItemPos[i].x =  x;
		ItemPos[i].y =  y;

		if( i == 3 )
		{
			x = MENU_ITEM_RECT_X + MENU_ITEM_BAR_OFFSET_X;
			y0 = y;
		}

		if( i == 5 )
		{
			x = RGB_ITEM_BAR_X2;
			y = y0;
		}
		else
		{
			y += MENU_ITEM_SPACE_FONT;
		}
	}

	w = CB_text_get_string_width_sys( (const byte *)lang_item_str[3], 0, CONFIG_FONTW_SYS, fontCoding_type );
	x = 0;
	y = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 3;

	Itemw[0] = w + CONFIG_FONTW_SYS;
	ItemPos[i].x =  x + MENU_ITEMNAME_OFFSET_X - 4;
	ItemPos[i].y =  y;
	i++;

	w = CB_text_get_string_width_sys( (const byte *)lang_item_str[4], 0, CONFIG_FONTW_SYS, fontCoding_type );
	x = 0;
	y = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 4;
	Itemw[1] = w + CONFIG_FONTW_SYS;
	ItemPos[i].x =  x + MENU_ITEMNAME_OFFSET_X - 4;
	ItemPos[i].y =  y;
	
	select_logo_pos[0].x = 5;
	select_logo_pos[0].y = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEMNAME_OFFSET_Y + MENU_ITEM_SPACE_FONT*3;

	select_logo_pos[1].x = select_logo_pos[0].x;
	select_logo_pos[1].y = select_logo_pos[0].y +  MENU_ITEM_SPACE_FONT;


	font_r = (U8)(fontcolor);
	font_g = (U8)(fontcolor >> 8);
	font_b = (U8)(fontcolor >> 16);

	bg_r = (U8)(fontbgcolor);
	bg_g = (U8)(fontbgcolor >> 8);
	bg_b = (U8)(fontbgcolor >> 16);

	i = 0;
	FontSize = bookfonts[bookfontindex].size;
	TextValue[i++] = FontSize;//ִС
	TextValue[i++] = rowspace;//м
	TextValue[i++] = wordspace;//ּ
	TextValue[i++] = font_r;//ɫ
	TextValue[i++] = font_g;//ɫ
	TextValue[i++] = font_b;//ɫ

	TextValue[i++] = bg_r;//ɫ
	TextValue[i++] = bg_g;//ɫ
	TextValue[i++] = bg_b;//ɫ

	mask = ALL_MASK_BIT;
	maskFocus = 0x01;
	FontSetDraw(  mask, maskFocus, TextValue );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while ( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_START )
				SelectBar = ITEM_MAX;
			else
				SelectBar--;
		}
		else if( key == KEY_DOWN )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_MAX )
				SelectBar = ITEM_START;
			else
				SelectBar++;
		}
		else if( key == KEY_LEFT )
		{
			SelectBar_old = SelectBar;
			switch( SelectBar )
			{
				case FONTSIZE_ID:
					if( bookfontindex <= 0 )
						bookfontindex = bookfontcount-1;
					else
						bookfontindex--;
					FontSize = bookfonts[bookfontindex].size;

					break;

				case ROWSPACE_ID:
					if( rowspace == 0 )
						rowspace = ROWSPACE_MAX;
					else
						rowspace--;

					break;

				case WORDSPACE_ID:
					if( wordspace == 0 )
						wordspace = WORDPACE_MAX;
					else
						wordspace--;

					break;

				case FONT_RCOLOR_ID:
					font_r--;
					break;

				case FONT_GCOLOR_ID:
					font_g--;
					break;

				case FONT_BCOLOR_ID:
					font_b--;
					break;

				case BG_RCOLOR_ID:
					bg_r--;
					break;

				case BG_GCOLOR_ID:
					bg_g--;
					break;

				case BG_BCOLOR_ID:
					bg_b--;
					break;

				default:
					break;
			}
		}
		else if( key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			switch( SelectBar )
			{
				case FONTSIZE_ID:
					if( bookfontindex >= (bookfontcount-1) )
						bookfontindex = 0;
					else
						bookfontindex++;
					FontSize = bookfonts[bookfontindex].size;
					break;

				case ROWSPACE_ID:
					if( rowspace >= ROWSPACE_MAX )
						rowspace = 0;
					else
						rowspace++;
					break;

				case WORDSPACE_ID:
					if( wordspace >= WORDPACE_MAX )
						wordspace = 0;
					else
						wordspace++;
					break;

				case FONT_RCOLOR_ID:
					font_r++;
					break;

				case FONT_GCOLOR_ID:
					font_g++;
					break;

				case FONT_BCOLOR_ID:
					font_b++;
					break;

				case BG_RCOLOR_ID:
					bg_r++;
					break;

				case BG_GCOLOR_ID:
					bg_g++;
					break;

				case BG_BCOLOR_ID:
					bg_b++;
					break;

				default:
					break;
			}
		}
		else if( key == KEY_A )
		{
			ctrl_waitrelease( key );

			//С
			if( bookfontindex != Font->bookfontindex )
			{
				Font->bookfontindex = bookfontindex;
				RetValue |= bmFONTSIZE;
			}

			//м
			if( Font->rowspace != rowspace )
			{
				Font->rowspace = rowspace;
				RetValue |= bmROWSPACE;
			}

			//ּ
			if( Font->wordspace != wordspace )
			{
				Font->wordspace = wordspace;
				RetValue |= bmWORDSPACE;
			}

			//ɫ
			fontcolor = (font_b << 16) | (font_g << 8) | font_r;
			if( Font->fontcolor != fontcolor || stylefcolor_inUse != Font->stylefcolor_inUse )
			{
				Font->stylefcolor_inUse = stylefcolor_inUse;
				Font->fontcolor = fontcolor;
				RetValue |= bmFONTCOLOR;
			}

			//ɫ
			fontbgcolor = (bg_b << 16) | (bg_g << 8) | bg_r;
			if( Font->fontbgcolor != fontbgcolor || stylefontbgcolor_inUse != Font->stylefontbgcolor_inUse )
			{
				Font->stylefontbgcolor_inUse = stylefontbgcolor_inUse;
				Font->fontbgcolor = fontbgcolor;
				RetValue |= bmFONTBGCOLOR;
			}

			break;
		}
		else if( key == KEY_B )
		{
			RetValue = 0;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = 0; i < (ITEM_COUNT+2); i++ )
			{
				if( i < 3 )
				{
					AjustKey.Min_x = ItemPos[i].x;
					AjustKey.Max_x = AjustKey.Min_x + SCREEN_W;
				}
				else if( i < 6 )
				{
					AjustKey.Min_x = RGB_ITEM_BAR_X;
					AjustKey.Max_x = AjustKey.Min_x + RGB_ITEM_BAR_W;
				}
				else if( i < 9 )
				{
					AjustKey.Min_x = RGB_ITEM_BAR_X2;
					AjustKey.Max_x = AjustKey.Min_x + RGB_ITEM_BAR_W;
				}
				else
				{
					AjustKey.Min_x = ItemPos[i].x;
					AjustKey.Max_x = AjustKey.Min_x + Itemw[i-ITEM_COUNT];
				}

				AjustKey.Min_y = ItemPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + MENU_ITEM_BAR_LOGO_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					SelectBar_old = SelectBar;

					if( i == ITEM_COUNT )
						i = 3;
					else if( i == (ITEM_COUNT + 1) )
						i = 6;

					SelectBar = i;
					key = KEY_TOUCH | KEY_A;
					break;
				}
			}

			if( result )
			{
				if( select_logo_buf )
				{
					for( i=0; i<2; i++ )
					{
						AjustKey.Min_x = select_logo_pos[i].x;
						AjustKey.Max_x = AjustKey.Min_x + SELECT_LOGO_W + 4;

						AjustKey.Min_y = select_logo_pos[i].y;
						AjustKey.Max_y = AjustKey.Min_y + SELECT_LOGO_H + 4;
						
						
						AjustKey.Min_x -= 3;
						AjustKey.Max_x += 2;
						
						AjustKey.Min_y -= 3;
						AjustKey.Max_y += 3;
						
						result = CheckValidxy( AjustKey, inputkey );
						if( result == 0 )
						{
							SelectBar_old = SelectBar;
		
							if( i == 0 )
							{	
								i = 3;
								if( stylefcolor_inUse )
									stylefcolor_inUse = 0;
								else
									stylefcolor_inUse = 1;
							}
							else if( i == 1 )
							{	
								i = 6;
								
								if( stylefontbgcolor_inUse )
									stylefontbgcolor_inUse = 0;
								else
									stylefontbgcolor_inUse = 1;
							}
		
							SelectBar = i;
							key = KEY_TOUCH | KEY_A;
							break;
						}
					}
				}
			}
		}
		else if( key == KEY_L )
		{
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_SELECT )
		{
			if( SelectBar == FONT_RCOLOR_ID || SelectBar == FONT_BCOLOR_ID || SelectBar == FONT_GCOLOR_ID )
			{
				if( stylefcolor_inUse )
					stylefcolor_inUse = 0;
				else
					stylefcolor_inUse = 1;
			}
			else if( SelectBar == BG_RCOLOR_ID || SelectBar == BG_BCOLOR_ID || SelectBar == BG_GCOLOR_ID )
			{
				if( stylefontbgcolor_inUse )
					stylefontbgcolor_inUse = 0;
				else
					stylefontbgcolor_inUse = 1;
			}


			ctrl_waitrelease( key );
		}

		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) || key == KEY_SELECT )
		{
			i = 0;
			FontSize = bookfonts[bookfontindex].size;
			TextValue[i++] = FontSize;
			TextValue[i++] = rowspace;
			TextValue[i++] = wordspace;
			TextValue[i++] = font_r;//ɫ
			TextValue[i++] = font_g;//ɫ
			TextValue[i++] = font_b;//ɫ

			TextValue[i++] = bg_r;//ɫ
			TextValue[i++] = bg_g;//ɫ
			TextValue[i++] = bg_b;//ɫ

			if( SelectBar_old == SelectBar )
			{
				mask = BIT( SelectBar );
				maskFocus = 0;
			}
			else
			{
				LoadVram( ScreenBuf, DOWN_SCREEN );
				mask = ALL_MASK_BIT;
				maskFocus = BIT( SelectBar );
			}
			FontSetDraw( mask, maskFocus, TextValue );
			Flush( DOWN_SCREEN );
		}
	}

	return RetValue;
}

void FontSetDraw( U16 mask,  U16 maskFocus, U16 *ItemValue )
{
	int i,j;
	int x,y;
	int x0,y0;
	int Adjust_x = 0;
	char str[ITEM_COUNT][4];
	int   TextBit;
	char ItemStr[16];
	pixel *Vram = GetVram( DOWN_SCREEN );
	int w;
	int x_adjust = 0;
#if USE_UNICODE_FONTLIB
#define		UCS2_BUF_LEN		16
	byte ucs2[UCS2_BUF_LEN];
#endif
	const byte RgbFont[3][2] = { "R", "G", "B" };
	const byte RgbFonts[] = "RGB";

	dword width, height;
	pixel bgc;
	int result;

	int need_redraw = maskFocus & ALL_MASK_BIT;
	int fontCoding_type = GetlanguageCodingType();

#define		RGB_ITEM_SPACE ( MENU_ITEM_SPACE_FONT - 3 )

	if( select_logo_buf == NULL )
	{
		result = image_read_sys( CONFIG_SELECTED, fs_file_get_type( CONFIG_SELECTED ), &width, &height, &select_logo_buf, &bgc );
	}

	if( need_redraw )//»Ʊ
	{
		w = CB_text_get_string_width_sys( (const byte*)lang_item[LANG_FONT_TITLE_ID], 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		x = ( SCREEN_W - w ) >> 1;
		CB_putnstringhorz_sys( x, MENU_TITLE_Y, 0, (const byte *)lang_item[LANG_FONT_TITLE_ID], INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
		
		memset( ucs2, 0x00, UCS2_BUF_LEN );
		utf8_ucs2( RgbFonts, ucs2 );
		CB_putnstringhorz_sys( R_LARROW_X - 5 - (DISP_FONTSIZE+(DISP_FONTSIZE>>1)) + 4, COLOR_BROWSE_Y + ((COLOR_BROWSE_H-DISP_FONTSIZE)>>1), 0, (const byte *)ucs2, INVALID_LEN, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
	}

	x = MENU_ITEM_RECT_X;
	y = MENU_ITEM_RECT_Y_FONTSET;

	FillRect( COLOR_BROWSE_X, COLOR_BROWSE_Y, COLOR_BROWSE_W, COLOR_BROWSE_H, RGB( ItemValue[FONT_RCOLOR_ID], ItemValue[FONT_GCOLOR_ID], ItemValue[FONT_BCOLOR_ID] ), DOWN_SCREEN );
	FillRect( COLOR_BROWSE_X2, COLOR_BROWSE_Y2, COLOR_BROWSE_W, COLOR_BROWSE_H, RGB( ItemValue[BG_RCOLOR_ID], ItemValue[BG_GCOLOR_ID], ItemValue[BG_BCOLOR_ID] ), DOWN_SCREEN );
#if 0
	if( select_logo_buf )
	{
		x0 = COLOR_BROWSE_X + COLOR_BROWSE_W + 20;
		y0 = COLOR_BROWSE_Y + (COLOR_BROWSE_H - SELECT_LOGO_H)/2;
		FillRect( x0 - 2, y0 - 2, SELECT_LOGO_W + 4, SELECT_LOGO_H + 4, COLOR_WHITE, DOWN_SCREEN );
		if( stylefcolor_inUse == false )
			bitBltFC( select_logo_buf, SELECT_LOGO_W, SELECT_LOGO_H, Vram, SCREEN_W, SCREEN_H, x0, y0, COLOR_GREEN );
	}
#else

	if( select_logo_buf )
	{
//		x0 = x + MENU_ITEMNAME_OFFSET_X - 4-SELECT_LOGO_W-5;
		x0 = 5;
		y0 = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEMNAME_OFFSET_Y + MENU_ITEM_SPACE_FONT*3;
		FillRect( x0, y0, SELECT_LOGO_W + 4, SELECT_LOGO_H + 4, COLOR_WHITE, DOWN_SCREEN );
		if( stylefcolor_inUse == false )
			bitBltFC( select_logo_buf, SELECT_LOGO_W, SELECT_LOGO_H, Vram, SCREEN_W, SCREEN_H, x0+2, y0+2, COLOR_GREEN );

		y0 += MENU_ITEM_SPACE_FONT;
		FillRect( x0, y0, SELECT_LOGO_W + 4, SELECT_LOGO_H + 4, COLOR_WHITE, DOWN_SCREEN );
		if( stylefontbgcolor_inUse == false )
			bitBltFC( select_logo_buf, SELECT_LOGO_W, SELECT_LOGO_H, Vram, SCREEN_W, SCREEN_H, x0+2, y0+2, COLOR_GREEN );
	}

#endif

	for( i=0; i<ITEM_COUNT; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				if( i < 3 )
				{
					FillRect( x, y, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
					bitBltFC( LArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_LARROW_OFFSET_X, y + MENU_LARROW_OFFSET_Y, COLOR_GREEN );
					bitBltFC( RArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_RARROW_OFFSET_X, y + MENU_RARROW_OFFSET_Y, COLOR_GREEN );
				}
				else if( i < 6 )
				{
//					FillRect( R_LARROW_X - 5, y, (R_RARROW_X + MENU_ARROW_LR_W + 5) - (R_LARROW_X - 5), MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
					w = CB_text_get_string_width_sys( (const byte *)lang_item_str[3], 0, CONFIG_FONTW_SYS, fontCoding_type );
					y0 = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 3;
					FillRect( x + MENU_ITEMNAME_OFFSET_X - 4, y0, w + CONFIG_FONTW_SYS, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );

					FillRect( x + MENU_ITEM_BAR_OFFSET_X, y, RGB_ITEM_BAR_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
					bitBltFC( LArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, R_LARROW_X, y + MENU_LARROW_OFFSET_Y, COLOR_GREEN );
					bitBltFC( RArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, R_RARROW_X, y + MENU_RARROW_OFFSET_Y, COLOR_GREEN );
				}
				else
				{
//					FillRect( R_LARROW_X - 5, y, (R_RARROW_X + MENU_ARROW_LR_W + 5) - (R_LARROW_X - 5), MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
					w = CB_text_get_string_width_sys( (const byte *)lang_item_str[4], 0, CONFIG_FONTW_SYS, fontCoding_type );
					y0 = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 4;
					FillRect( x + MENU_ITEMNAME_OFFSET_X - 4, y0, w + CONFIG_FONTW_SYS, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );

					FillRect( RGB_ITEM_BAR_X2, y, RGB_ITEM_BAR_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
					bitBltFC( LArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, R_LARROW_X2, y + MENU_LARROW_OFFSET_Y, COLOR_GREEN );
					bitBltFC( RArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, R_RARROW_X2, y + MENU_RARROW_OFFSET_Y, COLOR_GREEN );
				}
			}

//			if( i < 5 )
			{
				if( i < 3 )
				{
					j = i;
				}
				else if( i < 6 )
				{
					j = 3;
				}
				else
				{
					j = 4;
				}

				y0 = j * MENU_ITEM_SPACE_FONT + MENU_ITEM_RECT_Y_FONTSET;
				if( need_redraw )
				{
					SPRINTF_S( ItemStr, "%d.", j + 1 );
#if USE_UNICODE_FONTLIB
					memset( ucs2, 0x00, UCS2_BUF_LEN );
					utf8_ucs2( ItemStr, ucs2 );
					CB_putnstringhorz_sys( x + MENU_ITEMNAME_OFFSET_X - 4, y0 + MENU_ITEMNAME_OFFSET_Y, 0, (const byte *)ucs2, INVALID_LEN, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
					x_adjust = CONFIG_FONTW_SYS;
#endif
					CB_putnstringhorz_sys( x + MENU_ITEMNAME_OFFSET_X - 4 + x_adjust, y0 + MENU_ITEMNAME_OFFSET_Y, 0, (const byte *)lang_item_str[j], INVALID_LEN, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
				}
			}

			if( i >= 3 && i < 6)
			{
#if USE_UNICODE_FONTLIB
				memset( ucs2, 0x00, UCS2_BUF_LEN );
				utf8_ucs2( RgbFont[i-3], ucs2 );
				CB_putnstringhorz_sys( R_LARROW_X - 5 - DISP_FONTSIZE/2 + 4, y + MENU_ITEMNAME_OFFSET_Y, 0, (const byte *)ucs2, INVALID_LEN, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#else
				CB_putnstringhorz_sys( R_LARROW_X - 5 - DISP_FONTSIZE/2 + 4, y + MENU_ITEMNAME_OFFSET_Y, 0, (const byte *)RgbFont[i-3], INVALID_LEN, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
			}

			if( i < 3 )
			{
				bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x + MENU_ITEM_BAR_OFFSET_X, y + MENU_ITEM_BAR_OFFSET_Y );
			}
			else if( i < 6 )
			{
				bitBlt1( MenuBarBg, RGB_ITEM_BAR_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, RGB_ITEM_BAR_X, y + MENU_ITEM_BAR_OFFSET_Y );
			}
			else
			{
				bitBlt1( MenuBarBg, RGB_ITEM_BAR_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, RGB_ITEM_BAR_X2, y + MENU_ITEM_BAR_OFFSET_Y );
			}

//			if( i < 6 )
			{
			if( ItemValue[i] > 99 )
			{
				Adjust_x = (DISP_FONTSIZE >> 1) + (DISP_FONTSIZE >> 2);
				TextBit = 4;
			}
			else if( ItemValue[i] > 9 )
			{
				Adjust_x = DISP_FONTSIZE >> 1;
				TextBit = 3;
			}
			else
			{
				Adjust_x = DISP_FONTSIZE >> 2;
				TextBit = 2;
			}
			if( i < 3 )
				x0 = x + MENU_ITEM_BAR_OFFSET_X + MENU_ITEM_BAR_LOGO_W / 2 - Adjust_x;
			else if( i < 6 )
				x0 = RGB_ITEM_BAR_X + RGB_ITEM_BAR_W / 2 - Adjust_x;
			else
				x0 = RGB_ITEM_BAR_X2 + RGB_ITEM_BAR_W / 2 - Adjust_x;
			y0 = y + MENU_ITEM_BAR_OFFSET_Y + ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) / 2;

			intToString( (char *)str[i], TextBit, ItemValue[i] );
#if USE_UNICODE_FONTLIB
			memset( ucs2, 0x00, UCS2_BUF_LEN );
			utf8_ucs2( str[i], ucs2 );
			CB_putnstringhorz_sys( x0, y0, 0, (const byte *)ucs2, INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#else
			CB_putnstringhorz_sys( x0, y0, 0, (const byte *)str[i], INVALID_LEN, MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
			}
		}

		y += MENU_ITEM_SPACE_FONT;

		if( i == 5 )
		{
			y = MENU_ITEM_RECT_Y_FONTSET + MENU_ITEM_SPACE_FONT * 3;
		}

		mask >>= 1;
		maskFocus >>= 1;
	}
}

#define		MENU_KEYA_LOGO_X3		30
#define		MENU_KEY_LOGO_Y3		(MENU_KEY_LOGO_Y1+8)

#define		MENU_KEYB_LOGO_X3		( MENU_KEYA_LOGO_X3 + 12 * 3 + 20 )
#define		MENU_KEYSELECT_LOGO_X	( MENU_KEYB_LOGO_X3 + 12 * 3 + 20 )

void MenuKeyHintDraw( int flag )
{
	int x,y;
	int result;
	pixel *imgdata = NULL;
	dword w, h;
	pixel bgc;
	pixel *Vram = GetVram( DOWN_SCREEN );

	if( flag == 0 )
	{
		x = MENU_KEYA_LOGO_X1;
		y = MENU_KEY_LOGO_Y1;
	}
	else if( flag == 1 )
	{
		x = MENU_KEYA_LOGO_X2;
		y = MENU_KEY_LOGO_Y2;
	}
	else if( flag == 2 )
	{
		x = MENU_KEYA_LOGO_X3;
		y = MENU_KEY_LOGO_Y3;
	}

	result = image_read_sys( CONFIG_AKEY, fs_file_get_type( CONFIG_AKEY ), &w, &h, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBltFC( imgdata, w, h, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );
	}
	else
	{
		CB_putnstringhorz_sys( x, y, 0, (const byte *)"(A)", INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
	}

	w = CB_text_get_string_width_sys( (const byte*)lang_ok, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
	CB_putnstringhorz_sys( x - w - 3, y, 0, (const byte *)lang_ok, INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );


	if( flag == 0 )
	{
		x = MENU_KEYB_LOGO_X1;
		y = MENU_KEY_LOGO_Y1;
	}
	else if( flag == 1 )
	{
		x = MENU_KEYB_LOGO_X2;
		y = MENU_KEY_LOGO_Y2;
	}
	else if( flag == 2 )
	{
		x = MENU_KEYB_LOGO_X3;
		y = MENU_KEY_LOGO_Y3;
	}

	result = image_read_sys( CONFIG_BKEY, fs_file_get_type( CONFIG_BKEY ), &w, &h, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBltFC( imgdata, w, h, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );
	}
	else
	{
		CB_putnstringhorz_sys( x, y, 0, (const byte *)"(B)", INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
	}

	w = CB_text_get_string_width_sys( (const byte*)lang_cancel, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
	CB_putnstringhorz_sys( x - w - 3, y, 0, (const byte *)lang_cancel, INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );


	if( flag == 2 )
	{
		x = MENU_KEYSELECT_LOGO_X;
		y = MENU_KEY_LOGO_Y3;

		result = image_read_sys( CONFIG_SELECTKEY, fs_file_get_type( CONFIG_SELECTKEY ), &w, &h, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBltFC( imgdata, w, h, Vram, SCREEN_W, SCREEN_H, x, y + 1, COLOR_GREEN );
			w = CB_text_get_string_width_sys( (const byte*)lang_item[LANG_SELECT_ID], 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		}
		else
		{
			CB_putnstringhorz_sys( x, y, 0, (const byte *)"(Select)", INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
			w = CB_text_get_string_width_sys( (const byte*)"(Select)", 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		}

		CB_putnstringhorz_sys( x - w - 3, y, 0, (const byte *)lang_item[LANG_SELECT_ID], INVALID_LEN, MENU_TITLE_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
	}

	if( imgdata )
	{
		free((void*) imgdata);
		imgdata = NULL;
	}
}
