#ifndef __FONTSET
#define __FONTSET

#include <datatype.h>

enum {
	FONTSIZE_MARK 		= 0X0000000F,
	ROWSPACE_MARK 		= 0X000000F0,
	TEXTCOLOR_MARK 		= 0XFFFFFF00
};

enum {
	FONTSIZE_SHIFT 		= 0,
	ROWSPACE_SHIFT 		= 4,
	TEXTCOLOR_SHIFT 	= 8
};


typedef struct{
	int bookfontindex;
	U8 rowspace;
	U8 wordspace;
	int fontcolor;
	int fontbgcolor;
	int stylefcolor_inUse;
	int stylefontbgcolor_inUse;
}FONTSET_s;

U32 FontSet( FONTSET_s *Font );
void FontSetDraw( U16 mask,  U16 maskFocus, U16 *ItemValue );
void MenuKeyHintDraw( int flag );



#endif //__FONTSET
