#include <HelpMenu_FileBrowse.h>
#include <SettingsFrame.h>
#include <datatype.h>
#include <display.h>
#include <gdi.h>
#include <Macro.h>
#include <DrvMemMgr.h>
#include <display.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <language.h>
#include <strsafe.h>

#include <debugoff.h>

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

void HelpMenuDisplay_FileBrowse( void )
{
	dword w;
	pixel ScreenBuf[SCREEN_W*SCREEN_H];
	U16 key;
	int x,y;
	char str[32];
	const byte *out_str = NULL;
#if USE_UNICODE_FONTLIB
#define		LEN_UCS2		64
	byte ucs2[LEN_UCS2];
#endif

	int fontCoding_type = GetlanguageCodingType();

	SaveVram( ScreenBuf, DOWN_SCREEN );

	DrawSettingsFrame( false );

	w = CB_text_get_string_width_sys( (const byte *)lang_Help, 0, CONFIG_FONTW_SYS, fontCoding_type );

	x = ( SCREEN_W - w ) >> 1;
	TextOut( x, MENU_TITLE_Y, (const byte*)lang_Help, MENU_TITLE_FCOLOR, DOWN_SCREEN );

#define		ROW_BANK			4
#define		START_XX_W			46
#define		START_Y0			(HELP_MENU_Y + 16)
#define		START_X0			3
#define		START_X1			( START_X0 + START_XX_W )
#define		START_X2			(SCREEN_W >> 1)
#define		START_X3			( START_X2 + START_XX_W )
	x = 3;
	y = START_Y0;
	TextOut( (SCREEN_W - DISP_FONTSIZE * 4) >> 1, y, (const byte *)lang_item[LANG_FBH_TITLE_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Up:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_UP_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Down:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_DOWN_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Left:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_LEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Right:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_RIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

#if 0
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"L:", MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_TITLE_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"R:", MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_TITLE_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
#endif

	STRCPY_S( str, "L/R:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_L_R_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_A_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "B:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_B_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "SELECT:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_SELECT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "START:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_START_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease( CONFIG_HELPKEY );

	while ( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( key );
		ctrl_waitrelease( key );

		if( key == KEY_A || key == KEY_B || key == CONFIG_HELPKEY )
		{
			break;
		}
	}
	LoadVram( ScreenBuf, DOWN_SCREEN );
	Flush( DOWN_SCREEN );
}
