#include <HelpMenu_Text.h>
#include <SettingsFrame.h>
#include <datatype.h>
#include <display.h>
#include <gdi.h>
#include <Macro.h>
#include <DrvMemMgr.h> 
#include <display.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <language.h>
#include <strsafe.h>
#include <debugoff.h>

#define TEST_XY_EN	0

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

void HelpMenuDisplay_Pdf( void )
{
	dword w;
	pixel ScreenBuf[SCREEN_W*SCREEN_H];
	U16 key;
	int x,y;
	BOOL font_in_book_bak = font_in_book;
	char str[32];
	const byte *out_str = NULL;
#if USE_UNICODE_FONTLIB
#define		LEN_UCS2		64
	byte ucs2[LEN_UCS2];
#endif
	
	font_in_book = false;

	SaveVram( ScreenBuf, DOWN_SCREEN );

	DrawSettingsFrame( false );
	w = CB_text_get_string_width_sys( (const byte *)lang_Help, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
	x = ( SCREEN_W - w ) >> 1;
	TextOut( x, MENU_TITLE_Y, (const byte*)lang_Help, MENU_TITLE_FCOLOR, DOWN_SCREEN );

#define		ROW_BANK			4
#define		START_XX_W			37
#define		START_Y0			(HELP_MENU_Y + 16)
#define		START_X0			3
#define		START_X1			( START_X0 + START_XX_W  )
#define		START_X2			((SCREEN_W >> 1) - 24 )
#define		START_X3			( START_X2 + START_XX_W + 12 )

	x = 3;
	y = START_Y0;
	TextOut( (SCREEN_W - DISP_FONTSIZE * 4) >> 1, y, (const byte *)lang_item[LANG_PDFH_TITLE_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Up:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_PBH_UP_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Down:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_PBH_DOWN_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Left:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_PBH_LEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Right:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_PBH_RIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "L:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );//Ϸҳ
	TextOut( START_X1 - 25, y , (const byte *)lang_item[LANG_TXTRH_LEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "R:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;//·ҳ
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1 - 25, y , (const byte *)lang_item[LANG_TXTRH_RIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+L:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );//תҳ
	TextOut( START_X1 - 10, y , (const byte *)lang_item[LANG_TXTRH_RLEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+R:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );//תβҳ
	TextOut( START_X1 - 10, y , (const byte *)lang_item[LANG_TXTRH_RRIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "START:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_START_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+UP/Y:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y = START_Y0;
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3 + 15, y , (const byte *)lang_item[LANG_PBH_AUP_Y_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+DOWON/X:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3 + 15, y , (const byte *)lang_item[LANG_PBH_ADOWN_X_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+Left:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3, y , (const byte *)lang_item[LANG_PBH_ALEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "A+Right:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3, y , (const byte *)lang_item[LANG_PBH_ARIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "B:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3 + 15, y , (const byte *)lang_item[LANG_TXTRH_B_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	
	STRCPY_S( str, "SELECT:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
	TextOut( START_X3 + 15, y , (const byte *)lang_item[LANG_FBH_SELECT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease( CONFIG_HELPKEY );

	while ( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( key );
		ctrl_waitrelease( key );
		
		if( key == KEY_B || key == CONFIG_HELPKEY || key == KEY_A )
		{
			break;
		}
	}
	LoadVram( ScreenBuf, DOWN_SCREEN );
	Flush( DOWN_SCREEN );
	
	font_in_book = font_in_book_bak;
}
