#include <HelpMenu_Text.h>
#include <MainMenuSettings.h>
#include <SettingsFrame.h>
#include <datatype.h>
#include <display.h>
#include <gdi.h>
#include <Macro.h>
#include <DrvMemMgr.h>
#include <display.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <language.h>
#include <strsafe.h>
#include <debugoff.h>

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

U32 HelpMenuDisplay_Text( BOOL need_bak, BOOL IsModeDialog )
{
	dword w;
	pixel ScreenBuf[SCREEN_W*SCREEN_H];
	U16 key;
	int x,y;
	U32 RetValue = 0;
	int fontCoding_type = GetlanguageCodingType();
	char str[32];
	const byte *out_str = NULL;
#if USE_UNICODE_FONTLIB
#define		LEN_UCS2		64
	byte ucs2[LEN_UCS2];
#endif

	if( need_bak )
		SaveVram( ScreenBuf, DOWN_SCREEN );

	DrawSettingsFrame( !IsModeDialog );
	w = CB_text_get_string_width_sys( (const byte *)lang_Help, 0, CONFIG_FONTW_SYS, fontCoding_type );
	x = ( SCREEN_W - w ) >> 1;
	TextOut( x, MENU_TITLE_Y, (const byte*)lang_Help, MENU_TITLE_FCOLOR, DOWN_SCREEN );

#define		ROW_BANK			4
#define		START_XX_W			45
#define		START_Y0			(HELP_MENU_Y + 16)
#define		START_X0			3
#define		START_X1			( START_X0 + START_XX_W + 10 )
#define		START_X2			( (SCREEN_W >> 1) + 10 + 20 )
#define		START_X3			( START_X2 + START_XX_W + 4 )
	x = 3;
	y = START_Y0;
	TextOut( (SCREEN_W - DISP_FONTSIZE * 4) >> 1, y, (const byte *)lang_item[LANG_TXTRH_TITLE_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	y += DISP_FONTSIZE + ROW_BANK;

	STRCPY_S( str, "Up:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_UP_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Down:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_DOWN_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Left:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );//Ϸҳ
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_LEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Right:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );//·ҳ
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_RIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

#if 0
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"L:", MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_UP_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"R:", MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_UP_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
#endif

	STRCPY_S( str, "R+Left:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_RLEFT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "R+Right:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_RRIGHT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "X:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_X_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "Y:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_Y_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

#if 0
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"A:", MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_FBH_A_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X0, y , (const byte *)"B:", MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X1, y , (const byte *)lang_item[LANG_TXTRH_B_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );
#endif

	y = START_Y0;

	STRCPY_S( str, "A:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X3 - 20, y , (const byte *)lang_item[LANG_FBH_A_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "B:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X3 - 20, y , (const byte *)lang_item[LANG_TXTRH_B_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "SELECT:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X3, y , (const byte *)lang_item[LANG_FBH_SELECT_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	STRCPY_S( str, "START:" );
#if USE_UNICODE_FONTLIB
	memset( ucs2, 0x00, LEN_UCS2 );
	utf8_ucs2( str, ucs2 );
	out_str = (const byte *)ucs2;
#else
	out_str = (const byte *)str;
#endif
	y += DISP_FONTSIZE + ROW_BANK;
	TextOut( START_X2, y , (const byte *)out_str, MESSAGE_HINT_MENU_FCOLOR, DOWN_SCREEN );
	TextOut( START_X3, y , (const byte *)lang_item[LANG_FBH_START_ID], MESSAGE_HINT_TEXT_COLOR, DOWN_SCREEN );

	Flush( DOWN_SCREEN );

	ctrl_waitrelease( CONFIG_HELPKEY );

	while ( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( key );

		if( key == KEY_B )
		{
			break;
		}
		else if( key == CONFIG_HELPKEY && IsModeDialog == true )
		{
			break;
		}
		else if( key == KEY_L )
		{
			if( IsModeDialog == false )
			{
				RetValue = BACKWARD;
				ctrl_waitrelease( key );
				break;
			}
		}
		else if( key == KEY_R )
		{
			if( IsModeDialog == false )
			{
				RetValue = FORWARD;
				ctrl_waitrelease( key );
				break;
			}
		}
	}
	LoadVram( ScreenBuf, DOWN_SCREEN );

	if( need_bak )
		Flush( DOWN_SCREEN );

	return RetValue;
}
