#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>
#include <font.h>
#include <scene.h>
#include <FontSet.h>
#include <JumpTo.h>
#include <BacklightSet.h>
#include <ReadingMode.h>
#include <MainMenuSettings.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <SettingsFrame.h>
#include <FontSet.h>
#include <strsafe.h>
#include <language.h>
#include <debugoff.h>

static char *lang_title_str = NULL;
static char *lang_item_str = NULL;

static pixel UArrow[MENU_UARROW_W*MENU_UARROW_H];
static pixel DArrow[MENU_DARROW_W*MENU_DARROW_H];

BOOL UArrow_IsReady = false;
BOOL DArrow_IsReady = false;

#define		ITEM_COUNT					1

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
U32 JumpToPercentage( U32 *Percentage )
{
	U32 RetValue = 0;
	pixel ScreenBuf[SCREEN_W * SCREEN_H];
	int result;
	U16 key;
	int i;
	U8	 ShiftBit = 0; //ߵλΪ0λ,һ4λ
	U32  JumpToValue;//ʼֵΪֵֵ10000
	U16 mask;
	U16 maskFocus;
	U8  BitNum[4];
	U32 tempw;;
	dword width, height;
	pixel *imgdata = NULL;
	pixel bgc;

	DrawSettingsFrame( true );
	MenuKeyHintDraw( 0 );

	SaveVram( ScreenBuf, DOWN_SCREEN );

	lang_title_str = lang_item[LANG_JUMP_TITLE_ID];
	lang_item_str = lang_item[LANG_JUMP_ITEM0_ID];

	//DArrow
	if( DArrow_IsReady == false )
	{
		result = image_read_sys( CONFIG_DARROW, fs_file_get_type( CONFIG_DARROW ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt( imgdata, width, height, DArrow, width, height );
			DArrow_IsReady = true;
		}
	}

	//UArrow
	if( UArrow_IsReady == false )
	{
		result = image_read_sys( CONFIG_UARROW, fs_file_get_type( CONFIG_UARROW ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt( imgdata, width, height, UArrow, width, height );
			UArrow_IsReady = true;
		}
	}

	if( imgdata )
	{
		free((void*) imgdata);
		imgdata = NULL;
	}

	if( *Percentage > 10000 )
		*Percentage = 10000;
	JumpToValue = *Percentage;

	tempw = JumpToValue;
	for( i = 0; i < 4; i++ )
	{
	 	BitNum[i] = tempw % 10;
	 	tempw = tempw / 10;
	}

	mask = BIT( 0 );
	maskFocus = BIT( 0 );
	JumpToDraw(  mask, maskFocus, BitNum, ShiftBit );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while ( 1 )
	{
		while( !(key = Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( key );

		if( key == KEY_DOWN )
		{
			if( BitNum[3-ShiftBit] == 9 )
				BitNum[3-ShiftBit] = 0;
			else
				BitNum[3-ShiftBit]++;
			JumpToValue = BitNum[3] * 1000 + BitNum[2] * 100 + BitNum[1] * 10 + BitNum[0];
		}
		else if( key == KEY_UP )
		{
			if( BitNum[3-ShiftBit] == 0 )
				BitNum[3-ShiftBit] = 9;
			else
				BitNum[3-ShiftBit]--;
			JumpToValue = BitNum[3] * 1000 + BitNum[2] * 100 + BitNum[1] * 10 + BitNum[0];
		}
		else if( key == KEY_LEFT )
		{
			if( ShiftBit == 0 )
				ShiftBit = 3;
			else
				ShiftBit--;
		}
		else if( key == KEY_RIGHT )
		{
			if( ShiftBit >= 3 )
				ShiftBit = 0;
			else
				ShiftBit++;
		}
		else if( key == KEY_A )
		{
			if( JumpToValue != *Percentage )
			{
				if( JumpToValue > 10000 )
					JumpToValue = 10000;
				*Percentage = JumpToValue;
				RetValue = bmJUMPTO;
			}
			else
			{
				RetValue = 0;
			}
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_B )
		{
			RetValue = 0;
			break;
		}
		else if( key == KEY_TOUCH )
		{
		}
		else if( key == KEY_L )
		{
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) )
		{
			LoadVram( ScreenBuf, DOWN_SCREEN );
			mask = BIT( 0 );
			maskFocus = BIT( 0 );
			JumpToDraw( mask, maskFocus, BitNum, ShiftBit );
			Flush( DOWN_SCREEN );
		}
	}

	return RetValue;
}

void JumpToDraw( U16 mask,  U16 maskFocus, U8 *ItemValue, U8 ShiftBit )//ShiftBitߵλΪ0λ,һ4λ
{
	int i,j,k;
	int x,y,w;
	int x0,y0,x1=1;
	char str[7];
	char ItemStr[20];
	pixel *Vram = GetVram( DOWN_SCREEN );
	const U8 ShiftBitTab[] = { 0, 1, 3, 4 };
	pixel fcolor;
	int x_adjust = 0;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif

	if( ShiftBit >= 4 )
		return;

	if( maskFocus & 0xff )//»Ʊ
	{
		w = CB_text_get_string_width_sys( (const byte *)lang_title_str, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		x = ( SCREEN_W - w ) >> 1;
		TextOut( x, MENU_TITLE_Y, (const byte*)lang_title_str, MENU_TITLE_FCOLOR, DOWN_SCREEN );
	}

	x = MENU_ITEM_RECT_X;
	y = MENU_ITEM_RECT_Y;
	for( i=0; i<ITEM_COUNT; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				FillRect( x, y, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
			}

			SPRINTF_S( ItemStr, "%d.", i + 1 );

#if USE_UNICODE_FONTLIB
			memset( ucs2, 0x00, 8 ); 
			utf8_ucs2( ItemStr, ucs2 );
			TextOut( x + MENU_ITEMNAME_OFFSET_X, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)ucs2, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
			x_adjust = CONFIG_FONTW_SYS;
#else
			TextOut( x + MENU_ITEMNAME_OFFSET_X, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)ItemStr, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
#endif
			TextOut( x + MENU_ITEMNAME_OFFSET_X + x_adjust, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)lang_item_str, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
			bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x + MENU_ITEM_BAR_OFFSET_X, y + MENU_ITEM_BAR_OFFSET_Y );


			for( j = 0,k = 3; j < 6; j++ )
			{
				if( j == 2 )
					str[j] = '.';
				else if( j == 5 )
					str[j] = '%';
				else
				{
					str[j] = ItemValue[k--] + '0';
				}
			}
			str[j] = '\0';

			x0 = x + MENU_ITEM_BAR_OFFSET_X + ( ( MENU_ITEM_BAR_LOGO_W - (DISP_FONTSIZE >> 1) * 6 - JUMPTO_FONTSPACE * 5 ) >> 1 );
			y0 = y + MENU_ITEM_BAR_OFFSET_Y + ( ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) >> 1 );
			for( j = 0; j < 6; j++ )
			{
				if( j == ShiftBitTab[ShiftBit] )
				{
					fcolor = MENU_JUMPTO_BAR_FCOLOR_FOCUS;
					x1 = x0;//ڶλѡͷ
				}
				else
				{
					fcolor = MENU_JUMPTO_BAR_FCOLOR;
				}

#if USE_UNICODE_FONTLIB
				memset( ucs2, 0x00, 8 );
				utf8decode( str+j, ucs2 );
				CB_disp_putcharhorz( x0, y0, CONFIG_FONTW_SYS, CONFIG_FONTH_SYS, (const byte *)ucs2, fcolor, DOWN_SCREEN );
#else
				CB_disp_putcharhorz( x0, y0, CONFIG_FONTW_SYS, CONFIG_FONTH_SYS, (const byte *)(str+j), fcolor, DOWN_SCREEN );
#endif

				x0 += (DISP_FONTSIZE >> 1) + JUMPTO_FONTSPACE;
			}
		}

		if( maskFocus & 0x1 )
		{
			y0 = y + MENU_UARROW_OFFSET_Y;
			bitBltFC( UArrow, MENU_UARROW_W, MENU_UARROW_H, Vram, SCREEN_W, SCREEN_H, x1 - 1, y0, COLOR_GREEN );

			y0 += MENU_DARROW_OFFSET_Y;
			bitBltFC( DArrow, MENU_DARROW_W, MENU_DARROW_H, Vram, SCREEN_W, SCREEN_H, x1 - 1, y0, COLOR_GREEN );
		}

		y += MENU_ITEM_SPACE;
		mask >>= 1;
		maskFocus >>= 1;
	}
}
