#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <scene.h>
#include <scene_text.h>
#include <DrvMemMgr.h>
#include <StyleSet.h>
#include <FontSet.h>
#include <BacklightSet.h>
#include <JumpTo.h>
#include <BookmarkSet.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <ReadingMode.h>
#include <HelpMenu_Text.h>
#include <language.h>
#include "MainMenuSettings.h"

#include <debugoff.h>

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

static BOOL needrp_bg = true;

//λID
enum{
	FONT_SETTINGS_ORDER_ID = 0,
	STYLE_SETTINGS_ORDER_ID = 1,
	READING_MODE_ORDER_ID = 2,
	BACKLIGHT_ORDER_ID = 3,
	JUMPTO_ORDER_ID = 4,
	BOOKMARK_ORDER_ID = 5,
	HELP_ORDER_ID = 6,
};

enum
{
	SELECTED_FONT_SETTINGS = FONT_SETTINGS_ORDER_ID,
	SELECTED_STYLE_SETTINGS = STYLE_SETTINGS_ORDER_ID,
	SELECTED_READINGMODE = READING_MODE_ORDER_ID,
	SELECTED_BACKLIGHT = BACKLIGHT_ORDER_ID,
	SELECTED_JUMPTO = JUMPTO_ORDER_ID,
	SELECTED_BOOKMARK = BOOKMARK_ORDER_ID,
	SELECTED_HELP = HELP_ORDER_ID,
};

enum{
	SELECTED_BAR_POS00 = 0,
	SELECTED_BAR_POS01,
	SELECTED_BAR_POS10,
	SELECTED_BAR_POS11,
	SELECTED_BAR_POS20,
	SELECTED_BAR_POS21,
	SELECTED_BAR_POS30,
	SELECTED_BAR_MIN = SELECTED_BAR_POS00,
	SELECTED_BAR_MAX = SELECTED_BAR_POS30
};

const POS Rect[] = {
	{ MENU_BAR_LOGO_X_POS0, MENU_BAR_LOGO_Y_POS0 }, //λ0
	{ MENU_BAR_LOGO_X_POS1, MENU_BAR_LOGO_Y_POS1 }, //λ1
	{ MENU_BAR_LOGO_X_POS2, MENU_BAR_LOGO_Y_POS2 }, //λ2
	{ MENU_BAR_LOGO_X_POS3, MENU_BAR_LOGO_Y_POS3 }, //λ3
	{ MENU_BAR_LOGO_X_POS4, MENU_BAR_LOGO_Y_POS4 }, //λ4
	{ MENU_BAR_LOGO_X_POS5, MENU_BAR_LOGO_Y_POS5 }, //λ5
	{ MENU_BAR_LOGO_X_POS6, MENU_BAR_LOGO_Y_POS6 } //λ6
};

static const char LogoName[MENU_BAR_COUNT][16] =
{
	CONFIG_FONT,
	CONFIG_STYLE,
	CONFIG_READINGMODE,
	CONFIG_BACKLIGHT,
	CONFIG_JUMPTO,
	CONFIG_BOOKMARK,
	CONFIG_HELP
};

static const char LogoNameFocus[MENU_BAR_COUNT][32] =
{
	CONFIG_FONTFOCUS,
	CONFIG_STYLEFOCUS,
	CONFIG_READINGMODEFOCUS,
	CONFIG_BACKLIGHTFOCUS,
	CONFIG_JUMPTOFOCUS,
	CONFIG_BOOKMARKFOCUS,
	CONFIG_HELPFOCUS
};

static char *MenubarStr[MENU_BAR_COUNT];

pixel MenuLogoBuf[MENU_BAR_COUNT][MAINMENU_BAR_LOGO_W*MAINMENU_BAR_LOGO_H];
pixel MenuLogoBufFocus[MENU_BAR_COUNT][MAINMENU_BAR_LOGO_W*MAINMENU_BAR_LOGO_H];

static U16 MenuLogoBuf_InitFlag = 0;
static U16 MenuLogoBufFocus_InitFlag = 0;

#define		ALL_MASK_BIT		0x7F

void MenubarStr_Init()
{
	int i;

	i = 0;
	MenubarStr[i++] = lang_item[LANG_FONT_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_STYLE_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_READMODE_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_BRIGHTNESS_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_JUMP_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_BM_MENU_ID];
	MenubarStr[i++] = lang_item[LANG_HELP_MENU_ID];
}

U32 MenuSettings( MENUSETTINGS_s *settings )
{
	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	U32 RetValue = 0;
	U32 Ret = 0;
	int result;
	U16 key;
	int i;

	FONTSET_s *Font = &settings->Font;
	int *StyleIndex = &settings->StyleIndex;
	t_read 	*ReadMode = &settings->ReadMode;
	BACKLIGHT_s *backlight = &settings->backlight;
	U32  *Percentage = &settings->Percentage;//10000 //ֵд޸
	BMSETTINGS_s  *bmsettings = &settings->bmsettings;

	U16 mask = 0,maskFocus = 0;

	U16 	SelectBar = config.MenuBarIndex;
	U16 	SelectBar_old = SelectBar;

	if( SelectBar >= MENU_BAR_COUNT )
	{
		SelectBar = MENU_BAR_COUNT;
		SelectBar_old = SelectBar;
	}

	MenubarStr_Init();

	needrp_bg = true;
	if( MenuLogoBufFocus_InitFlag !=  ALL_MASK_BIT )
		DrawSettingMenuBar( ALL_MASK_BIT, ALL_MASK_BIT );//ѡѡʱ
	if( MenuLogoBuf_InitFlag !=  ALL_MASK_BIT )
		DrawSettingMenuBar( ALL_MASK_BIT, 0x00 );//ѡѡʱ
	DrawSettingMenuBar( ALL_MASK_BIT, BIT( SelectBar ) );//ȫҵ1λΪѡ

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while ( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS00 )
				SelectBar = SELECTED_BAR_POS30;
			else if( SelectBar == SELECTED_BAR_POS01 )
				SelectBar = SELECTED_BAR_POS21;
			else
				SelectBar -= 2;

			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_DOWN )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS30 )
				SelectBar = SELECTED_BAR_POS00;
			else if( SelectBar == SELECTED_BAR_POS21 )
				SelectBar = SELECTED_BAR_POS01;
			else
				SelectBar += 2;

			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_LEFT )
		{
#if 0
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS00 )
				SelectBar = SELECTED_BAR_POS30;
			else
				SelectBar -= 1;
#else
			SelectBar_old = SelectBar;
			if( SelectBar != SELECTED_BAR_POS30 )
			{
				if( (SelectBar & 0x01)  == 0 )
					SelectBar++;
				else
					SelectBar--;
			}
#endif
			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_RIGHT )
		{
#if 0
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS30 )
				SelectBar = SELECTED_BAR_POS00;
			else
				SelectBar += 1;
#else
			SelectBar_old = SelectBar;
			if( SelectBar != SELECTED_BAR_POS30 )
			{
				if( (SelectBar & 0x01)  == 0 )
					SelectBar++;
				else
					SelectBar--;
			}
#endif
			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_L )
		{
#if 1
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS00 )
				SelectBar = SELECTED_BAR_POS30;
			else
				SelectBar -= 1;
#else
			SelectBar_old = SelectBar;
			if( SelectBar != SELECTED_BAR_POS30 )
			{
				if( (SelectBar & 0x01)  == 0 )
					SelectBar++;
				else
					SelectBar--;
			}
#endif
			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_R )
		{
#if 1
			SelectBar_old = SelectBar;
			if( SelectBar == SELECTED_BAR_POS30 )
				SelectBar = SELECTED_BAR_POS00;
			else
				SelectBar += 1;
#else
			SelectBar_old = SelectBar;
			if( SelectBar != SELECTED_BAR_POS30 )
			{
				if( (SelectBar & 0x01)  == 0 )
					SelectBar++;
				else
					SelectBar--;
			}
#endif
			mask = BIT( SelectBar_old ) | BIT( SelectBar );
		}
		else if( key == KEY_A )
		{
_KEY_OK_PRESS:
			switch( SelectBar )
			{
				case SELECTED_FONT_SETTINGS:
					Ret = FontSet( Font );
					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( Ret )
					{
						RetValue |= Ret;
#if SETTINGS_EFFECTIVE_AT_ONCE
						goto _MenuSettings_Exit;
#endif
					}

					break;

				case SELECTED_STYLE_SETTINGS:
					Ret = StyleSet( StyleIndex );

					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( Ret )
					{
						RetValue |= Ret;
#if SETTINGS_EFFECTIVE_AT_ONCE
					goto _MenuSettings_Exit;
#endif
					}

					break;

				case SELECTED_READINGMODE:
					Ret = ReadingModeSet( ReadMode );

					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( Ret )
					{
						RetValue |= Ret;
#if SETTINGS_EFFECTIVE_AT_ONCE
						goto _MenuSettings_Exit;
#endif
					}
					break;

				case SELECTED_BACKLIGHT:
					Ret = BacklightSet( backlight );

					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( Ret )
					{
						if( Ret & bmBRIGHTNESS )
						{
							ds2_setBrightness( backlight->brightness );
							RetValue |= Ret;
						}
						else if( Ret & bmLANGUAGE )
						{
							MenubarStr_Init();
							bg_screen_load();
						}
					}

					break;

				case SELECTED_JUMPTO:
					Ret = JumpToPercentage( Percentage );

					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( Ret )
					{
						RetValue |= Ret;
						goto _MenuSettings_Exit;
					}
					break;

				case SELECTED_BOOKMARK:
					result = BookmarkManage( bmsettings, true );
					if( result == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( result == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}

					if( result >= 0 )
					{
						bmsettings->row = result;//к
						RetValue = bmBOOKMARK;//ǩñ־
						goto _MenuSettings_Exit;
					}
					break;
				case SELECTED_HELP:
					Ret = HelpMenuDisplay_Text( false, false );
					if( Ret == FORWARD )
					{
						if( SelectBar == SELECTED_BAR_POS30 )
							SelectBar = SELECTED_BAR_POS00;
						else
							SelectBar += 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					else if( Ret == BACKWARD )
					{
						if( SelectBar == SELECTED_BAR_POS00 )
							SelectBar = SELECTED_BAR_POS30;
						else
							SelectBar -= 1;

						goto _KEY_OK_PRESS;//൱ڰһȷֱӽһѡ
					}
					break;

				default:
					continue;
			}

			needrp_bg = true;
			mask = ALL_MASK_BIT;
			ds2_getrawInput( &inputkey );
			if( inputkey.key == KEY_B )
			{
				maskFocus = BIT( SelectBar );
				DrawSettingMenuBar( mask, maskFocus );
				Flush( DOWN_SCREEN );
				ctrl_waitrelease( inputkey.key );
			}
		}
		else if( key == KEY_B || key == KEY_X )
		{
_KEY_EXIT:
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = SELECTED_BAR_MIN; i <= SELECTED_BAR_MAX; i++ )
			{
				AjustKey.Min_x = Rect[i].x;
				AjustKey.Max_x = Rect[i].x + MAINMENU_BAR_LOGO_W;

				AjustKey.Min_y = Rect[i].y + 12;
				AjustKey.Max_y = Rect[i].y + MAINMENU_BAR_LOGO_H - 4;

				Ret = CheckValidxy( AjustKey, inputkey );
				if( Ret == 0 )
				{
					SelectBar_old = SelectBar;
					SelectBar = i;
					key = KEY_TOUCH | KEY_A;

					mask = BIT( SelectBar_old ) | BIT( SelectBar );
					maskFocus = BIT( SelectBar );
					DrawSettingMenuBar( mask, maskFocus );
					Flush( DOWN_SCREEN );

					goto _KEY_OK_PRESS;
				}
			}

			//ǷÿķΧ֮⣬ˣȡ
			//ϲ
			AjustKey.Min_x = 0;
			AjustKey.Min_y = 0;
			AjustKey.Max_x = MAINMENU_BG_X + MAINMENU_BG_RECT_W;
			AjustKey.Max_y = MAINMENU_BG_Y - 1;

			if( !CheckValidxy( AjustKey, inputkey ) )//
			{
				goto _KEY_EXIT;
			}

			//²
			AjustKey.Min_x = 0;
			AjustKey.Min_y =  MAINMENU_BG_X + MAINMENU_BG_RECT_W;
			AjustKey.Max_x = SCREEN_W - 1;
			AjustKey.Max_y = SCREEN_H - 1;

			if( !CheckValidxy( AjustKey, inputkey ) )//
			{
				goto _KEY_EXIT;
			}

			//󲿷
			AjustKey.Min_x = 0;
			AjustKey.Min_y = MAINMENU_BG_Y;
			AjustKey.Max_x = MAINMENU_BG_X - 1;
			AjustKey.Max_y = MAINMENU_BG_Y + MAINMENU_BG_RECT_H;

			if( !CheckValidxy( AjustKey, inputkey ) )//
			{
				goto _KEY_EXIT;
			}


			//Ҳ
			AjustKey.Min_x = MAINMENU_BG_X + MAINMENU_BG_RECT_W;
			AjustKey.Min_y = 0;
			AjustKey.Max_x = SCREEN_W - 1;
			AjustKey.Max_y = SCREEN_H - 1;

			if( !CheckValidxy( AjustKey, inputkey ) )//
			{
#if 1
				goto _KEY_EXIT;
#endif
			}

			//Ļ⣬ֻҪǰûм⵽ִȡ
			AjustKey.Min_x = 0;
			AjustKey.Min_y = 0;
			AjustKey.Max_x = SCREEN_W - 1;
			AjustKey.Max_y = SCREEN_H - 1;

			if( !CheckValidxy( AjustKey, inputkey ) )//
			{
				goto _KEY_EXIT;
			}
		}
		else
		{
//			continue;
		}

		if( key & (KEY_LEFT|KEY_RIGHT|KEY_UP|KEY_DOWN|KEY_L|KEY_R|KEY_TOUCH|KEY_A) )
		{
//			if( SelectBar_old != SelectBar )
			{
				if( (key & KEY_A)  == 0 )
					mask = BIT( SelectBar_old ) | BIT( SelectBar );
				else
					mask = ALL_MASK_BIT;
				maskFocus = BIT( SelectBar );
				DrawSettingMenuBar( mask, maskFocus );
				Flush( DOWN_SCREEN );
			}
		}
	}

_MenuSettings_Exit:

	config.MenuBarIndex = SelectBar;
	return RetValue;
}

void DrawSettingMenuBar( U16 mask,  U16 maskFocus )
{
	int i;
	int result = -1;
	const char *str = 0;
	int x;

	dword width = 0, height = 0;
	pixel *imgdata = NULL;;
	pixel bgc;
	pixel Fcolor;
	pixel *LogoBuf = 0;
	U16 *InitFlag = 0;
	int ay = 0;

	pixel *Vram = GetVram( DOWN_SCREEN );


#define		BAR_FORFONT_W			88
#define		BAR_FORFONT_OFFSET_X	29


	if( needrp_bg )
	{
		result = image_read_sys( CONFIG_MAINMENUBG, fs_file_get_type( CONFIG_MAINMENUBG ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, MAINMENU_BG_X, MAINMENU_BG_Y );
		}
		needrp_bg = false;
	}
	for( i = 0; i < MENU_BAR_COUNT; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				str = LogoNameFocus[i];
				Fcolor = MENU_BAR_FCOLOR_FOCUS;
				LogoBuf = MenuLogoBuf[i];
				InitFlag = &MenuLogoBufFocus_InitFlag;
			}
			else
			{
				str = LogoName[i];
				Fcolor = MENU_BAR_FCOLOR;
				LogoBuf = MenuLogoBufFocus[i];
				InitFlag = &MenuLogoBuf_InitFlag;
			}

			if( (*InitFlag) & BIT( i ) )
			{
				bitBlt2( LogoBuf, MAINMENU_BAR_LOGO_W, MAINMENU_BAR_LOGO_H, 0, 0, Vram, SCREEN_W, SCREEN_H, Rect[i].x, Rect[i].y );
			}
			else
			{
				result = image_read_sys( str, fs_file_get_type( (const char*)str ), &width, &height, &imgdata, &bgc );
				if( result == 0 )
				{
					bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, Rect[i].x, Rect[i].y );
					bitBlt2( imgdata, width, height, 0, 0, LogoBuf, MAINMENU_BAR_LOGO_W, MAINMENU_BAR_LOGO_H, 0, 0 );//
					*InitFlag |= BIT( i );
				}
			}
			int w = CB_text_get_string_width_sys( (const byte *)MenubarStr[i], 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
			if( BAR_FORFONT_W >= w )
			{
				x = Rect[i].x + BAR_FORFONT_OFFSET_X + (( BAR_FORFONT_W - w ) >> 1);
			}
			else
			{
				x = Rect[i].x + BAR_FORFONT_OFFSET_X;
			}

			if( i == 2 )
				ay = -2;
			else
				ay = 0;

			TextOut( x, Rect[i].y + MENU_BAR_FONT_OFFSET_Y + ay, (const byte *)MenubarStr[i], Fcolor, DOWN_SCREEN );
		}
		mask >>= 1;
		maskFocus >>= 1;
	}
	if( imgdata )
	{
		free((void *) imgdata);
		imgdata = NULL;
	}
}

//ںϷΧڷ0򷵻1
int CheckValidxy(  AJUST_KEY_BUF AjustKey, KEY_BUF inputkey )
{
	if( inputkey.x >= AjustKey.Min_x && inputkey.x <= AjustKey.Max_x && inputkey.y >= AjustKey.Min_y && inputkey.y <= AjustKey.Max_y  )
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
