#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>
#include <font.h>
#include <scene.h>
#include <FontSet.h>
#include <ReadingMode.h>
#include <MainMenuSettings.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <SettingsFrame.h>
#include <FontSet.h>
#include <strsafe.h>
#include <language.h>
#include <debugoff.h>

static char *lang_title_str = NULL;
static char *lang_item_str[2];
static char *lang_item_value_str[5];

enum
{
	ITEM_START	= 0,
	READINGMODE_BAR = 0,
	SCREENUSE_BAR,
	ITEM_MAX 	= SCREENUSE_BAR,
	ITEM_INVALID,
};

#undef		BAR_COUNT
#define		BAR_COUNT					5

#undef		ITEM_COUNT
#define		ITEM_COUNT					2

#define		SCREEN_BASE_VALUE		2

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

//--------------------------------------------------------------------------
//--------------------------------------------------------------------------
U32 ReadingModeSet( t_read *ReadMode )
{
	U32 RetValue = 0;
	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	t_conf_vertread vertread_temp = ReadMode->vertread;//ʼֵΪֵд޸
	SCREEN_USE ScreenUseTemp = ReadMode->ScreenUse;//ʼֵΪֵд޸
	pixel ScreenBuf[SCREEN_W * SCREEN_H];
	char  *TextValue[BAR_COUNT];
	POS ItemPos[ITEM_COUNT];
	int result;
	U16 key;
	int i;
	int x,y;
	int SelectBar = 0;
	int SelectBar_old = 0;
	U16 mask;
	U16 maskFocus;

	DrawSettingsFrame( true );
	MenuKeyHintDraw( 0 );

	SaveVram( ScreenBuf, DOWN_SCREEN );

	lang_title_str = lang_item[LANG_READMODE_TITLE_ID];

	i = 0;
	lang_item_str[i++] = lang_item[LANG_READMODE_ITEM0_ID];
	lang_item_str[i++] = lang_item[LANG_READMODE_ITEM1_ID];

	i = 0;
	lang_item_value_str[i++] = lang_item[LANG_HORIZONTAL_ID];
	lang_item_value_str[i++] = lang_item[LANG_VERTICAL_ID];
	lang_item_value_str[i++] = lang_item[LANG_UPPERSCREEN_ID];
	lang_item_value_str[i++] = lang_item[LANG_LOWERSCREEN_ID];
	lang_item_value_str[i++] = lang_item[LANG_DOUBLECREEN_ID];

	x = MENU_ITEM_RECT_X + MENU_ITEM_BAR_OFFSET_X;
	y = MENU_ITEM_RECT_Y + MENU_ITEM_BAR_OFFSET_Y;
	for( i = 0; i < ITEM_COUNT; i++ )
	{
		ItemPos[i].x =  x;
		ItemPos[i].y =  y;
		y += MENU_ITEM_SPACE;
	}

	mask = 0x03;
	maskFocus = 0x01;
	i = 0;
	TextValue[i++] = lang_item_value_str[vertread_temp];
	TextValue[i] = lang_item_value_str[SCREEN_BASE_VALUE+ScreenUseTemp];
	ReadingModeSetDraw(  mask, maskFocus, (const char**)TextValue );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while ( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_START )
				SelectBar = ITEM_MAX;
			else
				SelectBar--;
		}
		else if( key == KEY_DOWN )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_MAX )
				SelectBar = ITEM_START;
			else
				SelectBar++;
		}
		else if( key == KEY_LEFT )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == READINGMODE_BAR )
			{
				if( vertread_temp <= conf_vertread_horz )
						vertread_temp = conf_vertread_rvert;
					else
						vertread_temp--;
			}
			else if( SelectBar == SCREENUSE_BAR )
			{
				if( ScreenUseTemp <= SCREEN_UP )
						ScreenUseTemp = SCREEN_DOUBLE;
					else
						ScreenUseTemp--;
			}
		}
		else if( key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == READINGMODE_BAR )
			{
				if( vertread_temp >= conf_vertread_rvert )
						vertread_temp = conf_vertread_horz;
					else
						vertread_temp++;
			}
			else if( SelectBar == SCREENUSE_BAR )
			{
				if( ScreenUseTemp >= SCREEN_DOUBLE )
						ScreenUseTemp = SCREEN_UP;
					else
						ScreenUseTemp++;
			}
		}
		else if( key == KEY_A )
		{
			RetValue = 0;
			if( ReadMode->ScreenUse != ScreenUseTemp )
			{
				ReadMode->ScreenUse = ScreenUseTemp;
				RetValue |= bmSCREENSELECT;
			}
			if( ReadMode->vertread != vertread_temp )
			{
				ReadMode->vertread = vertread_temp;
				RetValue |= bmVERTREAD;
			}
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_B )
		{
			RetValue = 0;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = 0; i < ITEM_COUNT; i++ )
			{
				AjustKey.Min_x = ItemPos[i].x;
				AjustKey.Max_x = AjustKey.Min_x + MENU_ITEM_BAR_LOGO_W;

				AjustKey.Min_y = ItemPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + MENU_ITEM_BAR_LOGO_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					SelectBar_old = SelectBar;
					SelectBar = i;
					key = KEY_TOUCH | KEY_A;
				}
			}
		}
		else if( key == KEY_L )
		{
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key == (KEY_TOUCH | KEY_A) )
		{
			i = 0;
			if( SelectBar_old == SelectBar )
			{
				mask = BIT( SelectBar );
				maskFocus = mask << 8;
				i = 0;
				TextValue[i++] = lang_item_value_str[vertread_temp];
				TextValue[i] = lang_item_value_str[SCREEN_BASE_VALUE+ScreenUseTemp];
			}
			else
			{
				LoadVram( ScreenBuf, DOWN_SCREEN );
				mask = BIT( SelectBar ) | BIT( SelectBar_old );
				maskFocus = BIT( SelectBar );
				i = 0;
				TextValue[i++] = lang_item_value_str[vertread_temp];
				TextValue[i] = lang_item_value_str[SCREEN_BASE_VALUE+ScreenUseTemp];
			}
			ReadingModeSetDraw( mask, maskFocus, (const char**)TextValue );
			Flush( DOWN_SCREEN );
		}
	}

	return RetValue;
}

void ReadingModeSetDraw( U16 mask,  U16 maskFocus, const char **ItemValue )
{
	int i;
	int x,y;
	int x0,y0;
	int w;

	char ItemStr[32];
	pixel *Vram = GetVram( DOWN_SCREEN );
	int fontCoding_type = GetlanguageCodingType();
	int x_adjust = 0;
#if USE_UNICODE_FONTLIB
	byte ucs2[8];
#endif
 
	if( maskFocus & 0xff )//»Ʊ
	{
		w = CB_text_get_string_width_sys( (const byte *)lang_title_str, 0, CONFIG_FONTW_SYS, fontCoding_type );
		x = ( SCREEN_W - w ) >> 1;
		TextOut( x, MENU_TITLE_Y, (const byte*)lang_title_str, MENU_TITLE_FCOLOR, DOWN_SCREEN );
	}

	x = MENU_ITEM_RECT_X;
	y = MENU_ITEM_RECT_Y;
	for( i=0; i<2; i++ )
	{
		if( mask == 0 )
			break;
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				FillRect( x, y, MENU_ITEM_RECT_W, MENU_ITEM_RECT_H, MENU_ITEM_RECT_COLOR, DOWN_SCREEN );
				bitBltFC( LArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_LARROW_OFFSET_X, y + MENU_LARROW_OFFSET_Y, COLOR_GREEN );
				bitBltFC( RArrow, MENU_ARROW_LR_W, MENU_ARROW_LR_H, Vram, SCREEN_W, SCREEN_H, x + MENU_RARROW_OFFSET_X, y + MENU_RARROW_OFFSET_Y, COLOR_GREEN );
			}

			if( ( ( maskFocus >> 8 ) & 0x1 ) == 0 )
			{
				SPRINTF_S( ItemStr, "%d.", i + 1 );
#if USE_UNICODE_FONTLIB
				memset( ucs2, 0x00, 8 );
				utf8_ucs2( ItemStr, ucs2 );
				TextOut( x + MENU_ITEMNAME_OFFSET_X, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)ucs2, MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
				x_adjust = CONFIG_FONTW_SYS;
#endif
				TextOut( x + MENU_ITEMNAME_OFFSET_X + x_adjust, y + MENU_ITEMNAME_OFFSET_Y, (const byte*)lang_item_str[i], MENU_ITEMNAME_FCOLOR, DOWN_SCREEN );
			}

			bitBlt1( MenuBarBg, MENU_ITEM_BAR_LOGO_W, MENU_ITEM_BAR_LOGO_H, Vram, SCREEN_W, SCREEN_H, x + MENU_ITEM_BAR_OFFSET_X, y + MENU_ITEM_BAR_OFFSET_Y );

			w = CB_text_get_string_width_sys( (const byte *)ItemValue[i], 0, CONFIG_FONTW_SYS, fontCoding_type );
			x0 = x + MENU_ITEM_BAR_OFFSET_X + (( MENU_ITEM_BAR_LOGO_W - w ) >> 1);
			y0 = y + MENU_ITEM_BAR_OFFSET_Y + ( MENU_ITEM_BAR_LOGO_H + 1 - DISP_FONTSIZE ) / 2;
			TextOut( x0, y0, (const byte *)ItemValue[i], MENU_ITEM_BAR_FCOLOR, DOWN_SCREEN );
		}

		y += MENU_ITEM_SPACE;
		mask >>= 1;
		maskFocus >>= 1;
	}
}
