#include "SettingsFrame.h"
#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <DrvMemMgr.h>

#include <debugoff.h>

pixel LArrow[MENU_ARROW_LR_W * MENU_ARROW_LR_H];
pixel RArrow[MENU_ARROW_LR_W * MENU_ARROW_LR_H];
pixel MenuBarBg[MENU_ITEM_BAR_LOGO_W * MENU_ITEM_BAR_LOGO_H];

BOOL LArrow_IsReady = false;
BOOL RArrow_IsReady = false;
BOOL MenuBarBg_IsReady = false;

void DrawSettingsFrame(  BOOL needp_LR  )
{
	int result;
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	pixel *Vram = GetVram( DOWN_SCREEN );

	//ò˵
	result = image_read_sys( CONFIG_MENUBG, fs_file_get_type( CONFIG_MENUBG ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, MAINMENU_BG_X, MAINMENU_BG_Y );
	}

	if( needp_LR )
	{
		//L
		result = image_read_sys( CONFIG_MENUL, fs_file_get_type( CONFIG_MENUL ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, MENU_L_X, MENU_L_Y, COLOR_GREEN );
		}

		//R
		result = image_read_sys( CONFIG_MENUR, fs_file_get_type( CONFIG_MENUR ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, MENU_R_X, MENU_R_Y, COLOR_GREEN );
		}
	}

	if( LArrow_IsReady == false )
	{
		//LArrow
		result = image_read_sys( CONFIG_LARROW, fs_file_get_type( CONFIG_LARROW ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt( imgdata, width, height, LArrow, width, height );
			LArrow_IsReady = true;
		}
	}

	if( RArrow_IsReady == false )
	{
		//RArrow
		result = image_read_sys( CONFIG_RARROW, fs_file_get_type( CONFIG_RARROW ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt( imgdata, width, height, RArrow, width, height );
			RArrow_IsReady = true;
		}
	}

	if( MenuBarBg_IsReady == false )
	{
		result = image_read_sys( CONFIG_MENUBAR, fs_file_get_type( CONFIG_MENUBAR ), &width, &height, &imgdata, &bgc );
		if( result == 0 )
		{
			bitBlt( imgdata, width, height, MenuBarBg, width, height );
			MenuBarBg_IsReady = true;
		}
	}

	if( imgdata )
	{
		free((void *) imgdata);
		imgdata = NULL;
	}
}
