#include <string.h>
#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <Macro.h>
#include <conf.h>
#include <scene.h>
#include <DrvMemMgr.h>
#include <MainMenuSettings.h>
#include <SettingsFrame.h>
#include <ds2io2.h>
#include <ctrl.h>
#include <key.h>
#include <StyleSet.h>
#include <FontSet.h>
#include <strsafe.h>
#include <gdi.h>
#include <language.h>


#include <debugoff.h>

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )


#undef  	BTN_COUNT
#define		BTN_COUNT					2

#define		SELECTED_RECT_W				3

pixel *StyleBuf = NULL;
U32 neeprlogo = 0;//ǷҪȡ 0:ʾӦλҪ 1:ѾȡҪ

static pixel *StyleBarBuf[STYLELOGO_COUNT];
static U32 neeprBarlogo = 0;//ǷҪȡ 0:ʾӦλҪ 1:ѾȡҪ

const STYLESET_s Style[10] = {
{ MENU_STYLE1_FCOLOR, 	MENU_STYLE1_BGCOLOR },
{ MENU_STYLE2_FCOLOR, 	MENU_STYLE2_BGCOLOR },
{ MENU_STYLE3_FCOLOR, 	MENU_STYLE3_BGCOLOR },
{ MENU_STYLE4_FCOLOR, 	MENU_STYLE4_BGCOLOR },
{ MENU_STYLE5_FCOLOR,	MENU_STYLE5_BGCOLOR },
{ MENU_STYLE6_FCOLOR,	MENU_STYLE6_BGCOLOR },
{ MENU_STYLE7_FCOLOR,	MENU_STYLE7_BGCOLOR },
{ MENU_STYLE8_FCOLOR,	MENU_STYLE8_BGCOLOR },
{ MENU_STYLE9_FCOLOR,	MENU_STYLE9_BGCOLOR },
{ MENU_STYLE10_FCOLOR, MENU_STYLE10_BGCOLOR }
};

pixel StyleRect[ (MENU_STYLE_RECT_W + SELECTED_RECT_W * 2) * ( MENU_STYLE_RECT_H + SELECTED_RECT_W * 2) ];

static POS ItemPos[STYLE_ITEM_COUNT];

enum
{
	ITEM0 = 0,
	STYLE0 = 0,
	STYLE1,
	STYLE2,
	STYLE3,
	STYLE4,
	STYLE5,
	STYLE6,
	STYLE7,
	STYLE8,
	STYLE9,
	ITEM_MAX = STYLE9,
	ITEM_INVALID,
};

U32 StyleSet( int  *StyleIndex )
{
	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	U32 RetValue = 0;
	int result;
	U16 key;
	int i;
	int x,y;
	int SelectBar = *StyleIndex;
	int SelectBar_old = SelectBar;
	U32 mask, maskFocus;//mask16λΪλǵǰѡ16λΪλһѡ

	DrawSettingsFrame( true );
	MenuKeyHintDraw( 1 );

	if( SelectBar < ITEM0 || SelectBar > ITEM_MAX )
	{
		SelectBar = SelectBar_old = 0;
	}

	y = MENU_STYLE1_Y - MENU_STYLE_OFFSET_Y;//һλ
	for( i=0; i<STYLE_ITEM_COUNT; i++ )
	{
		if( i & 0x1 )
		{
			x = MENU_STYLE1_X + MENU_STYLE_OFFSET_X;
		}
		else
		{
			x = MENU_STYLE1_X;
			y += MENU_STYLE_OFFSET_Y;
		}
		ItemPos[i].x = x;
		ItemPos[i].y = y;
	}

	mask = 0x03FF;
	maskFocus = BIT( SelectBar );
	StyleDraw( mask, maskFocus );

	Flush( DOWN_SCREEN );
	ctrl_waitrelease_anykey();

	while ( 1 )
	{
		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_SysKeyCheck( inputkey.key );
		key = inputkey.key;

		if( key == KEY_UP )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM0 )
				SelectBar = ITEM_MAX - 1;
			else if( SelectBar == ITEM0 + 1 )
				SelectBar = ITEM_MAX;
			else
				SelectBar -= 2;

		}
		else if( key == KEY_DOWN )
		{
			SelectBar_old = SelectBar;
			if( SelectBar == ITEM_MAX - 1 )
				SelectBar = ITEM0;
			else if( SelectBar == ITEM_MAX )
				SelectBar = ITEM0 + 1;
			else
				SelectBar += 2;

		}
		else if( key == KEY_LEFT || key == KEY_RIGHT )
		{
			SelectBar_old = SelectBar;
			if( (SelectBar & 0x01)  == 0 )
				SelectBar++;
			else
				SelectBar--;
		}

		else if( key == KEY_A )
		{
_BGSET_KEY_OK_PRESS:
			ctrl_waitrelease( key );
			if( SelectBar != *StyleIndex )
			{
				*StyleIndex = SelectBar;
				RetValue = bmSTYLE;
			}
			break;
		}
		else if( key == KEY_B )
		{
			RetValue = 0;
			break;
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸѡ
			for( i = 0; i < STYLE_ITEM_COUNT; i++ )
			{
				AjustKey.Min_x = ItemPos[i].x;
				AjustKey.Max_x = AjustKey.Min_x + MENU_STYLE_RECT_W;

				AjustKey.Min_y = ItemPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + MENU_STYLE_RECT_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					SelectBar_old = SelectBar;
					SelectBar = i;
#if 1
					mask      =  BIT( SelectBar_old ) << 16;
					maskFocus = BIT( SelectBar );
					StyleDraw( mask, maskFocus );
					Flush( DOWN_SCREEN );
					goto _BGSET_KEY_OK_PRESS;//ֱת൱ڰȷ
#else
					key = KEY_TOUCH | KEY_A;
#endif
				}
			}
		}
		else if( key == KEY_L )
		{
			RetValue = BACKWARD;
			ctrl_waitrelease( key );
			break;
		}
		else if( key == KEY_R )
		{
			RetValue = FORWARD;
			ctrl_waitrelease( key );
			break;
		}
		else
		{
//			continue;
		}

		if( key == KEY_UP || key == KEY_DOWN || key == KEY_LEFT || key == KEY_RIGHT || key ==  (KEY_TOUCH | KEY_A) )// key ==  KEY_TOUCH | KEY_A
		{
			if( SelectBar != SelectBar_old )
			{
				mask      =  BIT( SelectBar_old ) << 16;
				maskFocus = BIT( SelectBar );
				StyleDraw( mask, maskFocus );
			}
			Flush( DOWN_SCREEN );
		}
	}

	for( i = STYLELOGO_COUNT; i < STYLE_ITEM_COUNT; i++ )
	{
		if( neeprBarlogo & BIT( i ) )
		{
			free( StyleBarBuf[i-STYLELOGO_COUNT] );
			StyleBarBuf[i-STYLELOGO_COUNT] = 0;
		}
	}
	neeprBarlogo = 0;

	return RetValue;
}

void StyleDraw( U32 mask, U32 maskFocus )
{
	int x,y,i;
	U16 w,h;
	const char ItemStr[STYLELOGO_COUNT][12] = {
		"BLACK NIGHT",
		"Green",
		"BOARD",
		"BUM",
		"PINK"
	};
	BOOL FirstDrawFlag = false;
	U32 maskTemp;
	char logoname[128];

#if USE_UNICODE_FONTLIB
	char ucs2[64];
#endif

	pixel *Vram = GetVram( DOWN_SCREEN );

	int result;
	dword width,height;
	pixel *imgdata = NULL;
	pixel bgc;

	if( (mask & 0xffff) == 0x03FF )
	{
		w = CB_text_get_string_width_sys( (const byte *)lang_item[LANG_STYLE_TITLE_ID], 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
		x = ( SCREEN_W - w ) >> 1;
		TextOut( x, MENU_TITLE_Y, (const byte*)lang_item[LANG_STYLE_TITLE_ID], MENU_TITLE_FCOLOR, DOWN_SCREEN );
		FirstDrawFlag = true;
	}


	if( neeprBarlogo == 0 )
	{
		for( i = 0; i < STYLELOGO_COUNT; i++ )
			StyleBarBuf[i] = 0;
	}

	//ԭ
	if( FirstDrawFlag == false )
	{
		maskTemp = mask;
		maskTemp >>= 16;
		for( i=0; i<STYLE_ITEM_COUNT; i++ )
		{
			if( maskTemp == 0 )
				break;
			if( maskTemp & 0x1 )
			{
				x = ItemPos[i].x - SELECTED_RECT_W;
				y = ItemPos[i].y - SELECTED_RECT_W;
				w = MENU_STYLE_RECT_W + SELECTED_RECT_W * 2;
				h = MENU_STYLE_RECT_H + SELECTED_RECT_W * 2;
				bitBlt1( StyleRect, w, h, Vram, SCREEN_W, SCREEN_H, x, y );
			}
			maskTemp >>= 1;
		}
	}
	for( i=0; i<STYLE_ITEM_COUNT; i++ )
	{
		if( mask == 0 )
			break;

		if( mask & 0x1 )
		{
			if( i < STYLELOGO_COUNT )
			{
				FillRect( ItemPos[i].x, ItemPos[i].y, MENU_STYLE_RECT_W, MENU_STYLE_RECT_H, Style[i].bcolor, DOWN_SCREEN );

				x = ItemPos[i].x + ( ( MENU_STYLE_RECT_W - 5 * (DISP_FONTSIZE>>1) ) >> 1 );
				y = ItemPos[i].y + ( ( MENU_STYLE_RECT_H - DISP_FONTSIZE ) >> 1 );
				SPRINTF_S( logoname, "%s%d", "SKIN", i + 1 );//ʾı䣬Ÿı

#if USE_UNICODE_FONTLIB
					utf8_ucs2( (const char*)logoname, (byte*)ucs2 );
					TextOut( x, y, (const byte*)ucs2, Style[i].fcolor, DOWN_SCREEN );
#else
		 			TextOut( x, y, (const byte*)logoname, Style[i].fcolor, DOWN_SCREEN );
#endif

			}
			else
			{
				if( neeprBarlogo & BIT( i ) )
				{
					bitBlt1( StyleBarBuf[i-STYLELOGO_COUNT], width, height, Vram, SCREEN_W, SCREEN_H, ItemPos[i].x, ItemPos[i].y );

					x = ItemPos[i].x + ( ( MENU_STYLE_RECT_W - strlen( ItemStr[i-STYLELOGO_COUNT] ) * (DISP_FONTSIZE>>1) ) >> 1 );
					y = ItemPos[i].y + ( ( MENU_STYLE_RECT_H - DISP_FONTSIZE ) >> 1 );
#if USE_UNICODE_FONTLIB
					utf8_ucs2( ItemStr[i-STYLELOGO_COUNT], (byte*)ucs2 );
					TextOut( x, y, (const byte*)ucs2, Style[i].fcolor, DOWN_SCREEN );
#else
					TextOut( x, y, (const byte*)ItemStr[i-STYLELOGO_COUNT], Style[i].fcolor, DOWN_SCREEN );
#endif

				}
				else
				{
					SPRINTF_S( logoname, "%s%d%s", "Style", i + 1, "_Bar.bmp");//ļı䣬Ÿı
					result = image_read_sys( logoname, fs_file_get_type( logoname ), &width, &height, &imgdata, &bgc );
					if( result == 0 )
					{
						bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, ItemPos[i].x, ItemPos[i].y );

						StyleBarBuf[i-STYLELOGO_COUNT] = memalign( sizeof( pixel ), sizeof( pixel ) * width * height );
						if( StyleBarBuf[i-STYLELOGO_COUNT] )
						{
							bitBlt( imgdata, width, height, StyleBarBuf[i-STYLELOGO_COUNT], width, height );
							neeprBarlogo |= BIT( i );
						}

						x = ItemPos[i].x + ( ( MENU_STYLE_RECT_W - strlen( ItemStr[i-STYLELOGO_COUNT] ) * (DISP_FONTSIZE>>1) ) >> 1 );
						y = ItemPos[i].y + ( ( MENU_STYLE_RECT_H - DISP_FONTSIZE ) >> 1 );
#if USE_UNICODE_FONTLIB
						utf8_ucs2( ItemStr[i-STYLELOGO_COUNT], (byte*)logoname );
						TextOut( x, y, (const byte*)logoname, Style[i].fcolor, DOWN_SCREEN );
#else
						TextOut( x, y, (const byte*)ItemStr[i-STYLELOGO_COUNT], Style[i].fcolor, DOWN_SCREEN );
#endif
					}
				}
			}
		}

		if( maskFocus & 0x1 )
		{
			//
			x = ItemPos[i].x - SELECTED_RECT_W;
			y = ItemPos[i].y - SELECTED_RECT_W;
			w = MENU_STYLE_RECT_W + SELECTED_RECT_W * 2;
			h = MENU_STYLE_RECT_H + SELECTED_RECT_W * 2;
			bitBlt2( Vram, SCREEN_W, SCREEN_H, x, y, StyleRect, w, h, 0, 0 );

			//ѡ
			DrawRect0( x, y, w, h, SELECTED_RECT_W, MENU_STYLE_RECT_BGCOLOR_FOCUS, DOWN_SCREEN );
		}
		mask >>= 1;
		maskFocus >>= 1;
	}
	if( imgdata )
	{
		free((void *) imgdata);
		imgdata = NULL;
	}
}
