#include <string.h>
#include <datatype.h>
#include <config_ebook.h>
#include <image.h>
#include <fs.h>
#include <display.h>
#include <mystring.h>
#include <gdi.h>
#include <msgbox.h>
#include <strsafe.h>
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <MainMenuSettings.h>
#include <Macro.h>
#include <ctrl.h>
#include <key.h>
#include <scene.h>
#include <language.h>

#include <debugoff.h>

#define		TextOut( x, y, text, color, engine ) CB_putnstringhorz_sys( x, y, 0, text, INVALID_LEN, color, engine, DISP_FONTSIZE, DISP_FONTSIZE )

int DrawMessageBox( const char *title, int title_align, const char *msg, SCREEN_ID engine, U32 dialogtype, BOOL IsModeDialog )
{
	int i,x,x_offset;
	int keyA_logo_x = 0;
	int keyB_logo_x = 0;
	int msg_x,msg_y,msg_w, msg_h;
	int msg_btn_bank;
	int tempw;
	int w;
	int font_in_book_old = font_in_book;

	POS KeyPos[2];

	int KeyNum = 0;
	int result;
	dword width, height;
	pixel *imgdata = NULL;
	pixel bgc;
	int len, len_msg;

	KEY_BUF inputkey;
	AJUST_KEY_BUF AjustKey;
	U16 key;

	pixel *Vram = GetVram( engine );

	int fontCoding_type = GetlanguageCodingType();

	font_in_book = false;
	len_msg = strlen_ucs( msg );
	
	if( len_msg > 26 )
	{
		result = image_read_sys( CONFIG_MSGBOX2, fs_file_get_type( CONFIG_MSGBOX2 ), &width, &height, &imgdata, &bgc );
		msg_w = MSG_W2;
		msg_h = MSG_H2;
		msg_btn_bank = MSG_BTN_BANK2;
	}
	else
	{
		result = image_read_sys( CONFIG_MSGBOX, fs_file_get_type( CONFIG_MSGBOX ), &width, &height, &imgdata, &bgc );
		msg_w = MSG_W;
		msg_h = MSG_H;
		msg_btn_bank = MSG_BTN_BANK;
	}

	msg_x = (SCREEN_W - msg_w) >> 1;
	msg_y = (SCREEN_H - msg_h) >> 1;

	if( result == 0 )
	{
		bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, msg_x, msg_y, COLOR_GREEN );
	}

	if( lang_ok == NULL )
		lang_ok = &default_lang_str;

	if( lang_cancel == NULL )
		lang_cancel = &default_lang_str;

	len = strlen( lang_ok );
	x_offset = (BTN_W - len * (DISP_FONTSIZE>>1) - 12) >> 1;



	result = image_read_sys( CONFIG_BTNBG, fs_file_get_type( CONFIG_BTNBG ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		if( dialogtype == MB_OK ) // ȷ
		{
			x = msg_x + ( ( msg_w - BTN_W ) >> 1 );
			bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, MSG_OK_Y );

			w = CB_text_get_string_width_sys( (const byte *)lang_ok, 0, CONFIG_FONTW_SYS, fontCoding_type );
			tempw = w + 2 + KEY_W;
			if( BTN_W >= tempw + 2  )
			{
				x_offset = (BTN_W - tempw) >> 1;
				keyA_logo_x = x + x_offset + w + 2;
			}
			else if( BTN_W >= tempw  )
			{
				x_offset = 1;
				keyA_logo_x = x + x_offset + w;
			}
			else
			{
				x_offset = 0;
				keyA_logo_x = x + w;
			}
			TextOut( x + x_offset, MSG_OK_FONT_Y, (const byte *)lang_ok, MSG_KEY_FCOLOR, engine );

			KeyNum = 1;
			KeyPos[0].x = x;
		}
		else if( dialogtype == MB_CANCEL )// ˳
		{
			x = msg_x + ( ( msg_w - BTN_W ) >> 1 );
			bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, MSG_CANCEL_Y );

			w = CB_text_get_string_width_sys( (const byte *)lang_cancel, 0, CONFIG_FONTW_SYS, fontCoding_type );
			tempw = w + 2 + KEY_W;

			if( BTN_W >= tempw + 2  )
			{
				x_offset = (BTN_W - tempw) >> 1;
				keyB_logo_x = x + x_offset + w + 2;
			}
			else if( BTN_W >= tempw  )
			{
				x_offset = 1;
				keyB_logo_x = x + x_offset + w;
			}
			else
			{
				x_offset = 0;
				keyB_logo_x = x + w;
			}

			TextOut( x + x_offset, MSG_CANCEL_FONT_Y, (const byte *)lang_cancel, MSG_KEY_FCOLOR, engine );

			KeyNum = 1;
			KeyPos[0].x = x;
		}
		else if( dialogtype == ( MB_OK | MB_CANCEL ) )// ȷ/˳
		{
			KeyNum = 2;
			tempw = ( (msg_w - msg_btn_bank) >> 1 ) - BTN_W;//msg_btn_bank:࣬tempwߵİϢ߿Ŀ
			KeyPos[0].x = msg_x + tempw;
			KeyPos[1].x = KeyPos[0].x + BTN_W + msg_btn_bank;

			bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, KeyPos[0].x, MSG_OK_Y );
			bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, KeyPos[1].x, MSG_CANCEL_Y );

			w = CB_text_get_string_width_sys( (const byte *)lang_ok, 0, CONFIG_FONTW_SYS, fontCoding_type );
			tempw = w + 2 + KEY_W;
			if( BTN_W >= tempw + 2  )
			{
				x_offset = (BTN_W - tempw) >> 1;
				keyA_logo_x = KeyPos[0].x + x_offset + w + 2;
			}
			else if( BTN_W >= tempw  )
			{
				x_offset = 1;
				keyA_logo_x = KeyPos[0].x + x_offset + w;
			}
			else
			{
				x_offset = 0;
				keyA_logo_x = KeyPos[0].x + w;
			}
			TextOut( KeyPos[0].x + x_offset, MSG_OK_FONT_Y, (const byte *)lang_ok, MSG_KEY_FCOLOR, engine );

			w = CB_text_get_string_width_sys( (const byte *)lang_cancel, 0, CONFIG_FONTW_SYS, fontCoding_type );
			tempw = w + 2 + KEY_W;

			if( BTN_W >= tempw + 2  )
			{
				x_offset = (BTN_W - tempw) >> 1;
				keyB_logo_x = KeyPos[1].x + x_offset + w + 2;
			}
			else if( BTN_W >= tempw  )
			{
				x_offset = 1;
				keyB_logo_x = KeyPos[1].x + x_offset + w;
			}
			else
			{
				x_offset = 0;
				keyB_logo_x = KeyPos[1].x + w;
			}

			TextOut( KeyPos[1].x + x_offset, MSG_CANCEL_FONT_Y, (const byte *)lang_cancel, MSG_KEY_FCOLOR, engine );
		}
		else
		{
			goto _MsgBox_Exit;
		}
		free((void *) imgdata);

		if( dialogtype & MB_OK )
		{
			result = image_read_sys( CONFIG_AKEY, fs_file_get_type( CONFIG_AKEY ), &width, &height, &imgdata, &bgc );
			if( result == 0 )
			{
				bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, keyA_logo_x, MSG_OK_Y + 2, COLOR_GREEN );
			}
		}

		if( dialogtype & MB_CANCEL )
		{
			result = image_read_sys( CONFIG_BKEY, fs_file_get_type( CONFIG_BKEY ), &width, &height, &imgdata, &bgc );
			if( result == 0 )
			{
				if( KeyNum == 2 )
					i = 1;
				else
					i = 0;
				bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, keyB_logo_x, MSG_OK_Y + 2, COLOR_GREEN );
			}
		}
	}

	KeyPos[0].y = MSG_OK_Y;//궼һ
	KeyPos[1].y = MSG_OK_Y;//궼һ

	//
	if( title_align == LEFT_ALIGN )
		x = msg_x + 5;
	else if( title_align == RIGHT_ALIGN )
		x = msg_x + ( msg_w - ( strlen( title ) ) * (DISP_FONTSIZE >> 1) - 5 );
	else //if( title_align == CENTER_ALIGN )
		x = msg_x + ( (msg_w - ( strlen( title ) ) * (DISP_FONTSIZE >> 1) ) >> 1 );
	TextOut( x, MSG_TITLE_Y, (const byte*)title, MSG_TITLE_FCOLOR, engine );

	w = CB_text_get_string_width_sys( (const byte *)msg, 0, CONFIG_FONTW_SYS, fontCoding_type );
	if( w <= msg_w )
	{
		x = msg_x + ( (msg_w - w ) >> 1 );
		TextOut( x, MSG_TEXT_Y, (const byte*)msg, MSG_TEXT_FCOLOR, engine );
	}
	else
	{
//		len = strlen( msg );
		len = strlen_ucs( msg );
		int len_line = msg_w / DISP_FONTSIZE * 2 - 2;
		int line = 1;
		line += len / len_line;
		int y = MSG_TEXT_Y - DISP_FONTSIZE * (line >> 1);
		if( y < msg_y + 22 )
			y = msg_y + 22;

		dword maxpixel = len_line * DISP_FONTSIZE / 2;

#define		MAX_LINE		4
		dword pixelw;
		const char *pos = msg;
		const char *posend = pos + memlen_s( msg );
		dword count;

		if( line > MAX_LINE )
			line = MAX_LINE;

		for( i=0; i<line;i++ )
		{
			pixelw = CB_text_get_string_width( pos, posend, maxpixel, 0, &count, DISP_FONTSIZE );

			x = msg_x + ( (msg_w - pixelw ) >> 1 );

//			CB_putnstringhorz_sys( x, y, 0, (const byte*)pos, strcount_ucs( pos, count ), MSG_TEXT_FCOLOR, engine, DISP_FONTSIZE, DISP_FONTSIZE );
			CB_putnstringhorz_sys( x, y, 0, (const byte*)pos, count, MSG_TEXT_FCOLOR, engine, DISP_FONTSIZE, DISP_FONTSIZE );
			y += DISP_FONTSIZE;
			if( line != MAX_LINE )
				y += 2;

			pos += count;

			if( pos >= posend )
				break;
		}
	}

	if( IsModeDialog == false )
	{
		font_in_book = font_in_book_old;
		return 1;
	}

	Flush( engine );

	ctrl_waitrelease_anykey();

	while( 1 )
	{
//		Flush( engine );

		while( !(Proc_GetInput( &inputkey, CONFIG_KEY_REPEAT_TIME_N )) );
		Proc_Supend( inputkey.key );
		key = inputkey.key;

		ctrl_waitrelease( key );

		if( key == KEY_A )
		{
			if( dialogtype & MB_OK )
			{
				result = 1;
				break;
			}
		}
		else if( key == KEY_B )
		{
			if( dialogtype & MB_CANCEL )
			{
				result = 0;
				break;
			}
		}
		else if( key == KEY_TOUCH )
		{
			//жǷĸ
			for( i = 0; i < KeyNum; i++ )
			{
				AjustKey.Min_x = KeyPos[i].x;
				AjustKey.Max_x = AjustKey.Min_x + BTN_W;

				AjustKey.Min_y = KeyPos[i].y;
				AjustKey.Max_y = AjustKey.Min_y + BTN_H;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					result = 1 - i;
					goto _MsgBox_Exit;
				}
			}
		}
	}
_MsgBox_Exit:

	if( imgdata )
	{
		free((void *) imgdata);
	}
	font_in_book = font_in_book_old;
	return result;
}
