/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config_ebook.h"

#ifdef ENABLE_BG

#include <string.h>
#include "display.h"
#include "image.h"
#include "bg.h"
#include "config.h"
#include "scene.h"
#include "win.h"

#if ENABLE_BMP
#include <bmp.h>
BMPContext *bmpctx;
#endif

#include "common/utils.h"
#include "conf.h"
#include <gdi.h>

#include <MainMenuSettings.h>
#include <mystring.h>
#include <DrvMemMgr.h>
#include <language.h>

#include <debugoff.h>

//-----------------------------------궨---------------------------------------------


//-----------------------------------ȫֱ---------------------------------------
pixel bg_start_down[SCREEN_W * SCREEN_H];//̬ͼ񻺴
pixel bg_start_up[SCREEN_W * SCREEN_H];//̬ͼ񻺴

pixel RetLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel FolderLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel TxtLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel PdfLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel PicLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel ZipLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel UnknowLOGO[FL_MINILOGO_W * FL_MINILOGO_H];
pixel SlideLOGO[FL_SLIDE_W * FL_SLIDE_H];

int notice_exit_font_x = -1;

const pixel FLBgColor[2] = { FL_FIRSTLINE_BG_COLOR, FL_SECONDLINE_BG_COLOR };
const pixel FL_LineRecty[10] = {
	FL_MINILOGO_START_Y+FL_LINE_H * 0,
	FL_MINILOGO_START_Y+FL_LINE_H * 1,
	FL_MINILOGO_START_Y+FL_LINE_H * 2,
	FL_MINILOGO_START_Y+FL_LINE_H * 3,
	FL_MINILOGO_START_Y+FL_LINE_H * 4,
	FL_MINILOGO_START_Y+FL_LINE_H * 5,
	FL_MINILOGO_START_Y+FL_LINE_H * 6,
	FL_MINILOGO_START_Y+FL_LINE_H * 7,
	FL_MINILOGO_START_Y+FL_LINE_H * 8,
	FL_MINILOGO_START_Y+FL_LINE_H * 9
};


//-----------------------------------ȫֱ---------------------------------------
extern t_conf config;
extern pixel * bufferMain;
extern pixel * bufferSub;

//-----------------------------------------------------------------------------------
void bg_screen_load()
{
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	int result;

	int wordspace;
	int fontCoding_type = GetlanguageCodingType();
#if USE_UNICODE_FONTLIB
	U16 ucs2[10];
#endif
	int font_in_book_bak = font_in_book;
	font_in_book = false;
	
//----------------------------------------------------------------------------------------------
	result = image_read_sys( CONFIG_SUBBG, fs_file_get_type( CONFIG_SUBBG ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, bg_start_up, SCREEN_W, SCREEN_H, 0, 0 );//
		free((void *) imgdata);
		imgdata = NULL;
	}

	//SELECT KEY
	result = image_read_sys( CONFIG_SELECTKEY, fs_file_get_type( CONFIG_SELECTKEY ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBltFC( imgdata, width, height, bg_start_up, SCREEN_W, SCREEN_H, NOTICE_HELP_LOGO_X, NOTICE_HELP_LOGO_Y, COLOR_GREEN );//
		free((void *) imgdata);
		imgdata = NULL;
	}

	//START KEY
	result = image_read_sys( CONFIG_STARTKEY, fs_file_get_type( CONFIG_STARTKEY ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBltFC( imgdata, width, height, bg_start_up, SCREEN_W, SCREEN_H, NOTICE_EXIT_LOGO_X, NOTICE_EXIT_LOGO_Y, COLOR_GREEN );//
		free((void *) imgdata);
		imgdata = NULL;
	}
	bufferTemp = bg_start_up;
#if USE_UNICODE_FONTLIB
	memset( (void*)ucs2, 0x00, 10*2 );
	utf8_to_ucs_Fast( ucs2, 10*2, (const byte*)EDITION_STR, INVALID_LEN );
	CB_putnstringhorz_sys( EDITION_STR_X, EDITION_STR_Y, 0, (const byte *)ucs2, INVALID_LEN, EDITION_STR_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
#else
	CB_putnstringhorz_sys( EDITION_STR_X, EDITION_STR_Y, 0, (const byte *)EDITION_STR, INVALID_LEN, EDITION_STR_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
	if( config.cur_lang_index == LANG_INDEX_CN )
		wordspace = 1;
	else
		wordspace = 0;

	width = CB_text_get_string_width_sys( (const byte*)lang_Help, 0, CONFIG_FONTW_SYS, fontCoding_type );
	CB_putnstringhorz_sys( NOTICE_HELP_LOGO_X - width - 4, NOTICE_HELP_Y, wordspace, (const byte *)lang_Help, INVALID_LEN, NOTICE_FCOLOR, VRAMTEMP, DISP_BOOK_FONTSIZE, DISP_BOOK_FONTSIZE );
	width = CB_text_get_string_width_sys( (const byte*)lang_Exit, 0, CONFIG_FONTW_SYS, fontCoding_type );
	notice_exit_font_x = NOTICE_EXIT_LOGO_X - width - 4;
	CB_putnstringhorz_sys( notice_exit_font_x, NOTICE_EXIT_Y, wordspace, (const byte *)lang_Exit, INVALID_LEN, NOTICE_FCOLOR, VRAMTEMP, DISP_BOOK_FONTSIZE, DISP_BOOK_FONTSIZE );

	font_in_book = font_in_book_bak;
}

extern void bg_load()
{
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	int result;

	int wordspace;
	int fontCoding_type = GetlanguageCodingType();
#if USE_UNICODE_FONTLIB
	U16 ucs2[10];
#endif
	
	bg_screen_load();

//----------------------------------------------------------------------------------------------
	//ļб
	result = image_read_sys( CONFIG_MAINBG, fs_file_get_type( CONFIG_MAINBG ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, bg_start_down, SCREEN_W, SCREEN_H, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//L
	result = image_read_sys( CONFIG_LLOGO, fs_file_get_type( CONFIG_LLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, bg_start_down, SCREEN_W, SCREEN_H, FL_L_X, FL_L_Y );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//R
	result = image_read_sys( CONFIG_RLOGO, fs_file_get_type( CONFIG_RLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, bg_start_down, SCREEN_W, SCREEN_H, FL_R_X, FL_R_Y );
		free((void *) imgdata);
		imgdata = NULL;
	}

//-----------------------------------д----------------------------------------------------------
#if 0
	bufferTemp = bg_start_down;
	CB_putnstringhorz_sys( FL_CATALOG_FONT_X, FL_CATALOG_FONT_Y, 0, (const byte *)"Ŀ¼:", INVALID_LEN, FL_CATALOG_FONT_FCOLOR, VRAMTEMP, DISP_FONTSIZE, DISP_FONTSIZE );
	bufferTemp = 0;
#endif


//----------------------------------------ƲҪͼƬ------------------------------------------------
	//
	result = image_read_sys( CONFIG_RETURNBG, fs_file_get_type( CONFIG_RETURNBG ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, RetLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//ļLOGO
	result = image_read_sys( CONFIG_FOLDERLOGO, fs_file_get_type( CONFIG_FOLDERLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, FolderLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//TXT LOGO
	result = image_read_sys( CONFIG_TXTLOGO, fs_file_get_type( CONFIG_TXTLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, TxtLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//PDF LOGO
	result = image_read_sys( CONFIG_PDFLOGO, fs_file_get_type( CONFIG_PDFLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, PdfLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//PIC LOGO
	result = image_read_sys( CONFIG_PICLOGO, fs_file_get_type( CONFIG_PICLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, PicLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//ZIP LOGO
	result = image_read_sys( CONFIG_ZIPLOGO, fs_file_get_type( CONFIG_ZIPLOGO ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, ZipLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//Unknow LOGO
	result = image_read_sys( CONFIG_UNKNOWFILE, fs_file_get_type( CONFIG_UNKNOWFILE ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, UnknowLOGO, FL_MINILOGO_W, FL_MINILOGO_W, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//Slide LOGO
	result = image_read_sys( CONFIG_SLIDE, fs_file_get_type( CONFIG_SLIDE ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, SlideLOGO, FL_SLIDE_W, FL_SLIDE_H, 0, 0 );
		free((void *) imgdata);
		imgdata = NULL;
	}

	//---ò˵LOGO---
	DrawSettingMenuBar( 0x7F, 0x7F );//ѡʱ
	DrawSettingMenuBar( 0x7F, 0x00 );//ѡʱ
}

extern BOOL bg_display( SCREEN_ID engine )
{
	int i,j;
	int x,y,x_font;
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	int result;
	pixel *Vram = NULL;
	const char LogoName[2][64] = { CONFIG_CATEGORYFOCUS, CONFIG_CATEGORY };
	pixel Fcolor;
	char *lang_str[3];

	if ( config.have_bg )
	{
		if( engine == DOWN_SCREEN )
		{
			LoadVram( bg_start_down, engine );

			Vram = GetVram( DOWN_SCREEN );

			x = ( SCREEN_W - ( FL_CATEGORY_W + FL_CATEGORY_BANK ) * 3 - FL_CATEGORY_BANK ) >> 1;
			y = FL_CATEGORY_Y + ( FL_CATEGORY_H - DISP_FONTSIZE ) / 2;

			i = 0;
			lang_str[i++] = lang_item[LANG_CATALOG_ALL_ID];
			lang_str[i++] = lang_item[LANG_CATALOG_BOOK_ID];
			lang_str[i++] = lang_item[LANG_CATALOG_PICTURE_ID];

			int fontCoding_type = GetlanguageCodingType();
			for( i = 0; i < 3; i++ )
			{
				if( i == config.CategoryFlag )
				{
					j = 0;
					Fcolor = FL_CATEGORYFOCUS_FCOLOR;
				}
				else
				{
					j = 1;
					Fcolor = FL_CATEGORY_FCOLOR;
				}
				result = image_read_sys( LogoName[j], fs_file_get_type( LogoName[j] ), &width, &height, &imgdata, &bgc );
				if( result == 0 )
				{
					bitBltFC( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x , FL_CATEGORY_Y, COLOR_GREEN );
					free((void *) imgdata);
					imgdata = NULL;
				}

				//---------------------------д---------------------------
				width = CB_text_get_string_width_sys( (const byte*)lang_str[i], 0, CONFIG_FONTW_SYS, fontCoding_type );

				if( width <= FL_CATEGORY_W )
					x_font = x + (( FL_CATEGORY_W - width ) >> 1);
				else
					x_font = x;
				CB_putnstringhorz_sys( x_font, y, 0, (const unsigned char*)lang_str[i], INVALID_LEN, Fcolor, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
				x += ( FL_CATEGORY_W + FL_CATEGORY_BANK );
			}
		}
		else
		{
			LoadVram( bg_start_up, engine );
		}
		return true;
	}
	return false;
}

#endif
