#include <stdio.h>
#include "bmp.h"
#include <bmplib.h>
#include <fs_api.h>
#include "bit_ops.h"
#include <bmp.h>
#include <datatype.h>
#include <gdi.h>
#include <config_ebook.h>
#include <DrvMemMgr.h>
#include <Macro.h>
#include <scene_image.h>
#include <scene.h>
#include <mystring.h>
#include <memory.h>
#include <unzip.h>
#include <strsafe.h>

#include <debugoff.h>

#define Gravity(c,cg) { \
  c+=cg; \
  cg=c&7; \
  c=c>>3; \
  if((c&(~0x1f))!=0) c=(c<0) ? 0x00 : 0x1f; \
}
static U16 gr=0,gg=0,gb=0;

#define			IMAGEVIEW_MEMDEST_SIZE			( 1024 * 1024 )//1MBytes
#define			IMAGEVIEW_MEMSRC_SIZE			( 512 * 1024 )//512KBytes
unsigned int BufferDstPixel_Max = 0;

//-------------------------------------------------------------------------------------------
static BOOL CreateBMPBuf( BMPContext *bmpctx, U32 width, U32 height, U8 bpp );
static pixel * LoadBMP( const char *filename );
static void BMPFree( void );

//-------------------------------------------------------------------------------------------
BMPContext *bmpctx;
BMPContext *pGBMP;
static char *BMP_LoadErrorStr;
static pixel *bmpBuffer = NULL;
static int ErrorCode = ERR_UNKNOWN;
static bool ImgBufferHold = true;

//-------------------------------------------------------------------------------------------
static	int zoom_w, zoom_h;
static	int zoom_w_org, zoom_h_org;
static	int BufferDstLine_Out = 0;//Ѿн
static	pixel *imgzoomsrc = NULL;//Ų

//----------------------------
static	pixel *Vram = NULL;
static	pixel *VramLinePtr = NULL;
static	pixel *VramPtr = NULL;
static	int start_x_up = 0;
static	int dst_done_h_up = 0;
static	int dst_done_h_old_up = 0;
static	int dst_done_h_old_prev_up = 0;
static	int dst_done_h_up_max = 0;
static	int src_do_h_up = 0;
static	int srcstart_line_up = 0;//ŵԭʼʼ
static	int srcstart_line_old_up = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr_up[2] = { NULL, NULL };//ŵָ(2)
static	int start_pixelX = 0;
static	int end_pixelX = 0;
static	PAINT_RECT Prect;

//----------------------------
static	pixel *Thumbimg = NULL;
static	int start_x = 0;
static	int dst_done_h = 0;
static	int dst_done_h_old = 0;
static	int dst_done_h_old_prev = 0;
static	int src_do_h = 0;
static	int srcstart_line = 0;//ŵԭʼʼ
static	int srcstart_line_old = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr[2] = { NULL, NULL };//ŵָ(2)

static	dword Thumbw, Thumbh;
static	dword Thumbw_org, Thumbh_org;
static	RECT ThumbR, ThumbSR;

//-------------------------------------------------------------------------------------------
extern pixel * bufferMain;
extern pixel * bufferSub;

//-------------------------------------------------------------------------------------------
U32 BMPWidth()  { return bmpctx->width; }        // width is memory bitmap's width

U32 BMPHeight()  { return bmpctx->height; }    // height is memory bitmap's height

U32 BMPPitch()  { return bmpctx->pitch; }        // pitch returns bytes per line

pixel *BMPBuffer() { return (pixel *)bmpctx->buffer; }

BOOL BMPInit( void )
{
	BMPContext *bmpctxp = (BMPContext*)zmalloc( sizeof(BMPContext) );
	if( !bmpctxp )
	{
		ErrorCode = ERR_MEM_LACK;
		return false;
	}
	bmpctx = bmpctxp;
	bmpctx->width = 0;
	bmpctx->height = 0;
	bmpctx->pitch = 0;
	bmpctx->buffer = NULL;
	bmpctx->getwidth = &BMPWidth;
	bmpctx->getheight = &BMPHeight;
	bmpctx->getbuffer = BMPBuffer;
	bmpctx->LoadBMP = LoadBMP;
	bmpctx->createBMPbuf = &CreateBMPBuf;
	bmpctx->createBMP = &LoadBMP;
	bmpctx->Free = &BMPFree;
	return true;
}

static BOOL CreateBMPBuf( BMPContext *bmpctx, U32 width, U32 height, U8  bpp )
{
	U8 bpp_to_byte = 0;
	ImgBufferHold = true;
	switch( bpp )
	{
		case 8:
			bpp_to_byte = 1;
			break;
		case 15:
		case 16:
			bpp_to_byte = 2;
			break;
		case 24:
			bpp_to_byte = 3;
			break;
		case 32:
			bpp_to_byte = 4;
			break;
		default:
			break;
	}
	bmpctx->width = width;
    bmpctx->height = height;

    bmpctx->pitch = width * bpp_to_byte;//ÿеĶǰԭʼֽ,bpp_to_byte:λֽ
    bmpctx->pitch = (bmpctx->pitch + 3) & (~3);//ÿеĶԭʼֽ,bpp_to_byte:λֽ


	U32 bufferSize_Byte = width * height * PIXEL_BYTES;//ʾ治ֽڶ

	if( bmpBuffer == 0 )
		bmpBuffer= (pixel*)memalign( PIXEL_BYTES, bufferSize_Byte + 4 );//+width:ȫԺͷԿ
	if( bmpBuffer == 0 || (U32)bmpBuffer < 0x80000000 )
	{
		if( bufferSize_Byte > IMAGEVIEW_MEMDEST_SIZE )
			bufferSize_Byte = IMAGEVIEW_MEMDEST_SIZE;
		bmpBuffer= (pixel*)memalign( PIXEL_BYTES, bufferSize_Byte + 4 );//+width:ȫԺͷԿ
		if( bmpBuffer == 0 || (U32)bmpBuffer < 0x80000000 )
		{
			ErrorCode = ERR_MEM_LACK;
			return false;
		}
		ImgBufferHold = false;
	}
//	if( ImageViewFlag )//
//		ImgBufferHold = false;
	
	BufferDstPixel_Max = bufferSize_Byte >> (PIXEL_BYTES>>1);
	
	if( PIXEL_BYTES == 2 )
	{
		if( ImgBufferHold == false )
			memsetword( (word*)(bmpBuffer), COLOR_BLACK, (bufferSize_Byte + 4)>>1 );//Ϊɫ
		else
			memsetword( (word*)(bmpBuffer), COLOR_BLACK, width * height );//Ϊɫ
	}
	else if( PIXEL_BYTES == 4 )
	{
		if( ImgBufferHold == false )
			memsetdword( (word*)(bmpBuffer), COLOR_BLACK, (bufferSize_Byte + 4)>>2 );//Ϊɫ
		else
			memsetdword( (dword*)(bmpBuffer), COLOR_BLACK, width * height );//Ϊɫ
	}
    return true;
}


void BMPFree( void )
{
	if( bmpctx != NULL )
	{
		free( bmpctx );
		bmpctx = NULL;
	}
}

static inline U16 GetVariable16bit(void *pb)
{
  U16 res = 0;
  U8 *pb8=(U8*)pb;

  res  =(U16)pb8[0] << 0;
  res |=(U16)pb8[1] << 8;

  return(res);
}

static inline U32 GetVariable32bit(void *pb)
{
  U32 res = 0;
  U8 *pb8=(U8*)pb;

  res  =(U32)pb8[0] << 0;
  res |=(U32)pb8[1] << 8;
  res |=(U32)pb8[2] << 16;
  res |=(U32)pb8[3] << 24;

  return(res);
}

int GetBMPHeader(U8 *pb,TBMPHeader *pBMPHeader)
{
  if(pb==NULL){
    BMP_LoadErrorStr="SourceData Null.";
    ErrorCode = ERR_MEM_INVALID;
    return(false);
  }
  if(pBMPHeader==NULL){
    BMP_LoadErrorStr="pBMPHeader Null.";
    ErrorCode = ERR_MEM_INVALID;
    return(false);
  }

  pBMPHeader->bfType[0]=pb[0];
  pBMPHeader->bfType[1]=pb[1];
  pBMPHeader->bfSize=GetVariable32bit(&pb[2]);
  pBMPHeader->bfReserved1=GetVariable16bit(&pb[6]);
  pBMPHeader->bfReserved2=GetVariable16bit(&pb[8]);
  pBMPHeader->bfOffset=GetVariable32bit(&pb[10]);
  pBMPHeader->biSize=GetVariable32bit(&pb[14+0]);
  pBMPHeader->biWidth=GetVariable32bit(&pb[14+4]);
  pBMPHeader->biHeight=GetVariable32bit(&pb[14+8]);
  pBMPHeader->biPlanes=GetVariable16bit(&pb[14+12]);
  pBMPHeader->biBitCount=GetVariable16bit(&pb[14+14]);
  pBMPHeader->biCopmression=GetVariable32bit(&pb[14+16]);
  pBMPHeader->biSizeImage=GetVariable32bit(&pb[14+20]);
  pBMPHeader->biXPixPerMeter=GetVariable32bit(&pb[14+24]);
  pBMPHeader->biYPixPerMeter=GetVariable32bit(&pb[14+28]);
  pBMPHeader->biClrUsed=GetVariable32bit(&pb[14+32]);
  pBMPHeader->biCirImportant=GetVariable32bit(&pb[14+36]);

////  pBMPHeader->pPalette=&pb[14+40];//԰0x36ʼ
////  pBMPHeader->pBitmap=&pb[pBMPHeader->bfOffset];

  pBMPHeader->DataWidth=0;

  if((pBMPHeader->bfType[0]!='B')||(pBMPHeader->bfType[1]!='M'))
  {
    BMP_LoadErrorStr="Error MagicID!=BM";
    ErrorCode = ERR_FORMAT;
    return(false);
  }

  if(pBMPHeader->biCopmression!=BI_RGB){
    BMP_LoadErrorStr="Error notsupport Compression";
    ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
    return(false);
  }

  if(pBMPHeader->biHeight>=0x80000000){
    BMP_LoadErrorStr="Error notsupport OS/2 format";
    ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
    return(false);
  }

  if(pBMPHeader->biPlanes!=1){
    BMP_LoadErrorStr="Error notsupport Planes!=1";
    ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
    return(false);
  }

  switch(pBMPHeader->biBitCount){
    case 1:
      BMP_LoadErrorStr="Error notsupport 1bitcolor.";
      ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
      return(false);
    case 4:
      BMP_LoadErrorStr="Error notsupport 4bitcolor.";
      ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
      return(false);
    case 8:
      pBMPHeader->DataWidth=pBMPHeader->biWidth*1;
      break;
    case 16:
	   pBMPHeader->DataWidth=pBMPHeader->biWidth*2;
      break;
    case 24:
      pBMPHeader->DataWidth=pBMPHeader->biWidth*3;
      break;
    case 32:
      BMP_LoadErrorStr="Error notsupport 32bitcolor.";
      ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
      return(false);
    default:
      BMP_LoadErrorStr="Error Unknown xxBitColor.";
      ErrorCode = ERR_FORMAT_NOT_SUPPORTED;
      return(false);
  }

  if((pBMPHeader->DataWidth&3)!=0){
    pBMPHeader->DataWidth+=4-(pBMPHeader->DataWidth&3);
  }

  BMP_LoadErrorStr="";
  return(true);
}


void bmpToRGB( U8 *pSrcBM, pixel *pDstBM, U8 *PaletteTable, int count, int bpp_to_byte )
{
	U8 *pal;
	U16 r,g,b;//16λΪGravityõ
	pixel data_pixel;
	int x;
	if( bpp_to_byte == 1 )
	{
		for( x = 0; x < count; x += bpp_to_byte )
		{
			pal=&PaletteTable[*pSrcBM*4];
			pSrcBM+=1;

			b=pal[0];
			g=pal[1];
			r=pal[2];

			if( PIXEL_BYTES == 2 )
			{
				Gravity(b,gb);
				Gravity(g,gg);
				Gravity(r,gr);

				*pDstBM++ = RGB15( r,g,b );
			}
			else if( PIXEL_BYTES == 4 )
			{
				*pDstBM++ = RGB24( r,g,b );//24λRGB
			}
		}
	}
	else if( bpp_to_byte == 2 )
	{
		for( x=0; x<count; x += bpp_to_byte )
		{
			data_pixel = u8array_to_u16( pSrcBM, x );
			b = data_pixel & 0x001f;
			g = ( data_pixel >> 5 ) & 0x001f;
			r = ( data_pixel >> 10 ) & 0x001f;

			if( PIXEL_BYTES == 2 )
			{
				*pDstBM++ =  RGB15(r,g,b);
			}
			else if( PIXEL_BYTES == 4 )
			{
				r <<= 3;
				g <<= 3;
				b <<= 3;
				*pDstBM++ =  RGB24(r,g,b);
			}
		}
	}
	else if( bpp_to_byte == 3 )
	{
		for( x=0; x<count; x += bpp_to_byte )
		{
			b = pSrcBM[x+0];
			g = pSrcBM[x+1];
			r = pSrcBM[x+2];

			if( PIXEL_BYTES == 2 )
			{
				b >>= 3;
				g >>= 3;
				r >>= 3;
				*pDstBM++ = RGB15( r,g,b );
			}
			else if( PIXEL_BYTES == 4 )
			{
				*pDstBM++ = RGB24( r,g,b );;
			}
		}
	}
}

static void ShowImgGradual_Init( dword width, dword height )
{
		dword w;
//----------------------------
		Thumbimg = image_getthumbbuffer();
		start_x = 0;
		dst_done_h = 0;
		dst_done_h_old = 0;
		dst_done_h_old_prev = 0;
		src_do_h = 0;
		srcstart_line = 0;//ŵԭʼʼ
		srcstart_line_old = 0;//ŵԭʼʼ
		BufferDstLine_Out = 0;//Ѿн
		imgzoomsrc = (pixel*)memalign( PIXEL_BYTES, width * PIXEL_BYTES );//Ų
		imgzoomsrcptr[0] = NULL;//ŵָ(2)
		imgzoomsrcptr[1] = NULL;//ŵָ(2)

		GetThumbwh( &Thumbw, &Thumbh, width, height, config.rotate );
		image_GetZoomwh( width, height, &zoom_w, &zoom_h );

		if( ((dword)config.rotate & 0x1) == 0 )
		{
			zoom_w_org = zoom_w;
			zoom_h_org = zoom_h;

			Thumbw_org = Thumbw;
			Thumbh_org = Thumbh;
		}
		else
		{
			zoom_w_org = zoom_h;
			zoom_h_org = zoom_w;

			Thumbw_org = Thumbh;
			Thumbh_org = Thumbw;
		}

		GetThumbPos( &ThumbR, &ThumbSR, 0, 0, Thumbw, Thumbh, zoom_w, zoom_h );

		memsetword( Thumbimg, COLOR_BLACK, CONFIG_THUMBW * CONFIG_THUMBH );
		scene_printthumbimgBg( COLOR_BLACK );

//----------------------------
		Vram = GetVram( UP_SCREEN );
		VramLinePtr = Vram;
		VramPtr = Vram;
		start_x_up = 0;
		dst_done_h_up = 0;
		dst_done_h_old_up = 0;
		dst_done_h_old_prev_up = 0;
		dst_done_h_up_max = 0;
		src_do_h_up = 0;
		srcstart_line_up = 0;//ŵԭʼʼ
		srcstart_line_old_up = 0;//ŵԭʼʼ
		imgzoomsrcptr_up[0] = NULL;//ŵָ(2)
		imgzoomsrcptr_up[1] = NULL;//ŵָ(2)
		start_pixelX = 0;
		end_pixelX = 0;

		GetScreenPos( &Prect, zoom_w, zoom_h );
		start_pixelX = 0;
		end_pixelX = SCREEN_W - 1;
		if( end_pixelX > width - 1 )
			end_pixelX = width - 1;

		if( (config.rotate & 0x1) == 0 )
			w = Prect.w;
		else
			w = Prect.h;

		if( (config.rotate & 0x1) == 0 )
		{
			dst_done_h_up_max = SCREEN_H;
		}
		else
		{
			dst_done_h_up_max = SCREEN_W;
		}
		if( dst_done_h_up_max > height )
			dst_done_h_up_max = height;

		VramLinePtr += Prect.painttop * SCREEN_W;//ʼָ
		memsetword( Vram, COLOR_BLACK, SCREEN_W * SCREEN_H );
}

static void ShowImgGradual_Free()
{
	if( imgzoomsrc )
	{
		free( imgzoomsrc );
		imgzoomsrc = NULL;
	}
}


#define			DISPLAY_COUNT_MAX_UP			8
static void ShowImgGradual_up( dword width, dword height, int imgline_out, pixel *pImgLine, int *endFlag )
{
	static int dis_count = 0;
	if( pImgLine == NULL || *endFlag == true )
		return;

	if( src_do_h_up < 2 )
	{
		if( dst_done_h_up < dst_done_h_up_max && BufferDstLine_Out >= srcstart_line_up )
		{
			if( BufferDstLine_Out - srcstart_line_up == src_do_h_up )
				imgzoomsrcptr_up[src_do_h_up++] = pImgLine;
			else
			{
				imgzoomsrcptr_up[0] = imgzoomsrcptr_up[1];
				imgzoomsrcptr_up[1] = pImgLine;
				src_do_h_up = 2;
			}
		}
	}
	if( src_do_h_up == 2 )
	{
		//-------------------------------------
		if( (dst_done_h_up < dst_done_h_up_max) && src_do_h_up == 2 )
		{
			src_do_h_up = 0;
			do{
				VramPtr = VramLinePtr + Prect.paintleft;
				srcstart_line_old_up = srcstart_line_up;
				dst_done_h_old_prev_up = dst_done_h_up;

				srcstart_line_up = image_zoom_bilinear_Line_FromBuffer2( imgzoomsrcptr_up[0], imgzoomsrcptr_up[1], width, height, VramPtr, zoom_w_org, zoom_h_org, start_pixelX, end_pixelX, &dst_done_h_up, &start_x_up );

				VramLinePtr += SCREEN_W;

				if( dst_done_h_up >= dst_done_h_up_max )
				{
					*endFlag = true;
					break;
				}
			}while( srcstart_line_up == srcstart_line_old_up );

			if( (++dis_count >= DISPLAY_COUNT_MAX_UP) || (*endFlag == true) )
			{
				Flush( UP_SCREEN );
				dis_count = 0;
			}
		}
	}
}

#define			DISPLAY_COUNT_MAX_DOWN			4
static void ShowImgGradual_down( dword width, dword height, int imgline_out, pixel *pImgLine )
{
	static int dis_count = 0;

	if( pImgLine == NULL )
		return;

	if( src_do_h < 2 )
	{
		if( BufferDstLine_Out >= srcstart_line )
		{
			if( BufferDstLine_Out - srcstart_line == src_do_h )
				imgzoomsrcptr[src_do_h++] = pImgLine;
			else
			{
				imgzoomsrcptr[0] = imgzoomsrcptr[1];
				imgzoomsrcptr[1] = pImgLine;
				src_do_h = 2;
			}
		}
	}
	if( src_do_h == 2 || BufferDstLine_Out == height )
	{
		src_do_h = 0;
		dst_done_h_old = dst_done_h;

		pixel *ThumbimgPtr = NULL;
		do{
			srcstart_line_old = srcstart_line;
			dst_done_h_old_prev = dst_done_h;

			ThumbimgPtr = Thumbimg + dst_done_h_old_prev * Thumbw;
			srcstart_line = image_zoom_bilinear_Line_FromBuffer( imgzoomsrcptr[0], imgzoomsrcptr[1], width, height, ThumbimgPtr, Thumbw_org, Thumbh_org, &dst_done_h, &start_x );

		}while( srcstart_line == srcstart_line_old );

#if 1
		scene_printthumbimgline( ThumbR, ThumbSR, dst_done_h_old, dst_done_h - dst_done_h_old );
#else
		scene_printthumbimg( 0, 0, Thumbw, Thumbh, zoom_w, zoom_h, Thumbimg );
#endif

		if( ++dis_count >= DISPLAY_COUNT_MAX_DOWN )
		{
			Flush( DOWN_SCREEN );
			dis_count = 0;
		}
	}
}

static pixel* LoadBMP( const char * filename )
{
//---------------ֲ----------------------------
	U32 width 	= 0;
    U32 height 	= 0;
    U8  bpp		= 0;
    U32 bmpDataOffset;//λͼƫ,λͼʼַ
    FILE * fp_r = NULL;
    FILE * fp_w = NULL;
    int filelen = 0;
    int y = 0;
	U8 bpp_to_byte = 0;
	U32 pitch = 0;
	U8 *pSrcBM = NULL;
	pixel *pDstBM = NULL;
	U8 *BmpTempbuf = NULL;
    U8 *PaletteTable = NULL;
    TBMPHeader BMPHeader;
    U8 *bufferSrcPtr = NULL;
    pixel *RetPtr = NULL;

    U32 BufferDstPixel_Cur = 0;

	gr=0,gg=0,gb=0;
	memset( &BMPHeader, 0x00, sizeof(TBMPHeader) );
//-------------------------------------------------------
    fp_r = fopen( filename, "rb" );
    if( fp_r == NULL )
    {
    	ErrorCode = ERR_FILE_OPEN;
    	return NULL;
    }

    fseek( fp_r, 0, SEEK_END );
    filelen = ftell( fp_r );
    if( filelen <= 0  ) // ȡļ
	{
        fclose( fp_r );
        ErrorCode = ERR_FILE_RW;
        return NULL;
    }
    BmpTempbuf = (U8*)zmalloc( sizeof( TBMPHeader ) );
    if( !BmpTempbuf )
    {
    	ErrorCode = ERR_MEM_LACK;
    	goto _LoadBMP_Exit;
    }
    fseek( fp_r, 0, SEEK_SET );
    fread( BmpTempbuf, 1, sizeof( TBMPHeader ), fp_r );

    if( GetBMPHeader( BmpTempbuf, &BMPHeader ) == false )
    {
    	free( BmpTempbuf );
    	goto _LoadBMP_Exit;
    }
    free( BmpTempbuf );
    BmpTempbuf = NULL;
    // ȡbmpߺͿ
    width 	= BMPHeader.biWidth;
    height 	=	BMPHeader.biHeight;
    bpp			= BMPHeader.biBitCount;
    bmpDataOffset = BMPHeader.bfOffset;//λͼƫ,λͼʼַ

    if( CreateBMPBuf( bmpctx, width, height, bpp ) == false )
	{
		goto _LoadBMP_Exit;
	}
	
	if( ImgBufferHold == false )
	{
		fp_w = fopen_imgSwapfile( "wb" );
		if( fp_w == NULL )
		{
			ErrorCode = ERR_FILE_OPEN;
			goto _LoadBMP_Exit;
		}
	}

	if( bpp == 8 || bpp == 16 || bpp ==24 )
	{
		int bufferSrcSize = 0;
		int bufferSrcSize_line_max = 0;//Ϊλܴµ
		int bufferSrcSize_line_cur = -1;//Ϊλ嵱ǰʹ,ʼСڣ
		int height_left;//ÿζȡʣĸ߶
		int height_r;//ÿζȡ߶

		bpp_to_byte = bpp / 8;
		pitch = width * bpp_to_byte;

		if( bpp == 8 )
		{
	  		BMPHeader.pPalette = (U8*)zmalloc( 256 * 4 );//һҪɫд޸
	  		if( BMPHeader.pPalette == NULL )
	  		{
	  			ErrorCode = ERR_MEM_LACK;
	  			goto _LoadBMP_Exit;
	  		}

	  		fseek( fp_r, 0x36, SEEK_SET );//ȡ԰
	  		fread( BMPHeader.pPalette, 1, 256*4, fp_r );

	  		PaletteTable=BMPHeader.pPalette;
		}

		int pitch_align = (pitch+3) & (~3);//4ֽڶpicthֽ ÿһ4ֽڶ
		int offset = 0;
		pixel 	*bufferDstPtr = NULL;
		int x_count;
		int x_width;

#define				ZOOM_DO_UP_FLAG				1
#define				ZOOM_DO_DOWN_FLAG			1
#define				UP_NOTUSE_FUN				0
#define				DOWN_NOTUSE_FUN				0

		int UpendFlag = false;
		pixel *pImgZoomLine = NULL;

		if( ImageViewFlag == true )
		{
			scene_printimgInfo( width, height );
			ShowImgGradual_Init( width, height );
			Flush( DOWN_SCREEN );
			Flush( UP_SCREEN );
		}

		bufferSrcSize = pitch_align * height;
		if( bufferSrcSize > IMAGEVIEW_MEMSRC_SIZE )
			bufferSrcSize = IMAGEVIEW_MEMSRC_SIZE;

  		bufferSrcPtr = (U8*)malloc( bufferSrcSize );//bpp=8ʱѹ벻ѹд޸
		if( bufferSrcPtr == NULL || (U32)bufferSrcPtr < 0x80000000 )
		{
			bufferSrcPtr = (U8*)malloc( pitch_align );
			if( bufferSrcPtr == NULL )
			{
				ErrorCode = ERR_MEM_LACK;
				goto _LoadBMP_Exit;
			}
			bufferSrcSize = pitch_align;
		}
		if( bufferSrcSize > pitch_align )
		{
			if( bufferSrcSize < IMAGEVIEW_MEMSRC_SIZE )
	  			bufferSrcSize_line_max = height;
	  		else
	  		{
	  			bufferSrcSize_line_max = bufferSrcSize / pitch_align;
	  		}
	  	}
	  	else
	  	{
	  		bufferSrcSize_line_max = 1;
	  	}
		bufferDstPtr = ((pixel *)bmpBuffer);//ָ£ͣͼƬݻһַ
		height_left = height;//ʣ߶
		offset =  bmpDataOffset + pitch_align * (height-1);//λһԭʼ
	  	for( y = 0; y < height; y++ )
		{
			pDstBM = bufferDstPtr;
			if( bufferSrcSize == pitch_align )
			{
				fseek( fp_r, offset, SEEK_SET );
				fread( bufferSrcPtr, 1, pitch_align, fp_r );
				pSrcBM=bufferSrcPtr;
			}
			else
			{
				if( bufferSrcSize_line_cur < 0 )//
				{
					if( height_left > 0 )//ʣ߶
					{
						if( height_left >= bufferSrcSize_line_max )
						{
							height_r = 	bufferSrcSize_line_max;
						}
						else
						{
							height_r = 	height_left;
						}
						offset = bmpDataOffset + (height_left - height_r) * pitch_align;
						fseek( fp_r, offset,  SEEK_SET );//ȡλͼ
						fread( bufferSrcPtr, 1, height_r *pitch_align, fp_r );
		  				bufferSrcSize_line_cur = height_r - 1;//û嵱ǰ
		  				height_left -= height_r;//ʣ߶
		  			}
				}
				pSrcBM=&bufferSrcPtr[bufferSrcSize_line_cur*pitch_align];
			}

			if( ImgBufferHold == false )
			{
				if( BufferDstPixel_Cur+width > BufferDstPixel_Max )
				{
					x_width = (BufferDstPixel_Max - BufferDstPixel_Cur);
					x_count = x_width * bpp_to_byte;
				}
				else
				{
					x_width = width;
					x_count = pitch;
				}
			}
			else
			{
				x_width = width;
				x_count = pitch;
			}

			bmpToRGB( pSrcBM, pDstBM, PaletteTable, x_count, bpp_to_byte );

			bufferDstPtr += x_width;
			BufferDstPixel_Cur += x_width;
			
			if( ImageViewFlag )
			{
				if( x_count == pitch )
				{
					pImgZoomLine = pDstBM;
				}
				else
				{
					memcpyword( imgzoomsrc, pDstBM, x_width );
				}
			}

			if( ImgBufferHold == false )
			{
				if( BufferDstPixel_Cur >= BufferDstPixel_Max )
				{
					fwrite(  bmpBuffer, PIXEL_BYTES, BufferDstPixel_Max, fp_w );

					BufferDstPixel_Cur -= BufferDstPixel_Max;
					if( BufferDstPixel_Cur > 0 )
					{
						if( PIXEL_BYTES == 2 )
							memcpyword( (word*)bmpBuffer, (word*)(bmpBuffer+BufferDstPixel_Max), BufferDstPixel_Cur );//
						else
							memcpydword( (dword*)bmpBuffer, (dword*)(bmpBuffer+BufferDstPixel_Max), BufferDstPixel_Cur );//
					}
					bufferDstPtr = ((pixel *)bmpBuffer) + BufferDstPixel_Cur;
					pDstBM = bufferDstPtr;
				}
				else
				{
					pDstBM += x_width;
				}

				if( x_count != pitch )
				{
					bmpToRGB( pSrcBM+x_count, pDstBM, PaletteTable, pitch-x_count, bpp_to_byte );
					bufferDstPtr += width - x_width;
					BufferDstPixel_Cur += width - x_width;
				}
			}
			
			if( ImageViewFlag )
			{
				if( x_count != pitch )
				{
					memcpyword( imgzoomsrc+x_width, pDstBM, width - x_width );
					pImgZoomLine = imgzoomsrc;
				}
				ShowImgGradual_down( width, height, BufferDstLine_Out, pImgZoomLine );
				ShowImgGradual_up( width, height, BufferDstLine_Out, pImgZoomLine, &UpendFlag );

#if (ZOOM_DO_DOWN_FLAG|ZOOM_DO_UP_FLAG)
				BufferDstLine_Out++;
#endif
			}
			
			if( bufferSrcSize == pitch_align )
				offset -= pitch_align;
			else
				bufferSrcSize_line_cur--;
		}

		if( ImgBufferHold == false && BufferDstPixel_Cur > 0 )
		{
			fwrite(  bmpBuffer, PIXEL_BYTES, BufferDstPixel_Cur, fp_w );
			BufferDstPixel_Cur = 0;
		}
	}

	RetPtr = bmpBuffer;
_LoadBMP_Exit:
	
	if( BmpTempbuf )
	{
		free( BmpTempbuf );
   	 	BmpTempbuf = NULL;	
	}
	
	if( bufferSrcPtr )
    {
    	free( bufferSrcPtr );
    	bufferSrcPtr = NULL;
    }

	if( bpp == 8 )
	{
	    if( BMPHeader.pPalette )
	    {
			free( BMPHeader.pPalette );
			BMPHeader.pPalette = NULL;
		}
	}

	if( bmpBuffer && RetPtr == NULL )
	{
		free( bmpBuffer );
		bmpBuffer = NULL;
	}

	if( fp_r )
	{
		fclose( fp_r );
	}

	if( fp_w )
	{
		fclose( fp_w );
	}

	ShowImgGradual_Free();


	return RetPtr;
}

/*
FUNCTION : ȡBMPͼƬ
IN : const std::string & filename ͼƬȫ·
RETURN : void
*/
static pixel* LoadBMP_in_zip( const U8 *bmp_src )
{
	{
//---------------ֲ----------------------------
	U32 width 	= 0;
    U32 height 	=	0;
    U8  bpp			= 0;
    U32 bmpDataOffset;//λͼƫ,λͼʼַ
    FILE * fp_w = NULL;
    int y = 0;
	U8 bpp_to_byte = 0;
	U32 pitch = 0;
	U8 *pSrcBM = NULL;
	pixel *pDstBM = NULL;
	U8 *BmpHeaderBuf = NULL;
    U8 *PaletteTable = NULL;
	TBMPHeader BMPHeader;
    unsigned int BufferDstPixel_Cur = 0;

	gr=0,gg=0,gb=0;
	memset( &BMPHeader, 0x00, sizeof(TBMPHeader) );
//-------------------------------------------------------
    BmpHeaderBuf = (U8*)malloc( sizeof( TBMPHeader ) );
    if( BmpHeaderBuf == NULL )
    {
    	ErrorCode = ERR_MEM_LACK;
    	goto _Error_Exit_LoadBMP;
    }

	memcpy( BmpHeaderBuf, bmp_src, sizeof( TBMPHeader ) );

    if( GetBMPHeader( BmpHeaderBuf, &BMPHeader ) == false )
    {
    	free( BmpHeaderBuf );
    	goto _Error_Exit_LoadBMP;
    }
    free( BmpHeaderBuf );
    BmpHeaderBuf = NULL;

    // ȡbmpߺͿ
    width 	= BMPHeader.biWidth;
    height 	=	BMPHeader.biHeight;
    bpp			= BMPHeader.biBitCount;
    bmpDataOffset = BMPHeader.bfOffset;//λͼƫ,λͼʼַ

    if( CreateBMPBuf( bmpctx, width, height, bpp ) == false )
	{
		goto _Error_Exit_LoadBMP;
	}
	
	if( ImgBufferHold == false )
	{
	   	fp_w = fopen_imgSwapfile( "wb" );
		if( fp_w == NULL )
		{
			ErrorCode = ERR_FILE_OPEN;
			goto _Error_Exit_LoadBMP;
		}
	}

	if( bpp == 8 || bpp == 16 || bpp ==24 )
	{
		int bufferSrcSize = 0;
		int bufferSrcSize_line_max = 0;//Ϊλܴµ
		int bufferSrcSize_line_cur = -1;//Ϊλ嵱ǰʹ,ʼСڣ
		int height_left;//ÿζȡʣĸ߶
		int height_r;//ÿζȡ߶
		U8 *bufferSrcPtr = NULL;

		int bufferDstSize_line_max = 0;//Ϊλܴµ

		bpp_to_byte = bpp / 8;
		pitch = width * bpp_to_byte;

		if( bpp == 8 )
		{
	  		BMPHeader.pPalette = (U8*)malloc( 256 * 4 );//һҪɫд޸
	  		if( BMPHeader.pPalette == NULL )
	  		{
	  			ErrorCode = ERR_MEM_LACK;
	  			goto _Error_Exit_LoadBMP;
	  		}


			memcpy( BMPHeader.pPalette, bmp_src + 0x36, 256*4 );

	  		PaletteTable=BMPHeader.pPalette;
		}

		int pitch_align = (pitch+3) & (~3);//4ֽڶpicthֽ ÿһ4ֽڶ
		int offset = 0;
		pixel 	*bufferDstPtr = NULL;
		int x_count;
		int x_width;

#define				ZOOM_DO_UP_FLAG				1
#define				ZOOM_DO_DOWN_FLAG			1
#define				UP_NOTUSE_FUN				0
#define				DOWN_NOTUSE_FUN				0

		int UpendFlag = false;
		pixel *pImgZoomLine = NULL;

		if( ImageViewFlag )
		{
			scene_printimgInfo( width, height );
			ShowImgGradual_Init( width, height );
		}

		bufferSrcSize = pitch_align * height;
		if( bufferSrcSize > IMAGEVIEW_MEMSRC_SIZE )
			bufferSrcSize = IMAGEVIEW_MEMSRC_SIZE;

  		bufferSrcPtr = (U8*)malloc( bufferSrcSize );//bpp=8ʱѹ벻ѹд޸
		if( bufferSrcPtr == NULL || (U32)bufferSrcPtr < 0x80000000 )
		{
			bufferSrcPtr = (U8*)malloc( pitch_align );
			if( bufferSrcPtr == NULL )
			{
				ErrorCode = ERR_MEM_LACK;
				goto _Error_Exit_LoadBMP;
			}
			bufferSrcSize = pitch_align;
		}
		if( bufferSrcSize > pitch_align )
		{
			if( bufferSrcSize < IMAGEVIEW_MEMSRC_SIZE )
	  			bufferSrcSize_line_max = height;
	  		else
	  		{
	  			bufferSrcSize_line_max = bufferSrcSize / pitch_align;
	  		}
	  	}
	  	else
	  	{
	  		bufferSrcSize_line_max = 1;
	  	}
		bufferDstSize_line_max = BufferDstPixel_Max / width;

		bufferDstPtr = ((pixel *)bmpBuffer);//ָ£ͣͼƬݻһַ
		height_left = height;//ʣ߶
		offset =  bmpDataOffset + pitch_align * (height-1);//λһԭʼ
	  	for( y = 0; y < height; y++ )
		{
			pDstBM = bufferDstPtr;
			if( bufferSrcSize == pitch_align )
			{
  				memcpy( bufferSrcPtr, bmp_src + offset, pitch_align );
				pSrcBM=bufferSrcPtr;
			}
			else
			{
				if( bufferSrcSize_line_cur < 0 )//
				{
					if( height_left > 0 )//ʣ߶
					{
						if( height_left >= bufferSrcSize_line_max )
						{
							height_r = 	bufferSrcSize_line_max;
						}
						else
						{
							height_r = 	height_left;
						}
						offset = bmpDataOffset + (height_left - height_r) * pitch_align;
						memcpy( bufferSrcPtr, bmp_src + offset, height_r *pitch_align );
		  				bufferSrcSize_line_cur = height_r - 1;//û嵱ǰ
		  				height_left -= height_r;//ʣ߶
		  			}
				}
				pSrcBM=&bufferSrcPtr[bufferSrcSize_line_cur*pitch_align];
			}

			if( ImgBufferHold == false )
			{
				if( BufferDstPixel_Cur+width > BufferDstPixel_Max )
				{
					x_width = (BufferDstPixel_Max - BufferDstPixel_Cur);
					x_count = x_width * bpp_to_byte;
				}
				else
				{
					x_width = width;
					x_count = pitch;
				}
			}
			else
			{
				x_width = width;
				x_count = pitch;
			}

			bmpToRGB( pSrcBM, pDstBM, PaletteTable, x_count, bpp_to_byte );

			bufferDstPtr += x_width;
			BufferDstPixel_Cur += x_width;
			
			if( ImageViewFlag == true )
			{
				if( x_count == pitch )
				{
					pImgZoomLine = pDstBM;
				}
				else
				{
					memcpyword( imgzoomsrc, pDstBM, x_width );
				}	
			}

			if( ImgBufferHold == false )
			{
				if( BufferDstPixel_Cur >= BufferDstPixel_Max )
				{
					fwrite(  bmpBuffer, PIXEL_BYTES, BufferDstPixel_Max, fp_w );

					BufferDstPixel_Cur -= BufferDstPixel_Max;
					if( BufferDstPixel_Cur > 0 )
					{
						if( PIXEL_BYTES == 2 )
							memcpyword( (word*)bmpBuffer, (word*)(bmpBuffer+BufferDstPixel_Max), BufferDstPixel_Cur );//
						else
							memcpydword( (dword*)bmpBuffer, (dword*)(bmpBuffer+BufferDstPixel_Max), BufferDstPixel_Cur );//
					}
					bufferDstPtr = ((pixel *)bmpBuffer) + BufferDstPixel_Cur;
					pDstBM = bufferDstPtr;
				}
				else
				{
					pDstBM += x_width;
				}

				if( x_count != pitch )
				{
					bmpToRGB( pSrcBM+x_count, pDstBM, PaletteTable, pitch-x_count, bpp_to_byte );
					bufferDstPtr += width - x_width;
					BufferDstPixel_Cur += width - x_width;
				}
			}
			
			if( ImageViewFlag )
			{
				if( x_count != pitch )
				{
					memcpyword( imgzoomsrc+x_width, pDstBM, width - x_width );
					pImgZoomLine = imgzoomsrc;
				}

				ShowImgGradual_down( width, height, BufferDstLine_Out, pImgZoomLine );
				ShowImgGradual_up( width, height, BufferDstLine_Out, pImgZoomLine, &UpendFlag );

#if (ZOOM_DO_DOWN_FLAG|ZOOM_DO_UP_FLAG)
				BufferDstLine_Out++;
#endif	
			}
			
			if( bufferSrcSize == pitch_align )
				offset -= pitch_align;
			else
				bufferSrcSize_line_cur--;
		}

		if( ImgBufferHold == false && BufferDstPixel_Cur > 0 )
		{
			fwrite(  bmpBuffer, PIXEL_BYTES, BufferDstPixel_Cur, fp_w );
			BufferDstPixel_Cur = 0;
		}

    	if( bufferSrcPtr )
    	{
    		free( bufferSrcPtr );
    	}
    	if( bpp == 8 && BMPHeader.pPalette )
    	{
			free( BMPHeader.pPalette );
			BMPHeader.pPalette = NULL;
		}
	}

	if( fp_w )
	{
		fclose( fp_w );
	}

	ShowImgGradual_Free();

	return (pixel *)bmpBuffer;

_Error_Exit_LoadBMP:
	
	if( BmpHeaderBuf )
	{
		free( BmpHeaderBuf );
    	BmpHeaderBuf = NULL;
    }
	
	if( bpp == 8 )
	{
		if( BMPHeader.pBitmap )
	    {
	    	free( BMPHeader.pBitmap );
	    	BMPHeader.pBitmap = NULL;
	    }
	    if( BMPHeader.pPalette )
	    {
			free( BMPHeader.pPalette );
			BMPHeader.pPalette = NULL;
		}
	}

	if( fp_w )
	{
		fclose( fp_w );
	}

	if( bmpBuffer )
	{
		free( bmpBuffer );
		bmpBuffer = NULL;
	}

	ShowImgGradual_Free();
	return NULL;
	}
}

extern int read_bmp( const char *filename, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor )
{
	ErrorCode = ERR_UNKNOWN;
	if( BMPInit() == false )
	{
		return ErrorCode;
	}
	bmpBuffer = *image_data;

	pixel *bmpbuf = LoadBMP( filename );
	if( !bmpbuf )
	{
		goto _Error_Exit_Readbmp;
	}

	if( ImgBufferHold )
	{
		*image_data = bmpbuf;
	}
	else
	{
		free( bmpbuf );
	}
	*pwidth = BMPWidth();
	*pheight = BMPHeight();
	*bgcolor = 0;

	BMPFree();

	bmpBuffer = NULL;

	return 0;

_Error_Exit_Readbmp:
	BMPFree();

	return ErrorCode;
}

//---------------------------------------------------------------------------------------------------------------
//functionڶȡʹzipѹbmpļ
//---------------------------------------------------------------------------------------------------------------
extern int bmp_read_dib_file( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn )
{
	pixel *bmpbuf = NULL;
	dword filelen = 0;
	int len, len_w;
	FILE *fp_sw = NULL;
	U8 *pImgBufferSrc = NULL;

	ErrorCode = ERR_UNKNOWN;
	if( BMPInit() == false )
		return ErrorCode;

	if( ImageViewFlag )
	{
		filelen = imgSize;
	}
	else
	{
		filelen = unztellsize( fp );
	}

	bmpBuffer = *image_data;
	image_zip_fseek( fp, 0, SEEK_SET );
	pImgBufferSrc = (U8*)malloc( filelen + 1 );

	if( pImgBufferSrc )
	{
		readfn( (void*)pImgBufferSrc, 1, filelen, (void*)fp );
		bmpbuf = (pixel*)LoadBMP_in_zip( (const U8*)pImgBufferSrc );//صbmpǽͼƬָ
		if( bmpbuf == NULL )
			goto _bmp_read_dib_file_Exit;

		if( ImgBufferHold == true )
		{
			*image_data = bmpbuf;
		}
		else
		{
			free( bmpbuf );
		}
	
		bmpBuffer = NULL;
	
		*pwidth 	= 	BMPWidth();
		*pheight 	=	BMPHeight();
		*bgcolor    = 	COLOR_BLACK;
	
		ErrorCode = ERR_NONE;
	}
	else
	{
		pImgBufferSrc = malloc( IMAGEVIEW_MEMDEST_SIZE );
		if( !pImgBufferSrc )
		{
			ErrorCode = ERR_MEM_LACK;
			goto _bmp_read_dib_file_Exit;
		}

		fp_sw = fopen_imgZipSwapfile( "swapfile.bmp", "w" );
		if( !fp_sw )
		{
			ErrorCode = ERR_FILE_OPEN;
			goto _bmp_read_dib_file_Exit;
		}

		len = filelen;
		while( len > 0 )
		{
			len_w = len;
			if( len_w > IMAGEVIEW_MEMDEST_SIZE )
				len_w = IMAGEVIEW_MEMDEST_SIZE;
			readfn( (void*)pImgBufferSrc, 1, len_w, (void*)fp );
			fwrite( pImgBufferSrc, 1, len_w, fp_sw );
			len -= len_w;
		}
		if( fp_sw )
		{
			fclose( fp_sw );
			fp_sw = NULL;
		}
		
//		char imgdat_name[IMGDAT_NAME_LEN];
//		STRCPY_S( imgdat_name, CONFIG_EBOOK_ROOTDIR );
//		STRCAT_S( imgdat_name, "swapfile.bmp" );
		
		ErrorCode = read_bmp( (const char *)imgFileName, pwidth, pheight, image_data, bgcolor );
		
		remove( imgFileName );//ɾļ
	}

_bmp_read_dib_file_Exit:
	
	if( pImgBufferSrc )
	{
		free( pImgBufferSrc );
		pImgBufferSrc = NULL;
	}
	
	BMPFree();
	return ErrorCode;
}

