#ifndef _BMP_H_
#define _BMP_H_

#include <datatype.h>
#include <gdi.h>
#include <display.h>

#define BI_RGB        0L
#define BI_RLE8       1L
#define BI_RLE4       2L
#define BI_BITFIELDS  3L

struct TBMPHeader_s{
  U8 bfType[2];//[0] //ļʶ 2 bytes ֽڵʶλͼ
  U32 bfSize;//[2]	//1 dword ֽڱʾļĴС
  U16 bfReserved1;//[6] //1 dword Ϊ0 
  U16 bfReserved2;//[8]
  U32 bfOffset;//[0x0a] //1 dword ļʼλͼݿʼ֮(bitmap data)֮ƫ 
  U32 biSize;//[0x0e] //1 dword λͼϢͷ(Bitmap Info Header)ĳȣλͼɫѹȡ
  U32 biWidth;//[0x12]//1 dword λͼĿȣΪλ 
  U32 biHeight;//[0x16] //1 dword λͼĸ߶ȣΪλ 
  U16 biPlanes;//[0x1a] //1 word λͼλעֵ1
/*
1 - ɫλͼʵϿɫȱʡǺɫͰɫԼɫ
4 - 16 ɫλͼ
8 - 256 ɫλͼ
16 - 16bit ߲ɫλͼ
24 - 24bit ɫλͼ
32 - 32bit ǿɫλͼ 
*/
  U16 biBitCount;//[0x1c] λ //1 word ÿصλ
/*
0 - ѹ (ʹBI_RGBʾ)
1 - RLE 8-ʹ8λRLEѹʽ(BI_RLE8ʾ)
2 - RLE 4-ʹ4λRLEѹʽ(BI_RLE4ʾ)
3 - Bitfields-λŷʽ(BI_BITFIELDSʾ) 
*/

  U32 biCopmression;//[0x1e] //1 dword ѹ˵
  U32 biSizeImage;//[0x22] //1 dword ֽʾλͼݵĴС4ı 
  U32 biXPixPerMeter;//[0x26] //1 dword /ױʾˮƽֱ 
  U32 biYPixPerMeter;//[0x2a]//1 dword /ױʾĴֱֱ 
  U32 biClrUsed;//[0x2e] //1 dword λͼʹõɫ8-/رʾΪ100h 256. 
  
/*
ֵɫʱߵ0ʱʾɫһҪ
ɫ BMP汾Ĳͬͬ Palette N * 4 byte ɫ淶ڵɫеÿ4ֽRGBֵ
1ֽɫ
1ֽɫ
1ֽںɫ
1ֽ(Ϊ0)
*/  
  U32 biCirImportant;//[0x32] //1 dword ָҪɫ
  
  U8 *pPalette;//[0x36]
  U8 *pBitmap;//[0x3a]
  
  U32 DataWidth;
}; 

typedef struct TBMPHeader_s TBMPHeader;

typedef struct BMPContext_S
{
	U32 width;
  	U32 height;
  	U32 pitch;
  	pixel *buffer;    //  32 λַ룬 bitblt ʱӿٶȡ
  	U8 *bufferTemp;    //  32 λַ룬 bitblt ʱӿٶ ʱ壬ͼƬʱʹ,24BPP16BPPȰԭʼݶʱ壬͵buffer
	U32 (*getwidth)(void);
	U32 (*getheight)(void);
	pixel * (*getbuffer)(void);
	void (*Init)(void);
	pixel* (*LoadBMP)( const char *filename );
	BOOL (*reLoadBMP)(const char * filename);
	BOOL (*createBMPbuf)( struct BMPContext_S *bmpctx,U32 width, U32 height, U8  bpp );
	pixel* (*createBMP)( const char * filename );
	void (*Free)(void);
}BMPContext;


BOOL BMPInit( void );

//static void SetBMPbuf( BMPContext *pBMPTemp );
//static void BMP_SaveGloblePointer();
//static void BMP_RestoreGloblePointer();
//static BOOL CreateBMPBuf( BMPContext *bmpctx, U32 width, U32 height, U8 bpp );
//static pixel * LoadBMP( const char *filename );
//static void BMPFree( void );

extern int read_bmp( const char *filename, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor );

#endif//_BMP_H_
