/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"
#include <sys/stat.h>
#include <string.h>
#include "common/utils.h"
#include "bookmark.h"
#include "stdio.h"
#include <uart.h>
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <ds2io2.h>

#include <debugoff.h>

#define			DEBUG_LHM_BM		0

#define		BMGROUP_SIZE				(sizeof(t_bm_index) + 32 * BM_ROWS_SIZE)

#define		BmGroupFileId( index ) 		( index & 0x1F )
#define		BmGroupId( index ) 			( index>>5 )
#define		BmGroupSize( index ) 		( BmGroupId( index ) * BMGROUP_SIZE )
#define		BmGroupBase( index ) 		( INDEX_HEADER_SIZE + BmGroupSize( index ) )
#define		BmGroupFileOffset( index ) 	( BmGroupFileId( index ) * BM_ROWS_SIZE )
#define		BmGroupOffset( index ) 		( sizeof(t_bm_index) + BmGroupFileOffset( index ) )

#define		BmOffset( index )			( BmGroupBase( index) + BmGroupOffset( index ) )


static dword flagbits[32] = {
	0x00000001, 0x00000002, 0x00000004, 0x00000008, 0x00000010, 0x00000020,
	0x00000040, 0x00000080,
	0x00000100, 0x00000200, 0x00000400, 0x00000800, 0x00001000, 0x00002000,
	0x00004000, 0x00008000,
	0x00010000, 0x00020000, 0x00040000, 0x00080000, 0x00100000, 0x00200000,
	0x00400000, 0x00800000,
	0x01000000, 0x02000000, 0x04000000, 0x08000000, 0x10000000, 0x20000000,
	0x40000000, 0x80000000,
};

static char bmfile[PATH_MAX2];

static int bmStageFlag = BM_AUTO_LOAD;


#define		BM_HOURS_BIT		0
#define		BM_DAY_BIT			5
#define		BM_MONTH_BIT		10

#define		BM_HOURS_MASK		0X1F
#define		BM_DAY_MASK			0X1F
#define		BM_MONTH_MASK		0X3F

void bookmark_settime( p_bookmark bm, int pos )//ʱ
{
	RTC rtc;
	U16 time;

	ds2_getTime( &rtc );

	time = (rtc.month << BM_MONTH_BIT) | (rtc.day << BM_DAY_BIT) | (rtc.hours << BM_HOURS_BIT);
	bm->bmtime[pos].time = time;
	bm->bmtime[pos].minutes = rtc.minutes;
	bm->bmtime[pos].year = rtc.year;
}

RTC bookmark_timetran( t_bm_time bmtime )
{
	RTC rtc;

	rtc.year = bmtime.year;
	rtc.minutes = bmtime.minutes;

	rtc.hours = (bmtime.time >> BM_HOURS_BIT) & BM_HOURS_MASK;

	rtc.day = (bmtime.time >> BM_DAY_BIT) & BM_DAY_MASK;

	rtc.month = (bmtime.time >> BM_MONTH_BIT) & BM_MONTH_MASK;

	return rtc;
}


extern dword bookmark_encode(const char *filename)
{
	register dword h;

	for (h = 5381; *filename != 0; ++filename)
	{
		h += h << 5;
		h ^= *filename;
	}

	return h;
}

extern void bookmark_init(const char *fn)
{
	STRCPY_S(bmfile, fn);
	FILE *fp = fopen( bmfile, "rb" );
	if(  fp == NULL )
	{
		fp = fopen( bmfile, "wb" );
		if( fp )
		{
			fclose( fp );
		}
	}
	else
	{
		fclose( fp );
	}
}

p_bookmark bookmark_create_new_bm( dword hash )
{
	p_bookmark bm = NULL;
	bm = (p_bookmark) malloc( sizeof(t_bookmark) );
	if (bm == NULL)
	{
		return NULL;
	}
	//½bookmarkĳʼ
	memset(bm->row, 0xFF, BM_ROWS_SIZE);//dword row[10]; //rowĳʼֵΪ0xFFFFFFFF,Ӵֵ֪λûбʹ
	bm->index = INVALID;//ʼ־
	bm->hash = hash;//ݵǰǩļɵhashȥӦbm->indexbm->row[10]
	bm->prev = NULL;
	bm->next = NULL;
	bm->last = bm;
	return bm;
}

p_bookmark bookmark_open_hash2( dword hash, p_bookmark bm, FILE *fp )
{
	p_bookmark head_bm = bm;
	p_bookmark cur_bm = bm;
	p_bookmark temp_bm = NULL;

	int bmNewFlag = false;

	if( cur_bm == NULL || fp == NULL )
		return NULL;

	//ѯbmһǩ
	if( cur_bm->prev_index != 0xFFFFFFFF )
	{
		do{
			cur_bm->prev = bookmark_create_new_bm( hash );

			if( cur_bm->prev == NULL )
				goto _bookmark_open_hash2_Exit;

			fseek( fp, BmGroupBase( cur_bm->prev_index ) + BmGroupOffset( cur_bm->prev_index ), SEEK_SET );

			temp_bm = cur_bm;
			cur_bm = cur_bm->prev;
			cur_bm->next = temp_bm;
			cur_bm->index = cur_bm->next->prev_index;

			fread( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );
			head_bm = cur_bm;//
		}while( cur_bm->prev_index != 0xFFFFFFFF );
	}

	if( !(bmStageFlag == BM_AUTO_LOAD || bmStageFlag == BM_AUTO_SAVE) )
	{
		//ѯbmһǩ
		cur_bm = bm;
		do{
			if( cur_bm->next_index == 0xFFFFFFFF )//ǩ½һǩ
			{
				if( bmStageFlag == BM_MAN_LOOKUP )
				{
					goto _bookmark_open_hash2_Exit;
				}

				if( cur_bm->row[BM_FULL_POSITION0] == 0xFFFFFFFF )
				{
					goto _bookmark_open_hash2_Exit;
				}

				cur_bm->next = bookmark_create_new_bm( hash );
				temp_bm = cur_bm;
				cur_bm = cur_bm->next;
				cur_bm->prev = temp_bm;
				bmNewFlag = true;
			}
			else
			{
				fseek( fp, BmOffset( cur_bm->next_index ), SEEK_SET );
				cur_bm->next = bookmark_create_new_bm( hash );

				if( cur_bm->next == NULL )
					goto _bookmark_open_hash2_Exit;

				temp_bm = cur_bm;
				cur_bm = cur_bm->next;
				cur_bm->prev = temp_bm;
				cur_bm->index = cur_bm->prev->next_index;

				fread( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );
			}
		}while( (cur_bm->next_index != 0xFFFFFFFF || cur_bm->row[BM_FULL_POSITION1] != 0xFFFFFFFF) &&  (bmNewFlag == false) );

_bookmark_open_hash2_Exit:
		head_bm->last = cur_bm;
	}

	return head_bm;
}


static
p_bookmark bookmark_open_hash( dword hash )//ѯǷѾǩбļУûб棬򷵻һѾʼǩļ(10洢λ)
{
	p_bookmark bm = NULL;
	FILE *fp = NULL;
	dword count;
	t_bm_index bi;
	int i, j;

	bm = bookmark_create_new_bm( hash );
	if (bm == NULL)
	{
		return NULL;
	}
	fp = fopen( bmfile, "rb" );
	if( !fp )
	{
		free( bm );//2010-4-21 17:22:44
		return NULL;
	}

	if( fread( &count, 1, sizeof(dword), fp ) < sizeof(dword) )//ǩͷǰ4ֽΪǩ
	{
		fclose( fp );
		return bm;//ûвҵ½ѳʼıǩ
	}
	fseek( fp, INDEX_HEADER_SIZE, SEEK_SET );
	for( i = 0; i < count; i++ ) //ǩ鵥ԪĿ,ÿԪռãsizeof(t_bm_index)+32*10*4ÿǩɴ32ļÿļ10δ洢ռ
	{
		if( fread( &bi, 1, sizeof(t_bm_index), fp ) < sizeof(t_bm_index) )
		{
			goto _bookmark_open_hash_Exit;
		}

		for (j = 0; j < 32; j++)//ǩڲѯÿǩڿɴ洢32ļ(hash)
		{
			if ( (bi.flag & flagbits[j]) > 0 && bi.hash[j] == bm->hash ) //bi.flag & flagbits[j] == 0ʱʾ˴洢ռ(hashλüӦ10洢λ)δʹ
			{
				bm->index = i * 32 + j;//ҵӦbm->index
				fseek(fp, j * BM_ROWS_SIZE, SEEK_CUR);
				fread( &bm->row[0], 1, BM_ROWS_SIZE, fp );//ҵӦbm->row[10]ԭȱкȡ(1ļ10λõкŶ)
				if( bm->prev_index == 0xFFFFFFFF && bm->next_index == 0xFFFFFFFF && bm->row[BM_FULL_POSITION0] == 0xFFFFFFFF )
				{
					goto _bookmark_open_hash_Exit;
				}
				else
				{
					if( bmStageFlag == BM_AUTO_LOAD || bmStageFlag == BM_AUTO_SAVE )
					{
						if( bm->prev_index == 0xFFFFFFFF )
							goto _bookmark_open_hash_Exit;
					}
					bm = bookmark_open_hash2( hash, bm, fp );
					goto _bookmark_open_hash_Exit;
				}
			}
		}
		fseek( fp, 32 * BM_ROWS_SIZE, SEEK_CUR );
	}

_bookmark_open_hash_Exit:
	fclose( fp );
	return bm;
}

extern p_bookmark bookmark_open( const char *filename )
{
	if (!filename)
		return NULL;
	return bookmark_open_hash( bookmark_encode(filename) );
}

extern void bookmark_save( p_bookmark bm )
{
	p_bookmark cur_bm = NULL;
	p_bookmark prev_bm = NULL;
	if (!bm)
		return;
	FILE *fp = fopen( bmfile, "rb+" );
	if( !fp )
		return;
	dword count = 0;//¼ǩ鵥Ԫ,ÿԪռãsizeof(t_bm_index)+32*10*4
	t_bm_index bi;

	if( ((fread( (char*)(&count), 1, sizeof(dword), fp )) < sizeof(dword)) || count == 0 )//ԭûнǩ飬½һǩ鵥Ԫһǩͷ32ļ*10λÿļ,ǩͷݽṹΪ_bm_index4 + (4+32*4) + (32 * 10 * 4) = 1416byte
	{
		count = 1;
		fseek( fp, 0, SEEK_SET );
		fwrite( &count, 1, sizeof(dword), fp );
		memset( &bi, 0, sizeof(t_bm_index) );//t_bm_indexṹʼֵ־flag32λõļhashȫʼΪ0
		fwrite( &bi, 1, sizeof(t_bm_index), fp );
		dword *temp = (dword *) calloc(32 * BM_ROWS_LEN, sizeof(dword));
		if( temp )
		{
			memset(temp, 0, 32 * BM_ROWS_SIZE);
			fwrite( temp, 1, 32 * BM_ROWS_SIZE, fp );
			free( temp );
		}
	}
	cur_bm = bm->last;
	prev_bm = cur_bm->prev;
	if (cur_bm->index == INVALID)//½һǩ
	{
		fseek( fp, INDEX_HEADER_SIZE + (count - 1) * BMGROUP_SIZE, SEEK_SET );
		fread( &bi, 1, sizeof(t_bm_index), fp );

		if (bi.flag != 0xFFFFFFFF)//ǩ32ļռʹʱ־Ϊ 0xFFFFFFFF
		{
			dword j;
			for (j = 0; j < 32; j++)
			{
				if ((bi.flag & flagbits[j]) == 0)
				{
					bi.flag |= flagbits[j];
					bi.hash[j] = cur_bm->hash;
					cur_bm->index = (count - 1) * 32 + j;
					if( prev_bm )
						cur_bm->prev_index = prev_bm->index;
					fseek( fp, INDEX_HEADER_SIZE + (count - 1) * BMGROUP_SIZE, SEEK_SET );//count:ǩ
					fwrite( &bi, 1, sizeof(t_bm_index), fp );
					fseek( fp, j * BM_ROWS_SIZE, SEEK_CUR );
					fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );//дļڵ10洢λ
					break;
				}
			}
		}
		else //ǩѾռʹϣ½һǩcount+1ǩд
		{
			fseek( fp, INDEX_HEADER_SIZE + count * BMGROUP_SIZE, SEEK_SET );
			memset(&bi, 0, sizeof(t_bm_index));
			bi.flag = 1;
			bi.hash[0] = cur_bm->hash;
			cur_bm->index = count * 32;
			if( prev_bm )
				cur_bm->prev_index = prev_bm->index;
			fwrite( &bi, 1, sizeof(t_bm_index), fp );
			fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );
			dword *temp = (dword *) calloc(31 * BM_ROWS_LEN, sizeof(dword));//32ļλѾд1ʣ31

			memset(temp, 0, 31 * BM_ROWS_SIZE);
			fwrite( temp, 1, 31 * BM_ROWS_SIZE, fp );
			free(temp);

			fseek( fp, 0, SEEK_SET );//дǩ
			count++;
			fwrite( &count, 1, sizeof(dword), fp );
		}

		if( prev_bm != cur_bm && prev_bm != NULL )
		{
			prev_bm->next_index = cur_bm->index;
			fseek( fp, INDEX_HEADER_SIZE + (prev_bm->index >> 5) * BMGROUP_SIZE +
					   sizeof(t_bm_index) + ((prev_bm->index & 0x1F) * BM_ROWS_SIZE), SEEK_SET );
			fwrite( &prev_bm->row[0], 1, BM_ROWS_SIZE, fp );
		}
	}
	else //ļıǩԭѾ
	{
		fseek( fp, INDEX_HEADER_SIZE + (cur_bm->index / 32) * BMGROUP_SIZE + //1sizeof(dword)ʾǩ(bm->index / 32)洢λõǩţ(sizeof(t_bm_index) + 32 * BM_ROWS_SIZE)1ǩĴ洢ռ䣬
				   sizeof(t_bm_index) + ((cur_bm->index % 32) * BM_ROWS_SIZE),//sizeof(t_bm_index)ǩͷ((bm->index % 32) * BM_ROWS_SIZE)ǩڵλ
				   SEEK_SET );
		fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );//д루1ļ10λõкš
											//´洢µкţ֪ΪʲôһкҪ10dwordֽȥ棿Ŀǰ˵һļֻһǩһǩӦһкţ //2010-4-21 16:06:49 Ѿ
	}

	fclose( fp );
}

//-------------------------------------------------------------------------------------------
//أ0ɾʧ
//	    1ɹɹ
//-------------------------------------------------------------------------------------------
extern int bookmark_delete(p_bookmark bm)//ɾǩеһļǩ(ֻɾhash10λõֵûиı)
{
	p_bookmark cur_bm = NULL;
	t_bm_index bi;
	U32 bmGroupSize;
	U32 bmGroupbase = 0;
	U32 bmGroupbase_old = 0;
	U32 bmGroupfileid;
	FILE *fp = NULL;

	fp = fopen( bmfile, "rb+" );
	if( !fp )
		return 0;

	cur_bm = bm->last;
	while( cur_bm )
	{
		bmGroupSize = BmGroupSize( cur_bm->index >> 5 );
		bmGroupbase = BmGroupBase( cur_bm->index >> 5 );
		bmGroupfileid = BmGroupFileId( cur_bm->index );

		//ɾhashռ
		if( bmGroupbase_old != bmGroupbase )
		{
			memset( &bi, 0, sizeof(t_bm_index) );
			fseek( fp, bmGroupbase, SEEK_SET );
			fread( &bi, 1, sizeof(t_bm_index), fp );
		}

		bi.flag &= ~flagbits[bmGroupfileid];//־
		bi.hash[bmGroupfileid] = 0x00000000;//ļhash

		fseek( fp, bmGroupbase, SEEK_SET );
		fwrite( &bi, 1, sizeof(t_bm_index), fp );

		//ԲкŶֻ־hash
#if 0
		memset( &cur_bm->row[0], 0x00, BM_ROWS_SIZE );
		fseek( fp, BmGroupFileOffset( cur_bm->index ), SEEK_CUR );
		fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );
#endif

		cur_bm = cur_bm->prev;
		if( cur_bm )
		{
			cur_bm->next_index = 0xFFFFFFFF;
		}
	}

	fclose(fp);
	return 1;
}

extern void bookmark_close(p_bookmark bm)
{
	if( bm == NULL )
		return;
	p_bookmark cur_bm = bm->last;
	if (cur_bm != NULL)
	{
		do{
			free((void *) cur_bm);
			cur_bm = cur_bm->prev;
		}while( cur_bm );
	}
	bm = NULL;
}

extern dword bookmark_autoload( const char *filename ) //Զصǩļ10еĵ1
{
	dword row;

	bmStageFlag = BM_AUTO_LOAD;//Զ
	p_bookmark bm = bookmark_open(filename);

	if (bm == NULL)
	{
		return 0;
	}
	if (bm->row[BM_AUTO_SAVE_POSITION] == INVALID)//½ĸճʼֵINVALID = -1,0XFFFFFFFF
	{
		row = 0;//δҵЧкʱĬΪ0
	}
	else//ҵЧǩȡЧк
	{
		row = bm->row[BM_AUTO_SAVE_POSITION];//10λһλãֹܲ1Զֻص1
	}
	bookmark_close(bm);
	return row;
}

extern void bookmark_autosave( const char *filename, dword row )//Զλǩļ10еĵ11λѾᱻ
{
	if (!filename)
		return;
	extern BOOL scene_readbook_in_raw_mode;

	if (scene_readbook_in_raw_mode)
		return;
	bmStageFlag = BM_AUTO_SAVE;//Զ
	p_bookmark bm = bookmark_open(filename);

	if (bm == NULL)
		return;

	bm->row[BM_AUTO_SAVE_POSITION] = row;//ԭȱк, 浽10λһλ

	bookmark_settime( bm, BM_AUTO_SAVE_POSITION );


	bookmark_save(bm);
	bookmark_close(bm);
}

extern void bookmark_Manualsave( const char *filename, dword row )//Զλǩļ10еĵ11λѾᱻ
{
	int i = 0;
	int SaveFlag = false;
	p_bookmark cur_bm = NULL;
	p_bookmark bm = NULL;
	if (!filename)
		return;
	extern BOOL scene_readbook_in_raw_mode;

	if (scene_readbook_in_raw_mode)
		return;

	bmStageFlag = BM_MAN_SAVE;//˹
	bm = bookmark_open(filename);
	if (bm == NULL)
	{
		return;
	}

	cur_bm = bm->last;
	while( cur_bm != NULL && SaveFlag == false )
	{
		for( i = 0; i < BM_GROUP_INDEX_MAX_COUNT; i++ )
		{
			if( cur_bm->row[i] == 0xFFFFFFFF )
			{
				if( bm == cur_bm && i == BM_AUTO_SAVE_POSITION )//Զλ
					continue;
				cur_bm->row[i] = row;//ԭȱк
				bookmark_settime( cur_bm, i );
				SaveFlag = true;
				goto _bookmark_Manualsave_Next;
			}
			else if( cur_bm->row[i] == row )
			{
				goto _bookmark_Manualsave_Exit;
			}
		}
		cur_bm = cur_bm->next;
	}

_bookmark_Manualsave_Next:
	bookmark_save(bm);
_bookmark_Manualsave_Exit:
	bookmark_close(bm);
}

extern p_bookmark bookmark_Lookup( const char *filename )//Զλǩļ10еĵ11λѾᱻ
{
	if (!filename)
		return NULL;
	extern BOOL scene_readbook_in_raw_mode;

	if (scene_readbook_in_raw_mode)
		return NULL;

	bmStageFlag = BM_MAN_LOOKUP;//˹ѯ
	p_bookmark bm = bookmark_open(filename);

	if (bm == NULL)
		return NULL;

	return bm;
}

//-----------------------------------------------------------------------------------------------------------------------
//bookmark_deleteһhashӦ10λȫɾ
//bookmark_deleteOpɾһhashӦ10λеһhash10λȫЧhashٱʼΪ0
//أ-1ɾʧ
//       ֵɾɹ
//-----------------------------------------------------------------------------------------------------------------------
int bookmark_deleteOp( p_bookmark bm, U32 row )
{
	int i,j,i_start,delbmFlag = false;
	dword delPos = 0xFFFFFFFF;
	FILE *fp = NULL;
	p_bookmark cur_bm = NULL;
	p_bookmark save_bm = NULL;

	t_bm_index bi;
	U32 bmGroupSize;
	U32 bmGroupbase = 0;
	U32 bmGroupbase_old = 0;
	U32 bmGroupfileid;

	if( bm == NULL || row == 0xFFFFFFFF )
		return -1;

	cur_bm = bm;
	while( cur_bm && delbmFlag == false )
	{
		for( i = 0; i < BM_GROUP_INDEX_MAX_COUNT; i++ )
		{
			if( cur_bm->row[i] == row )
			{
				if( !(cur_bm == bm && i == BM_AUTO_SAVE_POSITION) )
				{
					delPos = i;
					delbmFlag = true;
				}
			}
		}
		if( delbmFlag == false )
			cur_bm = cur_bm->next;
	}

	if( delbmFlag == false )
	{
		if( bm->row[BM_AUTO_SAVE_POSITION] == row )
		{
			cur_bm = bm;
			delPos = BM_AUTO_SAVE_POSITION;
			delbmFlag = true;
		}

		if( delbmFlag == false )
			return -1;
	}

	fp = fopen( bmfile, "rb+" );
	if( !fp )
		return -1;

	cur_bm->row[delPos] = 0xFFFFFFFF;//ɾ

	i_start = 2;
	j = i_start - 1;
	save_bm = bm;
	cur_bm = bm;
	while( cur_bm && save_bm )//˳
	{
		i = i_start;
		do{
			if( save_bm->row[j] != 0xFFFFFFFF )
				j++;
			else if( save_bm->row[j] == 0xFFFFFFFF && cur_bm->row[i] != 0xFFFFFFFF )
			{
				save_bm->row[j++] = cur_bm->row[i];
				cur_bm->row[i] = 0xFFFFFFFF;
			}

			if( j >= BM_GROUP_INDEX_MAX_COUNT )
			{
				j = 0;
				save_bm = save_bm->next;
			}

		}while( (++i) < BM_GROUP_INDEX_MAX_COUNT );

		cur_bm = cur_bm->next;
		i_start = 0;
	}
	cur_bm = bm->last;
	while( cur_bm )//ɾ
	{
		for( i = 0; i < BM_GROUP_INDEX_MAX_COUNT; i++ )
		{
			if( cur_bm->row[i] != 0xFFFFFFFF )
				goto _bookmark_deleteOp_Next;
		}

		bmGroupSize = (cur_bm->index >> 5) * BMGROUP_SIZE;
		bmGroupbase = INDEX_HEADER_SIZE + bmGroupSize;

		bmGroupfileid = cur_bm->index & 0x1F;

		//ɾhashռ
		if( bmGroupbase_old != bmGroupbase )
		{
			bmGroupbase_old = bmGroupbase;
			memset( &bi, 0, sizeof(t_bm_index) );
			fseek( fp, bmGroupbase, SEEK_SET );
			fread( &bi, 1, sizeof(t_bm_index), fp );
		}

		bi.flag &= ~flagbits[bmGroupfileid];//־
		bi.hash[bmGroupfileid] = 0x00000000;//ļhash

		fseek( fp, bmGroupbase, SEEK_SET );
		fwrite( &bi, 1, sizeof(t_bm_index), fp );


		//ԲкŶֻ־hash
#if 0
		memset( &cur_bm->row[0], 0x00, BM_ROWS_SIZE );
		fseek( fp, ( cur_bm->index & 0x1F ) * BM_ROWS_SIZE, SEEK_CUR );
		fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );
#endif

		cur_bm = cur_bm->prev;
		if( cur_bm )
		{
			free( cur_bm->next );
			cur_bm->next_index = 0xFFFFFFFF;
			cur_bm->next = NULL;

			bm->last = cur_bm;
		}
	}
_bookmark_deleteOp_Next:
	if( cur_bm )
	{
		cur_bm = bm;
		while( cur_bm )//дЧ
		{
			bmGroupSize = (cur_bm->index >> 5) * BMGROUP_SIZE;
			bmGroupbase = INDEX_HEADER_SIZE + bmGroupSize;

			bmGroupfileid = cur_bm->index & 0x1F;

			if( cur_bm->row[0] == 0xFFFFFFFF && cur_bm->row[1] == 0xFFFFFFFF )
			{
				//ɾhashռ
				if( bmGroupbase_old != bmGroupbase )
				{
					bmGroupbase_old = bmGroupbase;
					memset( &bi, 0, sizeof(t_bm_index) );
					fseek( fp, bmGroupbase, SEEK_SET );
					fread( &bi, 1, sizeof(t_bm_index), fp );
				}

				bi.flag &= ~flagbits[bmGroupfileid];//־
				bi.hash[bmGroupfileid] = 0x00000000;//ļhash

				fseek( fp, bmGroupbase, SEEK_SET );
				fwrite( &bi, 1, sizeof(t_bm_index), fp );
			}


			fseek( fp, bmGroupbase + sizeof(t_bm_index) + ( cur_bm->index & 0x1F ) * BM_ROWS_SIZE, SEEK_SET );
			fwrite( &cur_bm->row[0], 1, BM_ROWS_SIZE, fp );

			cur_bm = cur_bm->next;
		}
	}
	fclose(fp);

	return row;
}
