/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _BOOKMARK_H_
#define _BOOKMARK_H_

#include "common/datatype.h"
#include <ds2io2.h>

#define			BM_GROUP_INDEX_MAX_COUNT			10
#define			BM_AUTO_SAVE_POSITION				0 //10λеһλ
#define			BM_FULL_POSITION0					9
#define			BM_FULL_POSITION1					9
#define			BM_ROWS_LEN							( 10 + 10 + 1 + 1 )//dword row[10] + t_bm_time bmtime[10] + dword prev_index + dword next_index
#define			BM_ROWS_SIZE						( BM_ROWS_LEN * sizeof(dword) )

#define			INDEX_HEADER_SIZE						( sizeof(dword) )//ǰһdword


enum{
	BM_AUTO_LOAD 	= BIT(0),//Զ
	BM_AUTO_SAVE	= BIT(1),//Զ
	BM_MAN_LOOKUP 	= BIT(2),//˹ѯ
	BM_MAN_SAVE 	= BIT(3)//˹
};


struct _bm_index
{
	dword flag;
	dword hash[32];
} __attribute__ ((packed));
typedef struct _bm_index t_bm_index, *p_bm_index;//33*4

typedef struct _bm_time
{
	U16 time;////ʱ  11111111 11111111 ֱռ6/5/5λ
	U8  year;
	U8  minutes;
}t_bm_time, *p_bm_time;

struct _bookmark
{
	dword row[10];
	t_bm_time bmtime[10];
	dword prev_index;
	dword next_index;
	dword index, hash;//hash:ļܺϢindex:ȫǩеλãǩ*32(ǩļ) + ÿļ10λеλ, index = 0xFFFFFFFFλûбʹ
	struct _bookmark *prev;
	struct _bookmark *next;
	struct _bookmark *last;
} __attribute__ ((packed));
typedef struct _bookmark t_bookmark, *p_bookmark;

extern void bookmark_init(const char *fn);
extern p_bookmark bookmark_open(const char *filename);
extern void bookmark_save(p_bookmark bm);
extern int bookmark_delete(p_bookmark bm);
extern void bookmark_close(p_bookmark bm);
extern dword bookmark_autoload(const char *filename);
extern void bookmark_autosave(const char *filename, dword row);
extern void bookmark_Manualsave( const char *filename, dword row );
extern BOOL bookmark_export(p_bookmark bm, const char *filename);
extern BOOL bookmark_import(const char *filename);
extern void bookmark_reorder( p_bookmark bm );
extern void bookmark_reorderAll( p_bookmark bm );
extern p_bookmark bookmark_Lookup( const char *filename );
extern void bookmark_Adjustorder( p_bookmark bm );
int bookmark_checkValidbm( p_bookmark bm );
int bookmark_GetValidbm( p_bookmark bm, BOOL IncludeAutoSavePos );
void bookmark_DelValidRepeatedbm( p_bookmark bm, BOOL IncludeAutoSavePos );
int bookmark_deleteOp( p_bookmark bm, U32 index );
p_bookmark bookmark_create_new_bm();

extern RTC bookmark_timetran( t_bm_time bmtime );

#define		bookmark_deleteAll( bm ) 		bookmark_delete( bm )

#endif
