/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config_ebook.h"
#include <string.h>
#include "common/utils.h"
#include "charsets.h"
#include <DrvMemMgr.h>
#include <fs_api.h>
#include <datatype.h>
#include <debugoff.h>

U16 *gbk_ucs_tbl = NULL;
U16 *big5_ucs_tbl = NULL;
U16 *sjis_ucs_tbl = NULL;


//-------------------------------궨---------------------------------------
#define		FONT_EXT_EN			0//ʹⲿֿ

#define		abort()			//ʱ޸

typedef dword ucs4_t;

int GetUTF8char( const byte * in, int inLength )
{
    unsigned char c;
    int tail = 0;
    int len = -1;

    if( ( in == NULL ) )
		return -1;

	if( ( *in != 0 ) && ( inLength > 0 ) )
	{
		c = *in++;
	    if ((c <= 0x7f) || (c >= 0xc2)) {
	        /* Start of new character. */
	        if (c < 0x80) {        /* U-00000000 - U-0000007F, 1 byte */
	            tail = 0;
	        } else if (c < 0xe0) { /* U-00000080 - U-000007FF, 2 bytes */
	            tail = 1;
	        } else if (c < 0xf0) { /* U-00000800 - U-0000FFFF, 3 bytes */
	            tail = 2;
	        } else if (c < 0xf5) { /* U-00010000 - U-001FFFFF, 4 bytes */
	            tail = 3;
	        } else {
	        	return -1;
	        }

			inLength--;
			if( inLength >= tail )
			{
				len = tail + 1;
		        while (tail-- && ((c = *in++) != 0) && ( inLength>0 ) ) {
		        	inLength--;
		            if ((c & 0xc0) == 0x80) {
		            } else {
		                len = -1;
		                break;
		            }
		        }
			}
	    }
	}
    return len;
}

U32 GetUTF8ToUnicodeLen( const byte * in, int inLength )
{
    unsigned char c;
    int tail = 0;
    U32 len = 0;

    if( ( in == NULL ) )
		return 0;

	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		c = *in++;
	    if ((c <= 0x7f) || (c >= 0xc2)) {
	        /* Start of new character. */
	        if (c < 0x80) {        /* U-00000000 - U-0000007F, 1 byte */
	            tail = 0;
	        } else if (c < 0xe0) { /* U-00000080 - U-000007FF, 2 bytes */
	            tail = 1;
	        } else if (c < 0xf0) { /* U-00000800 - U-0000FFFF, 3 bytes */
	            tail = 2;
	        } else if (c < 0xf5) { /* U-00010000 - U-001FFFFF, 4 bytes */
	            tail = 3;
	        } else {
	        	break;
	        }

			inLength--;
			if( inLength >= tail )
			{
		        while (tail-- && ((c = *in++) != 0) && ( inLength>0 ) ) {
		        	inLength--;
		            if ((c & 0xc0) == 0x80) {
		            } else {
		                in--;
		                break;
		            }
		        }
			}
			else
			{
				break;
			}
	    } else {
	    	break;
	    }
		len += 2;
	}
    return len;
}


U32 utf8_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength )
{
    unsigned char c;
    unsigned long code;
    int tail = 0;
    int outLenMax = outLength - 2;
    U32 len = 0;

    if( ( in == NULL ) || ( out == NULL ) )
		return 0;

	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;

		c = *in++;
	    if ((c <= 0x7f) || (c >= 0xc2)) {
	        /* Start of new character. */
	        if (c < 0x80) {        /* U-00000000 - U-0000007F, 1 byte */
	            tail = 0;
	            code = c;
	        } else if (c < 0xe0) { /* U-00000080 - U-000007FF, 2 bytes */
	            tail = 1;
	            code = c & 0x1f;
	        } else if (c < 0xf0) { /* U-00000800 - U-0000FFFF, 3 bytes */
	            tail = 2;
	            code = c & 0x0f;
	        } else if (c < 0xf5) { /* U-00010000 - U-001FFFFF, 4 bytes */
	            tail = 3;
	            code = c & 0x07;
	        } else {
	            /* Invalid size. */
	            code = 0;
	        }

			inLength--;
			if( inLength >= tail )
			{
		        while (tail-- && ((c = *in++) != 0) && ( inLength>0 ) ) {
		        	inLength--;
		            if ((c & 0xc0) == 0x80) {
		                /* Valid continuation character. */
		                code = (code << 6) | (c & 0x3f);

		            } else {
		                /* Invalid continuation char */
		                code = 0xfffd;
		                in--;
		                break;
		            }
		        }
			}
			else
			{
				break;
			}
	    } else {
	        /* Invalid UTF-8 char */
	        code = 0;
	        break;
	    }
	    /* currently we don't support chars above U-FFFF */
	//    *out = (code < 0x10000) ? code : 0;
		if( code >= 0x10000 )
			code = 0;

		//little endian
		*out++ = (U16)code;
		len += 2;
	}
	*out = 0;
    return len;
}

U32 utf8_to_ucs( byte* out, int outLength,const byte * in, int inLength )
{
    unsigned char c;
    unsigned long code;
    int tail = 0;
    int outLenMax = outLength - 2;
    U32 len = 0;

    if( ( in == NULL ) || ( out == NULL ) )
		return 0;

	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;

		c = *in++;
	    if ((c <= 0x7f) || (c >= 0xc2)) {
	        /* Start of new character. */
	        if (c < 0x80) {        /* U-00000000 - U-0000007F, 1 byte */
	            tail = 0;
	            code = c;
	        } else if (c < 0xe0) { /* U-00000080 - U-000007FF, 2 bytes */
	            tail = 1;
	            code = c & 0x1f;
	        } else if (c < 0xf0) { /* U-00000800 - U-0000FFFF, 3 bytes */
	            tail = 2;
	            code = c & 0x0f;
	        } else if (c < 0xf5) { /* U-00010000 - U-001FFFFF, 4 bytes */
	            tail = 3;
	            code = c & 0x07;
	        } else {
	            /* Invalid size. */
	            code = 0;
	        }

			inLength--;
			if( inLength >= tail )
			{
		        while (tail-- && ((c = *in++) != 0) && ( inLength>0 ) ) {
		        	inLength--;
		            if ((c & 0xc0) == 0x80) {
		                /* Valid continuation character. */
		                code = (code << 6) | (c & 0x3f);

		            } else {
		                /* Invalid continuation char */
		                code = 0xfffd;
		                in--;
		                break;
		            }
		        }
			}
			else
			{
				break;
			}
	    } else {
	        /* Invalid UTF-8 char */
	        code = 0;
	        break;
	    }
	    /* currently we don't support chars above U-FFFF */
	//    *out = (code < 0x10000) ? code : 0;
		if( code >= 0x10000 )
			code = 0;

		//little endian
		*out++ = (byte)code;
		*out++ = (byte)(code>>8);
		len += 2;
	}
	*out++ = 0;
	*out = 0;
    return len;
}

const byte* utf8decode(const byte *utf8, byte *ucs)
{
    unsigned char c = *utf8++;
    unsigned long code;
    int tail = 0;

    if ((c <= 0x7f) || (c >= 0xc2)) {
        /* Start of new character. */
        if (c < 0x80) {        /* U-00000000 - U-0000007F, 1 byte */
            code = c;
        } else if (c < 0xe0) { /* U-00000080 - U-000007FF, 2 bytes */
            tail = 1;
            code = c & 0x1f;
        } else if (c < 0xf0) { /* U-00000800 - U-0000FFFF, 3 bytes */
            tail = 2;
            code = c & 0x0f;
        } else if (c < 0xf5) { /* U-00010000 - U-001FFFFF, 4 bytes */
            tail = 3;
            code = c & 0x07;
        } else {
            /* Invalid size. */
            code = 0;
        }

        while (tail-- && ((c = *utf8++) != 0)) {
            if ((c & 0xc0) == 0x80) {
                /* Valid continuation character. */
                code = (code << 6) | (c & 0x3f);

            } else {
                /* Invalid continuation char */
                code = 0xfffd;
                utf8--;
                break;
            }
        }
    } else {
        /* Invalid UTF-8 char */
        code = 0;
    }
    /* currently we don't support chars above U-FFFF */
//    *ucs = (code < 0x10000) ? code : 0;
	if( code >= 0x10000 )
		code = 0;

	//little endian
	ucs[0] = (byte)code;
	ucs[1] = (byte)(code>>8);

    return utf8;
}

//-------------------------------------------------------
//תʵ賤
//inLength: unicodeȣּ
//totalNum: utf8ȣֽڼ
//-------------------------------------------------------
int GetUnicode2Utf8LenFast( const U16 * in, int inLength )
{
	int i, totalNum = 0;
	U16 unicode;
    for( i = 0; i < inLength; i++)
    {
        unicode = in[i];
        if (unicode > 0x0000 && unicode <= 0x007f)
        {
            totalNum += 1;
        }
        else if (unicode >= 0x0080 && unicode <= 0x07ff)
        {
            totalNum += 2;
        }
        else if (unicode >= 0x0800 && unicode <= 0xffff)
        {
            totalNum += 3;
        }
        else if ( unicode == 0x0000 )
    	{
    		break;
    	}
    }
    return totalNum;
}

//-------------------------------------------------------
//תʵ賤
//inLength: unicodeȣֽڼ
//totalNum: utf8ȣֽڼ
//-------------------------------------------------------
int GetUnicode2Utf8Len( const byte * in, int inLength )
{
	int i, totalNum = 0;
	U16 unicode;
    for( i = 0; i < inLength; i += 2 )
    {
        unicode = ( in[i+1] << 8 ) | in[i];
        if (unicode > 0x0000 && unicode <= 0x007f)
        {
            totalNum += 1;
        }
        else if (unicode >= 0x0080 && unicode <= 0x07ff)
        {
            totalNum += 2;
        }
        else if (unicode >= 0x0800 && unicode <= 0xffff)
        {
            totalNum += 3;
        }
        else if ( unicode == 0x0000 )
    	{
    		break;
    	}
    }
    return totalNum;
}

int Unicode2Utf8Fast( byte* out, int outLength,const U16 * in, int inLength )
{
	int i;
    //------------------------------------------------
    //Чж
    if( out == NULL || in == NULL || inLength<=1)
    {
        return 0;
    }

#if 0
    int totalNum = GetUnicodeToUtf8Len( in, inLength );//תʵ賤
    if( outLength < totalNum )//Чжϣ
    {
        return 0;
    }
#endif
    //------------------------------------------------

    int outsize = 0;//ʵʴС
    U16 unicode;
    for ( i = 0; i < inLength; i++ )
    {
        if(outsize>=outLength) //ռ䲻Ӧ
        {
           break;
        }
        unicode = in[i];
        if (unicode > 0x0000 && unicode <= 0x007f)
        {
            out[outsize++] = (byte)unicode;
        }
        else if (unicode >= 0x0080 && unicode <= 0x07ff)
        {
        	out[outsize++] = 0xC0 | (unicode >> 12);
			out[outsize++] = 0x80 | (unicode >>6 & 0x3F);
        }
        else if (unicode >= 0x0800 && unicode <= 0xffff)
        {
        	out[outsize++] = 0xE0 | (unicode >> 12);
			out[outsize++] = 0x80 | (unicode >>6 & 0x3F);
			out[outsize++] = 0x80 | (unicode &0x3F);
        }
        else if( unicode == 0x0000 )
        {
        	break;
        }
    }
    return outsize;
}

int Unicode2Utf8( byte* out, int outLength,const byte * in, int inLength )
{
	int i, totalNum = 0;
    //------------------------------------------------
    //Чж
    if(out == NULL || in == NULL || inLength<=1)
    {
        return 0;
    }

#if 0
    totalNum = GetUnicodeToUtf8Len( in, inLength );//תʵ賤
    if( outLength < totalNum )//Чжϣ
    {
        return 0;
    }
#endif
    //------------------------------------------------

    int outsize = 0;//ʵʴС
    U16 unicode;
    for ( i = 0; i < inLength; i += 2 )
    {
        if(outsize>=outLength) //ռ䲻Ӧ
        {
           break;
        }
        unicode = (in[i+1]<<8) | in[i];
        if (unicode > 0x0000 && unicode <= 0x007f)
        {
            out[outsize++] = (byte)unicode;
        }
        else if (unicode >= 0x0080 && unicode <= 0x07ff)
        {
        	out[outsize++] = 0xC0 | (unicode >> 12);
			out[outsize++] = 0x80 | (unicode >>6 & 0x3F);
        }
        else if (unicode >= 0x0800 && unicode <= 0xffff)
        {
        	out[outsize++] = 0xE0 | (unicode >> 12);
			out[outsize++] = 0x80 | (unicode >>6 & 0x3F);
			out[outsize++] = 0x80 | (unicode &0x3F);
        }
        else if( unicode == 0x0000 )
        {
        	break;
        }
    }
    return outsize;
}

extern int UnicodeToUtf8( const byte* src, byte* utf8)
{
	int len=0;
	U16 ucs2;
	while( !(src[0] == 0x00 && src[1] == 0x00) )
	{
		ucs2 = (src[1] << 8) | src[0];
		if (ucs2 < 0x80) //one byte
		{
			utf8[len++] = ucs2;

		}
		else if (ucs2 < 0x800) //two byte
		{
			utf8[len++] = 0xC0 | (ucs2 >> 12);
			utf8[len++] = 0x80 | (ucs2 >>6 & 0x3F);
		}
		else
		{
			utf8[len++] = 0xE0 | (ucs2 >> 12);
			utf8[len++] = 0x80 | (ucs2 >>6 & 0x3F);
			utf8[len++] = 0x80 | (ucs2 &0x3F);
		}
		src += 2;
	}

	utf8[len] = 0;//ַ
	return len;
}

CodeType CheckCodeType(const byte* AnsiStr,U32 length)
{
	CodeType strCodeType=CODETYPE_DEFAULT;
	byte low=0,high=0;
	U16 chr=0;
	const byte *p = (const byte*)AnsiStr;

	if (!AnsiStr)
	{
		return CODETYPE_DEFAULT;
	}
	if (length==0)
	{
		return CODETYPE_DEFAULT;
	}


	//жǷUNICODE
	BOOL isUNICODE=TRUE;//дĽ
	if( p[0] == 0xFF && p[1] == 0xFE )
	{
		strCodeType = CODETYPE_UNICODE;
		isUNICODE=TRUE;
	}
	else if( p[0] == 0xFE && p[1] == 0xFF )
	{
		strCodeType = CODETYPE_UNICODE_BIGENDIAN;
		isUNICODE=TRUE;
	}
	else
	{
		isUNICODE=FALSE;
	}

	if (isUNICODE)
		return strCodeType;


	//жǷUTF-8
	U32 i=0;
	BOOL isUTF8=TRUE;

	if( p[0] == 0xEF && p[1] == 0xBB && p[2] == 0xBF )//UFT8 BOM
	{
		isUTF8=TRUE;
	}
	else
	{
		isUTF8 = IsUTF8( AnsiStr, length );
	}
	if (isUTF8)
		return CODETYPE_UTF8;


	U32 JISMapLength,GBKMapLength,BIG5MapLength;
	byte *JISMapBuffer = NULL,*GBKMapBuffer = NULL,*BIG5MapBuffer = NULL;

	//ӳ
	FILE *fp = NULL;
	byte *buffer = NULL;
	int len;
	local_map_t localmap;

	// GBK/BIG5/Shift-JIS
	fp = fopen( CONFIG_FONT_LOCAL2UMAP_DIR, "rb" );
	if( !fp )
	{
		goto _CheckCodeType_Exit;
	}

	fseek( fp, 0, SEEK_END );
	len = ftell( fp );
	if( len == 0 )
	{
		goto _CheckCodeType_Exit;
	}

	buffer = (byte*)malloc( len );
	if( buffer == NULL )
	{
		goto _CheckCodeType_Exit;
	}
	fseek( fp, 0, SEEK_SET );
	fread( buffer, 1, len, fp );
	fclose( fp );
	fp = NULL;

	memcpy( (void*)(&localmap),  (const void*)buffer, sizeof( local_map_t ) );

	//GBK
	GBKMapBuffer = buffer + localmap.offset_gbk;
	GBKMapLength = localmap.length_gbk;

	//BIG5
	BIG5MapBuffer = buffer + localmap.offset_big5;
	BIG5MapLength = localmap.length_big5;

	//Shift-JIS
	JISMapBuffer = buffer + localmap.offset_sjis;
	JISMapLength = localmap.length_sjis;

	//룬˳Shift-JIS>GBK>BIG5
	//ͨǰ⣬м
	//ӦUnicodeַǷΪ0xFFFDıԽ׼ȷԽ
	//֮
	strCodeType=CODETYPE_SHIFTJIS;
	for (i=0;i<length;)
	{
		memcpy(&high,AnsiStr+i,1); //ȡһbyte
		i++;
		if (high<=0x7F)  //ASCII
		{
			low=high;
			high=0;
		}
		else if ((high>=0xA1)&&(high<=0xDF))  //Ƭ
		{
			low=high;
			high=0;
		}
		else  //˫ֽ
		{
			memcpy(&low,AnsiStr+i,1); //ȡλ
			i++;
		}

		chr=low+high*256;
		if (chr<0x80) // ASCII
		{}
		else if (chr<JIS0201OFFSET) // 0x80 - 0xA0 δռ
		{
			strCodeType=CODETYPE_DEFAULT; // δ֪
			break;
		}
		else if (chr<(JIS0201OFFSET+JIS0201LENGTH)) // 0xA1 - 0xDF Ǽ
		{}
		else if (chr<JIS0208OFFSET) // 0xE0 - 0x813F δռ
		{
			strCodeType=CODETYPE_DEFAULT;  // δ֪
			break;
		}
		else // 0x8140 - 0xFFFF
		{
			int offset;
			offset=chr-JIS0208OFFSET+JIS0201LENGTH;
			memcpy((void*)&chr,JISMapBuffer+offset*2,2);
			if (chr==0xFFFD)
			{
				strCodeType=CODETYPE_GBK;
				break;
			}
		}
	}
	if (strCodeType==CODETYPE_GBK)
	{
		for (i=0;i<length;)
		{
			memcpy(&high,AnsiStr+i,1); //ȡһbyte
			i++;
			if (high>0x7F) //һbyteǸλ
			{
				memcpy(&low,AnsiStr+i,1); //ȡλ
				i++;
			}
			else
			{
				low=high;
				high=0;
			}

			chr=low+high*256;
			if (chr<0x80) // ASCII
			{}
			else if (chr<GBKOFFSET) // 0x80 - 0x813F δռ
			{
				strCodeType=CODETYPE_DEFAULT;   // δ֪
				break;
			}
			else
			{
				int offset;
				offset=chr-GBKOFFSET;
				memcpy((void*)&chr,GBKMapBuffer+offset*2,2);
				if (chr==0xFFFD)
				{
					strCodeType=CODETYPE_BIG5;
					break;
				}
			}
		}
	}
	if (strCodeType==CODETYPE_BIG5)
	{
		for (i=0;i<length;)
		{
			memcpy(&high,AnsiStr+i,1); //ȡһbyte
			i++;
			if (high>0x7F) //һbyteǸλ
			{
				memcpy(&low,AnsiStr+i,1); //ȡλ
				i++;
			}
			else
			{
				low=high;
				high=0;
			}

			chr=low+high*256;
			if (chr<0x80) // ASCII
			{}
			else if (chr<BIG5OFFSET) // 0x80 - 0x813F δռ
			{
				strCodeType=CODETYPE_DEFAULT;   // δ֪
				break;
			}
			else
			{
				int offset;
				offset=chr-BIG5OFFSET;
				memcpy((void*)&chr,BIG5MapBuffer+offset*2,2);
				if (chr==0xFFFD)
				{
					strCodeType=CODETYPE_DEFAULT;
					break;
				}
			}
		}
	}

	if( strCodeType == CODETYPE_DEFAULT )
		strCodeType == CODETYPE_GBK;

_CheckCodeType_Exit:

	if( buffer )
	{
		free( buffer );
		buffer = NULL;
	}

	if( fp )
	{
		fclose( fp );
		fp = NULL;
	}

	return strCodeType;
}

bool IsUTF8(const byte* pBuffer, long size)
{
    bool IsUTF8 = true;
    byte* start = (byte*)pBuffer;
    byte* end = (byte*)pBuffer + size;
    while (start < end)
    {
        if (*start < 0x80) // (10000000): ֵС0x80ΪASCIIַ
        {
            start++;
        }
        else if (*start < (0xC0)) // (11000000): ֵ0x800xC0֮ΪЧUTF-8ַ
        {
            IsUTF8 = false;
            break;
        }
        else if (*start < (0xE0)) // (11100000): ˷ΧΪ2ֽUTF-8ַ
        {
            if (start >= end - 1)
                break;
            if ((start[1] & (0xC0)) != 0x80)
            {
                IsUTF8 = false;
                break;
            }
            start += 2;
        }
        else if (*start < (0xF0)) // (11110000): ˷ΧΪ3ֽUTF-8ַ
        {
            if (start >= end - 2)
                break;
            if ((start[1] & (0xC0)) != 0x80 || (start[2] & (0xC0)) != 0x80)
            {
                IsUTF8 = false;
                break;
            }
            start += 3;
        }
        else
        {
            IsUTF8 = false;
            break;
        }
    }
    return IsUTF8;
}

extern word charsets_gbk_to_ucs(const byte * in)
{
	U16 page,offset;
	ucs4_t u = 0;
	U32 len = 0;
	FILE *fp = NULL;

	if( gbk_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_GBKTOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		gbk_ucs_tbl = (U16*)memalign( 2, len );
		if( gbk_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( gbk_ucs_tbl, 1, len, fp );
		fclose( fp );
	}

#define		GBK_PAGE_SIZE				( 0x7f-0x40+0xff-0x80 )//190
#define		GBK_PAGE2_OFFSET			( 0x7f-0x40-0x80 )

	if( ( in == NULL ) )
		return 0;

	if( *in < 0x80 )
	{
		u = (U16)(*in);
	}
	else if( *in >= 0x81 && *in <= 0xFE )
	{
		page = *in - 0x81;
		if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
		{
			offset = *(in+1) - 0x40;
			u = gbk_ucs_tbl[page * GBK_PAGE_SIZE + offset];
		}
		else if( *(in+1) >= 0x80 && *(in+1) <= 0xFE )
		{
			offset = *(in+1) + GBK_PAGE2_OFFSET;
			u = gbk_ucs_tbl[page * GBK_PAGE_SIZE + offset];
		}
		else
		{
			u = 0x1FFF;
		}
	}
	else
	{
		u = 0x1FFF;
	}

	return u;
}

//------------------------------------------------------------------------------------
//inLength: ֽڼ
//outLength: ֽڼ
//len: ֽڼ
//------------------------------------------------------------------------------------
U32 gbk_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	ucs4_t u = 0;
	U32 len = 0;
	U32 outLenMax = outLength-2;
	FILE *fp = NULL;

	if( gbk_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_GBKTOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		gbk_ucs_tbl = (U16*)memalign( 2, len );
		if( gbk_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( gbk_ucs_tbl, 1, len, fp );
		fclose( fp );
	}

	if( ( in == NULL ) || ( out == NULL ) )
		return 0;

#define		GBK_PAGE_SIZE				( 0x7f-0x40+0xff-0x80 )//190
#define		GBK_PAGE2_OFFSET			( 0x7f-0x40-0x80 )

	len = 0;
	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;

		if( *in < 0x80 )
		{
			*out++ = (U16)(*in);
			inLength--;
			in++;
		}
		else if( *in >= 0x81 && *in <= 0xFE )
		{
			page = *in - 0x81;
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				offset = *(in+1) - 0x40;
			}
			else if( *(in+1) >= 0x80 && *(in+1) <= 0xFE )
			{
				offset = *(in+1) + GBK_PAGE2_OFFSET;
			}
			else
			{
				break;
			}
			*out++ = gbk_ucs_tbl[page * GBK_PAGE_SIZE + offset];
			inLength -= 2;
			in += 2;
		}
		len += 2;
	}
	*out = 0;

	return len;
}

//------------------------------------------------------------------------------------
//outLength: ֽڼ
//len: ֽڼ
//------------------------------------------------------------------------------------
U32 gbk_to_ucs( byte* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	U32 len = 0;
	U32 outLenMax = outLength-2;
	FILE *fp = NULL;
	U16 temp16;

	if( gbk_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_GBKTOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		gbk_ucs_tbl = (U16*)memalign( 2, len );
		if( gbk_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( gbk_ucs_tbl, 1, len, fp );
		fclose( fp );
	}

	if( ( in == NULL ) || ( out == NULL ) )
		return 0;

#define		GBK_PAGE_SIZE				( 0x7f-0x40+0xff-0x80 )//190
#define		GBK_PAGE2_OFFSET			( 0x7f-0x40-0x80 )

	len = 0;
	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;

		if( *in < 0x80 )
		{
			*out++ = (byte)(*in);
			*out++ = 0x00;
			inLength--;
			in++;
		}
		else if( *in >= 0x81 && *in <= 0xFE )
		{
			page = *in - 0x81;
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				offset = *(in+1) - 0x40;
			}
			else if( *(in+1) >= 0x80 && *(in+1) <= 0xFE )
			{
				offset = *(in+1) + GBK_PAGE2_OFFSET;
			}
			else
			{
				break;
			}
			temp16 = gbk_ucs_tbl[page * GBK_PAGE_SIZE + offset];
			*out++ = (byte)temp16;
			*out++ = (byte)(temp16>>8);
			inLength -= 2;
			in += 2;
		}

		len += 2;
	}
	*out++ = 0;
	*out = 0;

	return len;
}

int Get_gbk2ucs_Len( const byte * in, int inLength )
{
	U32 len = 0;

	if( ( in == NULL ) )
		return 0;

	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( *in < 0x80 )
		{
			inLength--;
			in++;
		}
		else if( *in >= 0x81 && *in <= 0xFE )
		{
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				inLength -= 2;
				in += 2;
			}
			else if( *(in+1) >= 0x80 && *(in+1) <= 0xFE )
			{
				inLength -= 2;
				in += 2;
			}
			else
			{
				break;
			}
		}

		len += 2;
	}

	return len;	
}

//------------------------------------------------------------------------------------
//inLength: ֽڼ
//outLength: ֽڼ
//len: ֽڼ
//------------------------------------------------------------------------------------
U32 big5_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	U32 len=0;
	FILE *fp = NULL;
	u32 outLenMax = outLength - 2;

	if( big5_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_BIG5TOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		big5_ucs_tbl = (U16*)memalign( 2, len );
		if( big5_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( big5_ucs_tbl, 1, len, fp );
		fclose( fp );
	}
	if( (!in) || (!out) )
		return 0;

#define		BIG5_PAGE_SIZE				( 0x7f-0x40+0xff-0xa1 )
#define		BIG5_PAGE2_OFFSET			( 0x7f-0x40-0xa1 )

	len = 0;
	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;
		if( *in < 0x80 )
		{
			*out++ = (U16)(*in);
			inLength--;
			in++;
		}
		else if( *in >= 0xA1 && *in <= 0XF9 )
		{
			page = *in - 0xA1;
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				offset = *(in+1) - 0x40;
			}
			else if( *(in+1) >= 0xA1 && *(in+1) <= 0xFE )
			{
				offset = *(in+1) + BIG5_PAGE2_OFFSET;
			}
			else
			{
				break;
			}
			*out++ = big5_ucs_tbl[page * BIG5_PAGE_SIZE + offset];
			inLength -= 2;
			in += 2;
		}
		else
		{
			break;
		}
		len += 2;
	}
	*out = 0;
	return len;
}

U32 big5_to_ucs( byte* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	U32 len=0;
	FILE *fp = NULL;
	u32 outLenMax = outLength - 2;
	U16 temp16;

	if( big5_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_BIG5TOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		big5_ucs_tbl = (U16*)memalign( 2, len );
		if( big5_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( big5_ucs_tbl, 1, len, fp );
		fclose( fp );
	}
	if( (!in) || (!out) )
		return 0;

#define		BIG5_PAGE_SIZE				( 0x7f-0x40+0xff-0xa1 )
#define		BIG5_PAGE2_OFFSET			( 0x7f-0x40-0xa1 )

	len = 0;
	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( len >= outLenMax )
			break;
		if( *in < 0x80 )
		{
			*out++ = (byte)(*in);
			*out++ = 0x00;
			inLength--;
			in++;
		}
		else if( *in >= 0xA1 && *in <= 0XF9 )
		{
			page = *in - 0xA1;
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				offset = *(in+1) - 0x40;
			}
			else if( *(in+1) >= 0xA1 && *(in+1) <= 0xFE )
			{
				offset = *(in+1) + BIG5_PAGE2_OFFSET;
			}
			else
			{
				break;
			}
			temp16 = big5_ucs_tbl[page * BIG5_PAGE_SIZE + offset];
			*out++ = (byte)temp16;
			*out++ = (byte)(temp16>>8);
			inLength -= 2;
			in += 2;
		}
		else
		{
			break;
		}
		len += 2;
	}
	*out++ = 0;
	*out = 0;
	return len;
}

int Get_big52ucs_Len( const byte * in, int inLength )
{
	U32 len=0;

	if( (!in) )
		return 0;

	while( ( *in != 0 ) && ( inLength > 0 ) )
	{
		if( *in < 0x80 )
		{
			inLength--;
			in++;
		}
		else if( *in >= 0xA1 && *in <= 0XF9 )
		{
			if( *(in+1) >= 0x40 && *(in+1) <= 0x7E )
			{
				inLength -= 2;
				in += 2;
			}
			else if( *(in+1) >= 0xA1 && *(in+1) <= 0xFE )
			{
				inLength -= 2;
				in += 2;
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
		len += 2;
	}
	return len;
}


//=============================================================================================
//Shift-JIS
//=============================================================================================
const U16 sjis_page_code[45] = {
		0x81, 0x82, 0x83, 0x84,//4
		0X87, 0X88, 0X89, 0X8A, 0X8B, 0X8C, 0X8D, 0X8E, 0X8F, //9
		0X90, 0X91, 0X92, 0X93, 0X94, 0X95, 0X96, 0X97, 0X98, 0X99, 0X9A, 0X9B, 0X9C, 0X9D, 0X9E, 0X9F,//16
		0XE0, 0XE1, 0XE2, 0XE3, 0XE4, 0XE5, 0XE6, 0XE7, 0XE8, 0XE9, 0XEA,//11
		0XED, 0XEE,//2
		0XFA, 0XFB, 0XFC//3
	};


U32 sjis_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	U32 len=0;
	FILE *fp = NULL;
	int outLenMax = outLength - 2;

	if( sjis_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_SJISTOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		sjis_ucs_tbl = (U16*)memalign( 2, len );
		if( sjis_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( sjis_ucs_tbl, 1, len, fp );
		fclose( fp );
	}
	if( (!in) || (!out) || (inLength==0) || (!out) )
		return 0;

#define		SJIS_PAGE_SIZE				( 0XFC-0x40 + 1)

	len=0;
	while( *in != '\0' && inLength > 0 )
	{
		if( len >= outLenMax )
			break;
		if( *in < 0x80 )
		{
			*out++ = (U16)(*in);
			inLength--;
			in++;
			len += 2;
			continue;
		}
		else if( *in >= 0x81 && *in <= 0X84 )//4 page
		{
			page = *in - 0x81;
		}
		else if( *in >= 0x87 && *in <= 0X9F )//25
		{
			page = *in - 0x87 + 4;
		}
		else if( *in >= 0xE0 && *in <= 0XEA )//11
		{
			page = *in - 0xE0 + 4 + 25;
		}
		else if( *in >= 0XED && *in <= 0XEE )//2
		{
			page = *in - 0XED + 4 + 25 + 11;
		}
		else if( *in >= 0XFA && *in <= 0XFC )//3
		{
			page = *in - 0XFA + 4 + 25 + 11 + 2;
		}
		else
		{
			break;
		}

		offset = *(in+1) - 0x40;
		*out++ = sjis_ucs_tbl[page * SJIS_PAGE_SIZE + offset];
		inLength -= 2;
		in += 2;
		len += 2;
	}
	*out = 0;
	return len;
}

U32 sjis_to_ucs( byte* out, int outLength,const byte * in, int inLength )
{
	U16 page,offset;
	U32 len=0;
	FILE *fp = NULL;
	int outLenMax = outLength - 2;
	U16 temp16;

	if( sjis_ucs_tbl == NULL )
	{
		fp = fopen( CONFIG_SJISTOUCS_PATH, "r" );
		if( !fp )
			return 0;
		fseek( fp, 0, SEEK_END );
		len = ftell( fp );
		if( len == 0 )
			return 0;

		sjis_ucs_tbl = (U16*)memalign( 2, len );
		if( sjis_ucs_tbl == NULL )
		{
			fclose( fp );
			return 0;
		}

		fseek( fp, 0, SEEK_SET );
		fread( sjis_ucs_tbl, 1, len, fp );
		fclose( fp );
	}
	if( (!in) || (!out) )
		return 0;

#define		SJIS_PAGE_SIZE				( 0XFC-0x40 + 1)

	len=0;
	while( *in != '\0' && inLength > 0 )
	{
		if( len >= outLenMax )
			break;
		if( *in < 0x80 )
		{
			*out++ = (U16)(*in);
			inLength--;
			in++;
			len += 2;
			continue;
		}
		else if( *in >= 0x81 && *in <= 0X84 )//4 page
		{
			page = *in - 0x81;
		}
		else if( *in >= 0x87 && *in <= 0X9F )//25
		{
			page = *in - 0x87 + 4;
		}
		else if( *in >= 0xE0 && *in <= 0XEA )//11
		{
			page = *in - 0xE0 + 4 + 25;
		}
		else if( *in >= 0XED && *in <= 0XEE )//2
		{
			page = *in - 0XED + 4 + 25 + 11;
		}
		else if( *in >= 0XFA && *in <= 0XFC )//3
		{
			page = *in - 0XFA + 4 + 25 + 11 + 2;
		}
		else
		{
			break;
		}

		offset = *(in+1) - 0x40;
		temp16 = sjis_ucs_tbl[page * SJIS_PAGE_SIZE + offset];
		*out++ = (byte)temp16;
		*out++ = (byte)(temp16>>8);
		inLength -= 2;
		in += 2;
		len += 2;
	}
	*out++ = 0;
	*out = 0;
	return len;
}

int Get_sjis2ucs_Len( const byte * in, int inLength )
{
	U32 len=0;

	if( (!in) )
		return 0;

	while( *in != '\0' && inLength > 0 )
	{
		if( *in < 0x80 )
		{
			inLength--;
			in++;
			len += 2;
			continue;
		}
		else if( *in >= 0x81 && *in <= 0X84 )//4 page
		{
		}
		else if( *in >= 0x87 && *in <= 0X9F )//25
		{
		}
		else if( *in >= 0xE0 && *in <= 0XEA )//11
		{
		}
		else if( *in >= 0XED && *in <= 0XEE )//2
		{
		}
		else if( *in >= 0XFA && *in <= 0XFC )//3
		{
		}
		else
		{
			break;
		}

		inLength -= 2;
		in += 2;
		len += 2;
	}
	return len;
}