/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _CHARSETS_H
#define _CHARSETS_H

#include <datatype.h>


typedef		struct {
	U32 offset_gbk;
	U32 length_gbk;
	U32 offset_big5;
	U32 length_big5;
	U32 offset_sjis;
	U32 length_sjis;
}local_map_t;

extern U16 *gbk_ucs_tbl;
extern U16 *big5_ucs_tbl;
extern U16 *sjis_ucs_tbl;

extern dword charsets_utf32_conv(const byte * ucs, byte * cjk);
extern dword charsets_ucs_conv(const byte * uni, byte * cjk);
extern void charsets_big5_conv(const byte * big5, byte * cjk);
extern void charsets_sjis_conv(const byte * jis, byte ** cjk, dword * newsize);
extern dword charsets_utf8_conv(const byte * ucs, byte * cjk);
extern dword charsets_utf16_conv(const byte * ucs, byte * cjk);
extern dword charsets_utf16be_conv(const byte * ucs, byte * cjk);
extern word charsets_gbk_to_ucs(const byte * cjk);
extern dword charsets_ucsbe_conv(const byte * ucs, byte * cjk);
extern const byte* utf8decode(const byte *utf8, byte *ucs);
//extern int utf8_ucs2(const byte *utf8, byte *ucs);

U32 gbk_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength );
U32 gbk_to_ucs( byte* out, int outLength,const byte * in, int inLength );
int Get_gbk2ucs_Len( const byte * in, int inLength );

U32 big5_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength );
U32 big5_to_ucs( byte* out, int outLength,const byte * in, int inLength );
int Get_big52ucs_Len( const byte * in, int inLength );

U32 utf8_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength );
U32 utf8_to_ucs( byte* out, int outLength,const byte * in, int inLength );

U32 GetUTF8ToUnicodeLen( const byte * in, int inLength );

extern int UnicodeToUtf8( const byte* src, byte* utf8);

extern bool IsUTF8(const byte* pBuffer, long size);
CodeType CheckCodeType(const byte* AnsiStr,U32 length);

int GetUnicodeToUtf8Len( const U16 * in, int inLength );
int GetUnicode2Utf8LenFast( const U16 * in, int inLength );
int Unicode2Utf8( byte* out, int outLength,const byte * in, int inLength );
int Unicode2Utf8Fast( byte* out, int outLength,const U16 * in, int inLength );

int GetUTF8char( const byte * in, int inLength );

U32 sjis_to_ucs_Fast( U16* out, int outLength,const byte * in, int inLength );
U32 sjis_to_ucs( byte* out, int outLength,const byte * in, int inLength );
int Get_sjis2ucs_Len( const byte * in, int inLength );


#endif
