#ifndef __CONFIG_H
#define __CONFIG_H

#include <datatype.h>
#include <Macro.h>

//#define			CONFIG_EDITION_CN						0
//#define			CONFIG_EDITION_EN						1
//#define			CONFIG_EDITION_JP						2
//#define			CONFIG_EDITION							CONFIG_EDITION_JP

#define  		SUPPORT_DIAGONAL_MARK_DISPLAY			1
#define  		SUPPORT_DOUBLEPAN_DISPLAY_TEXT			1 //֧˫ʾı
#define  		SETTINGS_EFFECTIVE_AT_ONCE				1

#define			ROWSPACE_MAX							15
#define			WORDPACE_MAX							15

#define			SUPPORT_EDITION_CN						1
#define			SUPPORT_EDITION_EN						(!SUPPORT_EDITION_CN)

#define			USE_UNICODE_AS_LOCAL					0
#define			USE_UNICODE_FONTLIB						1

#define			DRAW_NAVIGATION_IN_TEXT					1

#define			SUPPORT_BACKLIGHTSET					0//Ƿֱ֧

#define			CONFIG_HELPKEY							KEY_SELECT

#define			CONFIG_FONTSIZE_SYS						12//ϵͳʹõֺţ⣩
#define			CONFIG_FONTW_SYS						12//ϵͳʹõֺţ⣩
#define			CONFIG_FONTH_SYS						12//ϵͳʹõֺţ⣩
#define			CONFIG_FONTW_MIN						10
#define			CONFIG_FONTW_MAX						18

#define			CONFIG_TIMER_ID							1

#define			CONFIG_KEY_REPEAT_TIME_N				250//250

#define			CONFIG_FONTSIZE_MIN						10
#define			CONFIG_FONTSIZE_MAX						20

#define			CONFIG_ENFONTLIB						0

#define SCREEN_W 256
#define SCREEN_H 192

#define MENUWIN_W  210
#define MENUWIN_H  150

#define MENUWIN_X0 23
#define MENUWIN_Y0 21

#define MAINTITLE_X0	30
#define MAINTITLE_Y0	20

#define MAINTITLE_W 	( SCREEN_W - MAINTITLE_X0 - MAINTITLE_X0 )
#define MAINTITLE_H 	13

#define MAINWIN_X0		  MAINTITLE_X0
#define MAINWIN_Y0		( MAINTITLE_Y0 + MAINTITLE_H )

#define MAINWIN_W 		( SCREEN_W - MAINWIN_X0 - MAINWIN_X0 )
#define MAINWIN_H 		( SCREEN_H - MAINWIN_Y0 - MAINWIN_Y0 )

#define MAINWIN_X1		( MAINWIN_X0 + MAINWIN_W )
#define MAINWIN_Y1		( MAINWIN_Y0 )

#define MAINWIN_X2		( MAINWIN_X0 + MAINWIN_W )
#define MAINWIN_Y2		( MAINWIN_Y0 + MAINWIN_H )

#define MAINWIN_X3		( MAINWIN_X0 )
#define MAINWIN_Y3		( MAINWIN_Y0 + MAINWIN_H + 16 )


#define FINFOWIN_X0 	270	//
#define FINFOWIN_Y0		120

#define FINFOWIN_X1   270//
#define FINFOWIN_Y1		142

#define FINFOWIN_W		160
#define FINFOWIN_H		110
//
//#define DOWN_SCREEN		0
//#define UP_SCREEN		1

//enum
//{
//    DOWN_SCREEN = 0,
//    UP_SCREEN = 1
//};


#define FONT12	1

#define ENABLE_BG	1
#define ENABLE_IMAGE 1
//#undef COLOR16BIT
#define COLOR16BIT

#define		INVALID_LEN			0X7FFFFFFF

#undef ENABLE_TTF //ʹttf

#define     CONFIG_ROOTNAME 						"fat:"
#define     CONFIG_ROOTDIR 							"fat:/"
#define     CONFIG_EBOOK_ROOTDIR 					"fat:/iReader/"
#define     CONFIG_DIR_SEPERATOR 					'/'
#define     CONFIG_DIR_SEPERATORS 					"/"
#define     CONFIG_EBOOK_BGPIC 						"bg.bmp"
#define     CONFIG_EBOOK_BGZIPPIC 					"bg.zip"
#define     CONFIG_EBOOK_BM_NAME 					"bookmark.conf"

#define		CONFIG_DIR_IMAGESRC_BUF					"swapfile0.$$$"
#define		CONFIG_DIR_IMAGESCALE_BUF				"swapfile1.$$$"
#define		CONFIG_DIR_IMAGESCALE_R_BUF				"swapfile2.$$$"
#define		IMGDAT_NAME_LEN							32

#define		CONFIG_DIR_JPEGZIP_BUF					"swapfile.jpg"
#define		IMAGEZIP_BUF_MAX_LEN					(  1024 * 1024 )

#define     CONFIG_FONTCONVERT_NAME 				"fat:/iReader/fontconvert"
#define     CONFIG_UNICODE_GB18030_TBL 				"fat:/iReader/fonts/unicode_gb18030_tbl.bin"
#define     CONFIG_GB18030_UNICODE_TBL 				"fat:/iReader/fonts/gb18030_unicode_tbl.bin"

#define     CONFIG_GBKTOUCS_PATH 					"fat:/iReader/fonts/gbk_ucs.tbl"
#define     CONFIG_BIG5TOUCS_PATH 					"fat:/iReader/fonts/big5_ucs.tbl"
#define     CONFIG_SJISTOUCS_PATH 					"fat:/iReader/fonts/sjis_ucs.tbl"

//font
#define     DIRGBK10 "fat:/iReader/fonts/GBK10"
#define     DIRGBK12 "fat:/iReader/fonts/GBK12"
#define     DIRGBK14 "fat:/iReader/fonts/GBK14"
#define     DIRGBK16 "fat:/iReader/fonts/GBK16"
#define     DIRGBK18 "fat:/iReader/fonts/GBK18"
#define     DIRGBK20 "fat:/iReader/fonts/GBK20"
#define     DIRGBK24 "fat:/iReader/fonts/GBK24"
#define     DIRGBK28 "fat:/iReader/fonts/GBK28"
#define     DIRGBK32 "fat:/iReader/fonts/GBK32"

#define     DIRASC10 "fat:/iReader/fonts/ASC10"
#define     DIRASC12 "fat:/iReader/fonts/ASC12"
#define     DIRASC14 "fat:/iReader/fonts/ASC14"
#define     DIRASC16 "fat:/iReader/fonts/ASC16"
#define     DIRASC18 "fat:/iReader/fonts/ASC18"
#define     DIRASC20 "fat:/iReader/fonts/ASC20"
#define     DIRASC24 "fat:/iReader/fonts/ASC24"
#define     DIRASC28 "fat:/iReader/fonts/ASC28"
#define     DIRASC32 "fat:/iReader/fonts/ASC32"


#define     BPP  					16 //ʾλֽڱʾ

#define		USE_BMP_LOGO		1
#define		USE_PNG_LOGO		0
#define		USE_JPG_LOGO		0

//ͼƬ·궨
#if 		USE_BMP_LOGO

#define 	CONFIG_MSGBOX_LOGO					"fat:/iReader/msg.bmp"
#define		CONFIG_TOPBAND_LOGO					"fat:/iReader/TopBand.bmp"
#define		CONFIG_BOTTOMBAND_LOGO				"fat:/iReader/BottomBand.bmp"
#define		CONFIG_RETURNARROW_LOGO				"fat:/iReader/ReturnBtn.bmp"
#define		CONFIG_AKEY_LOGO					"fat:/iReader/AKey.bmp"
#define		CONFIG_BKEY_LOGO					"fat:/iReader/BKey.bmp"
#define		CONFIG_XKEY_LOGO					"fat:/iReader/XKey.bmp"
#define		CONFIG_YKEY_LOGO					"fat:/iReader/YKey.bmp"
#define		CONFIG_CROSSKEY_LOGO				"fat:/iReader/CrossBtn.bmp"
#define		CONFIG_VARROW_LOGO					"fat:/iReader/VArrow.bmp"
#define		CONFIG_MENUBG_LOGO					"fat:/iReader/MenuBg.bmp"
#define		CONFIG_MENUBG_LOGO2					"fat:/iReader/MenuBg2.bmp"
#define		CONFIG_MENU_CLOSEBTN_LOGO			"fat:/iReader/CloseBtn.bmp"
#define		CONFIG_MENU_UNSELECTED_LOGO			"fat:/iReader/UnselectedBtn.bmp"
#define		CONFIG_MENU_SELECTED_LOGO			"fat:/iReader/SelectedBtn.bmp"
#define		CONFIG_SELECTED_LEFT_LOGO 			"fat:/iReader/LeftArrow.bmp"
#define		CONFIG_SELECTED_RIGHT_LOGO 			"fat:/iReader/RightArrow.bmp"
#define		CONFIG_BM_LOGO 						"fat:/iReader/Bookmark.bmp"
#define		CONFIG_MESSAGEBOX_LOGO 				"fat:/iReader/MessageBg.bmp"
#define		CONFIG_MESSAGEBOX_LOGO2 			"fat:/iReader/MessageBg2.bmp"
#define		CONFIG_PROGRESS_FG_LOGO 			"fat:/iReader/ProgressFg.bmp"
#define		CONFIG_PROGRESS_BG_LOGO 			"fat:/iReader/ProgressBg.bmp"
#define		CONFIG_NAVIGATIONBAR_LOGO 			"fat:/iReader/NavigationBar.bmp"
#define		CONFIG_SLIDE_LOGO 					"fat:/iReader/SlideText.bmp"



#elif 		USE_PNG_LOGO

#define 	CONFIG_MSGBOX_LOGO					"fat:/iReader/msg.png"
#define		CONFIG_TOPBAND_LOGO					"fat:/iReader/TopBand.png"
#define		CONFIG_BOTTOMBAND_LOGO				"fat:/iReader/BottomBand.png"
#define		CONFIG_RETURNARROW_LOGO				"fat:/iReader/ReturnBtn.png"
#define		CONFIG_AKEY_LOGO					"fat:/iReader/AKey.png"
#define		CONFIG_BKEY_LOGO					"fat:/iReader/BKey.png"
#define		CONFIG_XKEY_LOGO					"fat:/iReader/XKey.png"
#define		CONFIG_YKEY_LOGO					"fat:/iReader/YKey.png"
#define		CONFIG_VARROW_LOGO					"fat:/iReader/VArrow.png"

#elif 		USE_JPG_LOGO

#define 	CONFIG_MSGBOX_LOGO					"fat:/iReader/msg.jpg"
#define		CONFIG_TOPBAND_LOGO					"fat:/iReader/TopBand.jpg"
#define		CONFIG_BOTTOMBAND_LOGO				"fat:/iReader/BottomBand.jpg"
#define		CONFIG_RETURNARROW_LOGO				"fat:/iReader/ReturnBtn.jpg"
#define		CONFIG_AKEY_LOGO					"fat:/iReader/AKey.jpg"
#define		CONFIG_BKEY_LOGO					"fat:/iReader/BKey.jpg"
#define		CONFIG_XKEY_LOGO					"fat:/iReader/XKey.jpg"
#define		CONFIG_YKEY_LOGO					"fat:/iReader/YKey.jpg"
#define		CONFIG_VARROW_LOGO					"fat:/iReader/VArrow.jpg"

#endif

//궨
#define		TOPBAND_X							0
#define		TOPBAND_Y							0

#define		BOTTOMBAND_X						0
#define		BOTTOMBAND_Y						172

#define		DATATIME_X 							12
#define		DATATIME_Y 							178

#define		FILE_BROWSE_X						11
#define		FILE_BROWSE_Y						6

//#define		FILE_DIR_X							60
//#define		FILE_DIR_Y							6

#define		FL_LINE_RECT_START_X				0
#define		FL_LINE_RECT_START_Y				21

#define		FL_2DOTS_X							12
#define		FL_2DOTS_Y							23

//#define		FL_LINE_FONT_START_X		FL_2DOTS_X
//#define		FL_LINE_FONT_START_Y		(FL_2DOTS_Y) //	FL_LINE_H = 15

#define		RETURN_ARROW_X				27
#define		RETURN_ARROW_Y				23

#define		FL_TIME_X					8
#define		FL_TIME_Y					179

#define		FL_OK_X						106
#define		FL_OK_Y						178

#define		FL_CANCEL_X					155
#define		FL_CANCEL_Y					178

#define		FL_HELP_X					204
#define		FL_HELP_Y					178

#define		FL_AKEY_X					133
#define		FL_AKEY_Y					177

#define		FL_BKEY_X					182
#define		FL_BKEY_Y					177

#define		FL_YKEY_X					231
#define		FL_YKEY_Y					177

//#define		MAINMENU_BG_X				28
//#define		MAINMENU_BG_Y				27

#define		TIME_NUM_DISTANCE			1
#define		TIME_RECT_BG_W				80//ݼָʱ䱳ʱõ
#define		TIME_RECT_BG_H				14

#define		FL_TIME_W					(FL_OK_X - FL_TIME_X)
#define		FL_TIME_H					( SCREEN_H -  FL_TIME_Y )

//
#define		FL_NAVIGATION_BANK			7
#define		TEXT_SLIDE_BANK				8

#define		FL_NAVIGATIONBAR_W			9
#define		FL_NAVIGATIONBAR_H			144

#define		FL_NAVIGATIONBAR_X			( SCREEN_W - FL_NAVIGATION_BANK - FL_NAVIGATIONBAR_W )//240
#define		FL_NAVIGATIONBAR_Y			24

#define		TEXT_SLIDE_W					7
#define		TEXT_SLIDE_H					13

#define		TEXT_SLIDE_X					( SCREEN_W - TEXT_SLIDE_BANK - TEXT_SLIDE_W )//241
#define		TEXT_SLIDE_Y					33
#define		TEXT_SLIDE_MAX_Y				146

#define		FL_NAVIGATIONBAR_TRIANGLE_H		( TEXT_SLIDE_Y - FL_NAVIGATIONBAR_Y )


//#define		MENU_CLOSE_BTN_X			212
//#define		MENU_CLOSE_BTN_Y			32

//ߴ궨
#define		ARROW_W						4
#define		ARROW_H						7

#define		KEY_W						11
#define		KEY_H						11

#define		TOPBAND_W					SCREEN_W
#define		TOPBAND_H					21

#define		BOTTOMBAND_W				SCREEN_W
#define		BOTTOMBAND_H				20

#define		CLOSEBTN_W					10
#define		CLOSEBTN_H					10


//˵ÿغ궨

//ãťͼx50y60    x66y64
//ãťͼx141y60   x156y64
//Ķʽťͼx50y86    x66y90
//  ƣťͼx141y86   x156y90
//    תťͼx50y60    x66y114
//    ǩťͼx50y60    x156y114

//
#define		CLOSE_BTN_X			212
#define		CLOSE_BTN_Y			32

#define		MENU_FONT_SETTINGS_BG_X		50
#define		MENU_FONT_SETTINGS_BG_Y		60

#define		MENU_BG_SETTINGS_BG_X		141
#define		MENU_BG_SETTINGS_BG_Y		60

#define		MENU_READING_MODE_BG_X		50
#define		MENU_READING_MODE_BG_Y		86

#define		MENU_BACKLIGHT_BG_X			141
#define		MENU_BACKLIGHT_BG_Y			86

#define		MENU_JUMPTO_BG_X				50
#define		MENU_JUMPTO_BG_Y				112

#define		MENU_BM_BG_X			141
#define		MENU_BM_BG_Y			112

#define		MENU_SETTINGS_FONT_ADJUST_X (-4)
#define		MENU_SETTINGS_FONT_ADJUST_Y (-1)

#define		MENU_FONT_SETTINGS_FONT_X	66 + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_FONT_SETTINGS_FONT_Y	64 + MENU_SETTINGS_FONT_ADJUST_Y

#define		MENU_BG_SETTINGS_FONT_X		156  + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_BG_SETTINGS_FONT_Y		64   + MENU_SETTINGS_FONT_ADJUST_Y

#define		MENU_READING_MODE_FONT_X	66  + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_READING_MODE_FONT_Y	90  + MENU_SETTINGS_FONT_ADJUST_Y

#define		MENU_BACKLIGHT_FONT_X		159  + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_BACKLIGHT_FONT_Y		90   + MENU_SETTINGS_FONT_ADJUST_Y

#define		MENU_JUMPTO_FONT_X			69  + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_JUMPTO_FONT_Y			115

#define		MENU_BM_FONT_X		159  + MENU_SETTINGS_FONT_ADJUST_X
#define		MENU_BM_FONT_Y		115



//-------------------------------------2010-4-23 11:18:29
//#define     MENU_BAR_LOGO_BASE_X					50 //׼
//#define     MENU_BAR_LOGO_BASE_Y					60 //׼
#define     MENU_BAR_LOGO_BASE_W					91 //׼
#define     MENU_BAR_LOGO_BASE_H					26 //׼
#define		MENU_BAR_FONT_OFFSET1				12//ʼӦıʼľ
#define		MENU_BAR_FONT_OFFSET2				15//ʼӦıʼľ

//λ˳:٢ڢۢܢݢ
//enum{
//	MENU_BAR_LOGO_X_POS1	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 0,
//	MENU_BAR_LOGO_X_POS2	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 1,
//	MENU_BAR_LOGO_X_POS3	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 0,
//	MENU_BAR_LOGO_X_POS4	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 1,
//	MENU_BAR_LOGO_X_POS5	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 0,
//	MENU_BAR_LOGO_X_POS6	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_LOGO_BASE_W * 1
//};
//
//enum{
//	MENU_BAR_LOGO_Y_POS1	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 0,
//	MENU_BAR_LOGO_Y_POS2	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 0,
//	MENU_BAR_LOGO_Y_POS3	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 1,
//	MENU_BAR_LOGO_Y_POS4	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 1,
//	MENU_BAR_LOGO_Y_POS5	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 2,
//	MENU_BAR_LOGO_Y_POS6	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_LOGO_BASE_H * 2
//};

enum{
	MENU_FONT_SETTINGS_FONT_OFFSET_X		=	MENU_BAR_FONT_OFFSET1,
	MENU_BG_SETTINGS_FONT_OFFSET_X			=	MENU_BAR_FONT_OFFSET1,
	MENU_READMODE_SETTINGS_FONT_OFFSET_X	=	MENU_BAR_FONT_OFFSET1,
	MENU_BACKLIGHT_SETTINGS_FONT_OFFSET_X	=	MENU_BAR_FONT_OFFSET2,
	MENU_JUMPTO_SETTINGS_FONT_OFFSET_X		=	MENU_BAR_FONT_OFFSET2,
	MENU_BM_SETTINGS_FONT_OFFSET_X	=	MENU_BAR_FONT_OFFSET2
};


#define		MENU_FONT_OFFSET_Y					3

//ѡ񡱵x59y145 ʮּ.bmpx86y146
//ȷx106y145 A.bmpx134y145
//ȡx161y145 B.bmpx191y145
#define		SETTINGS_CROSS_BTN_X				86
#define		SETTINGS_CROSS_BTN_Y				146

#define		SETTINGS_CONFIRM_BTN_X				134
#define		SETTINGS_CONFIRM_BTN_Y				145

#define		SETTINGS_CLOSE_BTN_X				191
#define		SETTINGS_CLOSE_BTN_Y				145

#define		SETTINGS_CROSS_BTN_FONT_X			59
#define		SETTINGS_CROSS_BTN_FONT_Y			145

#define		SETTINGS_CONFIRM_BTN_FONT_X			106
#define		SETTINGS_CONFIRM_BTN_FONT_Y			145

#define		SETTINGS_CLOSE_BTN_FONT_X			161
#define		SETTINGS_CLOSE_BTN_FONT_Y			145

//ɫ궨
//#define		FL_DIR_FONT_COLOR					RGB( 0X06, 0X65, 0X9D )
#define		FILEBROWSE_FONT_COLOR				RGB( 0X33, 0X33, 0X33 )
#define		FL_2DOTS							RGB( 0X33, 0X33, 0X33 )
#define		FL_FONT_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		FL_SELECTED_BG_COLOR				RGB( 0XE9, 0XCF, 0XA9 )
#define		DATATIME_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		FL_TIME_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		FL_OK_COLOR							RGB( 0X33, 0X33, 0X33 )
#define		FL_CANCEL_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		FL_HELP_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		FL_FIRSTLINE_BG_COLOR				RGB( 0XFA, 0XF4, 0XEB )
#define		FL_SECONDLINE_BG_COLOR				RGB( 0XFF, 0XFF, 0XFF )

#define		MENU_SETTINGS_BAR_FONG_COLOR 		RGB15(0X1F, 0X1F, 0X1F )

#define		DEFAULT_READING_BG_COLOR			RGB( 0XEA, 0XEA, 0XEA )
#define		DEFAULT_READING_BG_COLOR24			RGB24( 0XEA, 0XEA, 0XEA )
#define		DEFAULT_READING_FONT_COLOR			RGB( 0X33, 0X33, 0X33 )
#define		DEFAULT_READING_FONT_COLOR24		RGB24( 0X33, 0X33, 0X33 )
#define		DEFAULT_READING_FONT_COLOR			RGB( 0X33, 0X33, 0X33 )

#define		BG_SETTINGS_STATICTEXTFONT_COLOR	RGB( 0X06, 0X65, 0X9D )
#define		BG_SETTINGS_SELECTED_BG_COLOR		RGB( 0X20, 0XA3, 0XEE )
#define		BG_SETTINGS_UNSELECTED_BG_COLOR		RGB( 0XD0, 0XE7, 0XF7 )
#define		BG_SETTINGS_SELECTEDTEXT_COLOR		RGB( 0XFF, 0XFF, 0XFF )
#define		BG_SETTINGS_UNSELECTEDTEXT_COLOR	RGB( 0X06, 0X65, 0X9D )



//ߴ궨
//#define		FL_LINE_W							( SCREEN_W - 0 )		//ļбÿһеĸ߶
//#define		FL_LINE_H							15		//ļбÿһеĸ߶
////#define		MAX_ITEM_LINE						10

#define		MAINMENU_BG_RECT_W					200
#define		MAINMENU_BG_RECT_H					135

#define		HINT2_BG_RECT_W						160
#define		HINT2_BG_RECT_H						108


#define		COLOR_BROWSE_RECT_W					30
#define		COLOR_BROWSE_RECT_H					30


//Ķ˵غ궨

//ĽڱʾĵĶĽȡ Ķ.bmp Ķ2.bmp  궼x53y148  Ķ2.bmpٷֱʾ
//81.4%x122y145ɫ#333333
//14:33x169y145ɫ#333333
//
#define     MENU_SETTINGS_TITLE_FILENAME_X		58
#define     MENU_SETTINGS_TITLE_FILENAME_Y		32

#define		MENU_SETTINGS_PROGRESS_LOGO_X		53
#define		MENU_SETTINGS_PROGRESS_LOGO_Y		148

#define		MENU_SETTINGS_PERCENTAGE_X			122
#define		MENU_SETTINGS_PERCENTAGE_Y			145

#define		MENU_SETTINGS_TIME_X				( 169 - 5 )
#define		MENU_SETTINGS_TIME_Y				145


//ɫ
#define		MENU_SETTINGS_TITLE_FILENAME_COLOR	RGB( 0X28, 0X78, 0XBB )
#define		MENU_SETTINGS_STATICTEXT_COLOR		RGB( 0X33, 0X33, 0X33 )

//ߴ
#define		MENU_SETTINGS_TITLE_FILENAME_DIS_W  ( SETTINGS_CLOSE_BTN_X - MENU_SETTINGS_TITLE_FILENAME_X - 2 )

#define		MENU_SETTINGS_BAR_W					70
#define		MENU_SETTINGS_BAR_H					18

#define     MENU_SETTINGS_PROGRESS_W			55
#define     MENU_SETTINGS_PROGRESS_H			5


//-------------------------------------------------------------------
//غ궨

//ִСx52y55 ɫ#06659D ͷ.bmpx115y57 ѡǿ5411ɫ飬ɫɫ #D0E7F7  x122y55   ѡɫ#06659D  ͷ.bmpx115y57
//ѡ꣺x144y56
//
//мݡx52y71 ɫ#06659D ѡǿ5411ɫ飬ɫɫ #D0E7F7  x122y71   ѡɫ#06659D  
//ѡ꣺x144y72
//
//ɫx52y87 ɫ#06659D
//
// "R"x106y87   ѡǿ5411ɫ飬ɫɫ #D0E7F7  x122y87   ѡɫ#06659D  
//ѡ꣺x144y88
//
// "G"x106y103   ѡǿ5411ɫ飬ɫɫ #D0E7F7  x122y103   ѡɫ#06659D  
//ѡ꣺x144y104
//
// "B"x106y119   ѡǿ5411ɫ飬ɫɫ #D0E7F7  x122y119   ѡɫ#06659D  
//ѡ꣺x144y120

//
#define		FONT_SETTINGS_FONTSIZE_X			42
#define		FONT_SETTINGS_FONTSIZE_Y			55

#define		FONT_SETTINGS_LINESPACE_X			42
#define		FONT_SETTINGS_LINESPACE_Y			71

#define		FONT_SETTINGS_FONTCOLOR_X			42
#define		FONT_SETTINGS_FONTCOLOR_Y			87

#define		FONT_SETTINGS_RFONT_X				106
#define		FONT_SETTINGS_RFONT_Y				90

#define		FONT_SETTINGS_GFONT_X				106
#define		FONT_SETTINGS_GFONT_Y				106

#define		FONT_SETTINGS_BFONT_X				106
#define		FONT_SETTINGS_BFONT_Y				122

#define		FONT_SETTINGS_FONTSIZE_RECT_X		122
#define		FONT_SETTINGS_FONTSIZE_RECT_Y		55

#define		FONT_SETTINGS_LINESPACE_RECT_X		122
#define		FONT_SETTINGS_LINESPACE_RECT_Y		71

#define		FONT_SETTINGS_R_RECT_X				122
#define		FONT_SETTINGS_R_RECT_Y				87

#define		FONT_SETTINGS_G_RECT_X				122
#define		FONT_SETTINGS_G_RECT_Y				103

#define		FONT_SETTINGS_B_RECT_X				122
#define		FONT_SETTINGS_B_RECT_Y				119


//ͷ.bmpǣx115y57x115y57x115y73x115y89x115y105x115y121
//Ҽͷ.bmpǣx179y57x179y57x179y73x179y89x179y105x179y121

#define		FONT_SETTINGS_FONTSIZE_LARROW_X		115
#define		FONT_SETTINGS_FONTSIZE_LARROW_Y		57

#define		FONT_SETTINGS_FONTSIZE_RARROW_X		179
#define		FONT_SETTINGS_FONTSIZE_RARROW_Y		57

#define		FONT_SETTINGS_LINESPACE_LARROW_X	115
#define		FONT_SETTINGS_LINESPACE_LARROW_Y	73

#define		FONT_SETTINGS_LINESPACE_RARROW_X	179
#define		FONT_SETTINGS_LINESPACE_RARROW_Y	73

#define		FONT_SETTINGS_R_LARROW_X			115
#define		FONT_SETTINGS_R_LARROW_Y			89

#define		FONT_SETTINGS_R_RARROW_X			179
#define		FONT_SETTINGS_R_RARROW_Y			89

#define		FONT_SETTINGS_G_LARROW_X			115
#define		FONT_SETTINGS_G_LARROW_Y			105

#define		FONT_SETTINGS_G_RARROW_X			179
#define		FONT_SETTINGS_G_RARROW_Y			105

#define		FONT_SETTINGS_B_LARROW_X			115
#define		FONT_SETTINGS_B_LARROW_Y			121

#define		FONT_SETTINGS_B_RARROW_X			179
#define		FONT_SETTINGS_B_RARROW_Y			121


#define		FONT_SETTINGS_FONTSIZE_RECT_AND_ARROW_X		FONT_SETTINGS_FONTSIZE_LARROW_X
#define		FONT_SETTINGS_FONTSIZE_RECT_AND_ARROW_Y		FONT_SETTINGS_FONTSIZE_RECT_Y

#define		FONT_SETTINGS_LINESPACE_RECT_AND_ARROW_X	FONT_SETTINGS_LINESPACE_LARROW_X
#define		FONT_SETTINGS_LINESPACE_RECT_AND_ARROW_Y	FONT_SETTINGS_LINESPACE_RECT_Y

#define	 	FONT_SETTINGS_R_RECT_AND_ARROW_X			FONT_SETTINGS_R_LARROW_X
#define	 	FONT_SETTINGS_R_RECT_AND_ARROW_Y			FONT_SETTINGS_R_RECT_Y

#define		FONT_SETTINGS_G_RECT_AND_ARROW_X			FONT_SETTINGS_G_LARROW_X
#define		FONT_SETTINGS_G_RECT_AND_ARROW_Y			FONT_SETTINGS_G_RECT_Y

#define		FONT_SETTINGS_B_RECT_AND_ARROW_X			FONT_SETTINGS_B_LARROW_X
#define		FONT_SETTINGS_B_RECT_AND_ARROW_Y			FONT_SETTINGS_B_RECT_Y

#define		FONT_SETTINGS_FONTSIZE_VALUE_X				144
#define		FONT_SETTINGS_FONTSIZE_VALUE_Y				55

#define		FONT_SETTINGS_LINESPACE_VALUE_X				144
#define		FONT_SETTINGS_LINESPACE_VALUE_Y				71

#define		FONT_SETTINGS_R_VALUE_X						144
#define		FONT_SETTINGS_R_VALUE_Y						87

#define		FONT_SETTINGS_G_VALUE_X						144
#define		FONT_SETTINGS_G_VALUE_Y						103

#define		FONT_SETTINGS_B_VALUE_X						144
#define		FONT_SETTINGS_B_VALUE_Y						119

//Ա߻и3030Ԥɫ顣ԤɫɫͨRGBֵʱɫx185y92
#define		FONT_SETTINGS_COLOR_BROWSE_RECT_X			185
#define		FONT_SETTINGS_COLOR_BROWSE_RECT_Y			92

//δѡʱѡɫ#D0E7F7ɫ#06659D
//ѡкʱѡɫ#20A3EEɫ#FFFFFF
//ɫ
#define		FONT_SETTINGS_STATICTEXT_COLOR		RGB( 0X06, 0X65, 0X9D )
#define		FONT_SETTINGS_UNSELECTEDTEXT_COLOR	RGB( 0X06, 0X65, 0X9D )
#define		FONT_SETTINGS_SELECTEDTEXT_COLOR	RGB( 0XFF, 0XFF, 0XFF )
#define		FONT_SETTINGS_UNSELECTED_BG_COLOR	RGB( 0XD0, 0XE7, 0XF7 )
#define		FONT_SETTINGS_SELECTED_BG_COLOR		RGB( 0X20, 0XA3, 0XEE )

//ߴ
#define		FONT_SETTINGS_ARROW_W				8  //8x10
#define		FONT_SETTINGS_ARROW_H				10

#define		COLOR_RECT_W						54
#define		COLOR_RECT_H						12

#define		FONT_SETTINGS_COLOR_RECT_AND_ARROW_W	( FONT_SETTINGS_R_RARROW_X - FONT_SETTINGS_R_LARROW_X + FONT_SETTINGS_ARROW_W )
#define		FONT_SETTINGS_COLOR_RECT_AND_ARROW_H	( COLOR_RECT_H )



//ɫغ궨
#define		BG_SETTINGS_TITLEFONT_X				40
#define		BG_SETTINGS_TITLEFONT_Y				65

#define		BG_SETTINGS_RFONT_X					106
#define		BG_SETTINGS_RFONT_Y					65
#define		BG_SETTINGS_R_RECT_X				122
#define		BG_SETTINGS_R_RECT_Y				65
#define		BG_SETTINGS_R_VALUE_X				144
#define		BG_SETTINGS_R_VALUE_Y				65

#define		BG_SETTINGS_GFONT_X					106
#define		BG_SETTINGS_GFONT_Y					80
#define		BG_SETTINGS_G_RECT_X				122
#define		BG_SETTINGS_G_RECT_Y				81
#define		BG_SETTINGS_G_VALUE_X				144
#define		BG_SETTINGS_G_VALUE_Y				81

#define		BG_SETTINGS_BFONT_X					106
#define		BG_SETTINGS_BFONT_Y					96
#define		BG_SETTINGS_B_RECT_X				122
#define		BG_SETTINGS_B_RECT_Y				97
#define		BG_SETTINGS_B_VALUE_X				144
#define		BG_SETTINGS_B_VALUE_Y				97

#define		BG_SETTINGS_COLOR_BROWSE_RECT_X		185
#define		BG_SETTINGS_COLOR_BROWSE_RECT_Y		72


//Ҽͷغ궨
//ͷ.bmpǣx115y66x115y81x115y97
//Ҽͷ.bmpǣx179y66x179y81x179y97
//
#define		BG_SETTINGS_RCOLOR_LEFTARROW_X		115
#define		BG_SETTINGS_RCOLOR_LEFTARROW_Y		66

#define		BG_SETTINGS_GCOLOR_LEFTARROW_X		115
#define		BG_SETTINGS_GCOLOR_LEFTARROW_Y		81

#define		BG_SETTINGS_BCOLOR_LEFTARROW_X		115
#define		BG_SETTINGS_BCOLOR_LEFTARROW_Y		97

#define		BG_SETTINGS_RCOLOR_RIGHTARROW_X		179
#define		BG_SETTINGS_RCOLOR_RIGHTARROW_Y		66

#define		BG_SETTINGS_GCOLOR_RIGHTARROW_X		179
#define		BG_SETTINGS_GCOLOR_RIGHTARROW_Y		81

#define		BG_SETTINGS_BCOLOR_RIGHTARROW_X		179
#define		BG_SETTINGS_BCOLOR_RIGHTARROW_Y		97

#define		BG_SETTINGS_RCOLOR_RECT_AND_ARROW_X	BG_SETTINGS_RCOLOR_LEFTARROW_X
#define		BG_SETTINGS_RCOLOR_RECT_AND_ARROW_Y	BG_SETTINGS_R_RECT_Y

#define		BG_SETTINGS_GCOLOR_RECT_AND_ARROW_X	BG_SETTINGS_GCOLOR_LEFTARROW_X
#define		BG_SETTINGS_GCOLOR_RECT_AND_ARROW_Y	BG_SETTINGS_G_RECT_Y

#define		BG_SETTINGS_BCOLOR_RECT_AND_ARROW_X	BG_SETTINGS_BCOLOR_LEFTARROW_X
#define		BG_SETTINGS_BCOLOR_RECT_AND_ARROW_Y	BG_SETTINGS_B_RECT_Y

//ߴ
#define		BG_SETTINGS_ARROW_W					8  //8x10
#define		BG_SETTINGS_ARROW_H					10

#define		BG_SETTINGS_COLOR_RECT_AND_ARROW_W	( BG_SETTINGS_BCOLOR_RIGHTARROW_X - BG_SETTINGS_RCOLOR_LEFTARROW_X + BG_SETTINGS_ARROW_W )
#define		BG_SETTINGS_COLOR_RECT_AND_ARROW_H	COLOR_RECT_H


//Ķʽغ궨
//Чͼ .png
//򣬱⣬رհťԼİʾ䡣
//
//ơx52y66 ɫ#06659D
//ͷ.bmpx115y67 
//ѡǿ5411ɫ飬ɫ#20A3EEx122y65   ɫ#FFFFFF  x147y66  Ҽͷ.bmpx179y67

//
#define		READINGMODE_SETTINGS_STATICTEXT_X		52
#define		READINGMODE_SETTINGS_STATICTEXT_Y		66

#define		READINGMODE_SETTINGS_LARROW_X			( 115 )
#define		READINGMODE_SETTINGS_LARROW_Y			67

#define		READINGMODE_SETTINGS_RARROW_X			( READINGMODE_SETTINGS_LARROW_X + COLOR_RECT_W + 10 )//179
#define		READINGMODE_SETTINGS_RARROW_Y			67

#define		READINGMODE_SETTINGS_COLOR_RECT_X		( READINGMODE_SETTINGS_LARROW_X + 7 )//122
#define		READINGMODE_SETTINGS_COLOR_RECT_Y		65

#define		READINGMODE_SETTINGS_TEXT_X				( READINGMODE_SETTINGS_COLOR_RECT_X + 16 )//138
#define		READINGMODE_SETTINGS_TEXT_Y				65

//ɫ
#define		READINGMODE_SETTINGS_STATICTEXT_COLOR		RGB( 0X06, 0X65, 0X9D )
#define		READINGMODE_SETTINGS_UNSELECTEDTEXT_COLOR	RGB( 0X06, 0X65, 0X9D )
#define		READINGMODE_SETTINGS_TEXT_COLOR				RGB( 0XFF, 0XFF, 0XFF )
#define		READINGMODE_SETTINGS_SELECTED_BG_COLOR  	RGB( 0X20, 0XA3, 0XEE )
#define		READINGMODE_SETTINGS_UNSELECTED_BG_COLOR  	RGB( 0XD0, 0XE7, 0XF7 )

//غ궨
#define		BACKLIGHT_SETTINGS_STATICTEXT_X			52
#define		BACKLIGHT_SETTINGS_STATICTEXT_Y			66

#define		BACKLIGHT_SETTINGS_LARROW_X				( 115 + 10 )
#define		BACKLIGHT_SETTINGS_LARROW_Y				( BACKLIGHT_SETTINGS_STATICTEXT_Y + 1 )//67

#define		BACKLIGHT_SETTINGS_RARROW_X				( BACKLIGHT_SETTINGS_LARROW_X + COLOR_RECT_W + 10 )//179
#define		BACKLIGHT_SETTINGS_RARROW_Y				BACKLIGHT_SETTINGS_LARROW_Y

#define		BACKLIGHT_SETTINGS_COLOR_RECT_X			( BACKLIGHT_SETTINGS_LARROW_X + 7 )//122
#define		BACKLIGHT_SETTINGS_COLOR_RECT_Y			( BACKLIGHT_SETTINGS_LARROW_Y - 2 )//66

#define		BACKLIGHT_SETTINGS_TEXT_X				( BACKLIGHT_SETTINGS_COLOR_RECT_X + 16 + 20 )//138
#define		BACKLIGHT_SETTINGS_TEXT_Y				BACKLIGHT_SETTINGS_COLOR_RECT_Y

//#define		BACKLIGHT_SETTINGS_TEXT_X				146
//#define		BACKLIGHT_SETTINGS_TEXT_Y				BACKLIGHT_SETTINGS_TEXT_Y

//ɫ
#define		BACKLIGHT_SETTINGS_SELECTEDTEXT_COLOR		RGB( 0XFF, 0XFF, 0XFF )
#define		BACKLIGHT_SETTINGS_UNSELECTEDTEXT_COLOR		RGB( 0X06, 0X65, 0X9D )
#define		BACKLIGHT_SETTINGS_SELECTED_BG_COLOR  		RGB( 0X20, 0XA3, 0XEE )
#define		BACKLIGHT_SETTINGS_UNSELECTED_BG_COLOR  	RGB( 0XD0, 0XE7, 0XF7 )


//תٷֱغ궨
//תx76y88 ɫ#06659D
//
//ٷʼ:x118y88 ɫ#333333
//ֱѡеĻɫΪ#20A3EEҳ ¼ͷ.bmp ¼ͷ.bmpǣy83x뵱ǰѡеͬ
//
#define		JUMPTO_SETTINGS_STATIC_TEXT_X			76
#define		JUMPTO_SETTINGS_STATIC_TEXT_Y			88

#define		JUMPTO_SETTINGS_VARROW_X				126
#define		JUMPTO_SETTINGS_VARROW_Y				83

#define		JUMPTO_SETTINGS_TEXT_X					( JUMPTO_SETTINGS_VARROW_X + 1 )
#define		JUMPTO_SETTINGS_TEXT_Y					88


#define		JUMPTO_SETTINGS_RECT_X					( JUMPTO_SETTINGS_TEXT_X > JUMPTO_SETTINGS_VARROW_X ? JUMPTO_SETTINGS_VARROW_X : JUMPTO_SETTINGS_TEXT_X )
#define		JUMPTO_SETTINGS_RECT_Y					JUMPTO_SETTINGS_VARROW_Y

//ɫ
#define		JUMPTO_SETTINGS_STATIC_TEXT_COLOR		RGB( 0X06, 0X65, 0X9D )
#define		JUMPTO_SETTINGS__TEXT_UNSELECTED_COLOR	RGB( 0X33, 0X33, 0X33 )
#define		JUMPTO_SETTINGS__TEXT_SELECTED_COLOR	RGB( 0X20, 0XA3, 0XEE )

//ߴ
#define		JUMPTO_SETTINGS_VAAROW_W				7
#define		JUMPTO_SETTINGS_VAAROW_H				23

#define		JUMPTO_SETTINGS_RECT_W					100
#define		JUMPTO_SETTINGS_RECT_H					JUMPTO_SETTINGS_VAAROW_H

//ǩغ궨

//˳Ϣʾغ궨
//Ϣ򱳾ǣϢ򱳾.bmpΪx33y38
//"ʾ"x46y42 ɫ#06659D
//"Ƿ˳iReader"x46y71 ɫ#333333
//ȷx91y131 ɫ#333333 A.bmpx118y130
//˳x140y131 ɫ#333333 B.bmpx167y130
//
#define		MESSAGE_X									MAINMENU_BG_X//31
#define		MESSAGE_Y									38

#define		MESSAGE_X0									0
#define		MESSAGE_Y0									0

#define		MESSAGE_HINT_FONT_X							(46 - 2 )
#define		MESSAGE_HINT_FONT_Y							( 41 + 0 )

//#define		MESSAGE_EXIT_IREADER_FONT_X				46
//#define		MESSAGE_EXIT_IREADER_FONT_Y				71

#define		MESSAGE_EXIT_IREADER_FONT_X					83 //
#define		MESSAGE_EXIT_IREADER_FONT_Y					84

#define		MESSAGE_CONFIRM_KEY_LOGO_X					118
#define		MESSAGE_CONFIRM_KEY_LOGO_Y					130

#define		MESSAGE_EXIT_KEY_LOGO_X						167
#define		MESSAGE_EXIT_KEY_LOGO_Y						130

#define		MESSAGE_CONFIRM_KEY_FONT_X					91
#define		MESSAGE_CONFIRM_KEY_FONT_Y					131

#define		MESSAGE_EXIT_KEY_FONT_X						140
#define		MESSAGE_EXIT_KEY_FONT_Y						131

//ɫ
#define		MESSAGE_HINT_MENU_FCOLOR					RGB( 0XFF, 0XFF, 0XFF )//RGB( 0XA7, 0XB2, 0XB4 )
//#define		MESSAGE_HINT_TEXT_COLOR					    RGB( 0X06, 0X65, 0X9D )
#define		MESSAGE_STATICTEXT_COLOR					RGB( 0X33, 0X33, 0X33 )


//˵غ궨
//
#define		HELP_MENU_X									6
//#define		HELP_MENU_Y									6

#define		HELP_MESSAGE_X0								TOPBAND_X
#define		HELP_MESSAGE_Y0								TOPBAND_Y

#define		HELP_MESSAGE_X1								BOTTOMBAND_X
#define		HELP_MESSAGE_Y1								BOTTOMBAND_Y

//ɫ

//ߴ



//====================================================================================================================================
//UI2ض
//====================================================================================================================================
//LOGO·궨
//-------------------------------------------------------------------------------------
#define		CONFIG_LOGO_ARCHNAME						"fat:/iReader/UI.zip"

//-------------------------------------------------------------------------------------
#define		CONFIG_BTNBG								"ButtonBg.bmp"
#define		CONFIG_FILEOPBG								"FileOpBg.bmp"
#define		CONFIG_FILEOPSELECTEDMENU					"FileOpSelectedMenu.bmp"
#define		CONFIG_FOLDERLOGO							"FolderLogo.bmp"
#define		CONFIG_LLOGO								"L.bmp"
#define		CONFIG_RLOGO								"R.bmp"
#define		CONFIG_MAINBG								"MainBg.bmp"
#define		CONFIG_SUBBG								"SubBg.bmp"
#define		CONFIG_PDFLOGO								"PDFLogo.bmp"
#define		CONFIG_TXTLOGO								"TxtLogo.bmp"
#define		CONFIG_PICLOGO								"PicLogo.bmp"
#define		CONFIG_ZIPLOGO								"zip.bmp"
#define		CONFIG_UNKNOWFILE							"UnknowFile.bmp"
#define		CONFIG_RETURNBG								"ReturnBg.bmp"
#define		CONFIG_CATEGORYFOCUS						"SelectedMenu.bmp"
#define		CONFIG_CATEGORY								"UnselectedMenu.bmp"
#define		CONFIG_SLIDE								"Slide.bmp"
#define		CONFIG_NAVIGATION							"Navigation.bmp"

#define		CONFIG_MAINMENUBG							"MainMenuBg.bmp"
#define		CONFIG_BACKLIGHT							"Backlight.bmp"
#define		CONFIG_BACKLIGHTFOCUS						"BacklightFocus.bmp"
#define		CONFIG_BOOKMARK								"Bookmark.bmp"
#define		CONFIG_BOOKMARKFOCUS						"BookmarkFocus.bmp"
#define		CONFIG_FONT									"Font.bmp"
#define		CONFIG_FONTFOCUS							"FontFocus.bmp"
#define		CONFIG_HELP									"Help.bmp"
#define		CONFIG_HELPFOCUS							"HelpFocus.bmp"
#define		CONFIG_JUMPTO								"JumpTo.bmp"
#define		CONFIG_JUMPTOFOCUS							"JumpToFocus.bmp"
#define		CONFIG_READINGMODE							"ReadingMode.bmp"
#define		CONFIG_READINGMODEFOCUS						"ReadingModeFocus.bmp"
#define		CONFIG_STYLE								"Style.bmp"
#define		CONFIG_STYLEFOCUS							"StyleFocus.bmp"

#define		CONFIG_UARROW								"UpArrow.bmp"
#define		CONFIG_DARROW								"DownArrow.bmp"
#define		CONFIG_LARROW								"LArrow.bmp"
#define		CONFIG_RARROW								"RArrow.bmp"
#define		CONFIG_MENUBAR								"MenuBar.bmp"
#define		CONFIG_MENUBG								"MenuBg.bmp"
#define		CONFIG_MENUL								"MenuL.bmp"
#define		CONFIG_MENUR								"MenuR.bmp"

#define		CONFIG_STYLE1								"Style1.bmp"
#define		CONFIG_STYLE2								"Style2.bmp"
#define		CONFIG_STYLE3								"Style3.bmp"
#define		CONFIG_STYLE4								"Style4.bmp"
#define		CONFIG_STYLE5								"Style5.bmp"
#define		CONFIG_STYLE6								"Style6.bmp"
#define		CONFIG_STYLE7								"Style7.bmp"
#define		CONFIG_STYLE8								"Style8.bmp"
#define		CONFIG_STYLE9								"Style9.bmp"
#define		CONFIG_STYLE10								"Style10.bmp"

#define		CONFIG_MSGBOX								"MessageBox.bmp"
#define		CONFIG_MSGBOX2								"MessageBox2.bmp"

#define		CONFIG_AKEY									"AKey.bmp"
#define		CONFIG_BKEY									"BKey.bmp"
#define		CONFIG_XKEY									"XKey.bmp"
#define		CONFIG_YKEY									"YKey.bmp"
#define		CONFIG_STARTKEY								"StartKey.bmp"
#define		CONFIG_SELECTKEY							"SelectKey.bmp"

#define		CONFIG_IREADERLOADING						"IreaderLoading.bmp"

#if 0
#define		CONFIG_ZOOMIN								"ZoomIn.bmp"
#define		CONFIG_ZOOMINPRESS							"ZoomInPress.bmp"
#define		CONFIG_ZOOMOUT								"ZoomOut.bmp"
#define		CONFIG_ZOOMOUTPRESS							"ZoomOutPress.bmp"
#define		CONFIG_ROTATIONL							"RotationL.bmp"
#define		CONFIG_ROTATIONLPRESS						"RotationLPress.bmp"
#define		CONFIG_ROTATIONR							"RotationR.bmp"
#define		CONFIG_ROTATIONRPRESS						"RotationRPress.bmp"
#define		CONFIG_PREVIMAGEPRESS						"PrevImagePress.bmp"
#define		CONFIG_PREVIMAGE							"PrevImage.bmp"
#define		CONFIG_NEXTIMAGEPRESS						"NextImagePress.bmp"
#define		CONFIG_NEXTIMAGE							"NextImage.bmp"
#else
#define		CONFIG_ZOOMIN								"ZoomIn"
#define		CONFIG_ZOOMOUT								"ZoomOut"
#define		CONFIG_ROTATIONL							"RotationL"
#define		CONFIG_ROTATIONR							"RotationR"
#define		CONFIG_PREVIMAGE							"PrevImage"
#define		CONFIG_NEXTIMAGE							"NextImage"
#define		CONFIG_IMAGETITLEBAR						"ImageTitleBar.bmp"
#endif

#define		CONFIG_BMSLIDEBAR							"BmSlideBar.bmp"
#define		CONFIG_BMSLIDE								"BmSlide.bmp"

#define		CONFIG_PDFLOADING							"PdfLoading.bmp"

#define		CONFIG_SELECTED								"Select.bmp"


//-------------------------------------------------------------------------------------
#define		CONFIG_BTNBG_DIR							"fat:/iReader/ButtonBg.bmp"
#define		CONFIG_FILEOPBG_DIR							"fat:/iReader/FileOpBg.bmp"
#define		CONFIG_FILEOPSELECTEDMENU_DIR				"fat:/iReader/FileOpSelectedMenu.bmp"
#define		CONFIG_LLOGO_DIR							"fat:/iReader/L.bmp"
#define		CONFIG_RLOGO_DIR							"fat:/iReader/R.bmp"
#define		CONFIG_MAINBG_DIR							"fat:/iReader/MainBg.bmp"
#define		CONFIG_SUBBG_DIR							"fat:/iReader/SubBg.bmp"
#define		CONFIG_RETURNBG_DIR							"fat:/iReader/ReturnBg.bmp"
#define		CONFIG_FOLDERLOGO_DIR						"fat:/iReader/FolderLogo.bmp"
#define		CONFIG_TXTLOGO_DIR							"fat:/iReader/TxtLogo.bmp"
#define		CONFIG_PDFLOGO_DIR							"fat:/iReader/PDFLogo.bmp"
#define		CONFIG_PICLOGO_DIR							"fat:/iReader/PicLogo.bmp"
#define		CONFIG_ZIPLOGO_DIR							"fat:/iReader/zip.bmp"
#define		CONFIG_UNKNOWFILE_DIR						"fat:/iReader/UnknowFile.bmp"
#define		CONFIG_SLIDE_DIR							"fat:/iReader/Slide.bmp"
#define		CONFIG_NAVIGATION_DIR						"fat:/iReader/Navigation.bmp"
#define		CONFIG_CATEGORYFOCUS_DIR					"fat:/iReader/SelectedMenu.bmp"
#define		CONFIG_CATEGORY_DIR							"fat:/iReader/UnselectedMenu.bmp"


#define		CONFIG_MAINMENUBG_DIR						"fat:/iReader/MainMenuBg.bmp"
#define		CONFIG_BACKLIGHT_DIR						"fat:/iReader/Backlight.bmp"
#define		CONFIG_BACKLIGHTFOCUS_DIR					"fat:/iReader/BacklightFocus.bmp"
#define		CONFIG_BOOKMARK_DIR							"fat:/iReader/Bookmark.bmp"
#define		CONFIG_BOOKMARKFOCUS_DIR					"fat:/iReader/BookmarkFocus.bmp"
#define		CONFIG_FONT_DIR								"fat:/iReader/Font.bmp"
#define		CONFIG_FONTFOCUS_DIR						"fat:/iReader/FontFocus.bmp"
#define		CONFIG_HELP_DIR								"fat:/iReader/Help.bmp"
#define		CONFIG_HELPFOCUS_DIR						"fat:/iReader/HelpFocus.bmp"
#define		CONFIG_JUMPTO_DIR							"fat:/iReader/JumpTo.bmp"
#define		CONFIG_JUMPTOFOCUS_DIR						"fat:/iReader/JumpToFocus.bmp"
#define		CONFIG_READINGMODE_DIR						"fat:/iReader/ReadingMode.bmp"
#define		CONFIG_READINGMODEFOCUS_DIR					"fat:/iReader/ReadingModeFocus.bmp"
#define		CONFIG_STYLE_DIR							"fat:/iReader/Style.bmp"
#define		CONFIG_STYLEFOCUS_DIR						"fat:/iReader/StyleFocus.bmp"

#define		CONFIG_UARROW_DIR							"fat:/iReader/UpArrow.bmp"
#define		CONFIG_DARROW_DIR							"fat:/iReader/DownArrow.bmp"
#define		CONFIG_LARROW_DIR							"fat:/iReader/LArrow.bmp"
#define		CONFIG_RARROW_DIR							"fat:/iReader/RArrow.bmp"
#define		CONFIG_MENUBAR_DIR							"fat:/iReader/MenuBar.bmp"
#define		CONFIG_MENUBG_DIR							"fat:/iReader/MenuBg.bmp"
#define		CONFIG_MENUL_DIR							"fat:/iReader/MenuL.bmp"
#define		CONFIG_MENUR_DIR							"fat:/iReader/MenuR.bmp"

#define		CONFIG_STYLE1_DIR							"fat:/iReader/Style1.bmp"
#define		CONFIG_STYLE2_DIR							"fat:/iReader/Style2.bmp"
#define		CONFIG_STYLE3_DIR							"fat:/iReader/Style3.bmp"
#define		CONFIG_STYLE4_DIR							"fat:/iReader/Style4.bmp"
#define		CONFIG_STYLE5_DIR							"fat:/iReader/Style5.bmp"
#define		CONFIG_STYLE6_DIR							"fat:/iReader/Style6.bmp"
#define		CONFIG_STYLE7_DIR							"fat:/iReader/Style7.bmp"
#define		CONFIG_STYLE8_DIR							"fat:/iReader/Style8.bmp"
#define		CONFIG_STYLE9_DIR							"fat:/iReader/Style9.bmp"
#define		CONFIG_STYLE10_DIR							"fat:/iReader/Style10.bmp"

#define		CONFIG_MSGBOX_DIR							"fat:/iReader/MessageBox.bmp"
#define		CONFIG_MSGBOX2_DIR							"fat:/iReader/MessageBox2.bmp"


//һԺ궨
//ߴ
#define		BTN_W										57
#define		BTN_H										16

//

//ɫ

//---------------------------------------------------------------------------------------------------
//ļбغ궨
//---------------------------------------------------------------------------------------------------
//ߴ
#define		FL_MINILOGO_W								17
#define		FL_MINILOGO_H								15

#define		FL_LINE_W									( SCREEN_W - 0 )		//ļбÿһеĸ߶
#define		FL_LINE_H									20		//ļбÿһеĸ߶
#define		MAX_ITEM_LINE								7

#define		FL_LINE_SEPERATOR_W							235
#define		FL_LINE_SEPERATOR_H							1

#define		FL_LINE_COLORRECT_W							250
#define		FL_LINE_COLORRECT_H							17

#define		FL_SLIDE_BANK								5
#define		FL_SLIDE_W									3
#define		FL_SLIDE_H									10

#define		FL_LR_W										14
#define		FL_LR_H										14

#define 	FL_CATEGORY_BANK							4
#define 	FL_CATEGORY_W								54
#define 	FL_CATEGORY_H								18

#define		FL_LOGO_FONT_OFFSET_X						29
#define		FL_LOGO_FONT_OFFSET_Y						3

#define		FL_LOGO_SEPERATOR_OFFSET_Y					18

#define		FL_VRAM_W									251
#define		FL_VRAM_H									FL_LINE_H
#define		FL_VRAM_LINE								( MAX_ITEM_LINE + 1 )

#define		FL_TOP_H									27
#define		FL_BOT_H									25


//
#define		FL_CATALOG_FONT_X							19
#define		FL_CATALOG_FONT_Y							6


#define		FL_LINE_START_Y								25
#define		FL_LINE_END_Y								( FL_LINE_START_Y + MAX_ITEM_LINE * FL_LINE_H )

#define		FL_MINILOGO_START_X							19
#define		FL_MINILOGO_START_Y							27

#define		FL_LINE_FONT_START_X						( FL_MINILOGO_START_X + FL_LOGO_FONT_OFFSET_X )//48
#define		FL_LINE_FONT_START_Y						( FL_MINILOGO_START_Y + FL_LOGO_FONT_OFFSET_Y )//30

#define		FILE_DIR_X									FL_LINE_FONT_START_X//( 47 + 10 )
#define		FILE_DIR_Y									6

#define		FL_LINE_SEPERATOR_X							11
#define		FL_LINE_SEPERATOR_Y							45

#define		FL_LINE_COLORRECT_X							1
#define		FL_LINE_COLORRECT_Y							27

#define 	FL_CATEGORY_X0 								47//44
#define 	FL_CATEGORY_X1 								( FL_CATEGORY_X0 +  FL_CATEGORY_W + FL_CATEGORY_BANK )
#define 	FL_CATEGORY_X2 								( FL_CATEGORY_X0 +  FL_CATEGORY_W * 2 + FL_CATEGORY_BANK * 2 )
#define 	FL_CATEGORY_Y 								( 172 )

#define		FL_L_X										( FL_CATEGORY_X0 - FL_LR_W - 27 )//6
#define		FL_L_Y										176

#define		FL_R_X										( SCREEN_W - FL_L_X - FL_LR_W )
#define		FL_R_Y										FL_L_Y

#define		FL_SLIDE_X									251
#define		FL_SLIDE_Y									25
#define		FL_SLIDE_MAX_Y								160

//ɫ
#define		FL_CATALOG_FONT_FCOLOR						RGB( 0XCE, 0XD6, 0XD9 )
#define		FL_DIR_FONT_COLOR							RGB( 0XCE, 0XD6, 0XD9 ) //x47y6  ɫ#CED6D9
#define		FL_CATEGORY_FCOLOR							RGB( 0XCD, 0XD9, 0XDB )
#define		FL_CATEGORYFOCUS_FCOLOR						RGB( 0XC3, 0XC4, 0XC4 )
#define		FL_LINE_FCOLOR								RGB( 0X72, 0XAB, 0XBA )
#define		FL_LINE_SEPERATOR_COLOR						RGB( 0X11, 0X22, 0X25 )
#define		FL_LINE_COLORRECT_COLOR						RGB( 0X25, 0X45, 0X4C )
#define		FL_LINE_BG_COLOR							0x8420

//---------------------------------------------------------------------------------------------------
//ò˵غ궨
//---------------------------------------------------------------------------------------------------
#define		MAINMENU_BG_X								0
#define		MAINMENU_BG_Y								0

#define     MENU_BAR_LOGO_BASE_X						8 //׼
#define     MENU_BAR_LOGO_BASE_Y						12 //׼
#define     MENU_BAR_OFFSET_X							125 //ѡ˵xϵƫ
#define     MENU_BAR_OFFSET_Y							42 //ѡ˵yϵƫ
#define		MENU_BAR_FONT_OFFSET_X						47 //ʼӦLOGOXϵľ
#define		MENU_BAR_FONT_OFFSET_Y						18 //ʼӦLOGOYϵľ

//λ˳:٢ڢۢܢݢ
enum{
	MENU_BAR_LOGO_X_POS0	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 0,
	MENU_BAR_LOGO_X_POS1	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 1,
	MENU_BAR_LOGO_X_POS2	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 0,
	MENU_BAR_LOGO_X_POS3	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 1,
	MENU_BAR_LOGO_X_POS4	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 0,
	MENU_BAR_LOGO_X_POS5	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 1,
	MENU_BAR_LOGO_X_POS6	= 	MENU_BAR_LOGO_BASE_X + MENU_BAR_OFFSET_X * 0,
};

enum{
	MENU_BAR_LOGO_Y_POS0	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 0,
	MENU_BAR_LOGO_Y_POS1	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 0,
	MENU_BAR_LOGO_Y_POS2	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 1,
	MENU_BAR_LOGO_Y_POS3	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 1,
	MENU_BAR_LOGO_Y_POS4	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 2,
	MENU_BAR_LOGO_Y_POS5	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 2,
	MENU_BAR_LOGO_Y_POS6	= 	MENU_BAR_LOGO_BASE_Y + MENU_BAR_OFFSET_Y * 3,
};

//ߴ
#define		MENU_BAR_COUNT								7

#define		MAINMENU_BAR_LOGO_W							120
#define		MAINMENU_BAR_LOGO_H							42

#define		MENU_ITEM_BAR_LOGO_W						120 //ڵѡ
#define		MENU_ITEM_BAR_LOGO_H						13

#define		MENU_LR_W									14
#define		MENU_LR_H									13

#define		MENU_ITEM_RECT_W							SCREEN_W
#define		MENU_ITEM_RECT_H							23

#define		MENU_ITEM_SPACE								33
#define		MENU_ITEM_SPACE_FONT						20

#define		MENU_ITEMNAME_OFFSET_X						23//MENU_ITEM_RECT_XΪ׼
#define		MENU_ITEMNAME_OFFSET_Y						6

#define		MENU_ITEM_BAR_OFFSET_X						(100+16)//MENU_ITEM_RECT_XΪ׼
#define		MENU_ITEM_BAR_OFFSET_Y						((MENU_ITEM_RECT_H-MENU_ITEM_BAR_LOGO_H)/2)//5

#define		MENU_LARROW_OFFSET_X						(MENU_ITEM_BAR_OFFSET_X-7)//93//MENU_ITEM_RECT_XΪ׼
#define		MENU_LARROW_OFFSET_Y						8

#define		MENU_RARROW_OFFSET_X						(MENU_ITEM_BAR_OFFSET_X+123)//223//MENU_ITEM_RECT_XΪ׼
#define		MENU_RARROW_OFFSET_Y						MENU_LARROW_OFFSET_Y

#define		MENU_UARROW_OFFSET_Y						(-2)//MENU_ITEM_RECT_YΪ׼
#define		MENU_DARROW_OFFSET_Y						19//MENU_UARROW_OFFSET_YΪ׼

#define		MENU_ARROW_LR_W								4
#define		MENU_ARROW_LR_H								7

#define		MENU_UARROW_W								7
#define		MENU_UARROW_H								5

#define		MENU_DARROW_W								7
#define		MENU_DARROW_H								7

//
#define		MENU_L_X									6
#define		MENU_L_Y									4

#define		MENU_R_X									( SCREEN_W - 1 - MENU_L_X - MENU_LR_W ) //237
#define		MENU_R_Y									MENU_L_Y

#define		MENU_ITEM_RECT_X							0//׼֣꣬<>Ϊ׼
#define		MENU_ITEM_RECT_Y							35

#define		MENU_ITEMNAME_X								( MENU_ITEM_RECT_X + MENU_ITEMNAME_OFFSET_X )//23
#define		MENU_ITEMNAME_Y								( MENU_ITEM_RECT_Y + MENU_ITEMNAME_OFFSET_Y )//41

#define		MENU_TITLE_X								103
#define		MENU_TITLE_Y								6

//ɫ
#define		MENU_BAR_FCOLOR								RGB( 0X22, 0X22, 0X22 )
#define		MENU_BAR_FCOLOR_FOCUS						RGB( 0XFF, 0XFF, 0XFF )

#define		MENU_ITEM_RECT_COLOR						RGB( 0X48, 0X6F, 0X84 )
#define		MENU_ITEMNAME_FCOLOR						RGB( 0XDA, 0XE2, 0XE6 )

#define		MENU_ITEM_BAR_FCOLOR						RGB( 0XFF, 0XFF, 0XFF )//ڵѡϵֵɫ

#define		MENU_TITLE_FCOLOR							RGB( 0XD3, 0XDD, 0XE0 )

//---------------------------------------------------------------------------------------------------
//ò˵غ궨
//---------------------------------------------------------------------------------------------------
//ߴ

//
#define		MENU_TITLE_FONTSETTING_X					103
#define		MENU_TITLE_FONTSETTING_Y					6

//ɫ
#define		MENU_TITLE_FONTSETTING_FCOLOR				RGB( 0XD3, 0XDD, 0XE0 )

//---------------------------------------------------------------------------------------------------
//תٷֱȲ˵غ궨
//---------------------------------------------------------------------------------------------------
//ߴ

//

//ɫ
#define		MENU_JUMPTO_BAR_FCOLOR						RGB( 0XC4, 0XE8, 0XFB )
#define		MENU_JUMPTO_BAR_FCOLOR_FOCUS				RGB( 0XFF, 0XFF, 0XFF )

//---------------------------------------------------------------------------------------------------
//ò˵غ궨
//---------------------------------------------------------------------------------------------------
//ߴ
#define		MENU_STYLE_RECT_W							80
#define		MENU_STYLE_RECT_H							22

#define		MENU_STYLE_OFFSET_X							103//MENU_STYLE1_XΪ׼
#define		MENU_STYLE_OFFSET_Y							30

#define		MENU_STYLE_RECT_W_FOCUS						3

#define		MENU_KEY_BANK								40

#define		STYLELOGO_COUNT								5
#define		STYLE_ITEM_COUNT							10

//
#define		MENU_STYLE1_X								34//׼
#define		MENU_STYLE1_Y								28//35

#define		MENU_KEY_X									35
#define		MENU_KEY_Y									170

#define		MENU_KEYA_LOGO_X1							66
#define		MENU_KEYA_LOGO_X2							88
#define		MENU_KEYB_LOGO_X1							131
#define		MENU_KEYB_LOGO_X2							194
#define		MENU_KEY_LOGO_Y1							170
#define		MENU_KEY_LOGO_Y2							177

//ɫ
#define		MENU_STYLE1_FCOLOR							RGB( 0X00, 0X00, 0X00 )
#define		MENU_STYLE1_BGCOLOR							RGB( 0XFF, 0XFF, 0XFF )
#define		STYLE1_SLIDEBAR_COLOR						RGB( 0XF0, 0XF0, 0XF0 )
#define		STYLE1_SLIDE_COLOR							RGB( 0X99, 0X99, 0X99 )

#define		MENU_STYLE2_FCOLOR							RGB( 0XFF, 0XFF, 0XFF )
#define		MENU_STYLE2_BGCOLOR							RGB( 0X00, 0X00, 0X00 )
#define		STYLE2_SLIDEBAR_COLOR						RGB( 0X33, 0X33, 0X33 )
#define		STYLE2_SLIDE_COLOR							RGB( 0X99, 0X99, 0X99 )

#define		MENU_STYLE3_FCOLOR							RGB( 0X00, 0X00, 0X00 )
#define		MENU_STYLE3_BGCOLOR							RGB( 0X66, 0X66, 0X66 )
#define		STYLE3_SLIDEBAR_COLOR						RGB( 0X76, 0X76, 0X76 )
#define		STYLE3_SLIDE_COLOR							RGB( 0XBC, 0XBC, 0XBC )

#define		MENU_STYLE4_FCOLOR							RGB( 0X99, 0X99, 0X99 )
#define		MENU_STYLE4_BGCOLOR							RGB( 0X33, 0X33, 0X33 )
#define		STYLE4_SLIDEBAR_COLOR						RGB( 0X4E, 0X4E, 0X4E )
#define		STYLE4_SLIDE_COLOR							RGB( 0XBC, 0XBC, 0XBC )

#define		MENU_STYLE5_FCOLOR							RGB( 0XA7, 0XB2, 0XB4 )
#define		MENU_STYLE5_BGCOLOR							RGB( 0X1B, 0X2C, 0X34 )
#define		STYLE5_SLIDEBAR_COLOR						RGB( 0X37, 0X47, 0X4E )
#define		STYLE5_SLIDE_COLOR							RGB( 0XA7, 0XB2, 0XB4 )

#define		MENU_STYLE6_FCOLOR							RGB( 0XE3, 0XE3, 0XE3 )//BlackNight
#define		MENU_STYLE6_BGCOLOR							RGB( 0X00, 0X00, 0X00 )
#define		STYLE6_SLIDEBAR_COLOR						RGB( 0X42, 0X42, 0X42 )
#define		STYLE6_SLIDE_COLOR							RGB( 0XAD, 0XAD, 0XAD )

#define		MENU_STYLE7_FCOLOR							RGB( 0XF0, 0XFA, 0XCD )//WORLD CUP
#define		MENU_STYLE7_BGCOLOR							RGB( 0X1B, 0X2C, 0X34 )
#define		STYLE7_SLIDEBAR_COLOR						RGB( 0X55, 0X6D, 0X45 )
#define		STYLE7_SLIDE_COLOR							RGB( 0XAA, 0XB6, 0XA2 )

#define		MENU_STYLE8_FCOLOR							RGB( 0X2D, 0X21, 0X1C )//BOAR
#define		MENU_STYLE8_BGCOLOR							RGB( 0X57, 0X40, 0X15 )
#define		STYLE8_SLIDEBAR_COLOR						RGB( 0XDA, 0XC7, 0XB4 )
#define		STYLE8_SLIDE_COLOR							RGB( 0X7C, 0X60, 0X50 )

#define		MENU_STYLE9_FCOLOR							RGB( 0X99, 0X00, 0X00 )//BUM
#define		MENU_STYLE9_BGCOLOR							RGB( 0X00, 0X33, 0X00 )
#define		STYLE9_SLIDEBAR_COLOR						RGB( 0XEB, 0XD2, 0XAC )
#define		STYLE9_SLIDE_COLOR							RGB( 0XD1, 0X94, 0X38 )

#define		MENU_STYLE10_FCOLOR							RGB( 0XC0, 0X70, 0XBC )//PINK
#define		MENU_STYLE10_BGCOLOR						RGB( 0X57, 0X25, 0X00 )
#define		STYLE10_SLIDEBAR_COLOR						RGB( 0XFD, 0XC6, 0XDD )
#define		STYLE10_SLIDE_COLOR							RGB( 0XD1, 0X94, 0X38 )

#define		MENU_STYLE_RECT_BGCOLOR_FOCUS				RGB( 0XFE, 0X90, 0X3B )

//skin1  ɫ#FFFFFF  ɫ #000000  ɫ #F0F0F0 ɫ #999999
//
//skin2  ɫ#000000  ɫ #FFFFFF  ɫ #333333 ɫ #999999
//
//skin3  ɫ#666666  ɫ #000000  ɫ #767676 ɫ #BCBCBC
//
//skin4  ɫ#333333  ɫ #999999  ɫ #4E4E4E ɫ #BCBCBC
//
//skin5  ɫ#1B2C34  ɫ #A7B2B4  ɫ #37474E ɫ #A7B2B4

//BlackNight  BlackNight_bj.bmp  ɫ #E3E3E3  ɫ #424242 ɫ #ADADAD
//
//WORLD CUP  WORLDCUP_bj.bmp  ɫ #F0FACD  ɫ #556D45 ɫ #AAB6A2
//
//BOARD  BOARD_bj.bmp  ɫ #2D211C  ɫ #DAC7B4 ɫ #7C6050
//
//BUM  BUM_bj.bmp  ɫ #990000  ɫ #EBD2AC ɫ #D19438
//
//PINK PINK_bj.bmp  ɫ #FDC6DD  ɫ #C070BC ɫ #D19438


//---------------------------------------------------------------------------------------------------
//ǩò˵غ궨
//---------------------------------------------------------------------------------------------------
//ߴ
#define		BM_ITEM_COUNT								4 //һǩ
#define		BM_LINE_H									30//ǩи
#define		BM_LINE_RECT_W								(247+3)
#define		BM_LINE_RECT_H								29//ǩби

#define		BM_LINE_SEPERATOR_W							BM_LINE_RECT_W//SCREEN_W
#define		BM_LINE_SEPERATOR_H							1

#define		BM_SLIDEBAR_W								3
#define		BM_SLIDEBAR_H								169

#define		BM_SLIDE_W									3
#define		BM_SLIDE_H									10

//
#define		BM_ADDBM_X									93
#define		BM_ADDBM_Y									65

#define		BM_LOOKBM_X									93
#define		BM_LOOKBM_Y									101

#define		BM_MANAGER_LOGO_X							6
#define		BM_MANAGER_LOGO_Y							2

#define		BM_MANAGER_FONT_X							30
#define		BM_MANAGER_FONT_Y							6

#define		BM_CONFIRM_KEY_FONT_X						34
#define		BM_CONFIRM_KEY_FONT_Y						178

#define		BM_CANCEL_KEY_FONT_X						108
#define		BM_CANCEL_KEY_FONT_Y						178

#define		BM_DEL_KEY_FONT_X							182
#define		BM_DEL_KEY_FONT_Y							178

#define		BM_CONFIRM_KEY_LOGO_X						61
#define		BM_CONFIRM_KEY_LOGO_Y						177

#define		BM_CANCEL_KEY_LOGO_X						135
#define		BM_CANCEL_KEY_LOGO_Y						177

#define		BM_DEL_KEY_LOGO_X							209
#define		BM_DEL_KEY_LOGO_Y							177

#define		BM_LINE_RECT_START_X						0
#define		BM_LINE_RECT_START_Y						26//׼

#define		BM_ID_TEXT_X								5
#define		BM_ID_TEXT_OFFSET_Y							3//BM_LINE_RECT_START_YΪ׼

#define		BM_DATATIME_X								(145-4)
#define		BM_DATATIME_OFFSET_Y						BM_ID_TEXT_OFFSET_Y

#define		BM_PERCENTAGE_X								(214-4)
#define		BM_PERCENTAGE_OFFSET_Y						BM_ID_TEXT_OFFSET_Y

#define		BM_TEXT_X									BM_ID_TEXT_X
#define		BM_TEXT_OFFSET_Y							16//42 BM_LINE_RECT_START_YΪ׼

#define		BM_LINE_SEPERATOR_X							0
#define		BM_LINE_SEPERATOR_OFFSET_Y					29//55 BM_LINE_RECT_START_YΪ׼

#define		BM_SLIDEBAR_X								250
#define		BM_SLIDEBAR_Y								23
#define		BM_SLIDE_X									BM_SLIDEBAR_X
#define		BM_SLIDE_Y									BM_SLIDEBAR_Y
#define		BM_SLIDE_MAX_Y								( BM_SLIDEBAR_Y + BM_SLIDEBAR_H - BM_SLIDE_H )

//ɫ
#define 	BM_STATICTEXT_COLOR							RGB( 0X33, 0X33, 0X33 )
#define		BM_FIRSTLINE_BG_COLOR						RGB( 0XFA, 0XF4, 0XEB )
#define		BM_SECONDLINE_BG_COLOR						RGB( 0XFF, 0XFF, 0XFF )
#define		BM_SELECTEDLINE_BG_COLOR					RGB( 0XF0, 0XDE, 0XC4 )

#define		BM_BAR_STATICTEXT_COLOR						RGB( 0XC0, 0XCA, 0XCC )
#define		BM_TEXT_COLOR								RGB( 0X4E, 0X62, 0X6D )
#define		BM_TEXT_COLOR_FOCUS							RGB( 0X73, 0X8B, 0X90 )

#define		BM_BAR_BG_COLOR								RGB( 0X28, 0X39, 0X49 )
#define		BM_BAR_BG_COLOR_FOCUS						RGB( 0X31, 0X59, 0X61 )

#define		BM_LINE_SEPERATOR_COLOR						RGB( 0XC2, 0XC7, 0XCA )

//---------------------------------------------------------------------------------------------------
//غ궨
//---------------------------------------------------------------------------------------------------
//
#define		HELP_MENU_X									6
#define		HELP_MENU_Y									12

//ɫ
#define		MESSAGE_HINT_TEXT_COLOR					   RGB( 0XFF, 0XFF, 0XFF )

//---------------------------------------------------------------------------------------------------
//Ϣغ궨
//---------------------------------------------------------------------------------------------------
//ߴ
#define 	MSG_W										166
#define 	MSG_H										99

#define 	MSG_W2										180
#define 	MSG_H2										99

#define		MSG_BTN_BANK								16
#define		MSG_BTN_BANK2								20

#define 	MSG_ITEM_SPACE								( MENU_ITEM_BAR_LOGO_H + 10 )

#define 	MSG_ITEM_RECT_W								( MSG_W - 2 )
#define 	MSG_ITEM_RECT_H								( MENU_ITEM_BAR_LOGO_H + 6 )

#define		BTN_FONT_OFFSET_X							15//ťϵڰťƫ
#define		BTN_FONT_OFFSET_Y							2

//
#define		MSG_X										( (SCREEN_W - MSG_W) >> 1 ) //53 //׼
#define		MSG_Y										( (SCREEN_H - MSG_H) >> 1 )//49

#define		MSG_TITLE_X									( MSG_X + 66 )//119
#define		MSG_TITLE_Y									( MSG_Y + 5  )//54

#define		MSG_TEXT_X									( MSG_X + 22 )//70
#define		MSG_TEXT_Y									( MSG_Y + 40 )//82

#define		MSG_OK_X									( MSG_X + 25 )//78
#define		MSG_OK_Y									( MSG_Y + 72 ) //121

#define		MSG_CANCEL_X								( MSG_OK_X + 65 )//143
#define		MSG_CANCEL_Y								MSG_OK_Y

#define		MSG_OK_FONT_X								( MSG_OK_X + BTN_FONT_OFFSET_X )//93
#define		MSG_OK_FONT_Y								( MSG_OK_Y + BTN_FONT_OFFSET_Y )//124

#define		MSG_CANCEL_FONT_X							( MSG_CANCEL_X + BTN_FONT_OFFSET_X )//158
#define		MSG_CANCEL_FONT_Y							MSG_OK_FONT_Y

#define		MSG_ITEM_RECT_X								( MSG_X + 1 )
#define		MSG_ITEM_RECT_Y								( MSG_Y + 24 )//73

#define		MSG_ITEM_BAR_OFFSET_X						( ( MSG_W - 2 - MENU_ITEM_BAR_LOGO_W ) >> 1 )//MSG_ITEM_RECT_XΪ׼
#define		MSG_ITEM_BAR_OFFSET_Y						3

//ɫ
#define		MSG_TITLE_FCOLOR							RGB( 0XD6, 0XDC, 0XDE )
#define		MSG_KEY_FCOLOR								RGB( 0XD6, 0XDC, 0XDE )
#define		MSG_TEXT_FCOLOR								RGB( 0X72, 0XAB, 0XBA )

//---------------------------------------------------------------------------------------------------
//ıĶغ궨
//---------------------------------------------------------------------------------------------------
//
#define		NAVIGATION_W								3
#define		NAVIGATION_H								192

#define		TXT_NAVIGATION_X							252
#define		TXT_NAVIGATION_Y							0

#define		TXT_SLIDE_W									3
#define		TXT_SLIDE_H									10

#define		TXT_SLIDE_X									TXT_NAVIGATION_X
#define		TXT_SLIDE_Y									0
#define		TXT_SLIDE_MAX_Y								( SCREEN_H - TXT_SLIDE_H )


//---------------------------------------------------------------------------------------------------
//ʾغ궨
//---------------------------------------------------------------------------------------------------

//Чͼ3.png
//
//˵
//ɫͳһǣ#506165
//
//ļ   ꣺x55y176
//X.bmp      ꣺x95y175
//       ꣺x120y176
//Y.bmp      ꣺x142y175
//˳       ꣺x164y176
//START.bmp  ꣺x189y176
//
//õʱ򰴼û  ļ X.bmp
//
//       ꣺x14y176
//Y.bmp      ꣺x38y175
//˳       ꣺x197y176
//START.bmp  ꣺x222y176

//#define			EDITION_STR								"iReader v1.1"
#define			EDITION_STR								"v1.11"

#define			SUBPAN_TIME_W							36
#define			SUBPAN_TIME_H							12

#define			NOTICE_HELP_LOGO_W						25
#define			NOTICE_HELP_LOGO_H						9

#define			NOTICE_EXIT_LOGO_W						22
#define			NOTICE_EXIT_LOGO_H						9

//
#define			NOTICE_HELP_X							14
#define			NOTICE_HELP_Y							176

#define			NOTICE_HELP_LOGO_X						39
#define			NOTICE_HELP_LOGO_Y						177

#define			NOTICE_EXIT_X							( 197 - 24 )
#define			NOTICE_EXIT_Y							176

#define			NOTICE_EXIT_LOGO_X						222
#define			NOTICE_EXIT_LOGO_Y						177

#define			EDITION_STR_X							(222-6)//103
#define			EDITION_STR_Y							8//135

#define			SUBPAN_DATE_X							74
#define			SUBPAN_TIME_X							( SUBPAN_DATE_X + 72 )
#define			SUBPAN_DATETIME_Y						NOTICE_HELP_LOGO_Y//139//142//152

//iReader v1.1  x103y135ɫ#737C7E
//ʱ 2010-6-13  11:24 x76y152ɫ#CCCCCC

//ɫ
#define			NOTICE_FCOLOR							RGB( 0X50, 0X61, 0X65 )
#define			EDITION_STR_FCOLOR						RGB( 0X73, 0X7C, 0X7E )
#define			SUBPAN_DATETIME_FCOLOR					RGB( 0XCC, 0XCC, 0XCC )

//---------------------------------------------------------------------------------------------------
//ͼƬغ궨
//---------------------------------------------------------------------------------------------------
#define 	OPLOGO_COUNT								6

#define		CONFIG_THUMB_X								37
#define		CONFIG_THUMB_MAX_X							219
#define		CONFIG_THUMB_Y								20
#define		CONFIG_THUMB_MAX_Y							161
#define		CONFIG_THUMBW								( 219 - 37 )//182//x37-x219y20-y161ʾ
#define		CONFIG_THUMBH								( 161 - 20 )//141

#define 	OPLOGO_W									64
#define 	OPLOGO_H					            	27

#define 	OPLOGO_W2									27
#define 	OPLOGO_H2					            	69

#define 	OPLOGO_SPACE								5
#define 	OPLOGO_X									0
#define 	OPLOGO_Y									( SCREEN_H - OPLOGO_H )
#define		ZOOMIN_MIN									( 25  )//СΪ25%
#define		ZOOMIN_MAX									( 4 * 100 )//Ŵ5
#define		ZOOMIN_MAX_W								1024
#define		ZOOMIN_MAX_H								1024

#define		ZOOM_STEP_25								25//25-100
#define		ZOOM_STEP_50								50//100-200
#define		ZOOM_STEP_100								100 //200-400

#define		ZOOM_LEVEL_25								25
#define		ZOOM_LEVEL_100								100
#define		ZOOM_LEVEL_200								200

#define 	IMAGE_INFO_X								13
#define 	IMAGE_INFO_Y								3
#define 	IMAGE_INFO_FCOLOR							RGB( 0x66, 0x66, 0x66 )

#define		IMAGE_TITLEBAR_W							SCREEN_W
#define		IMAGE_TITLEBAR_H							17

//---------------------------------------------------------------------------------------------------
//غ궨
//---------------------------------------------------------------------------------------------------
#define		CONFIG_FONT_LOCAL2UMAP_DIR					"fat:/iReader/fonts/local2u.map"
#define		CONFIG_LANGUAGE_ROOTDIR						"fat:/iReader/language/"
#define		CONFIG_LANGUAGE_DIR							"language/"
#define		CONFIG_LANGUAGE_EN							"en"
#define		CONFIG_LANGUAGE_CN							"cn"
#define		CONFIG_LANGUAGE_TW							"tw"
#define		CONFIG_LANGUAGE_JP							"jp"
#define		SUPPORT_LANG_MAX_COUNT						4//֧

//config_lang.txt
#define		LANG_DIR_INDEX_TABLE_SEG					"[language_dir_index_table]"
#define		DEFAULT_LANG_DIR_INDEX_SEG					"[default_lang_dir_index]"
#define		CUR_LANG_DIR_INDEX_SEG						"[cur_lang_dir_index]"
#define		LANG_DIR_INDEX_ITEM							"lang_dir_index="

#define		LANG_ITEM_IDX0								"0="
#define		LANG_ITEM_IDX1								"1="
#define		LANG_ITEM_IDX2								"2="
#define		LANG_ITEM_IDX3								"3="
#define		LANG_ITEM_IDX4								"4="
#define		LANG_ITEM_IDX5								"5="
#define		LANG_ITEM_IDX6								"6="
#define		LANG_ITEM_IDX7								"7="
#define		LANG_ITEM_IDX8								"8="
#define		LANG_ITEM_IDX9								"9="

//ͨ
#define		LANG_MENU									"Menu="
#define		LANG_TITLE									"Title="
#define		LANG_ITEM0                               	"Item0="
#define		LANG_ITEM1                               	"Item1="
#define		LANG_ITEM2                               	"Item2="
#define		LANG_ITEM3                               	"Item3="
#define		LANG_ITEM4                               	"Item4="
#define		LANG_ITEM5                               	"Item5="
#define		LANG_ITEM6                               	"Item6="
#define		LANG_ITEM7                               	"Item7="
#define		LANG_ITEM8                               	"Item8="
#define		LANG_ITEM9                               	"Item9="
#define		LANG_ITEM10                               	"Item10="

#define		LANG_LANG0									"Lang0="
#define		LANG_LANG1									"Lang1="
#define		LANG_LANG2									"Lang2="
#define		LANG_LANG3									"Lang3="

#define		LANG_MSG0                               	"Msg0="
#define		LANG_MSG1                               	"Msg1="
#define		LANG_MSG2                               	"Msg2="
#define		LANG_MSG3                               	"Msg3="
#define		LANG_MSG4                               	"Msg4="
#define		LANG_MSG5                               	"Msg5="
#define		LANG_MSG6                               	"Msg6="
#define		LANG_MSG7                               	"Msg7="
#define		LANG_MSG8                               	"Msg8="
#define		LANG_MSG9                               	"Msg9="
#define		LANG_MSG10                               	"Msg10="


#define		LANG_UP										"Up="
#define		LANG_DOWN									"Down="
#define		LANG_LEFT									"Left="
#define		LANG_RIGHT									"Right="
#define		LANG_L_R									"L/R="
#define		LANG_A										"A="
#define		LANG_B										"B="
#define		LANG_SELECT									"Select="
#define		LANG_START									"START="
#define		LANG_RLEFT									"R+Left="
#define		LANG_RRIGHT									"R+Right="
#define		LANG_X										"X="
#define		LANG_Y										"Y="
#define		LANG_L										"L="
#define		LANG_R										"R="
#define		LANG_AUP_Y									"A+UP/Y="
#define		LANG_ADOWN_X								"A+DOWN/X="
#define		LANG_ALEFT									"A+Left="
#define		LANG_ARIGHT									"A+Right="
#define		LANG_AL										"A+L="
#define		LANG_AR										"A+R="


//(ļlanguage.txt˳Ӧ)
#define		LANG_MSG_SEG								"[message]"
#define		LANG_OK										"OK="
#define		LANG_CANCEL									"Cancel="
#define		LANG_HELP									"Help="
#define		LANG_EXIT									"Exit="
#define		LANG_NOTICE									"Hint="
#define		LANG_EXITIREADER							"Exit iReader="
#define		LANG_EXITITXT								"Exit text="
#define		LANG_OPENFILEERROR							"File open failed="
#define		LANG_FILEEMPTY								"File empty="
#define		LANG_FILEENCODE								"File encode="

//[catalog type]
#define		LANG_CATALOG_SEG							"[catalog type]"
#define		LANG_CATALOG_ALL							"All="
#define		LANG_CATALOG_BOOK							"Book="
#define		LANG_CATALOG_PICTURE						"Picture="

//[font_settings]
#define		LANG_FONT_SEG								"[font_settings]"
#define		LANG_FONTSETTINGSMENU						"Menu="
#define		LANG_FONTSETTINGSTITLE						"Title="
#define		LANG_FONTSIZE                               "Item0="
#define		LANG_ROWSPACE                               "Item1="
#define		LANG_WORDSPAC                               "Item2="

//[style_settings]
#define		LANG_STYLE_SEG								"[style_settings]"
#define		LANG_STYLESETTINGS							"Style Settings="

//[readmode_settings]
#define		LANG_READMODE_SEG							"[readmode_settings]"
#define		LANG_READMODESETTINGS						"Readmode Settings="
#define		LANG_READMODE								"Readmode="
#define		LANG_SCREEN									"Screen="
#define		LANG_HORIZONTAL								"Horizontal="
#define		LANG_VERTICAL								"Vertical="
#define		LANG_UPPERSCREEN							"Upper Screen="
#define		LANG_LOWERSCREEN							"Lower Screen="
#define		LANG_DOUBLECREEN							"Double Screen="

//[system_settings]
#define		LANG_BRIGHTNESS_SEG							"[system_settings]"
#define		LANG_BRIGHTNESSSETTINGS						"Brightness Settings="
#define		LANG_BRIGHTNESS								"Brightness="
#define		LANG_BRIGHTNESS_NOTE						"Note="


//[jumpto_percentage]
#define		LANG_JUMP_SEG								"[jumpto_percentage]"
#define		LANG_JUMP									"Jump="
#define		LANG_JUMPTOPERCENTAGE						"Jumpto Percentage="
#define		LANG_JUMPTO									"Jumpto="


//[bookmark_settings]
#define		LANG_BM_SEG									"[bookmark_settings]"
#define		LANG_BOOKMARK								"Bookmark="
#define		LANG_BMSETTINGS								"Bookmark Settings="
#define		LANG_ADDBM									"Item0="
#define		LANG_VIEWBMLIST								"Item1="
#define		LANG_DELETE									"Item2="
#define		LANG_DELETEALL								"Item3="
#define		LANG_BM_JUMP								"Key0="
#define		LANG_RETURN									"Key1="
#define		LANG_BM_DEL									"Key2="
#define		LANG_BM_EMPTY								"Msg0="
#define		LANG_SAVEBM									"Msg1="
#define		LANG_SAVEBM_OK								"Msg2="

//[help menu]
#define		LANG_HELP_SEG								"[help menu]"
#define		LANG_MENU_HELP								"Help="

//[picture]
#define		LANG_PCITURE_SEG							"[picture]"
#define		LANG_SIZE									"Size="
#define		LANG_FILESIZE								"FileSize="
#define		LANG_ZOOM									"Zoom="
#define		LANG_ORIGSIZE								"Orig size="
#define		LANG_ADAPTH									"AdaptH="
#define		LANG_ADAPTW									"AdaptW="


//[file_browse]
#define 	LANG_FBH_SEG								"[file_browse]"

//[text_reading]
#define 	LANG_TXTRH_SEG								"[text_reading]"

//[picture_browse]
#define 	LANG_PBH_SEG								"[picture_browse]"

//[pdf_browse]
#define 	LANG_PDFH_SEG								"[pdf_browse]"
#define 	LANG_PDF_PAGE								"Page="
#define 	LANG_PDF_CURPAGE							"CurPage="


#endif  //__CONFIG_H
