#include <uart.h>
#include <display.h>
#include <datatype.h>
#include <config_ebook.h>
 
#if DEBUG_LHM
//------------------------------------Դӡ-----------------------------------
void debug_printf( unsigned char *buffer, unsigned int n, const unsigned char *str )
{
	printf( "%s\n", str );
	printf( "n = %d\n", n );

	if( buffer == 0 || n == 0 )
		return;
	int i;

	for( i=0; i<n; i++ )
	{
		printf( "%02X ", buffer[i] );
		if( ( i+1 ) % 512 == 0 )
			printf( "\n\n" );
		else if( ( i+1 ) % 16 == 0 )
			printf( "\n" );
		else if( ( i+1 ) % 8 == 0 )
			printf( "   " );
	}
	printf( "\n" );
}

void debug_printf2( pixel *buffer, unsigned int n, const unsigned char *str )
{
	if( buffer == 0 || n == 0 )
		return;
	int i;
	printf( "\n%s\n", str );
	for( i=0; i<n; i++ )
	{
		printf( "%04X ", buffer[i] );
		if( ( i+1 ) % 512 == 0 )
			printf( "\n\n" );
		else if( ( i+1 ) % 16 == 0 )
			printf( "\n" );
		else if( ( i+1 ) % 8 == 0 )
			printf( "   " );
	}
	printf( "\n" );
}

void debug_printf3( unsigned char *buffer, unsigned int n, const char *str, int line )
{
	printf( "[LINE: %d]%s\n", line, str );
	printf( "n = %d\n", n );

	if( buffer == 0 || n == 0 )
		return;
	int i;

	for( i=0; i<n; i++ )
	{
		printf( "%02X ", buffer[i] );
		if( ( i+1 ) % 512 == 0 )
			printf( "\n\n" );
		else if( ( i+1 ) % 16 == 0 )
			printf( "\n" );
		else if( ( i+1 ) % 8 == 0 )
			printf( "   " );
	}
	printf( "\n" );
}

extern void debug_dpfk( void *buf, unsigned int n, unsigned char *file, unsigned char *function, unsigned int line )
{
		printf( "\n\n" );
		printf( "%s,%s,%d\n", file, function, line );
		if( buf == NULL )
			return;

		dword i;
		unsigned char *bufp = (unsigned char*)buf;
		printf( "-------------------------------------------------------------------\n" );
		for( i=0; i<n; i++ )
		{
			printf( "%02X ", bufp[i] );
			if( (i+1)%512 == 0 )
				printf( "\n\n" );
			else if( (i+1)%16 == 0 )
				printf( "\n" );
			else if( (i+1)%8 == 0 )
				printf( " " );
		}
		printf( "\n-------------------------------------------------------------------\n\n" );
}
#endif
