/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"

#include <string.h>
#include "common/utils.h"
#include "scene.h"
#include "display.h"
#include "version.h"
#include "conf.h"
#include "mystring.h"
#include <fs_api.h>
#include <language.h>
#include <debugoff.h>

static char conf_filename[PATH_MAX2];

extern void conf_set_file(const char *filename)
{
	STRCPY_S(conf_filename, filename);
}

static void conf_default(p_conf conf)
{
	char appdir[PATH_MAX2];
	appdir[0] = '\0';
	STRCAT_S(appdir, CONFIG_ROOTDIR );
	memset(conf, 0, sizeof(t_conf));
//	STRCPY_S( conf->path, CONFIG_ROOTDIR );

	STRCPY_S( conf->Upath, CONFIG_ROOTDIR );//UTF8,ΪӢUTF8GBKһԿֱӿ

//	STRCPY_S( conf->shortpath, CONFIG_ROOTDIR );
	STRCPY_S(conf->lastfile, "");

#if 0
	STRCPY_S(conf->bgarch, "");
	STRCPY_S( conf->bgfile,  CONFIG_EBOOK_ROOTDIR );
	STRCAT_S(conf->bgfile, "bg.bmp");
	conf->bgwhere = scene_in_dir;
#else
	STRCPY_S( conf->bgarch,  CONFIG_EBOOK_ROOTDIR );
	STRCAT_S(conf->bgarch, "bg.zip");
	STRCPY_S(conf->bgfile, "bg.bmp");
	conf->bgwhere = scene_in_zip;
#endif

	conf->confver = IREADER_VERSION_NUM;
	conf->forecolor = 0xFFFFFFFF;
	conf->bgcolor = RGB15( 0, 8, 12 );//
	conf->have_bg = true;
	conf->rowspace = 3;//м
	conf->wordspace = 1;
	conf->borderspace = 5;
	conf->vertread = conf_vertread_horz;//Ķ
//	conf->infobar = conf_infobar_info;
	conf->infobar = conf_infobar_none;
	conf->rlastrow = false;//ҳʱǷظһУҳʱǷһҳһҳȥһе?
	conf->autobm = true; //Զǩػ򱣴浽ǩ
	conf->encode = conf_encode_gbk;

//--------ͼƬ------
	conf->fit = conf_fit_none;
	conf->fit = conf_fit_custom;
	conf->imginfobar = true;//ǷҪʾͼƬϢ
	conf->scrollbar = false;
	conf->scale = 100;
	conf->rotate = conf_rotate_0;//תǶϵ *90
	conf->bicubic = false; //true:ʹξ false:ʹ
	conf->viewpos = 1 * 3 + 1;//λã1У2Ͻ
	conf->isreading = false;
	conf->slideinterval = 5;
	conf->hprmctrl = false;
	conf->grayscale = 30;
	conf->showhidden = true;
	conf->showunknown = true;
	conf->showfinfo = false;//ǷʾļϢ
	conf->allowdelete = true;
	conf->arrange = conf_arrange_name;//ļб˳ʽ
	conf->enableusb = false;
	conf->viewpos = conf_viewpos_leftup;
	conf->imgmvspd = 16;//ͼƬƶΪλ
	conf->imgpaging = conf_imgpaging_direct;
	conf->fontsize = 10;
	conf->bookfontsize = 12;
	conf->reordertxt = false;
	conf->pagetonext = false;//config.pagetonext:ǰļѾһҳٰһҳǷһıļ?
	conf->autopage = 0;
	conf->autopagetype = 2;
	conf->autolinedelay = 0;
	conf->thumb = conf_thumb_scroll;
	conf->imgpagereserve = 0;
	conf->lyricex = 0;
	conf->autoplay = false;
	conf->usettf = 0;
	conf->freqs[0] = 1;
	conf->freqs[1] = 5;
	conf->freqs[2] = 8;
	conf->imgbrightness = 100;//ͼƬȣֵΪ100
	conf->dis_scrsave = false;
	conf->autosleep = 0;
	conf->load_exif = true;
	conf->prev_autopage = 2;
	conf->launchtype = 2;

	conf->titlecolor = COLOR_WHITE;
	conf->titlebcolor = RGB(0x30, 0x60, 0x30);
//	conf->menutextcolor = RGB(0xDF, 0xDF, 0xDF);//Ŀɫ
	conf->menutextcolor = COLOR_WHITE;//Ŀɫ
	conf->menubcolor = RGB(0x10, 0x30, 0x20);//Ŀɫ
	conf->selicolor = RGB(0xFF, 0xFF, 0x40);//ѡĿɫ
	conf->selbcolor = RGB(0x20, 0x20, 0xDF);//Ŀѡʱıɫ
	conf->selrcolor = RGB15(0x1F, 0x07, 0x00);//Ŀѡ߿ɫ
	conf->msgbcolor = RGB(0x18, 0x28, 0x50);
	conf->usedyncolor = false;//Ƿʹö̬ɫ

#ifdef ENABLE_TTF
	STRCPY_S(conf->cttfpath, appdir);
	STRCAT_S(conf->cttfpath, "fonts/gbk.ttf");
	STRCPY_S(conf->ettfpath, appdir);
	STRCAT_S(conf->ettfpath, "fonts/asc.ttf");
	conf->infobar_use_ttf_mode = true;

	conf->cfont_antialias = false;
	conf->cfont_cleartype = true;
	conf->cfont_embolden = false;

	conf->efont_antialias = false;
	conf->efont_cleartype = true;
	conf->efont_embolden = false;
#endif

	conf->img_no_repeat = false;

	conf->hide_flash = true;
	conf->tabstop = 4;//4ոһtabstop

	conf->apetagorder = true;

//------------PDF---------------
	conf->pdfmvspd = 10;

//-----------------------------------------
	conf->StyleIndex	= 0;//ĬϷ񣺰ɫɫ
	conf->ScreenUse = SCREEN_DOWN;//ĬʹĻ
	conf->brightness = 1;//0-3
	conf->BacklightUp = 1;//Ĭϴ
	conf->BacklightDown = 1;//Ĭϴ
	conf->CategoryFlag = 1; //Ĭȫ

	conf->MenuBarIndex = 0;
	conf->edge_distance_y = 2;//±߾
	conf->cur_lang_index = -1;//ĬΪЧȷ
	
	conf->fontcolor = -1;//use the font color of style
	conf->fontbgcolor = -1;//use the font color of style
	conf->stylefcolor_inUse = true;//use the font color of style
	conf->stylefontbgcolor_inUse = true;//use the font color of style
}

/*static*/ char *intToString(char *str, int size, int i)
{
	if (str == NULL || size == 0)
		return NULL;

	snprintf_s(str, size, "%ld", i);

	return str;
}

/*static*/ char *dwordToString(char *str, int size, dword dw)
{
	if (str == NULL || size == 0)
		return NULL;

	snprintf_s(str, size, "%lu", dw);

	return str;
}

extern BOOL ini_conf_load(const char *inifilename, p_conf conf)
{
	if (conf == NULL || inifilename == NULL)
	{
		return false;
	}

	FILE *fp = fopen( inifilename, "r" );
	if( !fp )
	{
		return false;
	}

	int len, RetValue;
	fseek( fp, 0, SEEK_END );
	len = ftell( fp );
	fseek( fp, 0, SEEK_SET );
	RetValue = fread( (unsigned char*)conf, 1, sizeof( t_conf ), fp );
	fclose( fp );

	if( RetValue != len )
		return false;
	else
		return true;
}

extern BOOL conf_load( p_conf conf )
{
	if ( ini_conf_load( conf_filename, conf) == false )
	{
		conf_default( conf );
		conf_save( conf );
		return false;
	}

	return true;
}

extern BOOL conf_save(p_conf conf)
{
	FILE *fp = fopen( conf_filename, "w" );
	if( !fp )
	{
		return false;
	}
	fwrite( (unsigned char*)conf, 1, sizeof( t_conf ), fp );
	fclose( fp );

	return true;
}
