/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _CONF_H_
#define _CONF_H_

#include <datatype.h>
#include <display.h>

typedef enum
{
	conf_encode_default = 0,
	conf_encode_gbk = 1,
	conf_encode_big5 = 2,
	conf_encode_sjis = 3,
	conf_encode_ucs = 4,
	conf_encode_utf8 = 5,
	conf_encode_ucs_bigendian = 6,
} t_conf_encode;


#if 0

typedef enum
{
	conf_fit_none = 0,
	conf_fit_width = 1,
	conf_fit_dblwidth = 2,
	conf_fit_height = 3,
	conf_fit_dblheight = 4,
	conf_fit_custom = 5
} t_conf_fit;

#else

typedef enum
{
	conf_fit_none = 0,
	conf_fit_width,
	conf_fit_height,
	conf_fit_custom,
	conf_fit_dblwidth,
	conf_fit_dblheight,
} t_conf_fit;

#endif

typedef enum
{
	conf_rotate_0 = 0,
	conf_rotate_90 = 1,
	conf_rotate_180 = 2,
	conf_rotate_270 = 3,
} t_conf_rotate;

typedef enum
{
	conf_cycle_single = 0,
	conf_cycle_repeat = 1,
	conf_cycle_repeat_one = 2,
	conf_cycle_random = 3
} t_conf_cycle;

typedef enum
{
	conf_arrange_ext = 0,
	conf_arrange_name = 1,
	conf_arrange_size = 2,
	conf_arrange_ctime = 3,
	conf_arrange_mtime = 4
} t_conf_arrange;

typedef enum
{
	conf_viewpos_leftup = 0,
	conf_viewpos_midup = 1,
	conf_viewpos_rightup = 2,
	conf_viewpos_leftmid = 3,
	conf_viewpos_midmid = 4,
	conf_viewpos_rightmid = 5,
	conf_viewpos_leftdown = 6,
	conf_viewpos_middown = 7,
	conf_viewpos_rightdown = 8,
} t_conf_viewpos;

typedef enum
{
	conf_imgpaging_direct = 0,
	conf_imgpaging_updown = 1,
	conf_imgpaging_leftright = 2,
} t_conf_imgpaging;

typedef enum
{
	conf_thumb_none = 0,
	conf_thumb_scroll = 1,
	conf_thumb_always = 2
} t_conf_thumb;

typedef enum
{
	conf_infobar_none = 0,
	conf_infobar_info = 1,
	conf_infobar_lyric = 2
} t_conf_infobar;

typedef enum
{
	conf_vertread_horz = 0,//ˮƽ
	conf_vertread_rvert = 1, //ҷ
	conf_vertread_lvert = 2,//
	conf_vertread_reversal = 3//
} t_conf_vertread;

typedef enum
{
	SCREEN_UP = 0,
	SCREEN_DOWN,
	SCREEN_DOUBLE,
}SCREEN_USE;

typedef struct
{
//	char path[PATH_MAX2];
	char Upath[PATH_MAX2];
	dword forecolor;
	dword listbgcolor;
	dword bgcolor;
	BOOL have_bg;
	dword titlecolor;
	dword titlebcolor;
	dword menutextcolor;
	dword menubcolor;
	dword selicolor;
	dword selbcolor;
	dword selrcolor;
	dword msgbcolor;
	BOOL usedyncolor;
	U8 rowspace;
	t_conf_infobar infobar;
	BOOL rlastrow;
	BOOL autobm;
	dword vertread;
	t_conf_encode encode;
	t_conf_fit fit;
	BOOL imginfobar;
	BOOL scrollbar;
	dword scale;
	t_conf_rotate rotate;
	dword txtkey[20];
	dword imgkey[20];
//	char shortpath[PATH_MAX2];
	dword confver;
	BOOL bicubic;
	dword wordspace;
	dword borderspace;
	char lastfile[PATH_MAX2];
	t_conf_encode mp3encode;
	t_conf_encode lyricencode;
	t_conf_cycle mp3cycle;
	BOOL isreading;
	char bgarch[PATH_MAX2];
	char bgfile[PATH_MAX2];
	int bgwhere;
	dword slideinterval;
	BOOL hprmctrl;
	int grayscale;
	BOOL showhidden;
	BOOL showunknown;
	BOOL showfinfo;
	BOOL allowdelete;
	t_conf_arrange arrange;
	BOOL enableusb;
	t_conf_viewpos viewpos;
	dword imgmvspd;
	t_conf_imgpaging imgpaging;
	dword flkey[20];
	int fontsize;
	BOOL reordertxt;
	BOOL pagetonext;
	int autopage;
	int prev_autopage;
	int autopagetype;
	int autolinedelay;
	BOOL thumb;
	int bookfontsize;
	BOOL enable_analog;
	BOOL img_enable_analog;
	dword txtkey2[20];
	dword imgkey2[20];
	dword flkey2[20];
	dword imgpagereserve;
	dword lyricex;
	BOOL autoplay;
	BOOL usettf;
#if 0
	char cttfarch[PATH_MAX2];
	char cttfpath[PATH_MAX2];
	char ettfarch[PATH_MAX2];
	char ettfpath[PATH_MAX2];
#endif
	int freqs[3];
	int imgbrightness;
	BOOL dis_scrsave;
	int autosleep;
	BOOL load_exif;
	int launchtype;
	BOOL infobar_use_ttf_mode;
	BOOL cfont_antialias;
	BOOL cfont_cleartype;
	BOOL cfont_embolden;
	BOOL efont_antialias;
	BOOL efont_cleartype;
	BOOL efont_embolden;
	BOOL img_no_repeat;
	BOOL hide_flash;
	dword tabstop;
	BOOL apetagorder;
	
//------pdf---------------
	dword pdfmvspd;
	
//-------new add----------
	int  StyleIndex;
	SCREEN_USE ScreenUse;
	BOOL BacklightUp;
	BOOL BacklightDown;
	int brightness;
	int CategoryFlag;//0:ȫ 1: 2:ͼƬ 
	U16 MenuBarIndex;
	U32 edge_distance_y;
	int cur_lang_index;
	
	int fontcolor;
	int fontbgcolor;
//	int fontcolor_show;
	BOOL stylefcolor_inUse;
	BOOL stylefontbgcolor_inUse;
	
} t_conf, *p_conf;

/* txt key:
	0 - bookmark;
	1 - prevpage;
	2 - nextpage;
	3 - prev100;
	4 - next100;
	5 - prev500;
	6 - next500;
	7 - firstpage;
	8 - lastpage;
	9 - prevbook;
	10 - nextbook;
	11 - exitbook;
	above 11 - reversed for future version

   image key:
	0 - imageprev;
	1 - imagenext;
	2 - imagescaletype;
	3 - imagescalesmaller;
	4 - imagescalelarger;
	5 - imagerotateleft;
	6 - imagerotateright;
	7 - imagebar;
	8 - imageinfo;
	9 - imageexit;
	above 9 - reversed for future version
*/

extern void conf_set_file(const char *filename);
extern BOOL conf_load(p_conf conf);
extern BOOL conf_save(p_conf conf);
extern char *intToString(char *str, int size, int i);
extern char *dwordToString(char *str, int size, dword dw);

#endif
