/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include <datatype.h>
#include <Macro.h>
#include <ds2io2.h>
#include <scene_text.h>
#include <BacklightSet.h>
#include <ExitMessageBox.h>
#include <ctrl.h>
#include <key.h>
#include <scene_image.h>


#include <debugoff.h>

//--------------------------------------------------------------
extern BOOL Proc_Supend( U16 key )
{
	KEY_BUF inputkey;
	U32 timestamp;
	if( key == KEY_LID )
	{
		ds2_getrawInput( &inputkey );
		if( inputkey.key == KEY_LID )
		{
			ds2_setSupend();
			while( inputkey.key == KEY_LID )
			{
				ds2_getrawInput( &inputkey );
			}
			ds2_wakeup();

			//ָԭĿ״̬
			if( up_sw == OFF || down_sw == OFF )
			{
				TimeDly( 5 );
				timestamp = getSysTime();
				while( (getSysTime() - timestamp) < 200 );
				DS2_setBacklight( up_sw, down_sw );//
			}

			return true;
		}
	}
	return false;
}

extern BOOL Proc_ExitSys( U16 key )
{
	if( key == KEY_START )
	{
		TurnOn_down();//
		if( ExitMessage() )
			scene_exit();
		return true;
	}
	return false;
}

extern void Proc_SysKeyCheck( U16 key )
{
	Proc_ExitSys( key );
	Proc_Supend( key );
}

extern KEY_BUF ctrl_waitmove()
{
	int y_old;
	KEY_BUF inputkey;
	ds2_getrawInput( &inputkey );
	y_old = inputkey.y;
	while( inputkey.key == KEY_TOUCH )
	{
		ds2_getrawInput( &inputkey );

		Proc_SysKeyCheck( inputkey.key );

		if( inputkey.y != y_old )
			break;
	}
	return inputkey;
}

extern void ctrl_waitrelease( U16 key )
{
	KEY_BUF inputkey;
	
	if( key == 0 )
		return;
	do{
		ds2_getrawInput( &inputkey );
	}while( key == inputkey.key );
}

extern void ctrl_waitrelease_anykey( void )
{
	KEY_BUF inputkey;
	U16 key;
	
	ds2_getrawInput( &inputkey );
	key = inputkey.key;
	if( key == 0 )
		return;
	do{
		ds2_getrawInput( &inputkey );
	}while( key == inputkey.key && inputkey.key != 0 );
}

extern U16 ctrl_waitany()
{
	KEY_BUF inputkey;
	do{
		ds2_getrawInput( &inputkey );
	}while( inputkey.key == 0 );	
}
