 /* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"
#include <win.h>
#include <string.h>
#include <unzip.h>
#include "scene.h"
#include "conf.h"
#include "display.h"
#include "strsafe.h"
#include "fs.h"

#include <gdi.h>
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <MemMgr.h>
#include <datatype.h>
#include <config_ebook.h>

#include <debugoff.h>

//-----------------------------------------------------------------------------------------------
pixel *vram_start = NULL;
pixel *vram_start_up = NULL;
pixel *vram_start_down = NULL;
pixel *vram_start_temp = NULL;
/*static */ byte *localfont_buffer = NULL, *book_localfont_buffer = NULL;
/*static */ byte	*efont_buffer =	NULL, *book_efont_buffer = NULL;
int DISP_FONTSIZE = 12, DISP_BOOK_FONTSIZE = 12;
int menuwin_h = MENUWIN_H;
int menuwin_w = MENUWIN_W;
int HRR = 10;
//int HRR = MENUWIN_H / 12 - 1;
int WRR = MENUWIN_W / 12 - 1;
int use_ttf = 0;
static int DISP_EFONTSIZE, DISP_CFONTSIZE, DISP_CROWSIZE, DISP_EROWSIZE,
	fbits_last = 0, febits_last =0;
int DISP_BOOK_EFONTSIZE, DISP_BOOK_CFONTSIZE;
int DISP_BOOK_EROWSIZE, DISP_BOOK_CROWSIZE;
int fbits_book_last = 0, febits_book_last = 0;
byte disp_ewidth[0x80];

//#define ENABLE_TTF

#ifdef ENABLE_TTF
p_ttf ettf = NULL, cttf = NULL;
#endif

typedef struct _VertexColor
{
	pixel color;
	U16 x, y, z;
} VertexColor;

typedef struct _Vertex
{
	U16 u, v;
	pixel color;
	U16 x, y, z;
} Vertex;


//-----------------------------------------------------------------------------------------------
#define DISP_RSPAN 0

#define CHECK_DISPLAY_BORDER

#ifdef CHECK_DISPLAY_BORDER
#undef  CHECK_AND_VALID
#define CHECK_AND_VALID(x, y) \
{\
	x = (x < 0) ? 0 : x; \
	y = (y < 0) ? 0 : y; \
	x = (x >= SCREEN_W )? SCREEN_W - 1: x;\
	y = (y >= SCREEN_H )? SCREEN_H - 1: y;\
}

#define CHECK_AND_VALID_4(x1, y1, x2, y2) \
{\
	CHECK_AND_VALID(x1, y1);\
	CHECK_AND_VALID(x2, y2);\
}

#define CHECK_AND_VALID_WH(x, y, w, h) \
{\
	CHECK_AND_VALID(x, y);\
	w = x + w > SCREEN_W ? SCREEN_W - x : w; \
	h = y + h > SCREEN_H ? SCREEN_H - y : h; \
}
#else
#define CHECK_AND_VALID(x, y)
#define CHECK_AND_VALID_4(x1, y1, x2, y2)
#define CHECK_AND_VALID_WH(x, y, w, h)
#endif

//#define disp_get_vaddr(x, y) 0

//-----------------------------------------ȫֱ---------------------------------------
extern t_conf config;
extern pixel * bufferMain;
extern int MAX_ITEM_NAME_LEN;

extern int  cfont_space;
extern int  efont_space;

extern int  book_efont_space;
extern int  book_cfont_space;

extern U8 efont_space_table[12];


//-----------------------------------------ȫֺ---------------------------------------
extern void disp_free_font();

//---------------------------------------------------------------------------------------
extern void disp_init()
{
	vram_start = (pixel *)bufferMain;
	vram_start_down = (pixel *)bufferMain;
	vram_start_up = (pixel *)bufferSub;
}

unsigned int __attribute__ ((aligned(16))) list[262144];


#ifdef ENABLE_GE
extern void init_gu(void)
{
	sceGuInit();

	sceGuStart(GU_DIRECT, list);
	sceGuDrawBuffer(GU_PSM_8888,
					(void *) 0 + 512 * SCREEN_H * PIXEL_BYTES, 512);
	sceGuDispBuffer(SCREEN_W, SCREEN_H, (void *) 0, 512);
	sceGuDepthBuffer((void *) 0 + (U32) 4 * 512 * SCREEN_H +
					 (U32) 2 * 512 * SCREEN_H, 512);
	sceGuOffset(2048 - (SCREEN_W / 2), 2048 - (SCREEN_H / 2));
	sceGuViewport(2048, 2048, SCREEN_W, SCREEN_H);
	sceGuDepthRange(65535, 0);
	sceGuScissor(0, 0, SCREEN_W, SCREEN_H);
	sceGuEnable(GU_SCISSOR_TEST);
	sceGuFrontFace(GU_CW);
	sceGuClear(GU_COLOR_BUFFER_BIT | GU_DEPTH_BUFFER_BIT);
	sceGuEnable(GU_TEXTURE_2D);
	sceGuFinish();
	sceGuSync(0, 0);

	sceDisplayWaitVblankStart();
	sceGuDisplay(1);
}
#endif

extern void disp_putpixel(int x, int y, pixel color)
{
	CHECK_AND_VALID(x, y);
#ifndef ENABLE_GE
	*(pixel *) disp_get_vaddr((x), (y)) = (color);
#else
	sceGuStart(GU_DIRECT, list);
	VertexColor *vertices = (VertexColor *) sceGuGetMemory(sizeof(VertexColor));

	vertices[0].color = color;
	vertices[0].x = x;
	vertices[0].y = y;
	vertices[0].z = 0;
	sceGuDrawArray(GU_POINTS, GU_COLOR_8888 | GU_VERTEX_16BIT | GU_TRANSFORM_2D,
				   1, 0, vertices);
	sceGuFinish();
	sceGuSync(0, 0);
#endif
}

extern void disp_set_fontsize(int fontsize)
{
	if (!use_ttf)
		memset(disp_ewidth, 0, 0x80);
	DISP_FONTSIZE = fontsize;
	if (fontsize <= 16)
	{
		DISP_CROWSIZE = 2;
		DISP_EROWSIZE = 1;
		fbits_last = (1 << (16 - fontsize)) / 2;
		febits_last = (1 << (8 - fontsize / 2)) / 2;
	}
	else if (fontsize <= 24)
	{
		DISP_CROWSIZE = 3;
		DISP_EROWSIZE = 2;
		fbits_last = (1 << (24 - fontsize)) / 2;
		febits_last = (1 << (16 - fontsize / 2)) / 2;
	}
	else
	{
		DISP_CROWSIZE = 4;
		DISP_EROWSIZE = 2;
		fbits_last = (1 << (32 - fontsize)) / 2;
		febits_last = (1 << (16 - fontsize / 2)) / 2;
	}
	DISP_CFONTSIZE = DISP_FONTSIZE * DISP_CROWSIZE;
	DISP_EFONTSIZE = DISP_FONTSIZE * DISP_EROWSIZE;

	menuwin_w = MENUWIN_W;
	menuwin_h = MENUWIN_H;

	HRR = menuwin_h / (DISP_FONTSIZE+1) - 1;
	WRR = ( menuwin_w - 10 ) / DISP_FONTSIZE;

	HRR = MAX_ITEM_LINE;

	MAX_ITEM_NAME_LEN = WRR * 2;//WRRÿһռ2ֽ

	//------------------------------------------------
	if( fontsize >= 10 && fontsize <= 32 )
	{
		cfont_space = 0;
		efont_space = efont_space_table[(fontsize>>1) - 5];//5Ϊfont = 10ʱ2á
	}
	else
	{
		cfont_space = 0;
		efont_space = 0;
	}
	
	if( DISP_FONTSIZE == 10 )
		DISP_FONTSIZE = 11;
}

extern void disp_set_book_fontsize(int fontsize)
{
	DISP_BOOK_FONTSIZE = fontsize;
	if (fontsize <= 16)
	{
		DISP_BOOK_CROWSIZE = 2;
		DISP_BOOK_EROWSIZE = 1;
		fbits_book_last = (1 << (16 - fontsize)) / 2;
		febits_book_last = (1 << (8 - fontsize / 2)) / 2;
	}
	else if (fontsize <= 24)
	{
		DISP_BOOK_CROWSIZE = 3;
		DISP_BOOK_EROWSIZE = 2;
		fbits_book_last = (1 << (24 - fontsize)) / 2;
		febits_book_last = (1 << (16 - fontsize / 2)) / 2;
	}
	else
	{
		DISP_BOOK_CROWSIZE = 4;
		DISP_BOOK_EROWSIZE = 2;
		fbits_book_last = (1 << (32 - fontsize)) / 2;
		febits_book_last = (1 << (16 - fontsize / 2)) / 2;
	}
	DISP_BOOK_CFONTSIZE = DISP_BOOK_FONTSIZE * DISP_BOOK_CROWSIZE;
	DISP_BOOK_EFONTSIZE = DISP_BOOK_FONTSIZE * DISP_BOOK_EROWSIZE;

//------------------------------------------------
	if( fontsize >= 10 && fontsize <= 32 )
	{
		book_cfont_space = 0;
		book_efont_space = efont_space_table[(fontsize>>1) - 5];//5Ϊfont = 10ʱ2á
	}
	else
	{
		book_cfont_space = 0;
		book_efont_space = 0;
	}
	
	if( DISP_BOOK_FONTSIZE == 10 )
		DISP_BOOK_FONTSIZE = 11;
}

extern BOOL disp_has_zipped_font(const char *zipfile, const char *efont, const char *localfont)
{
	unzFile unzf = unzOpen(zipfile);

	if (unzf == NULL)
		return false;

#if CONFIG_ENFONTLIB
	if (unzLocateFile(unzf, efont, 0) != UNZ_OK
		|| unzOpenCurrentFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return false;
	}
	unzCloseCurrentFile(unzf);
#endif

	if (unzLocateFile(unzf, localfont, 0) != UNZ_OK
		|| unzOpenCurrentFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return false;
	}
	unzCloseCurrentFile(unzf);

	unzClose(unzf);
	return true;
}

extern BOOL disp_has_font(const char *efont, const char *localfont)
{
	FILE *fp;
#if CONFIG_ENFONTLIB
	fp = fopen( efont, "rb" );

	if( fp == 0 )
		return false;
	fclose(fp);
#endif

	fp = fopen( localfont, "rb" );

	if( fp == 0 )
		return false;
	fclose(fp);
	return true;
}

extern void disp_assign_book_font()
{
	use_ttf = 0;
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer)
	{
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer)
	{
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	book_efont_buffer = efont_buffer;
	book_localfont_buffer = localfont_buffer;
}

extern BOOL disp_load_zipped_font(const char *zipfile, const char *efont, const char *localfont)
{
	disp_free_font();
	unzFile unzf = unzOpen(zipfile);
	unz_file_info info;
	dword size;

	if (unzf == NULL)
		return false;

#if CONFIG_ENFONTLIB
	if (unzLocateFile(unzf, efont, 0) != UNZ_OK
		|| unzOpenCurrentFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return false;
	}
	if (unzGetCurrentFileInfo(unzf, &info, NULL, 0, NULL, 0, NULL, 0) != UNZ_OK) {
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	size = info.uncompressed_size;
	if ((efont_buffer = (byte *) malloc(size)) == NULL) {
		disp_free_font();
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	unzReadCurrentFile(unzf, efont_buffer, size);
	unzCloseCurrentFile(unzf);
	book_efont_buffer = efont_buffer;
#endif

	if (unzLocateFile(unzf, localfont, 0) != UNZ_OK
		|| unzOpenCurrentFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return false;
	}
	if (unzGetCurrentFileInfo(unzf, &info, NULL, 0, NULL, 0, NULL, 0) != UNZ_OK) {
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	size = info.uncompressed_size;
	if ((localfont_buffer = (byte *) malloc(size)) == NULL) {
		disp_free_font();
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	unzReadCurrentFile(unzf, localfont_buffer, size);
	unzCloseCurrentFile(unzf);
	book_localfont_buffer = localfont_buffer;

	unzClose(unzf);

	return true;
}

extern BOOL disp_load_font(const char *efont, const char *localfont)
{
//--------------------------------------------------------
	int size;
	FILE *fp = NULL;

//--------------------------------------------------------
	disp_free_font();
	
#if CONFIG_ENFONTLIB
	fp = fopen( efont, "rb" );
	if (fp == 0)
	{
		return false;
	}
	fseek(fp, 0, SEEK_END);
	size = ftell( fp );
	if ((efont_buffer = (byte *) calloc(1, size)) == NULL)
	{
		fclose(fp);
		return false;
	}
	fseek( fp, 0, SEEK_SET );
	fread( efont_buffer, 1, size, fp );
	fclose( fp );
	book_efont_buffer = efont_buffer;
#endif

	fp = fopen( localfont, "rb" );
	if (fp == 0)
	{
		disp_free_font();
		return false;
	}
	fseek(fp, 0, SEEK_END);
	size = ftell( fp );
	if ((localfont_buffer = (byte *) calloc(1, size)) == NULL)
	{
		disp_free_font();
		fclose( fp );
		return false;
	}
	fseek(fp, 0, SEEK_SET);
	fread( localfont_buffer, 1, size, fp );
	fclose( fp );
	book_localfont_buffer = localfont_buffer;

	return true;
}

extern BOOL disp_load_zipped_book_font(const char *zipfile, const char *efont, const char *localfont)
{
	use_ttf = 0;
#ifdef ENABLE_TTF
	if (ettf != NULL) {
		ttf_close(ettf);
		ettf = NULL;
	}
	if (cttf != NULL) {
		ttf_close(cttf);
		cttf = NULL;
	}
#endif
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer)
	{
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	unzFile unzf = unzOpen(zipfile);
	unz_file_info info;
	dword size;

	if (unzf == NULL)
	{
		return false;
	}

#if CONFIG_ENFONTLIB
	if (unzLocateFile(unzf, efont, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return false;
	}
	if (unzGetCurrentFileInfo(unzf, &info, NULL, 0, NULL, 0, NULL, 0) != UNZ_OK)
	{
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	size = info.uncompressed_size;
	if ((book_efont_buffer = (byte *) calloc(1, size)) == NULL)
	{
		disp_free_font();
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	unzReadCurrentFile(unzf, book_efont_buffer, size);
	unzCloseCurrentFile(unzf);
#endif

	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer)
	{
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	if (unzLocateFile(unzf, localfont, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return false;
	}
	if (unzGetCurrentFileInfo(unzf, &info, NULL, 0, NULL, 0, NULL, 0) != UNZ_OK)
	{
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	size = info.uncompressed_size;
	if ((book_localfont_buffer = (byte *) calloc(1, size)) == NULL)
	{
		disp_free_font();
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return false;
	}
	unzReadCurrentFile(unzf, book_localfont_buffer, size);
	unzCloseCurrentFile(unzf);

	unzClose(unzf);
	return true;
}

extern BOOL disp_load_book_font(const char *efont, const char *localfont)
{
//------------------------------------------------------------------
	int size;
	FILE *fp = NULL;

//------------------------------------------------------------------
	use_ttf = 0;
#ifdef ENABLE_TTF
	if (ettf != NULL) {
		ttf_close(ettf);
		ettf = NULL;
	}
	if (cttf != NULL) {
		ttf_close(cttf);
		cttf = NULL;
	}
#endif
	//Ӣֿ
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer) {
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	
#if CONFIG_ENFONTLIB
	fp = fopen(efont, "rb" );

	if (fp == 0)
		return false;
	fseek(fp, 0, SEEK_END);
	size = ftell( fp );
	if ((book_efont_buffer = (byte *) calloc(1, size)) == NULL)
	{
		fclose(fp);
		return false;
	}
	fseek(fp, 0, SEEK_SET);
	fread( book_efont_buffer, 1, size, fp );
	fclose(fp);
#endif

	//localֿ
	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer)
	{
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	fp = fopen(localfont, "rb" );
	if (fp == 0) {
		disp_free_font();
		return false;
	}
	fseek(fp, 0, SEEK_END);
	size = ftell( fp );
	if ((book_localfont_buffer = (byte *) calloc(1, size)) == NULL) {
		disp_free_font();
		fclose(fp);
		return false;
	}
	fseek(fp, 0, SEEK_SET);
	fread( book_localfont_buffer, 1, size, fp );
	fclose(fp);

	return true;
}

extern void disp_free_font()
{
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer) {
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer) {
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	if (efont_buffer != NULL) {
		free((void *) efont_buffer);
		efont_buffer = NULL;
	}
	if (localfont_buffer != NULL) {
		free((void *) localfont_buffer);
		localfont_buffer = NULL;
	}
	use_ttf = 0;
#ifdef ENABLE_TTF
	memset(disp_ewidth, 0, 0x80);
	if (ettf != NULL) {
		ttf_close(ettf);
		ettf = NULL;
	}
	if (cttf != NULL) {
		ttf_close(cttf);
		cttf = NULL;
	}
#endif
}

#ifdef ENABLE_GE
void *framebuffer = 0;
#endif

extern void disp_flip()
{

}

BOOL check_range(int x, int y)
{
	return x >= 0 && x < SCREEN_W && y >= 0 && y < SCREEN_H;
}

extern void disp_putnstring(int x, int y, pixel color, const byte * str,
							int count, dword wordspace, int top, int height,
							int bot)
{

}

extern void disp_putnstringreversal_sys(int x, int y, pixel color,
										const byte * str, int count,
										dword wordspace, int top, int height,
										int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

	if (bot) {
		if (y >= bot)
			return;
		if (y + height > bot)
			height = bot - y;
	}

	CHECK_AND_VALID(x, y);

	x = SCREEN_W - x - 1, y = SCREEN_H - y - 1;

	if (x < 0 || y < 0)
		return;

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_FONTSIZE;
				y -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);
			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));

			ccur = localfont_buffer + pos * DISP_CFONTSIZE + top * DISP_CROWSIZE;

			for (cend = ccur + height * DISP_CROWSIZE; ccur < cend; ccur++) {
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint--;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint--;
				}
				vaddr -= 512;
			}
			str += 2;
			count -= 2;
			x -= DISP_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_FONTSIZE / 2;
				y -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					efont_buffer + ((dword) * str) * DISP_EFONTSIZE +
					top * DISP_EROWSIZE;
				for (cend = ccur + height * DISP_EROWSIZE; ccur < cend; ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint--;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint--;
					}
					vaddr -= 512;
				}
				x -= DISP_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_FONTSIZE / 2;
				y -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			str++;
			count--;
			x -= DISP_FONTSIZE / 2 + wordspace;
		}
	}
}

extern void disp_putnstringreversal(int x, int y, pixel color, const byte * str,
									int count, dword wordspace, int top,
									int height, int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

#ifdef ENABLE_TTF
	if (use_ttf) {
		disp_putnstring_reversal_truetype(cttf, ettf, x, y, color, str, count,
										  wordspace, top, height, bot);
		return;
	}
#endif

	if (bot) {
		if (y >= bot)
			return;
		if (y + height > bot)
			height = bot - y;
	}

	CHECK_AND_VALID(x, y);

	x = SCREEN_W - x - 1, y = SCREEN_H - y - 1;

	if (x < 0 || y < 0)
		return;

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE;
				y -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);
			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));
			ccur =
				book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE +
				top * DISP_BOOK_CROWSIZE;

			for (cend = ccur + height * DISP_BOOK_CROWSIZE; ccur < cend; ccur++) {
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint--;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint--;
				}
				vaddr -= 512;
			}
			str += 2;
			count -= 2;
			x -= DISP_BOOK_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2;
				y -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE +
					top * DISP_BOOK_EROWSIZE;
				for (cend = ccur + height * DISP_BOOK_EROWSIZE; ccur < cend;
					 ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint--;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_book_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint--;
					}
					vaddr -= 512;
				}
				x -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (x < 0) {
				break;
#if 0
				x = SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2;
				y -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			int j;

			for (j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j)
				x -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			str++;
			count--;
		}
	}
}

extern void disp_putnstringhorz_sys(int x, int y, pixel color, const byte * str,
									int count, dword wordspace, int top,
									int height, int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

	if (bot) {
		if (y >= bot)
			return;
		if (y + height > bot)
			height = bot - y;
	}

	CHECK_AND_VALID(x, y);

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (x > SCREEN_W - DISP_RSPAN - DISP_FONTSIZE) {
				break;
#if 0
				x = 0;
				y += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);
			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));
			ccur = localfont_buffer + pos * DISP_CFONTSIZE + top * DISP_CROWSIZE;

			for (cend = ccur + height * DISP_CROWSIZE; ccur < cend; ccur++) {
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint++;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint++;
				}
				vaddr += 512;
			}
			str += 2;
			count -= 2;
			x += DISP_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (x > SCREEN_W - DISP_RSPAN - DISP_FONTSIZE / 2) {
				break;
#if 0
				x = 0;
				y += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					efont_buffer + ((dword) * str) * DISP_EFONTSIZE +
					top * DISP_EROWSIZE;
				for (cend = ccur + height * DISP_EROWSIZE; ccur < cend; ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint++;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint++;
					}
					vaddr += 512;
				}
				x += DISP_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (x > SCREEN_W - DISP_RSPAN - DISP_FONTSIZE / 2) {
				break;
#if 0
				x = 0;
				y += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			str++;
			count--;
			x += DISP_FONTSIZE / 2 + wordspace;
		}
	}
}

extern void disp_putnstringhorz(int x, int y, pixel color, const byte * str, int count, dword wordspace, int top, int height, int bot, int engine )//bot:׶
{
	if (bot)
	{
		if ( y >= bot )
			return;
		if (y + height > bot)
			height = bot - y;
	}

	CHECK_AND_VALID(x, y);

	CB_putnstringhorz_sys( x, y, wordspace, str, count, color, engine, DISP_BOOK_FONTSIZE, DISP_BOOK_FONTSIZE );
	return;
}

extern void disp_putnstringhorz2(int x, int y, pixel color, const byte * str, int count, dword wordspace, int engine )
{
	pixel *vaddr;
	const byte *ccur, *cend;

	CHECK_AND_VALID(x, y);

	while (*str != 0 && count > 0)
	{
		if (*str > 0x80)
		{
			if (x > SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE)
			{
				break;
			}
			if (!check_range(x, y))
				return;

			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else
				vaddr = disp_get_vaddr_up(x, y);

			dword pos = (((dword) (*str - 0x81)) * 0xBF + ((dword) (*(str + 1) - 0x40)));
			ccur = book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE;

			for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0)
				{
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint++;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint++;
				}
				vaddr += SCREEN_W;
			}
			str += 2;
			count -= 2;
			x += DISP_BOOK_FONTSIZE + wordspace * 2;
		}
		else if (*str > 0x1F)
		{
			if (x > SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2)
			{
				break;
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur = book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE;
				for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_EROWSIZE; ccur < cend;
					 ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint++;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_book_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint++;
					}
					vaddr += SCREEN_W;
				}
				x += DISP_BOOK_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		}
		else
		{
			if (x > SCREEN_W - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2) {
				break;
		}
			if (!check_range(x, y))
				return;
			int j;

			for (j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j)
				x += DISP_BOOK_FONTSIZE / 2 + wordspace;
			str++;
			count--;
		}
	}
}

extern void disp_putnstringlvert_sys(int x, int y, pixel color,
									 const byte * str, int count,
									 dword wordspace, int top, int height,
									 int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

	if (bot) {
		if (x >= bot)
			return;
		if (x + height > bot)
			height = bot - x;
	}

	CHECK_AND_VALID(x, y);

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (y < DISP_RSPAN + DISP_FONTSIZE - 1) {
				break;
#if 0
				y = 271;
				x += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);
			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));
			ccur = localfont_buffer + pos * DISP_CFONTSIZE + top * DISP_CROWSIZE;

			for (cend = ccur + height * DISP_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint -= 512;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint -= 512;
				}
				vaddr++;
			}
			str += 2;
			count -= 2;
			y -= DISP_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (y < DISP_RSPAN + DISP_FONTSIZE - 1) {
				break;
#if 0
				y = 271;
				x += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					efont_buffer + ((dword) * str) * DISP_EFONTSIZE +
					top * DISP_EROWSIZE;
				for (cend = ccur + height * DISP_EROWSIZE; ccur < cend; ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint -= 512;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint -= 512;
					}
					vaddr++;
				}
				y -= DISP_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (y < DISP_RSPAN + DISP_FONTSIZE - 1) {
				break;
#if 0
				y = 271;
				x += DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			str++;
			count--;
			y -= DISP_FONTSIZE / 2 + wordspace;
		}
	}
}

extern void disp_putnstringlvert(int x, int y, pixel color, const byte * str,
								 int count, dword wordspace, int top,
								 int height, int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

#ifdef ENABLE_TTF
	if (use_ttf) {
		disp_putnstring_lvert_truetype(cttf, ettf, x, y, color, str, count,
									   wordspace, top, height, bot);
		return;
	}
#endif

	if (bot)
	{
		if (x >= bot)
			return;
		if (x + height > bot)
			height = bot - x;
	}

	CHECK_AND_VALID(x, y);

	while (*str != 0 && count > 0)
	{
		if (*str > 0x80)
		{
			if (y < DISP_BOOK_FONTSIZE - 1)//һ
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);
			dword pos = (((dword) (*str - 0x81)) * 0xBF + ((dword) (*(str + 1) - 0x40)));
			ccur = book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE;

			height = 12;
			for (cend = ccur + height * DISP_BOOK_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0)
				{
					for( b = 0x80; b > 0; b >>= 1 )
					{
						if ( ((*ccur) & b ) != 0 )
							*vpoint = color;
						vpoint -= SCREEN_W;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1)
				{
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint -= SCREEN_W;
				}
				vaddr++;
			}
			str += 2;
			count -= 2;
			y -= DISP_BOOK_FONTSIZE + wordspace * 2;
		}
		else if (*str > 0x1F)
		{
			if (y < DISP_BOOK_FONTSIZE / 2 - 1)
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur = book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE + top * DISP_BOOK_EROWSIZE;
				for( cend = ccur + height * DISP_BOOK_EROWSIZE; ccur < cend; ccur++ )
				{
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0)
					{
						for (b = 0x80; b > 0; b >>= 1)
						{
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint -= 512;
						}
						++ccur;
						bitsleft -= 8;
					}
					for( b = 0x80; b > febits_book_last; b >>= 1 )
					{
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint -= 512;
					}
					vaddr++;
				}
				y -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		}
		else
		{
			if (y < DISP_BOOK_FONTSIZE / 2 - 1)
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			int j;

			for ( j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j )
				y -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			str++;
			count--;
		}
	}
}
 
extern void disp_putnstringlvert2( int x, int y, pixel color, const byte * str, int count, dword wordspace, SCREEN_ID engine )
{
	pixel *vaddr;
	const byte *ccur, *cend;

	CHECK_AND_VALID(x, y);

	if( x + DISP_BOOK_FONTSIZE > SCREEN_W )
		return;

	while( *str != 0 && count > 0 )
	{
		if (*str > 0x80)
		{
			if (y < DISP_BOOK_FONTSIZE - 1)//һ
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;

			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else
				vaddr = disp_get_vaddr_up(x, y);

			dword pos = (((dword) (*str - 0x81)) * 0xBF + ((dword) (*(str + 1) - 0x40)));
			ccur = book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE;

			for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0)
				{
					for( b = 0x80; b > 0; b >>= 1 )
					{
						if ( ((*ccur) & b ) != 0 )
							*vpoint = color;
						vpoint -= SCREEN_W;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1)
				{
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint -= SCREEN_W;
				}
				vaddr++;
			}
			str += 2;
			count -= 2;
			y -= DISP_BOOK_FONTSIZE + wordspace * 2;
		}
		else if (*str > 0x1F)
		{
			if (y < DISP_BOOK_FONTSIZE / 2 - 1)
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else
				vaddr = disp_get_vaddr_up(x, y);

			{
				ccur = book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE;
				for( cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_EROWSIZE; ccur < cend; ccur++ )
				{
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0)
					{
						for (b = 0x80; b > 0; b >>= 1)
						{
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint -= SCREEN_W;
						}
						++ccur;
						bitsleft -= 8;
					}
					for( b = 0x80; b > febits_book_last; b >>= 1 )
					{
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint -= SCREEN_W;
					}
					vaddr++;
				}
				y -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		}
		else
		{
			if (y < DISP_BOOK_FONTSIZE / 2 - 1)
			{
				break;
#if 0
				y = 271;
				x += DISP_BOOK_FONTSIZE;
#endif
			}
			if ( !check_range(x, y) )
				return;
			int j;

			for ( j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j )
				y -= DISP_BOOK_FONTSIZE / 2 + wordspace;
			str++;
			count--;
		}
	}
}


extern void disp_putnstringrvert_sys(int x, int y, pixel color,
									 const byte * str, int count,
									 dword wordspace, int top, int height,
									 int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

	CHECK_AND_VALID(x, y);

	if (x < bot)
		return;
	if (x + 1 - height < bot)
		height = x + 1 - bot;

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (y > SCREEN_H - DISP_RSPAN - DISP_FONTSIZE) {
				break;
#if 0
				y = 0;
				x -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));
			ccur = localfont_buffer + pos * DISP_CFONTSIZE + top * DISP_CROWSIZE;

			for (cend = ccur + height * DISP_CROWSIZE; ccur < cend; ccur++) {
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += 512;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint += 512;
				}
				vaddr--;
			}
			str += 2;
			count -= 2;
			y += DISP_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (y > SCREEN_H - DISP_RSPAN - DISP_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					efont_buffer + ((dword) * str) * DISP_EFONTSIZE +
					top * DISP_EROWSIZE;
				for (cend = ccur + height * DISP_EROWSIZE; ccur < cend; ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint += 512;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += 512;
					}
					vaddr--;
				}
				y += DISP_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (y > SCREEN_H - DISP_RSPAN - DISP_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			str++;
			count--;
			y += DISP_FONTSIZE / 2 + wordspace;
		}
	}
}

#if 0
extern void disp_putnstringrvert(int x, int y, pixel color, const byte * str,
								 int count, dword wordspace, int top,
								 int height, int bot)
{
	pixel *vaddr;
	const byte *ccur, *cend;

#ifdef ENABLE_TTF
	if (use_ttf) {
		disp_putnstring_rvert_truetype(cttf, ettf, x, y, color, str, count,
									   wordspace, top, height, bot);
		return;
	}
#endif

	CHECK_AND_VALID(x, y);

	if (x < bot)
		return;
	if (x + 1 - height < bot)
		height = x + 1 - bot;

	while (*str != 0 && count > 0) {
		if (*str > 0x80) {
			if (y > SCREEN_H - DISP_RSPAN - DISP_BOOK_FONTSIZE) {
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			dword pos =
				(((dword) (*str - 0x81)) * 0xBF +
				 ((dword) (*(str + 1) - 0x40)));
			ccur =
				book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE +
				top * DISP_BOOK_CROWSIZE;

			for (cend = ccur + height * DISP_BOOK_CROWSIZE; ccur < cend; ccur++) {
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += 512;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint += 512;
				}
				vaddr--;
			}
			str += 2;
			count -= 2;
			y += DISP_BOOK_FONTSIZE + wordspace * 2;
		} else if (*str > 0x1F) {
			if (y > SCREEN_H - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			vaddr = disp_get_vaddr(x, y);

			{
				ccur =
					book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE +
					top * DISP_BOOK_EROWSIZE;
				for (cend = ccur + height * DISP_BOOK_EROWSIZE; ccur < cend;
					 ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint += 512;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_book_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += 512;
					}
					vaddr--;
				}
				y += DISP_BOOK_FONTSIZE / 2 + wordspace;
			}
			str++;
			count--;
		} else {
			if (y > SCREEN_H - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			int j;

			for (j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j)
				y += DISP_BOOK_FONTSIZE / 2 + wordspace;
			str++;
			count--;
		}
	}
}
#endif


void disp_putnstringrvert( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int fontw, int fonth )
{
	pixel *vaddr;
	const byte *ccur, *cend;

	CHECK_AND_VALID(x, y);


	while (*str != 0 && count > 0)
	{
		if (*str > 0x80)
		{
			if (y > SCREEN_H - DISP_BOOK_FONTSIZE) {//һ
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;

			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else if( engine == UP_SCREEN )
				vaddr = disp_get_vaddr_up(x, y);
			else
			{
				vram_start_temp = bufferTemp;
				if( vram_start_temp == NULL )
					return;
				vaddr = disp_get_vaddr_temp(x, y);
			}

			dword pos = (((dword) (*str - 0x81)) * 0xBF + ((dword) (*(str + 1) - 0x40)));
			ccur = book_localfont_buffer + pos * DISP_BOOK_CFONTSIZE;

			for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1)
					{
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += SCREEN_W;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = color;
					vpoint += SCREEN_W;
				}
				vaddr--;
			}
			str += 2;
			count -= 2;
//			y += DISP_BOOK_FONTSIZE + wordspace * 2;
			y += DISP_BOOK_FONTSIZE + wordspace;
		}
		else if (*str > 0x1F)
		{
			if (y > SCREEN_H - DISP_RSPAN - DISP_BOOK_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;

			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else if( engine == UP_SCREEN )
				vaddr = disp_get_vaddr_up(x, y);
			else
			{
				vram_start_temp = bufferTemp;
				if( vram_start_temp == NULL )
					return;
				vaddr = disp_get_vaddr_temp(x, y);
			}

			{
				ccur = book_efont_buffer + ((dword) * str) * DISP_BOOK_EFONTSIZE;
				for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_EROWSIZE; ccur < cend;
					 ccur++) {
					int b;
					pixel *vpoint = vaddr;
					int bitsleft = DISP_BOOK_FONTSIZE / 2 - 8;

					while (bitsleft > 0) {
						for (b = 0x80; b > 0; b >>= 1) {
							if (((*ccur) & b) != 0)
								*vpoint = color;
							vpoint += SCREEN_W;
						}
						++ccur;
						bitsleft -= 8;
					}
					for (b = 0x80; b > febits_book_last; b >>= 1) {
						if (((*ccur) & b) != 0)
							*vpoint = color;
						vpoint += SCREEN_W;
					}
					vaddr--;
				}

				y += DISP_BOOK_FONTSIZE / 2 + wordspace;
				if( bookfonts[bookfontindex_cur].size == 10 )
					y += 1;
			}
			str++;
			count--;
		}
		else
		{
			if (y > SCREEN_H - DISP_BOOK_FONTSIZE / 2) {
				break;
#if 0
				y = 0;
				x -= DISP_BOOK_FONTSIZE;
#endif
			}
			if (!check_range(x, y))
				return;
			int j;

			for (j = 0; j < (*str == 0x09 ? config.tabstop : 1); ++j)
			{
				y += DISP_BOOK_FONTSIZE / 2 + wordspace;
				if( bookfonts[bookfontindex_cur].size == 10 )
					y += 1;
			}
			str++;
			count--;
		}
	}
}

//extern void disp_fillvram( pixel color, int engine )
//{
//	FillVram( color, engine );
//}

extern void disp_fillrect(dword x1, dword y1, dword x2, dword y2, pixel color, int engine )
{
	FillRect( x1, y1, x2, y2, color, engine );
}

extern void disp_rectangle( dword x1, dword y1, dword x2, dword y2, pixel color, int engine )
{
	DrawRect( x1, y1, x2-x1, y2-y1, color, engine );
}

extern void disp_rectangle2( dword x1, dword y1, dword x2, dword y2, pixel color )
{
}
extern void disp_line( dword x1, dword y1, dword x2, dword y2, pixel color, int engine )
{
	DrawLine( x1, y1, x2, y2, color, engine );
}

#if 0

#ifdef ENABLE_TTF
static BOOL load_ttf_config(void)
{
	ttf_set_anti_alias(cttf, config.cfont_antialias);
	ttf_set_anti_alias(ettf, config.efont_antialias);
	ttf_set_cleartype(cttf, config.cfont_cleartype);
	ttf_set_cleartype(ettf, config.efont_cleartype);
	ttf_set_embolden(cttf, config.cfont_embolden);
	ttf_set_embolden(ettf, config.efont_embolden);

	return true;
}
#endif

extern BOOL disp_load_truetype_book_font(const char *ettffile,
										 const char *cttffile, int size)
{
#ifdef ENABLE_TTF
	use_ttf = 0;
	memset(disp_ewidth, size / 2, 0x80);
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer) {
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer) {
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	if (ettf == NULL) {
		if ((ettf = ttf_open(ettffile, size)) == NULL) {
			return false;
		}
	} else {
		ttf_set_pixel_size(ettf, size);
	}
	if (cttf == NULL) {
		if ((cttf = ttf_open(cttffile, size)) == NULL) {
			return false;
		}
	} else {
		ttf_set_pixel_size(cttf, size);
	}

	load_ttf_config();

	ttf_load_ewidth(ettf, disp_ewidth, 0x80);
	use_ttf = 1;
	return true;
#else
	return false;
#endif
}

#ifdef ENABLE_TTF
static p_ttf load_archieve_truetype_book_font(const char *zipfile,
											  const char *zippath, int size)
{
	p_ttf ttf = NULL;

	if (ttf == NULL && zipfile[0] != '\0') {
		buffer *b = NULL;

		extract_archive_file_into_buffer(&b, zipfile, zippath,
										 fs_file_get_type(zipfile));

		if (b == NULL) {
			return false;
		}

		if ((ttf = ttf_open_buffer(b->ptr, b->used, size, zippath)) == NULL) {
			buffer_free_weak(b);
			return false;
		}
		buffer_free_weak(b);
	} else {
		ttf_set_pixel_size(ttf, size);
	}

	use_ttf = 1;
	return ttf;
}
#endif

extern BOOL disp_load_zipped_truetype_book_font(const char *ezipfile,
												const char *czipfile,
												const char *ettffile,
												const char *cttffile, int size)
{
#ifdef ENABLE_TTF
	static char prev_ettfpath[PATH_MAX2] = "", prev_ettfarch[PATH_MAX2] = "";
	static char prev_cttfpath[PATH_MAX2] = "", prev_cttfarch[PATH_MAX2] = "";

	use_ttf = 0;
	memset(disp_ewidth, size / 2, 0x80);
	if (book_efont_buffer != NULL && efont_buffer != book_efont_buffer) {
		free((void *) book_efont_buffer);
		book_efont_buffer = NULL;
	}
	if (book_localfont_buffer != NULL && localfont_buffer != book_localfont_buffer) {
		free((void *) book_localfont_buffer);
		book_localfont_buffer = NULL;
	}
	if (ettf != NULL && strcmp(prev_ettfarch, config.ettfarch) == 0
		&& strcmp(prev_ettfpath, config.ettfpath) == 0) {
		ttf_set_pixel_size(ettf, size);
	} else {
		ttf_close(ettf);
		ettf = NULL;
		if (config.ettfarch[0] != '\0') {
			ettf =
				load_archieve_truetype_book_font(config.ettfarch,
												 config.ettfpath,
												 config.bookfontsize);
		} else {
			ettf = ttf_open(config.ettfpath, config.bookfontsize);
		}
		STRCPY_S(prev_ettfarch, config.ettfarch);
		STRCPY_S(prev_ettfpath, config.ettfpath);
	}
	if (cttf != NULL && strcmp(prev_cttfarch, config.cttfarch) == 0
		&& strcmp(prev_cttfpath, config.cttfpath) == 0) {
		ttf_set_pixel_size(cttf, size);
	} else {
		if (cttf != NULL) {
			ttf_close(cttf);
			cttf = NULL;
		}
		if (config.cttfarch[0] != '\0') {
			cttf =
				load_archieve_truetype_book_font(config.cttfarch,
												 config.cttfpath,
												 config.bookfontsize);
		} else {
			cttf = ttf_open(config.cttfpath, config.bookfontsize);
		}
		STRCPY_S(prev_cttfarch, config.cttfarch);
		STRCPY_S(prev_cttfpath, config.cttfpath);
	}

	if (cttf == NULL || ettf == NULL)
		return false;

	load_ttf_config();

	ttf_load_ewidth(ettf, disp_ewidth, 0x80);
	use_ttf = 1;
	return true;
#else
	return false;
#endif
}

#endif
