/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <datatype.h>
#include <config_ebook.h>
#include <ds2io.h>

#define		disp_fillvram( color, engine ) 		FillVram( color, engine )

#define 	DISP_RSPAN 	0

extern int DISP_FONTSIZE, DISP_BOOK_FONTSIZE, HRR, WRR;
extern byte disp_ewidth[0x80];
extern byte	*efont_buffer, *book_efont_buffer;
extern byte	*cfont_buffer, *book_cfont_buffer;

// R,G,B color to word value color
#ifdef COLOR16BIT
typedef word pixel;

#define PIXEL_BYTES 	2
#define COLOR_MAX 		31
#define COLOR_WHITE 	0xFFFF
#define COLOR_BLACK 	0x0000
#define COLOR_RED  	 	RGB15( 0x1f,0,0 )
#define COLOR_GREEN   	RGB15( 0,0x1f,0 )
#define COLOR_BLUE    	RGB15( 0,0,0x1f )


//#define RGB(r,g,b) ( (((pixel)(b)*31/255)<<10)|(((pixel)(g)*31/255)<<5)|((pixel)(r)*31/255)|BIT(15) )
#define RGB2(r,g,b) ((((pixel)(b))<<10)|(((pixel)(g))<<5)|((pixel)(r))|0x8000)
#define RGBA(r,g,b,a) ((((pixel)(b))<<10)|(((pixel)(g))<<5)|((pixel)(r))|((a)?0x8000:0))
#define RGB_R(c) ((c) & 0x1F)
#define RGB_G(c) (((c) >> 5) & 0x1F)
#define RGB_B(c) (((c) >> 10) & 0x1F)
#define RGB_16to32(c) (c)

#if COLOR_ADJUST //ɫУ

#define RGB24_B(c) ((c) & 0xFF)
#define RGB24_G(c) (((c) >> 8) & 0xFF)
#define RGB24_R(c) (((c) >> 16) & 0xFF)

#else

#define RGB24_R(c) ((c) & 0xFF)
#define RGB24_G(c) (((c) >> 8) & 0xFF)
#define RGB24_B(c) (((c) >> 16) & 0xFF)

#endif

//RGB16RGB24
#define RGB_16To24( InColor )  RGB24(  RGB_R( InColor ) * 255 / 31, RGB_G( InColor ) * 255 / 31, RGB_B( InColor ) * 255 / 31 )

//RGB24RGB16
#define RGB_24To16( InColor )  RGB15(  RGB24_R( InColor ) * 31 / 255, RGB24_G( InColor ) * 31 / 255, RGB24_B( InColor ) * 31 / 255 )

#else

typedef dword pixel;
#define PIXEL_BYTES 4
#define COLOR_MAX 255
#define COLOR_WHITE 0xFFFFFFFF
#define COLOR_BLACK 0x00000000
#define COLOR_RED   RGB24( 0XFF,0,0 )


#define RGB(r,g,b) ((((pixel)(r))<<16)|(((pixel)(g))<<8)|((pixel)(b))|0xFF000000)
#define RGB2(r,g,b) ((((pixel)(b))<<16)|(((pixel)(g))<<8)|((pixel)(r))|0xFF000000)
#define RGBA(r,g,b,a) ((((pixel)(b))<<16)|(((pixel)(g))<<8)|((pixel)(r))|(((pixel)(a))<<24))
#define RGB_R(c) ((c) & 0xFF)
#define RGB_G(c) (((c) >> 8) & 0xFF)
#define RGB_B(c) (((c) >> 16) & 0xFF)
#define RGB_16to32(c) RGBA((((c)&0x1F)*255/31),((((c)>>5)&0x1F)*255/31),((((c)>>10)&0x1F)*255/31),((c&0x8000)?0xFF:0))
#endif

#define disp_grayscale(c,r,g,b,gs) RGB2(((r)*(gs)+RGB_R(c)*(100-(gs)))/100,((g)*(gs)+RGB_G(c)*(100-(gs)))/100,((b)*(gs)+RGB_B(c)*(100-(gs)))/100)

extern pixel *vram_start;
extern pixel *vram_start_up;
extern pixel *vram_start_down;

extern byte *localfont_buffer, *book_localfont_buffer;
extern byte	*efont_buffer, *book_efont_buffer;
extern int fbits_book_last, febits_book_last;
extern int DISP_BOOK_EFONTSIZE, DISP_BOOK_CFONTSIZE;
extern int DISP_BOOK_EROWSIZE, DISP_BOOK_CROWSIZE;
#define disp_get_vaddr(x, y) ( vram_start + (x) + ( (y) * SCREEN_W ) )
#define disp_get_vaddr_up(x, y) ( vram_start_up + (x) + ( (y) * SCREEN_W ) )
#define disp_get_vaddr_down(x, y) ( vram_start_down + (x) + ( (y) * SCREEN_W ) )
#define disp_get_vaddr_temp(x, y) ( vram_start_temp + (x) + ( (y) * SCREEN_W ) )

#define disp_putstring(x,y,color,str) { DrawTextLine( x,y,SCREEN_W-1,str,color,0 );}

#define disp_waitv() 

U32 RGB_Convert( U32 Incolor, U8 InColorBit, U8 OutColorBit );

extern void disp_init();
extern BOOL disp_load_zipped_font(const char *zipfile, const char *efont, const char *cfont);
extern BOOL disp_load_font(const char *efont, const char *cfont);
extern void disp_set_fontsize(int fontsize);
extern void disp_assign_book_font();
extern void disp_set_book_fontsize(int fontsize);
extern BOOL disp_load_book_font(const char *efont, const char *cfont);
extern BOOL disp_load_zipped_book_font(const char *zipfile, const char *efont, const char *cfont);
extern BOOL disp_has_zipped_font(const char *zipfile, const char *efont, const char *cfont);
extern BOOL disp_has_font(const char *efont, const char *cfont);
extern void disp_putnstringrvert2( int x, int y, pixel color, const byte * str, int count, dword wordspace, SCREEN_ID engine );
extern void disp_putnstringreversal(int x, int y, pixel color, const byte * str,
									int count, dword wordspace, int top,
									int height, int bot);
extern void disp_putnstringhorz(int x, int y, pixel color, const byte * str, int count, dword wordspace, int top, int height, int bot, int engine );

//extern void disp_putnstringrvert(int x, int y, pixel color, const byte * str,
//								 int count, dword wordspace, int top,
//								 int height, int bot);

extern void disp_putnstringlvert2( int x, int y, pixel color, const byte * str, int count, dword wordspace, SCREEN_ID engine );
void disp_putnstringrvert( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int fontw, int fonth );


extern pixel *vram_start_up;
extern pixel *vram_start_down;
extern pixel *vram_start_temp;


#ifdef __cplusplus
}
#endif

#endif
