#--------------------------------------------------------------
# 
#--------------------------------------------------------------
ENABLE_EBOOK		:=	1
ENABLE_FREETYPE2	:=	1
ENABLE_JBIG2DEC		:=	1
ENABLE_PDF			:=	1


ENABLE_IMAGE		:=	1
ENABLE_JPEG			:=	0
ENABLE_JPEG6B		:=	1
ENABLE_BMP			:=	1
ENABLE_GIF			:=	0
ENABLE_GIF_MS		:=	1
ENABLE_PNG			:=	1
ENABLE_TIF			:=	1

ENABLE_KEY			:=	1
ENABLE_UNZIP		:=	1
ENABLE_ZLIB			:=  1

#
DEBUG_LHM			:= 0

#------------------------------------------------------------
# edition 0:cn 1:en 2:jp 3:tw
#------------------------------------------------------------
CONFIG_EDITION		:= 0

#------------------------------------------------------------
IMAGE_OBJS			:=
EBOOKOTHER_OBJS		:=

#------------------------------------------------------------
# Image
#------------------------------------------------------------
ifeq ($(ENABLE_IMAGE), 1)

ifeq ($(ENABLE_BMP), 1)
include $(EBOOKDIR)/bmp/bmp.mk
endif

ifeq ($(ENABLE_GIF), 1)
include $(EBOOKDIR)/gif/gif.mk
endif

ifeq ($(ENABLE_GIF_MS), 1)
include $(EBOOKDIR)/gif/gif.mk
endif

ifeq ($(ENABLE_JPEG), 1)
#include $(EBOOKDIR)/jpeg/jpeg.mk
endif

ifeq ($(ENABLE_JPEG6B), 1)
#include $(EBOOKDIR)/jpeg6b/jpeg6b.mk
endif

ifeq ($(ENABLE_TIF), 1)
include $(EBOOKDIR)/tiff/tif.mk
endif

ifeq ($(ENABLE_PNG), 1)
include $(EBOOKDIR)/png/png.mk
endif

endif


#------------------------------------------------------------
# others
#------------------------------------------------------------
include $(EBOOKDIR)/gdi/gdi.mk

ifeq ($(ENABLE_KEY),1)
include $(EBOOKDIR)/key/key.mk
endif

#include $(EBOOKDIR)/zlib/zlib.mk

include $(EBOOKDIR)/mem/mem.mk

#---------------------------------------------------------------
# MemMgr
#---------------------------------------------------------------
include $(EBOOKDIR)/MemMgr/MemMgr.mk

#---------------------------------------------------------------
# unzip
#---------------------------------------------------------------
ifeq ($(ENABLE_UNZIP),1)
include $(EBOOKDIR)/unzip/unzip.mk
endif

#---------------------------------------------------------------
# PDF
#---------------------------------------------------------------
MUPDF_X86 = 0
include $(EBOOKDIR)/sumatrapdf/sumatrapdf.mk

#---------------------------------------------------------------
# ebook src
#---------------------------------------------------------------
ifeq ($(ENABLE_EBOOK),1)

SOURCE_EBOOK	:=  $(EBOOKDIR) $(EBOOKDIR)/common
EBOOK_SRCS		:=  $(foreach dir,$(SOURCE_EBOOK),$(notdir $(wildcard $(dir)/*.c)))
EBOOK_CPPSRCS	:=  $(foreach dir,$(SOURCE_EBOOK),$(notdir $(wildcard $(dir)/*.cpp)))
#EBOOK_SRCS := charsets.c ctrl.c ebook_main.c scene.c utils.c zoom.c debug_lhm.c mystring.c

EBOOK_OBJS :=  $(EBOOK_SRCS:.c=.o)
EBOOK_OBJS +=  $(EBOOK_CPPSRCS:.cpp=.o)
#OBJS	+= $(EBOOK_OBJS)
SOURCES += $(EBOOK_SRCS) $(EBOOK_CPPSRCS)

endif


#---------------------------------------------------------------
# cpp_source src
#---------------------------------------------------------------
include $(EBOOKDIR)/Settings_Source/Settings_Source.mk

INCLUDES_EBOOK	:= common
CFLAGS	+= -I$(EBOOKDIR)
CFLAGS	+= $(addprefix -I$(EBOOKDIR)/, $(INCLUDES_EBOOK))

VPATH   +=  $(EBOOKDIR)
VPATH   +=  $(addprefix $(EBOOKDIR)/, $(INCLUDES_EBOOK))

#--------------------------------------------------------------
#--------------------------------------------------------------
CFLAGS	+= -DENABLE_EBOOK=$(ENABLE_EBOOK)
CFLAGS	+= -DENABLE_PDF=$(ENABLE_PDF)
CFLAGS	+= -DENABLE_FREETYPE2=$(ENABLE_FREETYPE2)
CFLAGS	+= -DENABLE_IMAGE=$(ENABLE_IMAGE)
CFLAGS	+= -DENABLE_JPEG=$(ENABLE_JPEG)
CFLAGS	+= -DENABLE_JPEG6B=$(ENABLE_JPEG6B)
CFLAGS	+= -DENABLE_BMP=$(ENABLE_BMP)
CFLAGS	+= -DENABLE_GIF=$(ENABLE_GIF)
CFLAGS	+= -DENABLE_PNG=$(ENABLE_PNG)
CFLAGS	+= -DENABLE_TIF=$(ENABLE_TIF)
CFLAGS	+= -DENABLE_UNZIP=$(ENABLE_UNZIP)
CFLAGS	+= -DMUPDF_X86=$(MUPDF_X86)
CFLAGS	+= -DDEBUG_LHM=$(DEBUG_LHM)
CFLAGS	+= -DCONFIG_EDITION=$(CONFIG_EDITION)
