#include <scene.h>
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <datatype.h>
#include <display.h>

//ds2_main.c
#include "console.h"
#include "ds2io.h"
#include <debugoff.h>

#define BLACK_COLOR		RGB15(0, 0, 0)
#define WHITE_COLOR		RGB15(31, 31, 31)

extern void main(int argc, char* argv[]);
extern int ebook_main( void );

int ebook_main( void )
{
	scene_init();
	return 0;
}

void ds2_main(void)
{
	int err;

	//Initial video and audio and other input and output
	err = ds2io_init(1024);
	if(err) goto _failure;

	//Initial console for printf funciton
//	err = ConsoleInit(WHITE_COLOR, BLACK_COLOR, UP_SCREEN, 10);
//	if(err) goto _failure;

	//Initial file system
	err = fat_init();
	if(err) goto _failure;

//clocklevel:   9    10   11   12   13
//frequence:	300M 336M 360M 384M 396M
	ds2_setCPUclocklevel( 11 );
	
	printf_clock();
	
#if 1
	ebook_main();
#else
	main(0, 0);
#endif

_failure:
	printf("some error\n");
	while(1);
	ds2_plug_exit();
}
