/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"

#include <string.h>
#include <unzip.h>
#include "common/utils.h"
#include "html.h"
#include "display.h"
#include "charsets.h"
#include <fat_ebook.h>
#include "fs.h"
#include "scene.h"
#include "conf.h"
#include "win.h"

#include <mystring.h>
#include <gdi.h>
#include <datatype.h>
#include <Macro.h>
#include <fs_api.h>
#include <fatdir.h>
#include <uart.h>
#include <fs_unicode.h>
#include <bit_ops.h>
#include <strsafe.h>
#include <language.h>

#include <debugoff.h>

extern t_conf config;

typedef struct
{
	const char *ext;
	t_fs_filetype ft;
} t_fs_filetype_entry;

typedef struct
{
	const char *fname;
	t_fs_filetype ft;
} t_fs_specfiletype_entry;


t_fs_filetype_entry ft_table[] =
{
	{"lrc", fs_filetype_txt},
	{"txt", fs_filetype_txt},
	{"log", fs_filetype_txt},
	{"ini", fs_filetype_txt},
	{"cfg", fs_filetype_txt},
	{"conf", fs_filetype_txt},
	{"inf", fs_filetype_txt},
	{"xml", fs_filetype_txt},
	{"cpp", fs_filetype_txt},
	{"in", fs_filetype_txt},
	{"am", fs_filetype_txt},
	{"mak", fs_filetype_txt},
	{"exp", fs_filetype_txt},
	{"sh", fs_filetype_txt},
	{"asm", fs_filetype_txt},
	{"s", fs_filetype_txt},
	{"patch", fs_filetype_txt},
	{"c", fs_filetype_txt},
	{"h", fs_filetype_txt},
	{"hpp", fs_filetype_txt},
	{"cc", fs_filetype_txt},
	{"cxx", fs_filetype_txt},
	{"pas", fs_filetype_txt},
	{"bas", fs_filetype_txt},
	{"py", fs_filetype_txt},
	{"mk", fs_filetype_txt},
	{"rc", fs_filetype_txt},
	{"pl", fs_filetype_txt},
	{"cgi", fs_filetype_txt},
	{"bat", fs_filetype_txt},
	{"js", fs_filetype_txt},
	{"vbs", fs_filetype_txt},
	{"vb", fs_filetype_txt},
	{"cs", fs_filetype_txt},
	{"css", fs_filetype_txt},
	{"csv", fs_filetype_txt},
	{"php", fs_filetype_txt},
	{"php3", fs_filetype_txt},
	{"asp", fs_filetype_txt},
	{"aspx", fs_filetype_txt},
	{"java", fs_filetype_txt},
	{"jsp", fs_filetype_txt},
	{"awk", fs_filetype_txt},
	{"tcl", fs_filetype_txt},
	{"y", fs_filetype_txt},
	{"html", fs_filetype_html},
	{"htm", fs_filetype_html},
	{"shtml", fs_filetype_html},
#ifdef ENABLE_IMAGE
	{"png", fs_filetype_png},
	{"gif", fs_filetype_gif},
	{"jpg", fs_filetype_jpg},
	{"jpeg", fs_filetype_jpg},
	{"bmp", fs_filetype_bmp},
	{"tif", fs_filetype_tif},
#endif
	{"zip", fs_filetype_zip},
	{"gz", fs_filetype_gz},
	{"chm", fs_filetype_chm},
	{"rar", fs_filetype_rar},
	{"pbp", fs_filetype_prog},
	{"ebm", fs_filetype_ebm},
#ifdef ENABLE_TTF
	{"ttf", fs_filetype_font},
	{"ttc", fs_filetype_font},
#endif
#if ENABLE_PDF
	{"pdf", fs_filetype_pdf},
#endif
	{NULL, fs_filetype_unknown}
};

t_fs_specfiletype_entry ft_spec_table[] = {
	{"Makefile", fs_filetype_txt},
	{"LICENSE", fs_filetype_txt},
	{"TODO", fs_filetype_txt},
	{"Configure", fs_filetype_txt},
	{"Changelog", fs_filetype_txt},
	{"Readme", fs_filetype_txt},
	{"Version", fs_filetype_txt},
	{"INSTALL", fs_filetype_txt},
	{"CREDITS", fs_filetype_txt},
	{NULL, fs_filetype_unknown}
};

int MAX_ITEM_NAME_LEN = 34;//displayСʱ޸
int DIR_INC_SIZE = 256;

extern const char *utils_fileext_ucs2(const char *filename);

void filename_to_itemname( p_win_menuitem item, int cur_count, const char *filename )
{
	if ((item[cur_count].width = strlen(filename)) > MAX_ITEM_NAME_LEN)
	{
		mbcsncpy_s(((unsigned char *) item[cur_count].name), MAX_ITEM_NAME_LEN - 2, ((const unsigned char *) filename), -1);
		if (strlen(item[cur_count].name) < MAX_ITEM_NAME_LEN - 3)
		{
			mbcsncpy_s( ((unsigned char *) item[cur_count].name), MAX_ITEM_NAME_LEN, ((const unsigned char *) filename), -1 );
			STRCAT_S(item[cur_count].name, "..");
		}
		else
			STRCAT_S(item[cur_count].name, "...");
		item[cur_count].width = MAX_ITEM_NAME_LEN;
	}
	else
	{
		STRCPY_S(item[cur_count].name, filename);
	}
}

extern dword fs_list_device(const char *dir, const char *sdir,
							p_win_menuitem * mitem, dword icolor,
							dword selicolor, dword selrcolor, dword selbcolor)
{
	strcpy_s((char *) sdir, 256, dir);
	dword cur_count = 0;
	p_win_menuitem item = NULL;

	cur_count = config.hide_flash ? 1 : 3;
	*mitem = win_realloc_items(NULL, 0, cur_count);
	if (*mitem == NULL)
		return 0;
	item = *mitem;
	STRCPY_S(item[0].name, "<MemoryStick>");
//	buffer_copy_string(item[0].compname, "ms0:");
	item[0].data = (void *) fs_filetype_dir;
	item[0].width = 13;
	item[0].selected = false;
//	item[0].icolor = icolor;
//	item[0].selicolor = selicolor;
//	item[0].selrcolor = selrcolor;
//	item[0].selbcolor = selbcolor;

	if (config.hide_flash == false) {
		STRCPY_S(item[1].name, "<NandFlash 0>");
//		buffer_copy_string(item[1].compname, "flash0:");
		item[1].data = (void *) fs_filetype_dir;
		item[1].width = 13;
		item[1].selected = false;
//		item[1].icolor = icolor;
//		item[1].selicolor = selicolor;
//		item[1].selrcolor = selrcolor;
//		item[1].selbcolor = selbcolor;
		STRCPY_S(item[2].name, "<NandFlash 1>");
//		buffer_copy_string(item[2].compname, "flash1:");
		item[2].data = (void *) fs_filetype_dir;
		item[2].width = 13;
		item[2].selected = false;
//		item[2].icolor = icolor;
//		item[2].selicolor = selicolor;
//		item[2].selrcolor = selrcolor;
//		item[2].selbcolor = selbcolor;
	}

	return cur_count;
}

/*
 * õıȣؼƣϵͳʹ
 */
int filename_string_width_process( char * name,  char * sname, bool IsDir )
{
	int width;
	int width2;
	int i, n;
	char str[10];

	if( !name || !sname )
		return 0;

	i = 0;
	n = 0;
	width2 = 0;
	while( i < 11 && sname[i] != '~' )i++;
	for( ; i<11; i++ )
	{
		if( sname[i] != 0x20 && sname[i] != 0x00 )
		{
			if( i == 8 )
				str[n++] = '.';
			str[n++] = sname[i];
			width2 += DISP_FONTSIZE >> 1;
		}
	}
	if( IsDir )
	{
		str[n++] = CONFIG_DIR_SEPERATOR;
		width2 += DISP_FONTSIZE >> 1;
	}
	str[n++] = 0x00;

	width = 0;
	while( (*(byte *) name) != 0 )
	{
		if ( (*(byte *) name) > 0x80 )
		{
			width += DISP_FONTSIZE;
			n = 2;
		}
		else
		{
			width += DISP_FONTSIZE >> 1;
			n = 1;
		}

		if( (width + width2) >= (SCREEN_W - FL_LINE_FONT_START_X - (SCREEN_W - FL_SLIDE_X + FL_SLIDE_W + FL_SLIDE_BANK)) )
		{
			i = 0;
			for( i=0; i<width2; i++ )
			{
				*name++ = str[i];
			}
			break;
		}

		name += n;
	}

	return width;
}

int filename_string_width_process_ucs2( char * name,  char * sname, bool IsDir )
{
	int width;
	int width2;
	int i, n;
	char str[16];

	if( !name || !sname )
		return 0;

	i = 0;
	n = 0;
	width2 = 0;
	while( i < 11 && sname[i] != '~' )i++;
	for( ; i<11; i++ )
	{
		if( sname[i] != 0x20 && sname[i] != 0x00 )
		{
			if( i == 8 )
			{
				str[n++] = '.';
				str[n++] = 0x00;
			}
			str[n++] = sname[i];
			str[n++] = 0x00;
			width2 += DISP_FONTSIZE >> 1;
		}
	}
	if( IsDir )
	{
		str[n++] = CONFIG_DIR_SEPERATOR;
		str[n++] = 0x00;
		width2 += DISP_FONTSIZE >> 1;
	}
	str[n++] = 0x00;//
	str[n++] = 0x00;

	width = 0;
	while( !(name[0] == 0x00 && name[1] == 0x00) )
	{
		if ( name[1] != 0x00 )
		{
			width += DISP_FONTSIZE;
		}
		else
		{
			width += DISP_FONTSIZE >> 1;
		}

		if( (width + width2) >= (SCREEN_W - FL_LINE_FONT_START_X - (SCREEN_W - FL_SLIDE_X + FL_SLIDE_W + FL_SLIDE_BANK)) )
		{
			i = 0;
			for( i=0; i<n; i++ )
			{
				*name++ = str[i];
			}
			break;
		}

		name += 2;
	}

	return width;
}

extern dword fs_readdir( const char * dirName, p_win_menuitem *mitem, BOOL showhidden, BOOL showunknown )//ȡĳ·µЧĿ¼
{
	p_win_menuitem item = NULL;
	bool IsDir;
	u16 len;
	int width;
	dword cur_count = 0;
	U8 attr = 0;
	DIR_STATE_STRUCT * dir = NULL;
	char *name = NULL;
  	int fontCoding_type = GetlanguageCodingType();

	len = strlen( dirName );
	if( *(dirName+len-1) == CONFIG_DIR_SEPERATOR )
	{
		dir = fat_opendir( dirName );
	}
	else
	{
		name = (char*)malloc( len + 2 );
		if( name == NULL )
			return 0;
		STRCPY_S( name, dirName );
		*(name+len) = CONFIG_DIR_SEPERATOR;
		*(name+len+1) = 0x00;
		dir = fat_opendir( name );
		free( name );
	}

	if (dir == NULL)
	{
     	return 0;
  	}

	DIR_ENTRY *entry = NULL;

	while( (entry = fat_readdir( dir )) != NULL )
	{
		attr = entry->entryData[DIR_ENTRY_attributes];

		if( attr & (ATTR_HIDDEN|ATTR_SYSTEM|ATTR_VOLUME) )//ʾļϵͳļ;
			continue;

		if( entry->d_name[0] == '.' )
  		{
  			if( entry->d_name[1] == '\0' )
  				continue;
  			else if( entry->d_name[1] == '.' )
  			{
  				if( entry->d_name[2] == '/' || entry->d_name[2] == '\\' )//Ҫʾ"../"Ļ޸Ĵ˴
  					entry->d_name[2] = '\0';
  			}
  		}


  		if( cur_count % DIR_INC_SIZE == 0 )
		{
			if (cur_count == 0)
				*mitem =
					win_realloc_items(NULL, cur_count, cur_count + DIR_INC_SIZE);
			else
				*mitem =
					win_realloc_items(*mitem, cur_count, cur_count + DIR_INC_SIZE);
			if (*mitem == NULL)
			{
				return 0;
			}
			item = *mitem;
		}

		//1ļ
		STRCPY_S( item[cur_count].Uname, entry->d_name );
		if ( attr & ATTR_DIRECTORY )
		{
			len = strlen( entry->d_name );
			entry->d_name[len++] = CONFIG_DIR_SEPERATOR;
			entry->d_name[len] = 0x00;
			IsDir = 1;
		}
		else
		{
			IsDir = 0;
		}
		memset( item[cur_count].name, 0x00, STR_DEFAULT_LEN );
		utf8_to_ucs( (byte*)item[cur_count].name, STR_DEFAULT_LEN, (const byte*)entry->d_name, INVALID_LEN );


		//ļȴ
		width = CB_text_get_string_width_sys( (const byte*)item[cur_count].name, 0, CONFIG_FONTW_SYS, fontCoding_type );
		if( width < (SCREEN_W - FL_LINE_FONT_START_X - (FL_SLIDE_W + FL_SLIDE_BANK)) )
		{
			item[cur_count].width = strlen_ucs( item[cur_count].name );
		}
		else
		{
	  		filename_string_width_process_ucs2( item[cur_count].name, (char*)&entry->entryData[0], IsDir );
	  		item[cur_count].width = strlen_ucs( item[cur_count].name );
		}

  		//2ļ
  		if ( attr & ATTR_DIRECTORY )
  		{
  			item[cur_count].data = (void *) fs_filetype_dir;
		}
  		else
  		{
  			t_fs_filetype ft = fs_file_get_type( entry->d_name );
			if (!showunknown && ft == fs_filetype_unknown)//showunknown1ʾļδ֪ļ
				continue;
			item[cur_count].data = (void *) ft;
  		}

		//3/ʱ ޸/ʱ
		//-------/ʱ-----------
		item[cur_count].data2[0] = u8array_to_u16( entry->entryData, DIR_ENTRY_cDate );//745洢
		item[cur_count].data2[1] = u8array_to_u16( entry->entryData, DIR_ENTRY_cTime );//5 6 5洢

  		//-------޸/ʱ-----------
  		item[cur_count].data2[2] = u8array_to_u16( entry->entryData, DIR_ENTRY_mDate );//745洢
  		item[cur_count].data2[3] = u8array_to_u16( entry->entryData, DIR_ENTRY_mTime );//5 6 5洢

  		//4ļ
  		item[cur_count].data3 = u8array_to_u32( entry->entryData, DIR_ENTRY_fileSize );

		cur_count++;
	}

  	fat_closedir( dir );

	return cur_count;
}

// New style fat system custom reading
extern dword fs_dir_to_menu( const char *dir, p_win_menuitem * mitem, BOOL showhidden, BOOL showunknown ) //icolorѡģĿɫselicolor: ѡĿɫselrcolor: Ŀѡɫselbcolor: Ŀѡڱɫ
{
	win_item_destroy(mitem, &filecount);
	dword count = fs_readdir( dir, mitem, showhidden, showunknown );//count:ЧĿ¼

	return count;
}

extern dword fs_zip_to_menu( const char *zipfile, p_win_menuitem * mitem )
{
	extern dword filecount;

	win_item_destroy(mitem, &filecount);
	unzFile unzf = unzOpen(zipfile);
	p_win_menuitem item = NULL;
	int len;

	if (unzf == NULL) {
		return 0;
	}
	dword cur_count = 1;
	*mitem = win_realloc_items(NULL, 0, DIR_INC_SIZE);
	if (*mitem == NULL) {
		unzClose(unzf);
		return 0;
	}
	item = *mitem;
	STRCPY_S(item[0].Uname, "../");
	STRCPY_S(item[0].name, "../");
	item[0].data = (void *) fs_filetype_dir;
	item[0].width = 4;
	item[0].selected = false;



	if (unzGoToFirstFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return 1;
	}

	do {
		char fname[PATH_MAX2];
		unz_file_info file_info;

		if( unzGetCurrentFileInfo( unzf, &file_info, fname, PATH_MAX2, NULL, 0, NULL, 0 ) != UNZ_OK )
			break;

		if (file_info.uncompressed_size == 0)
			continue;
		t_fs_filetype ft = fs_file_get_type(fname);

		if (ft == fs_filetype_chm || ft == fs_filetype_zip
			|| ft == fs_filetype_rar)
			continue;
		if (cur_count % DIR_INC_SIZE == 0)
		{
			if (cur_count == 0)
				*mitem = win_realloc_items( NULL, cur_count, cur_count + DIR_INC_SIZE );
			else
				*mitem = win_realloc_items(*mitem, cur_count, cur_count + DIR_INC_SIZE);
			if (*mitem == NULL)
			{
				unzClose(unzf);
				return 0;
			}
			item = *mitem;
		}
		item[cur_count].data = (void *) ft;
		item[cur_count].data3 = unztellsize( unzf );
//		buffer_copy_string(item[cur_count].compname, fname);
		if( config.cur_lang_index == LANG_INDEX_CN )
		{
			len = gbk_to_ucs( (byte*)item[cur_count].name, STR_DEFAULT_LEN, (const byte*)fname, INVALID_LEN );
//			Unicode2Utf8( (byte*)item[cur_count].Uname, STR_DEFAULT_LEN, (byte*)item[cur_count].name, len );
		}
		else if( config.cur_lang_index == LANG_INDEX_JP )
		{
			len = sjis_to_ucs( (byte*)item[cur_count].name, STR_DEFAULT_LEN, (const byte*)fname, INVALID_LEN );
//			Unicode2Utf8( (byte*)item[cur_count].Uname, STR_DEFAULT_LEN, (byte*)item[cur_count].name, len );
		}
		else if( config.cur_lang_index == LANG_INDEX_TW )
		{
			len = big5_to_ucs( (byte*)item[cur_count].name, STR_DEFAULT_LEN, (const byte*)fname, INVALID_LEN );
//			Unicode2Utf8( (byte*)item[cur_count].Uname, STR_DEFAULT_LEN, (byte*)item[cur_count].name, len );
		}
		else
		{
			filename_to_itemname(item, cur_count, fname);
		}
		STRCPY_S( item[cur_count].Uname, fname );

//		char t[20];
//		SPRINTF_S(t, "%u", (unsigned int) file_info.uncompressed_size);
//		buffer_copy_string(item[cur_count].shortname, t);
//		utf8_to_ucs( (byte*)item[cur_count].name, STR_DEFAULT_LEN, (const byte*)fname, INVALID_LEN );
//		filename_to_itemname(item, cur_count, fname);
		item[cur_count].selected = false;
		cur_count++;
	} while (unzGoToNextFile(unzf) == UNZ_OK);
	unzClose(unzf);
	return cur_count;
}

p_win_menuitem fs_empty_dir(dword * filecount, dword icolor,
							dword selicolor, dword selrcolor, dword selbcolor)
{
	p_win_menuitem p;

	p = win_realloc_items(NULL, 0, 1);
	if (p == NULL)
	{
		return NULL;
	}
	STRCPY_S( p->name, "<..>" );
//	buffer_copy_string(p->compname, "..");
	p->data = (void *) fs_filetype_dir;
	p->width = 4;
	p->selected = false;
//	p->icolor = icolor;
//	p->selicolor = selicolor;
//	p->selrcolor = selrcolor;
//	p->selbcolor = selbcolor;

	*filecount = 1;
	return p;
}

extern t_fs_filetype fs_file_get_type(const char *filename)//ΪUTF8
{
	const char *ext = utils_fileext(filename);
	t_fs_filetype_entry *entry = ft_table;
	t_fs_specfiletype_entry *entry2 = ft_spec_table;
	if (ext)
	{
		while (entry->ext != NULL)
		{
			if (stricmp(ext, entry->ext) == 0)
			{
				return entry->ft;
			}
			entry++;
		}
	}
	while (entry2->fname != NULL)
	{
		const char *shortname = strrchr(filename, CONFIG_DIR_SEPERATOR );

		if (!shortname)
			shortname = filename;
		else
			shortname++;
		if (stricmp(shortname, entry2->fname) == 0)
		{
			return entry2->ft;
		}
		entry2++;
	}
	return fs_filetype_unknown;
}

#ifdef ENABLE_IMAGE
extern BOOL fs_is_image(t_fs_filetype ft)
{
	return ft == fs_filetype_jpg || ft == fs_filetype_gif
		|| ft == fs_filetype_png
		|| ft == fs_filetype_bmp || ft == fs_filetype_tif;
}
#endif

extern BOOL fs_is_txtbook(t_fs_filetype ft)
{
	return ft == fs_filetype_txt || ft == fs_filetype_html
		|| ft == fs_filetype_gz;
}

static void extract_zip_file_into_buffer(buffer * buffer, const char *archname, const char *archpath)
{
	unzFile unzf = unzOpen(archname);

	if (unzf == NULL)
		return;
	if (unzLocateFile(unzf, archpath, 0) != UNZ_OK
		|| unzOpenCurrentFile(unzf) != UNZ_OK) {
		unzClose(unzf);
		return;
	}

	unz_file_info info;

	if (unzGetCurrentFileInfo(unzf, &info, NULL, 0, NULL, 0, NULL, 0) != UNZ_OK) {
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return;
	}
	buffer_prepare_copy(buffer, info.uncompressed_size);
	if (buffer->ptr == NULL) {
		unzCloseCurrentFile(unzf);
		unzClose(unzf);
		return;
	}
	unzReadCurrentFile(unzf, buffer->ptr, info.uncompressed_size);
	buffer->used = info.uncompressed_size;
	unzCloseCurrentFile(unzf);
	unzClose(unzf);
}

/**
 * ѹļڴ滺
 * @param buffer ָָ
 * @param archname ļ·
 * @param archpath ѹļ·
 * @param filetype ļ
 * @note ѹʧ, *buf = NULL
 */
extern void extract_archive_file_into_buffer(buffer ** buf,
											 const char *archname,
											 const char *archpath,
											 t_fs_filetype filetype)
{
	if (buf == NULL)
		return;

	if (archname == NULL || archpath == NULL) {
		*buf = NULL;
		return;
	}

	buffer *b;

	b = buffer_init();

	switch (filetype) {
		case fs_filetype_zip:
			extract_zip_file_into_buffer(b, archname, archpath);
			break;
		default:
			*buf = NULL;
			return;
			break;
	}

	if (b != NULL && b->ptr != NULL)
		*buf = b;
	else {
		*buf = NULL;
		buffer_free(b);
	}
}
