/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _FS_H_
#define _FS_H_

#ifdef __cplusplus
extern "C" {
#endif

#include "common/datatype.h"
#include "conf.h"
#include "win.h"
#include "buffer.h"
#include "config.h"
#include <config_ebook.h>

#if DEBUG_LHM
extern char extname_type[][256];
#endif

//ļλ
#define ATTR_NORMAL     	0x00            // д 
#define ATTR_READONLY   	0x01            // ֻ 
#define ATTR_HIDDEN     	0x02            //  
#define ATTR_SYSTEM     	0x04            // ϵͳļ 
#define ATTR_VOLUME     	0x08            // ļ 
#define ATTR_LONG_FILENAME	0x0f		// ļļ			 
#define ATTR_DIRECTORY  	0x10            // Ŀ¼ļ 
#define ATTR_ARCHIVE    	0x20            // 鵵ļ 

typedef enum
{
	fs_filetype_dir = 0,
	fs_filetype_chm,
	fs_filetype_gz,
	fs_filetype_zip,
	fs_filetype_rar,
	fs_filetype_txt,
	fs_filetype_html,
	fs_filetype_prog,
#if defined(ENABLE_IMAGE) || defined(ENABLE_BG)
	fs_filetype_bmp,
	fs_filetype_tif,//2009-8-20 9:44:20
	fs_filetype_gif,
	fs_filetype_jpg,
	fs_filetype_png,
#endif
	fs_filetype_ebm,
	fs_filetype_unknown
#ifdef ENABLE_TTF
		, fs_filetype_font
#endif

#if ENABLE_PDF
	,	fs_filetype_pdf
#endif
} t_fs_filetype;

extern dword fs_list_device(const char *dir, const char *sdir,
							p_win_menuitem * mitem, dword icolor,
							dword selicolor, dword selrcolor, dword selbcolor);
extern dword fs_flashdir_to_menu(const char *dir, const char *sdir,
								 p_win_menuitem * mitem, dword icolor,
								 dword selicolor, dword selrcolor,
								 dword selbcolor);
extern dword fs_dir_to_menu( const char *dir, p_win_menuitem * mitem, BOOL showhidden, BOOL showunknown );
							
extern dword fs_zip_to_menu( const char *zipfile, p_win_menuitem * mitem );

extern dword fs_rar_to_menu(const char *rarfile, p_win_menuitem * mitem,
							dword icolor, dword selicolor, dword selrcolor,
							dword selbcolor);
extern dword fs_chm_to_menu(const char *chmfile, p_win_menuitem * mitem,
							dword icolor, dword selicolor, dword selrcolor,
							dword selbcolor);
p_win_menuitem fs_empty_dir(dword * filecount, dword icolor,
							dword selicolor, dword selrcolor, dword selbcolor);
extern t_fs_filetype fs_file_get_type(const char *filename);
extern BOOL fs_is_image(t_fs_filetype ft);
extern BOOL fs_is_txtbook(t_fs_filetype ft);

extern void extract_archive_file_into_buffer(buffer ** buf,
											 const char *archname,
											 const char *archpath,
											 t_fs_filetype filetype);


extern t_fs_filetype fs_file_get_type_FromEntryData( const char *entryData );

#ifdef __cplusplus
}
#endif

#endif
