#include <font.h>
#include <language.h>
#include <scene.h>
#include <display.h>
#include <strsafe.h>
#include <ctrl.h>

#include <debugoff.h>

int FontSize = 0;

int (*CB_disp_putcharhorz) ( int x, int y, int fontw, int fonth, byte *str, pixel fontcolor, SCREEN_ID engine );
void (*CB_putnstringhorz_sys) ( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth );
void (*CB_putnstringhorz) ( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth, int top, int bot );
//void (*CB_disp_putnstringrvert)( int x, int y, pixel color, const byte * str, int count, dword wordspace, SCREEN_ID engine );
void (*CB_disp_putnstringrvert) ( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth );

//extern void disp_putnstringrvert(int x, int y, pixel color, const byte * str,
//								 int count, dword wordspace, int top,
//								 int height, int bot);

int (*CB_text_get_string_width_sys)( const unsigned char * str, dword wordspace, int fontw, int encode_type );
int (*CB_text_get_string_width)(const char *pos, const char *posend, dword maxpixel, dword wordspace, dword * count, dword fontsize );

//---------------------------------------------------------------------
//-------------------------ֿ------------------------------------
//---------------------------------------------------------------------
void fontlib_load( char *appdir )
{
	int _fsize;
	char fontzipfile[PATH_MAX2], efontfile[PATH_MAX2], localfontfile[PATH_MAX2];

	STRCPY_S(fontzipfile, appdir);
	STRCAT_S(fontzipfile, "fonts.zip");

	fontcount = 0;
	bookfontcount = 0;
//	if( config.cur_lang_index == LANG_INDEX_EN || config.cur_lang_index == LANG_INDEX_CN )
	{
		for (_fsize = CONFIG_FONTW_MIN; _fsize <= CONFIG_FONTW_MAX; _fsize += 2)
		{
			SPRINTF_S( localfontfile, "unicode%02d", _fsize );

			if (disp_has_zipped_font(fontzipfile, efontfile, localfontfile))
			{
				if (_fsize <= 16)
				{
					fonts[fontcount].size = _fsize;
					fonts[fontcount].zipped = true;
					if (fonts[fontcount].size == config.fontsize)
						fontindex = fontcount;
					fontcount++;
				}
				bookfonts[bookfontcount].size = _fsize;
				bookfonts[bookfontcount].zipped = true;
				if (bookfonts[bookfontcount].size == config.bookfontsize)
					bookfontindex = bookfontcount;
				bookfontcount++;
			}
			else
			{
				SPRINTF_S(localfontfile, "%sfonts/unicode%02d", appdir, _fsize);

				if (disp_has_font(efontfile, localfontfile))
				{
					if (_fsize <= 16)
					{
						fonts[fontcount].size = _fsize;
						fonts[fontcount].zipped = false;
						if (fonts[fontcount].size == config.fontsize)
							fontindex = fontcount;//fontindex: ǰʹõ
						fontcount++;
					}
					bookfonts[bookfontcount].size = _fsize;
					bookfonts[bookfontcount].zipped = true;
					if (bookfonts[bookfontcount].size == config.bookfontsize)
						bookfontindex = bookfontcount;
					ttfsize = config.bookfontsize;
					bookfontcount++;
				}
			}
		}
		if (fontcount == 0 || !scene_load_font( 1 ) || !scene_load_book_font( 0 ))//ȼ10壬bg_load()õ
		{
			ctrl_waitany();
			scene_exit();
			while( 1 );//ĽôϢʾȡ
		}
	}
}

void ProcFont_CallBackInit( void )
{
	CB_putnstringhorz_sys = NULL;
	CB_putnstringhorz = NULL;
	CB_disp_putnstringrvert = NULL;
	CB_text_get_string_width_sys = NULL;
}
