#ifndef _FONT_H_
#define _FONT_H_

#include <datatype.h>
#include <display.h>
#include <config_ebook.h>
#include <font_ucs2.h>

enum{
	ASCII = 0,
	GBK,
	BIG5,
	SJIS,
	UNICODE,
	UTF8,
};

//-----------------------------------------------------------------------------------------------
typedef  void (*putnstring_sys_t) ( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height );
typedef  void (*putnstring_t)( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height, int top, int bot );



extern int (*CB_disp_putcharhorz) ( int x, int y, int fontw, int fonth, byte *str, pixel fontcolor, SCREEN_ID engine );
extern void (*CB_putnstringhorz_sys) ( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height );
extern void (*CB_putnstringhorz) ( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height, int top, int bot );
//extern void (*CB_disp_putnstringrvert)( int x, int y, pixel color, const byte * str, int count, dword wordspace, SCREEN_ID engine );
void (*CB_disp_putnstringrvert) ( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth );
extern int (*CB_text_get_string_width_sys)( const unsigned char * str, dword wordspace, int fontw, int encode_type );
extern int (*CB_text_get_string_width)(const char *pos, const char *posend, dword maxpixel, dword wordspace, dword * count, dword fontsize );	

void fontlib_load( char *appdir );
void ProcFont_CallBackInit( void );

extern int FontSize;


#endif//_FONT_H_
