#include "config.h"
#include <Macro.h>

#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include <display.h>
#include "win.h"
#include "ctrl.h"
#include "fs.h"
#include "image.h"
#include "bookmark.h"
#include "conf.h"
#include "charsets.h"
#include "fat_ebook.h"
#include "location.h"

#include "text.h"
#include "bg.h"
#include "version.h"
#include "common/qsort.h"
#include "common/utils.h"
#include "scene_impl.h"

#include <msgbox.h>
#include <StyleSet.h>
#include <MainMenuSettings.h>
#include <ExitMessageBox.h>
#include <mmc_api.h>
#include <HelpMenu_FileBrowse.h>
#include <scene_text.h>
#include <language.h>
#include <font.h>

#include <fs_api.h>
#include <DrvMemMgr.h>
#include <language.h>
#include <charsets.h>
#include <strsafe.h>
#include <gdi.h>
#include <font.h>
#include <display.h>
#include <uart.h>
#include <bit_ops.h>

#include <debugoff.h>

/*-----------------------------------------------
FUNCTION : ⵱ǰַǷΪַ
IN : const char *textp ַ
RETURN : Ϊַ ture,false
-------------------------------------------------*/
local int GDICheck_UCS2( const unsigned char *textp )
{
	if( !textp )
		return false;

	U16 ucs2 = u8array_to_u16( textp, 0 );

	return (int)( ucs2 < 0x80 ? 1 : 2 );
}

int UCS2_text_get_string_width_sys2( const unsigned char * str, int count, dword wordspace, int fontw )
{
	if( str == NULL || count <= 0 )
		return 0;
//-------------------------------------------
	int width = 0;
    const U8 * textPos = (const U8 *)str;
	int aw,step;//aw:
//-------------------------------------------

	while( (!(textPos[0] == 0x00 && textPos[1] == 0x00)) && count > 0 )
    {
    	if( GDICheck_UCS2( (const unsigned char*)textPos ) == 2 )
    	{
    		aw = fontw;
    	}
    	else
    	{
//    		aw = disp_ewidth[*(byte *) textPos];
			aw = fontw >> 1;
    	}

		textPos += 2;
		width += aw + wordspace;
		count -= 2;
    }
	return width; //Ѿʾ
}


//--------------------------------------------------------------------------------------------------------------------------------------------
//ȡؿ
//--------------------------------------------------------------------------------------------------------------------------------------------
int UCS2_text_get_string_width_sys( const unsigned char * str, dword wordspace, int fontw, int encode_type )//encode_type: ,BIG5UTF8
{
	if( str == NULL )
		return 0;
	
	if( fontw == 10 )
		wordspace++;
		
	return UCS2_text_get_string_width_sys2( str, 0x7FFFFFFF, wordspace, fontw );
}


static int Proc_string_depart( const byte *pos, const byte *posend, dword wordspace, dword *letter_count, dword *word_width )
{
	*word_width = 0;
	*letter_count = 0;
	while ( pos < posend )
	{
		if( pos[1] != 0x00 )
		{
			break;
		}
		else if( (bytetable[*(byte *) pos] & 0x0C) )
		{
			*word_width += disp_ewidth[*(byte *) pos]+wordspace;
			*letter_count += 1;
			pos += 2;

			if( (bytetable[*(byte *) pos] & 0x08) )
			{
				break;
			}
		}
		else
		{
			break;
		}
	}
	return 0;
}

/*
 * õıȣؼƣʾıʹ
 * count: ռڴֽ
 */
int UCS2_text_get_string_width(const byte *pos, const byte *posend, dword maxpixel, dword wordspace, dword * count, dword fontsize )
{
	int j;
	int count_temp=0;
	int width = 0;
	dword letter_count, word_width;
	int letter_count_line;
	const byte *posstart = pos;
	const U16 *upos = NULL;
	
	if( fontsize == 10 )
		wordspace++;
	
	letter_count_line = maxpixel / ( disp_ewidth[(byte)'a'] + wordspace );
//_UCS2_text_get_string_width_Start:
	
	while ( pos < posend )// bytetable[*(byte *) pos] == 1 ʾǻس
	{
		upos = (U16*)pos;//뱣pos2ֽڶ
		if( *upos <= 0xFF )
		{
			if( bytetable[*upos] == 1 )
				break;
		}
		if ( pos[1] != 0x00 )
		{
//			width += fontsize;
			if ( (width+fontsize) > maxpixel )
			{
				break;
			}

			width += fontsize + wordspace;
			pos += 2;
			count_temp += 2;
		}
		else
		{
			if( bytetable[*(byte *) pos] & 0x04 )
			{
				Proc_string_depart( pos, posend, wordspace, &letter_count, &word_width );
				if( (width + word_width) > maxpixel )
				{
					if( word_width > maxpixel && width == 0 )
					{
						pos += letter_count_line<<1;
						count_temp += letter_count_line;
						width += letter_count_line * (disp_ewidth[(byte)'a']+wordspace);
					}
					break;
				}
				else
				{
					pos += letter_count<<1;
					count_temp += letter_count;
					width += word_width;
				}
			}
			else
			{
				for (j = 0; j < (*pos == 0x09 ? config.tabstop : 1); ++j)
					width += disp_ewidth[*(byte *) pos];

				if (width > maxpixel)
				{
					break;
				}
				width += wordspace;
				pos += 2;
				count_temp += 1;
			}
		}
	}

	*count = pos - posstart;//ֽ

	return width;//һЧݵشС
}

static int UCS2_disp_putcharhorz( int x, int y, int fontw, int fonth, byte *str, pixel fontcolor, SCREEN_ID engine )
{
//----------------------------------------------
	pixel *mem = NULL;
	byte *ccur = NULL;
	pixel *BASE = NULL;
	U8 ch;
	U16 px,py;
	U8 font_pitch, fontsize,bitsleft;
	byte *efontbuffer = NULL;
	byte *fontbuffer = NULL;

	U16 ucs2 = u8array_to_u16( str, 0 );

//----------------------------------------------
	if( !str ) 
	{ 
		return 0; 
	}

	if( engine == DOWN_SCREEN )
		mem = bufferMain;
	else if( engine == UP_SCREEN )
		mem = bufferSub;
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
			mem = bufferTemp;
		else
		{
			return 0;
		}
	}

	if( !mem )return 0;
	BASE = mem + y * SCREEN_W + x;
//	if( *str > 0x80 )
	{
		if( font_in_book == false )
		{
			fontbuffer = localfont_buffer;
			fontsize = DISP_FONTSIZE;
		}
		else
		{
			fontbuffer = book_localfont_buffer;
			fontsize = DISP_BOOK_FONTSIZE;
		}

		if( x > ( SCREEN_W - fontsize ) )//ʾΧ
			return 0;

		if( fontbuffer == NULL )
		{
			return 0;
		}
		switch( fontsize )
		{
			case 10:
			case 11:
				font_pitch = 22;
				fontsize = 11;//ʵ9壬ռ11*11
				break;
			case 12:font_pitch = 24;break;
			case 14:font_pitch = 28;break;
			case 16:font_pitch = 32;break;
			case 18:font_pitch = 54;break;
			case 20:font_pitch = 60;break;
			case 24:font_pitch = 72;break;
			case 28:font_pitch = 112;break;
			case 32:font_pitch = 128;break;
			default:fontsize = 12;
					font_pitch = 24;
					break;
		}
		ccur = fontbuffer + ucs2 * font_pitch;
		bitsleft = 0; //
		for ( py = 0; py <  fontsize; py++ )
		{
			ch = *ccur++;
			bitsleft = 8;
			for( px = 0;px < fontsize;px++,bitsleft-- )
			{
				if( bitsleft == 0 )
				{
					ch = *ccur++;
					bitsleft = 8;
				}
				if( ( ch & 0x80 ) != 0 )
					*(BASE+py*SCREEN_W+px) = fontcolor;
				ch <<= 1;
			}
		}
		if( ucs2 < 0x80 )
			return 1;
		else
			return 2;
	}
}

//----------------------------------------------------------------------------------------------------------------------------------------------
//count: ַڴֽ
//----------------------------------------------------------------------------------------------------------------------------------------------
static void UCS2_disp_putnstringhorz( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth )
{
	if( str == NULL ){  return; }
//-------------------------------------------
    const byte * textPos = (const byte *)str;
	int step,aw; //aw:
//-------------------------------------------
	if( fontw == 10 )
		wordspace++;
	while ( count > 0 )
    {
    	if( textPos[0] == 0x00 && textPos[1] == 0x00 )
    		break;
		step = UCS2_disp_putcharhorz( x, y, fontw, fonth, textPos, fontcolor, engine );

		if( step == 2 )
			aw = fontw;
		else if( step == 1 )
			aw = fontw >> 1;
		else
		{
			return;
		}

		textPos += 2;
		x += aw + wordspace;
//		count -= step;
		count -= 2;
    }
	return; //Ѿʾ
}

extern void UCS2_disp_putnstringrvert( int x, int y, dword wordspace, const byte *str, int count, pixel fontcolor, SCREEN_ID engine, int fontw, int fonth )
{
	pixel *vaddr;
	const byte *ccur, *cend;
	U8 font_pitch, fontsize,bitsleft;
	U8 ch;
	U16 px,py;
	dword pos;
	
	CHECK_AND_VALID(x, y);
	
	fontsize = DISP_BOOK_FONTSIZE;

	if( book_localfont_buffer == NULL )
	{
		return 0;
	}
	switch( fontsize )
	{
		case 10:
		case 11:
			font_pitch = 22;
			fontsize = 11;//ʵ9壬ռ11*11
			wordspace++;
			break;
		case 12:font_pitch = 24;break;
		case 14:font_pitch = 28;break;
		case 16:font_pitch = 32;break;
		case 18:font_pitch = 54;break;
		case 20:font_pitch = 60;break;
		case 24:font_pitch = 72;break;
		case 28:font_pitch = 112;break;
		case 32:font_pitch = 128;break;
		default:fontsize = 12;
				font_pitch = 24;
				break;
	}

	while ( count > 0 )
	{
		if( str[0] == 0x00 && str[1] == 0x00 )
			break;

		{
			if (!check_range(x, y))
				return;

			if( engine == DOWN_SCREEN )
				vaddr = disp_get_vaddr_down(x, y);
			else if( engine == UP_SCREEN )
				vaddr = disp_get_vaddr_up(x, y);
			else
			{
				vram_start_temp = bufferTemp;
				if( vram_start_temp == NULL )
					return;
				vaddr = disp_get_vaddr_temp(x, y);
			}

			pos = u8array_to_u16( str, 0 );
			ccur = book_localfont_buffer + pos * font_pitch;//DISP_BOOK_CFONTSIZE
			
			if( pos > 0x80 )
			{
				if (y > SCREEN_H - DISP_BOOK_FONTSIZE) {//һ
					break;
				}
			}
			else
			{
				if ( y > (SCREEN_H - (DISP_BOOK_FONTSIZE>>1)) ) {//һ
					break;	
				}
			}
#if 1	
			bitsleft = 0; //
			for ( py = 0; py <  fontsize; py++ )
			{
				ch = *ccur++;
				bitsleft = 8;
				pixel *vpoint = vaddr;
				for( px = 0;px < fontsize;px++,bitsleft-- )
				{
					if( bitsleft == 0 )
					{
						ch = *ccur++;
						bitsleft = 8;
					}
					if( ( ch & 0x80 ) != 0 )
						*vpoint = fontcolor;
					vpoint += SCREEN_W;
					ch <<= 1;
				}
				vaddr--;
			}
#else
			for (cend = ccur + DISP_BOOK_FONTSIZE * DISP_BOOK_CROWSIZE; ccur < cend; ccur++)
			{
				int b;
				pixel *vpoint = vaddr;
				int bitsleft = DISP_BOOK_FONTSIZE - 8;

				while (bitsleft > 0) {
					for (b = 0x80; b > 0; b >>= 1)
					{
						if (((*ccur) & b) != 0)
							*vpoint = fontcolor;
						vpoint += SCREEN_W;
					}
					++ccur;
					bitsleft -= 8;
				}
				for (b = 0x80; b > fbits_book_last; b >>= 1) {
					if (((*ccur) & b) != 0)
						*vpoint = fontcolor;
					vpoint += SCREEN_W;
				}
				vaddr--;
			}
#endif
			str += 2;
			count -= 2;
			if( pos < 0x80 )
				y += DISP_BOOK_FONTSIZE >> 1;
			else
				y += DISP_BOOK_FONTSIZE;
			y += wordspace;
		}
	}
}

int ProcFontUcs2_SetCallBack( int fontCoding_type )
{
	CB_putnstringhorz = NULL;

	if( fontCoding_type != conf_encode_ucs )
		return false;
	
	CB_disp_putcharhorz = UCS2_disp_putcharhorz;
	CB_putnstringhorz_sys = UCS2_disp_putnstringhorz;
	CB_disp_putnstringrvert = UCS2_disp_putnstringrvert;

	CB_text_get_string_width_sys = UCS2_text_get_string_width_sys;
	CB_text_get_string_width = UCS2_text_get_string_width;
}