#include "gdi.h"
#include <stdlib.h>
#include <fs_api.h>
#include "font.h"
#include <datatype.h>
#include <display.h>
#include <font.h>
#include <ds2io2.h>
#include <config_ebook.h>
#include <DrvMemMgr.h>
#include <debugoff.h>

//-----------------------------------궨----------------------------------------------
#define GDI_USE_DYNAMIC_MEMORY 1

#undef  local
#define local //static

//-----------------------------------ȫֱ----------------------------------------

#if ( GDI_USE_DYNAMIC_MEMORY == 0 )
static pixel vram_Main[SCREEN_W*SCREEN_H];
static pixel vram_Sub[SCREEN_W*SCREEN_H];
#endif

//-------------------------
pixel * bufferMain = 0;
pixel * bufferSub = 0;
pixel *bufferTemp = 0;	//ʹúҪǵΪ0

local U8  *cfontbuffer = 0;//ϵͳʾֿ
local U8  *efontbuffer = 0;//ϵͳʾӢֿ
local U8  *book_cfontbuffer = 0;//ʾֿ
local U8  *book_efontbuffer = 0;//ʾӢֿ
local U8  font_in_book = false; //ǰϵͳʾʾ־false ϵͳʾtrue ʾ


int  cfont_space = 0;
int  efont_space = 0;

int  book_efont_space = 0;
int  book_cfont_space = 0;

U8 efont_space_table[12] = {ASC10_SPACE_MAX, ASC12_SPACE_MAX, ASC14_SPACE_MAX, ASC16_SPACE_MAX, ASC18_SPACE_MAX, ASC20_SPACE_MAX,
												 0, ASC24_SPACE_MAX, 0, ASC28_SPACE_MAX, 0, ASC32_SPACE_MAX};

//-----------------------------------ȫֱ----------------------------------------
extern byte *localfont_buffer, *book_localfont_buffer;
extern byte	*efont_buffer, *book_efont_buffer;
//extern WORDSTOCK ws_table[WS_MAX_ID];
//extern FONT Fontctx;
extern int DISP_FONTSIZE;
extern int DISP_BOOK_FONTSIZE;

//-----------------------------------ȫֺ----------------------------------------

//---------------------------------------------------------------------------------------------
//---------------------------ʼ----------------------------------
void Update_Display( SCREEN_ID engine )
{
	bool RetValue = false;
	pixel *buf_dis_up = NULL;
	pixel *buf_dis_down = NULL;

	buf_dis_up = (pixel*)up_screen_addr;
	buf_dis_down = (pixel*)down_screen_addr;

	if( engine == UP_SCREEN )
	{
		RetValue = SaveVram( (pixel*)buf_dis_up, engine );
	}
	else if( engine == DOWN_SCREEN )
	{
		RetValue = SaveVram( (pixel*)buf_dis_down, engine );
	}
	else if( engine == DUAL_SCREEN )
	{
		RetValue = SaveVram( (pixel*)buf_dis_up, UP_SCREEN );
		if( RetValue )
			RetValue = SaveVram( (pixel*)buf_dis_down, DOWN_SCREEN );
	}

	if( RetValue == false )
		return;

	ds2_flipScreen( engine, 2 );
}

//------------------------------------------------------
//Դ
//------------------------------------------------------
local void FillVram( pixel color, SCREEN_ID engine )
{
	pixel *Vram;
	U32 x,y;

	if( engine == DOWN_SCREEN )
		Vram = 	bufferMain;
	else if( engine == UP_SCREEN )
		Vram = 	bufferSub;
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
			Vram = 	bufferTemp;
		else
			return;
	}
	else
		return;

	for( y=0; y<SCREEN_H; y++ )
	for( x=0; x<SCREEN_W; x++ )
		*Vram++ = color;
}

//------------------------------------------------------
//ȡԴ
//------------------------------------------------------
local pixel* GetVram( SCREEN_ID engine )
{
	if( engine == DOWN_SCREEN )
	{
		return bufferMain;
	}
	else if( engine == UP_SCREEN )
	{
		return bufferSub;
	}
	else if( engine == VRAMTEMP )
	{
		return bufferTemp;
	}
	else
	{
		return NULL;
	}
}

/*-------------------------------------------------------------------------------------------------
//Vram
----------------------------------------------------------------------------------------------------*/
bool SaveVram( pixel *buffer, SCREEN_ID engine )
{
	int w, h;
	pixel *Vram = NULL;

	if( buffer == NULL )
	{
		return false;
	}

	if( engine == DOWN_SCREEN )
	{
		Vram = bufferMain;
	}
	else if( engine == UP_SCREEN )
	{
		Vram = bufferSub;
	}
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
			Vram = bufferTemp;
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}

	for( h=0; h<SCREEN_H; h++ )
	for( w=0; w<SCREEN_W; w++ )
		*buffer++ = *Vram++;

	return true;
}

/*-------------------------------------------------------------------------------------------------
//װVram
----------------------------------------------------------------------------------------------------*/
void LoadVram( pixel *buffer, SCREEN_ID engine )
{
	int w, h;
	pixel *Vram;

	if( engine == DOWN_SCREEN )
	{
		Vram = bufferMain;
	}
	else if( engine == UP_SCREEN )
	{
		Vram = bufferSub;
	}
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
			Vram = bufferTemp;
		else
			return;
	}
	else
		return;

	for( h=0; h<SCREEN_H; h++ )
	for( w=0; w<SCREEN_W; w++ )
		*Vram++ = *buffer++;
}

/*-----------------------------------------------
FUNCTION : ⵱ǰַǷΪַ
IN : const char *textp ַ
RETURN : Ϊַ ture,false
-------------------------------------------------*/
local int GDICheck_CH( const unsigned char *textp )
{
	if( !textp )
		return false;

	return (int)( (*textp) > 0x80 ? true : false );//ֻҪ>0x80һɰ˫ֽڴʹ()
}

local void bitBlt_Specific( const pixel *src, int srcW, int srcH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor, BOOL IsValidFilter )
{
	pixel * pSrc;
	pixel * pSrc_Start;
    pixel * pDest;
    pixel * pDest_Start;
    pixel color;
	int x = 0,y = 0;
	int w = MIN( srcW, destW );
	int h = MIN( srcH, destH );

	if( !src || !dest )
		return;

	pSrc_Start  = (pixel * )(src + srcY * srcW + srcX);
    pDest_Start = (pixel * )(dest + destY * destW + destX);
	for( y=0; y<h; y++ )
	{
        pSrc  = pSrc_Start;
		pDest = pDest_Start;
		for( x=0; x<w; x++ )
		{
			if( IsValidFilter )
			{
				color = *pSrc++;
				if( color != fcolor )
					*pDest = color;
				pDest++;
			}
			else
			{
				*pDest++ =  *pSrc++;
			}
		}
		pSrc_Start  += srcW;
		pDest_Start += destW;
	}
}

local void bitBlt_Specific2( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor, BOOL IsValidFilter )
{
	pixel * pSrc;
	pixel * pSrc_Start;
    pixel * pDest;
    pixel * pDest_Start;
    pixel color;
	int x = 0,y = 0;
	int w = MIN( srcW, destW );
	int h = MIN( srcH, destH );

	w = MIN( w, CpyW );
	h = MIN( h, CpyH );

	pSrc_Start  = (pixel * )(src + srcY * srcW + srcX);
    pDest_Start = (pixel * )(dest + destY * destW + destX);
	for( y=0; y<h; y++ )
	{
        pSrc  = pSrc_Start;
		pDest = pDest_Start;
		for( x=0; x<w; x++ )
		{
			if( IsValidFilter )
			{
				color = *pSrc++;
				if( color != fcolor )
					*pDest = color;
				pDest++;
			}
			else
			{
				*pDest++ =  *pSrc++;
			}
		}
		pSrc_Start  += srcW;
		pDest_Start += destW;
	}
}

local void bitBlt4( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY )
{
	bitBlt_Specific2( src, srcW, srcH, CpyW, CpyH, srcX, srcY, dest, destW, destH, destX, destY, 0, 0 );
}
local void bitBlt3( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, const pixel *dest, int destW, int destH, int destX, int destY )
{
	bitBlt_Specific2( src, srcW, srcH, CpyW, CpyH, 0, 0, dest, destW, destH, destX, destY, 0, 0 );
}

local void bitBlt2( const pixel *src, int srcW, int srcH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY )
{
	bitBlt_Specific( src, srcW, srcH, srcX, srcY, dest, destW, destH, destX, destY, 0, 0 );
}

local void bitBlt1( const pixel *src, int srcW, int srcH, const pixel *dest, int destW, int destH, int destX, int destY )
{
	bitBlt_Specific( src, srcW, srcH, 0, 0, dest, destW, destH, destX, destY, 0, 0 );
}

local void bitBlt( const pixel *src, int srcW, int srcH, const pixel *dest, int destW, int destH )//ֱӿ(ͬСڿԿ)
{
	bitBlt_Specific( src, srcW, srcH, 0, 0, dest, destW, destH, 0, 0, 0, 0 );
}

local void bitBltFC( const pixel *src, int srcW, int srcH,  const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor )
{
	bitBlt_Specific( src, srcW, srcH, 0, 0, dest, destW, destH, destX, destY, fcolor, 1 );
}

int GDIInit( void )
{
	bufferMain = (pixel*)memalign( sizeof( pixel ), SCREEN_W * SCREEN_H * sizeof( pixel ) );
	if( bufferMain == NULL )
		return -1;

	bufferSub = (pixel*)memalign( sizeof( pixel ), SCREEN_W * SCREEN_H * sizeof( pixel ) );
	if( bufferSub == NULL )
		return -1;

	FillVram( COLOR_WHITE, DOWN_SCREEN );
	FillVram( COLOR_BLACK, DOWN_SCREEN );

	cfontbuffer = NULL;
	efontbuffer = NULL;
	return 0;
}

/*-----------------------------------------------------------------------------------------------------------------------------
FUNCTION : COLORREF * mem滭ַӢġֺͷţС10*10 12*12 14*14 16*16 18*18 20*20 24*24 28*28 32*32
IN :  U16 * mem ʾַ
IN : int x ʾַX
IN : int y ʾַY
RETURN : void
--------------------------------------------------------------------------------------------------------------------------------*/
local void GDIDrawChar( int x, int y, const U8 * text,pixel color, SCREEN_ID engine )
{
//----------------------------------------------
	pixel *mem = NULL;
	byte *ccur = NULL;
	pixel *BASE = NULL;
	U8 ch;
	U16 px,py;
	U8 font_pitch, fontsize,bitsleft;

//----------------------------------------------
	if( !text ) return;

	if( engine == DOWN_SCREEN )
		mem = bufferMain;
	else if( engine == UP_SCREEN )
		mem = bufferSub;
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
			mem = bufferTemp;
		else
			return;
	}

	if( !mem )return;
	BASE = mem + y * SCREEN_W + x;
	if( *text > 0x80 )
	{
		if( !localfont_buffer && !book_localfont_buffer ) return;

		if( font_in_book == false )
		{
			cfontbuffer = localfont_buffer;
			fontsize = DISP_FONTSIZE;
		}
		else
		{
			cfontbuffer = book_localfont_buffer;
			fontsize = DISP_BOOK_FONTSIZE;
		}
		switch( fontsize )
		{
			case 10:
				font_pitch = 20;
				break;
			case 12:
				font_pitch = 24;
				break;
			case 14:
				font_pitch = 28;
				break;
			case 16:
				font_pitch = 32;
				break;
			case 18:
				font_pitch = 54;
				break;
			case 20:
				font_pitch = 60;
				break;
			case 24:
				font_pitch = 72;
				break;
			case 28:
				font_pitch = 112;
				break;
			case 32:
				font_pitch = 128;
				break;
			default:
				fontsize = 12;
				font_pitch = 24;
				break;
		}
		ccur = cfontbuffer + ( ((dword)(*text - 0x81)) * 0xBF + ((dword)(*(text + 1) - 0x40)) ) * font_pitch;

		bitsleft = 0;
		for ( py = 0; py <  fontsize; py++ )
		{
			ch = *ccur++;
			bitsleft = 8;
			for( px = 0;px < fontsize;px++,bitsleft-- )
			{
				if( bitsleft == 0 )
				{
					ch = *ccur++;
					bitsleft = 8;
				}
				if( ( ch & 0x80 ) != 0 )
					*(BASE+py*SCREEN_W+px) = color;
				ch <<= 1;
			}
		}
	}
	else if( *text > 0x1F )
	{
		if( !efont_buffer && !book_efont_buffer ) return;

		if( font_in_book == false )
		{
			efontbuffer  = efont_buffer;
			fontsize = DISP_FONTSIZE;
		}
		else
		{
			efontbuffer  = book_efont_buffer;
			fontsize = DISP_BOOK_FONTSIZE;
		}

		switch( fontsize )
		{
			case 10:
				font_pitch = 10;
				break;
			case 12:
				font_pitch = 12;
				break;
			case 14:
				font_pitch = 14;
				break;
			case 16:
				font_pitch = 16;
				break;
			case 18:
				font_pitch = 36;
				break;
			case 20:
				font_pitch = 40;
				break;
			case 24:
				font_pitch = 48;
				break;
			case 28:
				font_pitch = 56;
				break;
			case 32:
				font_pitch = 64;
				break;
			default:
				fontsize = 16;
				font_pitch = 32;
				break;
		}

		ccur = efontbuffer + ((dword)*text) * font_pitch;
		bitsleft = 0;
		for ( py = 0; py <  fontsize; py++ )
		{
			ch = *ccur++;
			bitsleft = 8;
			for( px = 0;px < fontsize/2;px++,bitsleft-- )
			{
				if( bitsleft == 0 )
				{
					ch = *ccur++;
					bitsleft = 8;
				}
				if( ( ch & 0x80 ) != 0 )
					*(BASE+py*SCREEN_W+px) = color;

				ch <<= 1;
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------
/*
FUNCTION :engineһʾcountֽڵַtext
IN : int x ʾַX
IN : int y ʾַY
IN : int w ʾַĿ
IN : int h ʾַĸ߶
IN : const char * text ַʼַ
RETURN : صǰʾַָ
----------------------------------------------------------------------------------------------------*/
local U8 *DrawRectText( int x, int y, int w, int h, dword wordspace, dword rowspace, const unsigned char * text, pixel color, SCREEN_ID engine )
{
//-------------------------------------------
    int fontsize;
    const U8 * textPos = (const U8 *)text;
    int x_start, x_end, y_end;
    int efontspace;//Ӣ
	int cfontspace;//

//-------------------------------------------
    if( font_in_book == false )
    {
    	fontsize = DISP_FONTSIZE;
    	cfontspace = cfont_space;
    	efontspace = efont_space;
	}
    else
    {
    	fontsize = DISP_BOOK_FONTSIZE;
    	cfontspace = book_cfont_space;
    	efontspace = book_efont_space;//Ӣȵ
    }

	CHECK_AND_VALID( x, y );

	if( x + w >= SCREEN_W  || y + h >= SCREEN_H || DISP_FONTSIZE > w || DISP_FONTSIZE > h )
		return (U8*)textPos;//صǰʾָ

    x_start = x;
    x_end = x + w;
    y_end = y + h;
	while( *textPos != 0 )
    {
    	if( (x_end - x) < DISP_FONTSIZE )//ʾΧתһ
		{
			x = x_start;
			y += DISP_FONTSIZE + rowspace;
			if( (y_end -y) < DISP_FONTSIZE )
				return (U8*)textPos;//صǰʾָ
		}
		GDIDrawChar( x, y, textPos, color, engine );

		if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
		{
			textPos += 2;
			x += fontsize - cfontspace;//cfontspaceȵ
		}
		else
		{
			textPos += 1;
			x += fontsize - efontspace;//efontspaceӢȵ
		}
		x += wordspace;//ʾԭʼıôwordspaceӦΪ0Ϊԭպһпʾ꣬ôwordspaceһнʾꡣ
    }
	return NULL; //Ѿʾ
}

//---------------------------------------------------------------------------
local void DrawPixel( int x, int y, pixel color, SCREEN_ID engine )
{
  	if( engine == DOWN_SCREEN )
	{
    	*(bufferMain + y*SCREEN_W + x ) = color;        //bufferMain[y * SCREEN_WIDTH + x] = color;
	}
   	else if( engine == UP_SCREEN )
        *(bufferSub+ y*SCREEN_W  + x) = color;        //bufferSub[y * SCREEN_WIDTH + x] = color;
	else if( engine == VRAMTEMP )
	{
		if( bufferTemp )
		{
			*(bufferTemp+ y*SCREEN_W  + x) = color;        //bufferSub[y * SCREEN_WIDTH + x] = color;
		}
	}
}

/*---------------------------------------------------------------------------------------------------
FUNCTION : engineʾϵ꣨x,ycolor_fillɫһΪh,Ϊw
IN : int x ʼx
IN : int y ʼy
IN : int w 
IN : int h 
IN : SCREEN_ID engine ʾ
RETURN : void
------------------------------------------------------------------------------------------------------*/
local void FillRect( int x, int y, U16 w, U16 h, pixel color, SCREEN_ID engine )
{
//------------------------------------------------------
	U32 i=0,j=0;
	pixel destInc = 0;
  	pixel * pDest = 0;

//------------------------------------------------------
	if( sizeof( pixel ) == 2 )
      color = BIT(15) | color;

    if( engine == DOWN_SCREEN )
        pDest = bufferMain + (y * SCREEN_W) + x;
    else if( engine == UP_SCREEN )
        pDest = bufferSub + (y * SCREEN_W) + x;
    else if( engine == VRAMTEMP )
    {
		if( bufferTemp )
		{
			pDest = bufferTemp + (y * SCREEN_W) + x;
		}
		else
		{
			return;
		}
    }
    else
    	return;

   destInc = SCREEN_W - w;
   for( i = 0; i < h; ++i )
   {
      for( j = 0; j < w; ++j )
      {
         *pDest++ = color;
      }
      pDest += destInc;
   }
}

local void FillRect2( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine ) //ǶԽϵ
{
	int w,h;

	CHECK_AND_VALID( x1, y1 );
	CHECK_AND_VALID( x2, y2 );

	if( (x1 < x2) && (y1 < y2) )
	{
		w = x2 - x1;
		h = y2 - y1;
		FillRect( x1, y1, w, h, color, engine );
	}
	else if( (x1 > x2) && (y1 > y2) )
	{
		w = x1 - x2;
		h = y1 - y2;
		FillRect( x2, y2, w, h, color, engine );
	}
	else
	{
		return;
	}
}

/*
FUNCTION : engineʾϴ꣨x1,y1һֱߵ꣨x2,y2
IN : int x1 ʼx
IN : int y1 ʼy
IN : int x2 յx
IN : int y2 յy
IN : SCREEN_ID engine ʾ
RETURN : void
*/
local void DrawLine( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine )
{
//---------------------------------------------------------
    int ys,ye;
    int xs,xe;

    int px = 0;
    int py = 0;

    int xv;
    int yv;

    float yv2;
    float xv2;

    float px2=0;
    float py2=0;

    float xe2;
    float ye2;


//---------------------------------------------------------
    if((x1==x2)&&(y1==y2)) return;

    CHECK_AND_VALID( x1, y1 );
    CHECK_AND_VALID( x2, y2 );

    if(x1==x2) //ֱ
    {
        if(y1<y2)
        {
            ys=y1;
            ye=y2-1;
        }
        else
        {
            ys=y2+1;
            ye=y1;
        }
        for( py=ys;py<=ye;py++)
				{
            DrawPixel(x1,py,color,engine);
        }
        return;
    }

    if(y1==y2) //ˮƽ
    {
        if(x1<x2)
        {
            xs=x1;
            xe=x2-1;
        }
        else
        {
            xs=x2+1;
            xe=x1;
        }
        FillRect( xs, y1, xe - xs + 1, 1, color, engine );
        return;
    }

    if(abs(x2-x1)>abs(y2-y1))
    {
        px=0;
        py2=0;
        xe=x2-x1;
        ye2=y2-y1;

        if(0<xe) {
            xv=1;
        } else {
            xv=-1;
        }
        yv2=ye2/abs(xe);

        while(px!=xe)
       	{
            DrawPixel(x1+px,y1+(int)py2,color,engine);
            px+=xv;
            py2+=yv2;
        }
        return;
    }
    else
    {
        px2=0;
        py=0;
        xe2=x2-x1;
        ye=y2-y1;

        xv2=xe2/abs(ye);
        if(0<ye)
        {
            yv=1;
        }
        else
        {
            yv=-1;
        }

        while(py!=ye)
       	{
            DrawPixel(x1+(int)px2,y1+py,color,engine);
            px2+=xv2;
            py+=yv;
        }
        return;
    }
}


/*
FUNCTION : engineʾ꣨x,yһΪh,Ϊwı߿
IN : int x ʼx
IN : int y ʼy
IN : int w 
IN : int h 
IN : Rect_w߿
IN : SCREEN_ID engine ʾ
RETURN : void
*/
local void DrawRect0( int x, int y, U16 w, U16 h, U16 Rect_w, pixel color, SCREEN_ID engine )
{
	int i,j;
	pixel destInc = 0;
  	pixel *pDest = 0;

	if( w == 0 || h == 0 || w < (Rect_w <<1) || h < (Rect_w <<1) )
		return;
	CHECK_AND_VALID( x, y );

    if( engine == DOWN_SCREEN )
        pDest = bufferMain + (y * SCREEN_W) + x;
    else if( engine == UP_SCREEN )
        pDest = bufferSub + (y * SCREEN_W) + x;
    else if( engine == VRAMTEMP )
    {
		if( bufferTemp )
		{
			pDest = bufferTemp + (y * SCREEN_W) + x;
		}
		else
		{
			return;
		}
    }
    else
    	return;

   destInc = SCREEN_W - w;
   for( i = 0; i < h; ++i )
   {
      for( j = 0; j < w; ++j )
      {
      	if( j >= Rect_w && j < (w-Rect_w) && i >= Rect_w && i < (h-Rect_w) )
      		pDest++;
      	else
         *pDest++ = color;
      }
      pDest += destInc;
   }
}

local void DrawRect( int x, int y, U16 w, U16 h, pixel color, SCREEN_ID engine )
{
    DrawLine( x, y, x + w - 1, y, color, engine );
    DrawLine( x + w - 1, y, x + w - 1, y + h - 1, color, engine );
    DrawLine( x + w - 1, y + h - 1, x, y + h - 1, color, engine );
    DrawLine( x, y + h - 1, x, y, color, engine );
}

local void DrawRect2( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine )
{
    int w,h;

    CHECK_AND_VALID( x1, y1 );
    CHECK_AND_VALID( x2, y2 );

	w = abs( x2 - x1 );
	h = abs( y2 - y1 );

    DrawRect( min( x1,x2), min( y1,y2), w, h, color, engine );
}
//-------------------------------------------------------------------------------------------------
/*
FUNCTION :engineһʾcountֽڵַtext
IN : int x ʾַX
IN : int y ʾַY
IN : int w ʾַĿ
IN : int h ʾַĸ߶
IN : const char * text ַʼַ
RETURN : صǰʾַָ
----------------------------------------------------------------------------------------------------*/
#if 0
local U8 *DrawTextLinen( int x, int y, dword wordspace, const unsigned char * text, dword count, pixel color, SCREEN_ID engine )
{
	if( text == NULL )
		return NULL;
//-------------------------------------------
    int fontsize;
    const U8 * textPos = (const U8 *)text;
    const U8 *text_end = textPos + count;
	int efontspace = 0;//Ӣ
	int cfontspace = 0;//
	int aw,step;//aw:
//-------------------------------------------
    if( font_in_book == false )
    {
    	fontsize = DISP_FONTSIZE;
    	cfontspace = cfont_space;
    	efontspace = efont_space;
	}
    else
    {
    	fontsize = DISP_BOOK_FONTSIZE;
    	cfontspace = book_cfont_space;
    	efontspace = book_efont_space;//Ӣȵ
    }

    while( textPos < text_end )
    {
    	if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
    	{
    		step = 2;
    		aw = fontsize;
    	}
    	else
    	{
    		step = 1;
    		aw = disp_ewidth[*(byte *) textPos];
    	}

    	if( x > ( SCREEN_W - aw ) )//ʾΧ
    	{
    		return (U8*)textPos;//صǰʾָ
    	}

		GDIDrawChar( x, y, textPos, color, engine );
		textPos += step;
		x += aw + wordspace;
    }
	return 0; //Ѿʾ
}

local U8 *DrawTextLinen_sys( int x, int y, dword wordspace, const unsigned char * text, dword count, pixel color, SCREEN_ID engine )
{
	if( text == NULL )
		return NULL;
//-------------------------------------------
    int fontsize;
    const U8 * textPos = (const U8 *)text;
    const U8 *text_end = textPos + count;
	int efontspace = 0;//Ӣ
	int cfontspace = 0;//
//-------------------------------------------
    if( font_in_book == false )
    {
    	fontsize = DISP_FONTSIZE;
    	cfontspace = cfont_space;
    	efontspace = efont_space;
	}
    else
    {
    	fontsize = DISP_BOOK_FONTSIZE;
    	cfontspace = book_cfont_space;
    	efontspace = book_efont_space;//Ӣȵ
    }

    while( textPos < text_end )
    {
    	if( x > ( SCREEN_W - 1 - DISP_FONTSIZE ) )//ʾΧ
		{
			return (U8*)textPos;//صǰʾָ
		}

		GDIDrawChar( x, y, textPos, color, engine );

		if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
		{
			textPos += 2;
			x += fontsize - cfontspace;//cfontspaceȵ
			if( fontsize == 10 )
				x += 1;
		}
		else
		{
			textPos += 1;
			x += fontsize - efontspace;//efontspaceӢȵ
		}
		x += wordspace;//ʾԭʼıôwordspaceӦΪ0Ϊԭպһпʾ꣬ôwordspaceһнʾꡣ
    }
	return 0; //Ѿʾ
}

//-------------------------------------------------------------------------------------------------
/*
FUNCTION :engineʾַtext
IN : int x ʾַX
IN : int y ʾַY
IN : int w ʾַĿ
IN : int h ʾַĸ߶
IN : const char * text ַʼַ
RETURN : صǰʾַָ
----------------------------------------------------------------------------------------------------*/
local U8 *TextOutRectp( int *x, int y, U16 w, U16 h, const unsigned char * text, pixel color, SCREEN_ID engine )
{
    const U16 originX = *x;
    const U8 * textPos = (const U8 *)text;
    BOOL FontH = font_in_book ? DISP_BOOK_FONTSIZE : DISP_FONTSIZE;
    int efontspace;//Ӣ
	int cfontspace;//

	if( text == NULL )
		return NULL;

    if( font_in_book == false )
    {
    	cfontspace = cfont_space;
    	efontspace = efont_space;
    }
    else
    {
    	cfontspace = book_cfont_space;
    	efontspace = book_efont_space;
    }

    while( *textPos != 0 )
    {
		if( *x >=originX + w )//ʾΧ
			return (U8*)textPos;//صǰʾָ

        if( '\r' == *textPos || '\n' == *textPos )
        {
			y = y + FontH;
            *x = originX;
            ++textPos;
        }
	   	else
		{
			GDIDrawChar( *x, y, textPos, color, engine );

			if( GDICheck_CH( (const unsigned char*)textPos ) )
			{
				textPos += 2;
				*x += FontH - cfontspace;//cfontspace
			}
			else
			{
				textPos += 1;
				*x += FontH - efontspace;//efontspaceӢ
			}
	    }
    }
	return 0; //Ѿʾ
}

//-------------------------------------------------------------------------------------------------
/*
FUNCTION :engineʾַtext
IN : int x ʾַX
IN : int y ʾַY
IN : int w ʾַĿ
IN : int h ʾַĸ߶
IN : const char * text ַʼַ
RETURN : صǰʾַָ
----------------------------------------------------------------------------------------------------*/
local U8 *TextOutRect( int x, int y, U16 w, U16 h, const unsigned char * text, pixel color, SCREEN_ID engine )
{
	if( text == NULL )
		return NULL;
	return TextOutRectp( &x, y, w, h, text, color, engine );
}

//-------------------------------------------------------------------------------------------------------------
/*
FUNCTION :engineʾһַtext
IN : int *x ʾַX
IN : int y ʾַY
IN : int w ʾַĿ
IN : const char * text ַʼַ
RETURN : صǰʾַָ
ע⣺ʾַĸ߶
---------------------------------------------------------------------------------------------------------------*/
local U8 *DrawTextLine( int x1, int y1, U16 w, const unsigned char *text, pixel color, SCREEN_ID engine )
{
	if( text == NULL )
		return NULL;
	int fontsize = font_in_book ? DISP_BOOK_FONTSIZE : DISP_FONTSIZE;
	return TextOutRect( x1, y1, w, fontsize, text, color, engine );
}

local void TextOut( int x, int y, const unsigned char * text, pixel color, SCREEN_ID engine )
{
	if( text == NULL )
		return;
  	TextOutRect( x, y, SCREEN_W, SCREEN_H, text, color, engine );
}
#endif

int text_get_string_width_sys2( const unsigned char * text, dword count, dword wordspace )
{
//-------------------------------------------
	int width = 0;
    int fontsize;
    const U8 * textPos = (const U8 *)text;
    const U8 *text_end = textPos + count;
	int efontspace = 0;//Ӣ
	int cfontspace = 0;//
//-------------------------------------------

	if( text == NULL )
		return 0;

    if( font_in_book == false )
    {
    	fontsize = DISP_FONTSIZE;
    	cfontspace = cfont_space;
    	efontspace = efont_space;
	}
    else
    {
    	fontsize = DISP_BOOK_FONTSIZE;
    	cfontspace = book_cfont_space;
    	efontspace = book_efont_space;//Ӣȵ
    }

    while( textPos < text_end )
    {
		if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
		{
			textPos += 2;
			width += fontsize - cfontspace;//cfontspaceȵ
			if( fontsize == 10 )
				width += 1;
		}
		else
		{
			textPos += 1;
			width += fontsize - efontspace;//efontspaceӢȵ
		}
		width += wordspace;//ʾԭʼıôwordspaceӦΪ0Ϊԭպһпʾ꣬ôwordspaceһнʾꡣ
    }
	return width; //Ѿʾ
}


int text_get_string_width_sys3( const unsigned char * text, dword wordspace )
{
	dword count = 0;
	unsigned char * ptext = (unsigned char * )text;

	if( text == NULL )
		return 0;
	while( *ptext != '\0' )
	{
		count++;
		ptext++;
	}
	return text_get_string_width_sys2( text, count, wordspace );
}

int CN_text_get_string_width_sys2( const unsigned char * str, int count, dword wordspace, int fontw )
{
	
	if( str == NULL || count <= 0 )
		return 0;
//-------------------------------------------
	int width = 0;
    const U8 * textPos = (const U8 *)str;
	int aw,step;//aw:
//-------------------------------------------
	while ( *textPos != 0 && count > 0 )
    {
    	if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
    	{
    		step = 2;
    		aw = fontw;
    		if( aw == 10 )
    			aw++;
    	}
    	else
    	{
    		step = 1;
    		aw = disp_ewidth[*(byte *) textPos];
    	}
    	
		textPos += step;
		width += aw + wordspace;
    }
	return width; //Ѿʾ
}

//--------------------------------------------------------------------------------------------------------------------------------------------
//ȡؿ
//--------------------------------------------------------------------------------------------------------------------------------------------
int CN_text_get_string_width_sys( const unsigned char * str, dword wordspace, int fontw, int encode_type )//encode_type: ,GBKUTF8
{
	int count = 0;
	unsigned char * pstr = (unsigned char * )str;
	
	if( str == NULL )
		return 0;
	while( *pstr != '\0' )
	{	
		count++;
		pstr++;
	}
	return CN_text_get_string_width_sys2( str, count, wordspace, fontw );	
}

static void CN_disp_putnstringhorz_sys( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height )
{
	if( str == NULL )
		return;
//-------------------------------------------
    int fontsize;
    const U8 * textPos = (const U8 *)str;
//    const U8 *text_end = textPos + count;
	int aw,step;//aw:
//-------------------------------------------
    if( font_in_book == false )
    {
    	fontsize = DISP_FONTSIZE;
	}
    else
    {
    	fontsize = DISP_BOOK_FONTSIZE;
    }
    
	while ( *textPos != 0 && count > 0 )
    {
    	if( GDICheck_CH( (const unsigned char*)textPos ) )//ģأд޸ģĿǰֻ֧֣
    	{
    		step = 2;
    		aw = fontsize;
    	}
    	else
    	{
    		step = 1;
    		aw = disp_ewidth[*(byte *) textPos];
    	}
    	
    	if( x > ( SCREEN_W - aw ) )//ʾΧ
    	{
    		return;
    	}
    	
		GDIDrawChar( x, y, textPos, color, engine );
		textPos += step;
		count -= step;
		x += aw + wordspace;
    }
	return; //Ѿʾ
}

static void CN_disp_putnstringhorz( int x, int y, dword wordspace, const byte *str, int count, pixel color, SCREEN_ID engine, int width, int height, int top, int bot )
{
	
}

void ProcFontcn_SetCallBack()
{
	CB_putnstringhorz = CN_disp_putnstringhorz;
	CB_putnstringhorz_sys = CN_disp_putnstringhorz_sys;
	CB_text_get_string_width_sys = CN_text_get_string_width_sys; 
	CB_disp_putnstringrvert = disp_putnstringrvert;
}
