#ifndef _GDI_H_
#define _GDI_H_

#ifdef __cplusplus
extern "C" {
#endif

#include <datatype.h>
#include <font.h>
#include <config_ebook.h>
#include <ds2io.h>

extern pixel *bufferTemp;
extern pixel *bufferMain;
extern pixel *bufferSub;
extern U8  font_in_book;

#if 0
enum GRAPHICS_ENGINE
{
    UP_SCREEN = 1,
    DOWN_SCREEN = 2,
    DUAL_SCREEN = 3,
    VRAMTEMP = 4
};
#else
#define 	VRAMTEMP 		4
#endif

//typedef  enum GRAPHICS_ENGINE	SCREEN_ID;

enum MAIN_ENGINE_LAYER
{
    MEL_UP = 0,
    MEL_DOWN = 1
};

enum PRECENT_MODE
{
	NOTHING = 0,
    LEFT_TO_RIGHT = 1,
    RIGHY_TO_LEFT = 2,
	UP_TO_DOWN = 3,
	DOWN_TO_UP = 4
};

enum SUB_ENGINE_MODE
{
    SEM_TEXT = 0,
    SEM_GRAPHICS = 1
};

typedef enum
{
	GBK10 = 10,
	GBK12 = 12,
	GBK14 = 14,
	GBK16 = 16,
	GBK18 = 18,
	GBK20 = 20,
	GBK24 = 24,
	GBK28 = 28,
	GBK32 = 32
}CFONT;

typedef enum
{
	ASC10 = 10,
	ASC12 = 12,
	ASC14 = 14,
	ASC16 = 16,
	ASC18 = 18,
	ASC20 = 20,
	ASC24 = 24,
	ASC28 = 28,
	ASC32 = 32
}EFONT;

typedef enum
{
	ASC10_SPACE_MAX = 4,//
	ASC12_SPACE_MAX = 6,//
	ASC14_SPACE_MAX = 7,//ֿ⾭
	ASC16_SPACE_MAX = 8,//
	ASC18_SPACE_MAX = 9,//ֿ⾭
	ASC20_SPACE_MAX = 10,//ֿ⾭
	ASC24_SPACE_MAX = 12,//ֿ⾭
	ASC28_SPACE_MAX = 14,//
	ASC32_SPACE_MAX = 16//
}FONTSPACE;


typedef struct _gdiStruct
{
//---------------Ļɫ---------------------
  pixel penColor;
  pixel penColorSub;

//----------------------------------------
  pixel * bufferMain;

//----------------------------------------
  pixel * bufferSub;



  U32 layerPitch;

  U8  *cfontbuffer;//ֿ
  U8  *efontbuffer;//Ӣֿ

  U8  ccurfont;//ǰʹõֿ⣬ͬʱҲʾĴС
  U8  ecurfont;//ǰʹõӢֿ⣬ͬʱҲʾĴС

//	WS_ID  ccurfont_id;//ǰֿID
//	WS_ID  ecurfont_id;//ǰӢֿID
//---------------Ļѡ-------------------------
	SCREEN_ID engine;

	int efontspace;//Ӣ
	int cfontspace;//
	SCREENREF linespace; //м
//----------------ָ붨-----------------------------
}GDI;

#undef  local
#define local extern

local int GDIInit( void );
local void GDIDrawChar( int x, int y, const U8 * text,pixel color, SCREEN_ID engine );
local int GDICheck_CH( const unsigned char *textp );
local void DrawPixel( int x, int y, pixel color, SCREEN_ID engine );
local void FillRect( int x, int y, U16 w, U16 h, pixel color, SCREEN_ID engine );
local void FillRect2( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine );
local void DrawLine( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine );
local void DrawRect0( int x, int y, U16 w, U16 h, U16 Rect_w, pixel color, SCREEN_ID engine );
local void DrawRect( int x, int y, U16 w, U16 h, pixel color, SCREEN_ID engine );
local void DrawRect2( int x1, int y1, int x2, int y2, pixel color, SCREEN_ID engine );
local U8 *DrawTextLinen( int x, int y, dword wordspace, const unsigned char * text, dword count, pixel color, SCREEN_ID engine );
local U8 *DrawTextLinen_sys( int x, int y, dword wordspace, const unsigned char * text, dword count, pixel color, SCREEN_ID engine );
local U8 *TextOutRectp( int *x, int y, U16 w, U16 h, const unsigned char * text, pixel color, SCREEN_ID engine );
local U8 *TextOutRect( int x, int y, U16 w, U16 h, const unsigned char * text, pixel color, SCREEN_ID engine );
local U8 *DrawTextLinep( int *x1, int y1, U16 w, const unsigned char *text, pixel color, SCREEN_ID engine );
local U8 *DrawTextLine( int x1, int y1, U16 w, const unsigned char *text, pixel color, SCREEN_ID engine );
local void TextOut( int x, int y, const unsigned char * text, pixel color, SCREEN_ID engine );
local U8 *TextOutPan( int *x, int y, const unsigned char * text, pixel color, SCREEN_ID engine );
local U8 *DrawRectText( int x, int y, int w, int h, dword wordspace, dword rowspace, const unsigned char * text, pixel color, SCREEN_ID engine );

local void FillVram( pixel color, SCREEN_ID engine );
local pixel* GetVram( SCREEN_ID engine );
local void bitBlt_Specific( const pixel *src, int srcW, int srcH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor, BOOL IsValidFilter );
local void bitBlt_Specific2( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor, BOOL IsValidFilter );
local void bitBlt( const pixel *src, int srcW, int srcH, const pixel *dest, int destW, int destH );
local void bitBlt1( const pixel *src, int srcW, int srcH, const pixel *dest, int destW, int destH, int destX, int destY );
local void bitBlt2( const pixel *src, int srcW, int srcH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY );
local void bitBlt3( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, const pixel *dest, int destW, int destH, int destX, int destY );
local void bitBlt4( const pixel *src, int srcW, int srcH, int CpyW, int CpyH, int srcX, int srcY, const pixel *dest, int destW, int destH, int destX, int destY );

local void bitBltFC( const pixel *src, int srcW, int srcH,  const pixel *dest, int destW, int destH, int destX, int destY, pixel fcolor );

int text_get_string_width_sys2( const unsigned char * text, dword count, dword wordspace );
int text_get_string_width_sys3( const unsigned char * text, dword wordspace );

local void Flush( SCREEN_ID engine );
bool SaveVram( pixel *buffer, SCREEN_ID engine );
void LoadVram( pixel *buffer, SCREEN_ID engine );
pixel GetFLBgColor( U32 n_Line );
void Update_Display( SCREEN_ID engine );
void ProcFontcn_SetCallBack();

#undef  CHECK_AND_VALID
#define CHECK_AND_VALID(x, y) \
{\
	x = (x < 0) ? 0 : x; \
	y = (y < 0) ? 0 : y; \
	x = (x >= SCREEN_W )? SCREEN_W - 1: x;\
	y = (y >= SCREEN_H )? SCREEN_H - 1: y;\
}


#define Flush( engine ) Update_Display( engine )

#ifdef __cplusplus
}
#endif

#endif//_GDI_H_
