#include <stdio.h>

#include "_const.h"

#include "plugin.h"
#include "plugin_def.h"

#include "libgif/gif_lib.h"

#include <datatype.h>
#include <DrvMemMgr.h>
#include <fs_api.h>
#include <display.h>
#include <mystring.h>
#include <scene_image.h>
#include <image.h>
#include <strsafe.h>
#include <unzip.h>
#include <string.h>
#include <debugoff.h>

#define 	_consolePrintf		F

#define			IMAGEVIEW_MEMDEST_SIZE			( 1024 * 1024 )//1MBytes


void cbLoadLibrary(void)
{
}

void cbFreeLibrary(void)
{
}

void cbQueryInterfaceLibrary(void)
{
}

// -----------------

typedef struct {
  u32 Palettes[256];
  u32 PalettesCount;
  u32 Width,Height;
} TGIFInfo;

TGIFInfo GIFInfo;
U8 *pBitmap=NULL;
u32 BitmapWidth=0;
static int ErrorCode = ERR_UNKNOWN;

// ------------------------------------------------------------------------------------

static void _PrintGifError(void)
{
  _consolePrintf("GIF error:%d\n",GifLastError());
}

static void _PrintGifErrorStr(char *str)
{
  _consolePrintf("GIF error:%s\n",str);
}

FILE *readFunc_FileHandle = NULL;
U8 *ImgBufferSrc = NULL;
U32 ImgBufferSrc_Size = 0;
U32 readFunc_FpOffset = 0;

static int readFunc(GifFileType* GifFile, GifByteType* buf, int count)
{
	if( ImgBufferSrc )
	{
		if( readFunc_FpOffset + count > ImgBufferSrc_Size )
			count = ImgBufferSrc_Size - readFunc_FpOffset;
		memcpy( buf, ImgBufferSrc + readFunc_FpOffset, count );
		readFunc_FpOffset += count;
		return count;
	}
	else// if( readFunc_FileHandle )
  		return(fread(buf,1,count,readFunc_FileHandle));
}

static void MemSet8CPU(U8 v,void *dst,u32 len)
{
	u32 cnt;
  len>>=0;
  if(len==0) return;

  U8 *_dst=(U8*)dst;

  for(cnt=0;cnt<len;cnt++){
    _dst[cnt]=v;
  }
}

#define GAMMA(x)	(x)

bool LoadGIF(FILE *FileHandle)
{
	u32 idx;
	u32 InterlaceCount;
	s32 y;
  readFunc_FileHandle=FileHandle;

  if(FileHandle==0 && ImgBufferSrc==NULL){
    _PrintGifErrorStr("SourceData Null.");
    return(false);
  }

  {
    GifFileType *GifFile;

    _consolePrintf("OpenFile.\n");
    if ((GifFile = DGifOpen((void*)FileHandle, readFunc)) == NULL) {
      _PrintGifError();
      return false;
    }
    /* Scan the content of the GIF file and load the image(s) in: */
    GifRecordType RecordType;

    do {
      _consolePrintf("DGifGetRecordType\n");
      if (DGifGetRecordType(GifFile, &RecordType) == GIF_ERROR) {
        _PrintGifError();
        return false;
      }
      switch (RecordType) {
        case IMAGE_DESC_RECORD_TYPE:
          _consolePrintf("IMAGE_DESC_RECORD_TYPE\n");

          _consolePrintf("DGifGetImageDesc\n");
          if (DGifGetImageDesc(GifFile) == GIF_ERROR) {
            _PrintGifError();
            return false;
          }

          s32 Width=GifFile->Image.Width;
          s32 Height=GifFile->Image.Height;
          u32 PalettesCount;

/*
_consolePrintf("p:GifFile=%x\n",(u32)GifFile);
_consolePrintf("p:&Image.ColorMap=%x\n",&GifFile->Image.ColorMap);
_consolePrintf("p:&SColorMap=%x\n",&GifFile->SColorMap);
*/

          _consolePrintf("Update Color map\n",0);

          _consolePrintf("GifFile->Image.ColorMap = %x\n",(int)GifFile->Image.ColorMap);
          _consolePrintf("GifFile->SColorMap = %x\n",(int)GifFile->SColorMap);

          ColorMapObject *ColorMap = (GifFile->Image.ColorMap ? GifFile->Image.ColorMap : GifFile->SColorMap);

          PalettesCount=ColorMap->ColorCount;

          for(idx=0;idx<256;idx++){
            GIFInfo.Palettes[idx]=0 | BIT15;
          }

          for(idx=0;idx<PalettesCount;idx++){
            GifColorType* pColor = &ColorMap->Colors[idx];

            u32 pal=0;

            pal|=(GAMMA(pColor->Blue) & 0xff)<< 0;
            pal|=(GAMMA(pColor->Green) & 0xff) << 8;
            pal|=(GAMMA(pColor->Red) & 0xff) << 16;

            GIFInfo.Palettes[idx]=pal;
          }

          BitmapWidth=(Width+4+4) & ~3;

          _consolePrintf("malloc(%d);\n",BitmapWidth*Height);

          if(pBitmap!=NULL) free(pBitmap);
          pBitmap=(U8*)malloc(BitmapWidth*Height);
          if(pBitmap==NULL){
            _PrintGifErrorStr("out of memory.\n");
            return(false);
          }
          MemSet8CPU(GifFile->SBackGroundColor,pBitmap,BitmapWidth*Height);

          _consolePrintf("GetImage.\n");

          if (GifFile->Image.Interlace) {
            /* Need to perform 4 passes on the images: */
            const short InterlacedOffset[] = { 0, 4, 2, 1 }; /* The way Interlaced image should. */
            const short InterlacedJumps[] = { 8, 8, 4, 2 };    /* be read - offsets and jumps... */
            for (InterlaceCount=0; InterlaceCount<4; InterlaceCount++){
              u32 prgdiv=Height/16;
              for (y = InterlacedOffset[InterlaceCount]; y < Height; y += InterlacedJumps[InterlaceCount]) {
                if(prgdiv!=0){
                  prgdiv--;
                  }else{
                  prgdiv=Height/16;
                }
                if (DGifGetLine(GifFile, &pBitmap[(Height-1-y)*BitmapWidth], Width) == GIF_ERROR) {
                  _PrintGifError();
                  return false;
                }
              }
            }
            }else{
            u32 prgdiv=Height/16;
            for (y = 0; y < Height; y++) {
              if(prgdiv!=0){
                prgdiv--;
                }else{
                prgdiv=Height/16;
              }
              if (DGifGetLine(GifFile, &pBitmap[(Height-1-y)*BitmapWidth], Width) == GIF_ERROR) {
                _PrintGifError();
                return false;
              }
            }
          }

          _consolePrintf("GIFInfo Update.\n");

          GIFInfo.Width=Width;
          GIFInfo.Height=Height;
          GIFInfo.PalettesCount=PalettesCount;
          break;
        case EXTENSION_RECORD_TYPE:
          _consolePrintf("EXTENSION_RECORD_TYPE\n");
          /* Skip any extension blocks in file: */
          GifByteType *Extension;
          int ExtCode;
          if (DGifGetExtension(GifFile, &ExtCode, &Extension) == GIF_ERROR) {
            _PrintGifError();
            return false;
          }
          while (Extension != NULL) {
            if (DGifGetExtensionNext(GifFile, &Extension) == GIF_ERROR) {
              _PrintGifError();
              return false;
            }
          }
          break;
        case TERMINATE_RECORD_TYPE:
          _consolePrintf("TERMINATE_RECORD_TYPE\n");
          break;
        default:      /* Should be traps by DGifGetRecordType. */
          _consolePrintf("unknown RECORD_TYPE\n");
          break;
      }
    }
    while ((RecordType != TERMINATE_RECORD_TYPE)&&(pBitmap==NULL));

    _consolePrintf("CloseFile.\n");
    /* Close file when done */
    if (DGifCloseFile(GifFile) == GIF_ERROR) {
      _PrintGifError();
      return false;
    }
  }
	readFunc_FileHandle = NULL;
  if(pBitmap==NULL){
    return(false);
    }else{
    return(true);
  }
}

// ------------------------------------------------------------------------------------

extern void Free(void);
void Free(void)
{
  if(pBitmap!=NULL){
    free(pBitmap);
    pBitmap=NULL;
  }
}

typedef struct {
  s32 x,y,w,h;
} TRect;

void GetBitmap24(u32 LineY,U8 *pBM)
{
	s32 x;
  u32 *PaletteTable=GIFInfo.Palettes;

  U8 *pSrcBM=&pBitmap[(GIFInfo.Height-LineY-1)*BitmapWidth];

  for( x=0;x<GIFInfo.Width;x++){
    u32 pal=PaletteTable[pSrcBM[x]];

    pBM[0]=pal >> 16;
    pBM[1]=pal >> 8;
    pBM[2]=pal >> 0;
    pBM+=3;
  }
}

void GetBitmap16(u32 LineY,u16 *pBM)
{
	s32 x;
	U8 r,g,b;
  u32 *PaletteTable=GIFInfo.Palettes;

  U8 *pSrcBM=&pBitmap[(GIFInfo.Height-LineY-1)*BitmapWidth];

  for( x=0;x<GIFInfo.Width;x++){
    u32 pal=PaletteTable[pSrcBM[x]];

    r = pal >> 16;
    g = pal >> 8;
    b = pal >> 0;

    r >>= 3;
    g >>= 3;
    b >>= 3;

    pBM[x] = RGB15( r,g,b );
  }
}

s32 GetWidth(void)
{
  return(GIFInfo.Width);
}

s32 GetHeight(void)
{
  return(GIFInfo.Height);
}

int GetInfoIndexCount(void)
{
  return(0);
}

bool GetInfoStrA(int idx,char *str,int len)
{
  return(false);
}

bool GetInfoStrW(int idx,UnicodeChar *str,int len)
{
  return(false);
}

bool GetInfoStrUTF8(int idx,char *str,int len)
{
  return(false);
}

//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
extern int gif_read2( FILE *fp, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor )
{
	int result = -1;
	int y;
	dword width=0,height=0;
	dword ImgBufferPixel_Max = 0;
	dword ImgBufferPixel_Cur = 0;
	pixel *ImgBuffer = NULL;
	pixel *pImgBuffer = NULL;
	FILE *fp_w = NULL;
	bool ImgBufferHold = false;

	ErrorCode = ERR_UNKNOWN;

	result = LoadGIF( fp );

	if( result )
	{
		width = GetWidth();
		height = GetHeight();

		ImgBufferPixel_Max = width*height;
		ImgBuffer = memalign( PIXEL_BYTES, ImgBufferPixel_Max << (PIXEL_BYTES>>1) );
		if( ImgBuffer == NULL )
		{
			ImgBufferPixel_Max = IMAGEVIEW_MEMDEST_SIZE >> (PIXEL_BYTES>>1);
			ImgBuffer = memalign( PIXEL_BYTES, (ImgBufferPixel_Max + width) << (PIXEL_BYTES>>1) );
			if( ImgBuffer == NULL )
			{
				ErrorCode = ERR_MEM_LACK;
				goto _gif_read2_Exit;
			}
		}

		if( ImgBufferPixel_Max < width*height )
		{
			ImgBufferHold = false;
			fp_w = fopen_imgSwapfile( "w" );
			if( !fp_w )
			{
				ErrorCode = ERR_FILE_OPEN;
				goto _gif_read2_Exit;
			}
		}
		else
		{
			ImgBufferHold = true;
		}

		if( ImgBufferHold )
		{
			pImgBuffer = ImgBuffer;
			for( y=0; y<height; y++ )
			{
				GetBitmap16( y, pImgBuffer );
				pImgBuffer += width;
			}
		}
		else
		{
			ImgBufferPixel_Cur = 0;
			pImgBuffer = ImgBuffer;
			for( y=0; y<height; y++ )
			{
				GetBitmap16( y, pImgBuffer );
				ImgBufferPixel_Cur += width;
				pImgBuffer += width;

				if( ImgBufferPixel_Cur >= ImgBufferPixel_Max )
				{
					fwrite( ImgBuffer, PIXEL_BYTES, ImgBufferPixel_Max, fp_w );
					memcpyword( ImgBuffer, ImgBuffer + ImgBufferPixel_Max, ImgBufferPixel_Cur - ImgBufferPixel_Max );
					ImgBufferPixel_Cur -= ImgBufferPixel_Max;
					pImgBuffer = ImgBuffer + ImgBufferPixel_Cur;
				}
			}

			if( ImgBufferPixel_Cur > 0 )
			{
				fwrite( ImgBuffer, PIXEL_BYTES, ImgBufferPixel_Cur, fp_w );
				ImgBufferPixel_Cur = 0;
			}
		}
	}


	*pwidth = width;
	*pheight = height;
	*bgcolor = COLOR_BLACK;//ɫΪɫ
	if( ImgBufferHold )
	{
		*image_data = ImgBuffer;
	}
	Thumbimg_Needzoom = true;
	ErrorCode = ERR_NONE;
_gif_read2_Exit:

	if( ImgBuffer && !ImgBufferHold )
		free( ImgBuffer );

	Free();

	if( fp_w )
		fclose( fp_w );

	return ErrorCode;
}

//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
extern int gif_read(const char *filename, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor)
{
	FILE *fp = fopen( filename, "r" );
	if( !fp )
	{
		ErrorCode = ERR_FILE_OPEN;
		goto _gif_read_Exit;
	}

	gif_read2( fp, pwidth, pheight, image_data, bgcolor );

	if( fp )
		fclose( fp );

_gif_read_Exit:
	return ErrorCode;
}

//------------------------------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------------------------------
extern int gif_read_in_zip( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn )
{
//-------------------------------------------------------------
	dword filelen = 0;
	int len, len_w;
	FILE *fp_sw = NULL;
	U8 *pImgBufferSrc = NULL;
//	U8 *buffer = NULL;
//	int result = -1;

//-------------------------------------------------------------
	filelen = unztellsize( fp );
	pImgBufferSrc = (U8*)malloc( filelen + 1 );

	image_zip_fseek( fp, 0, SEEK_SET );
	if( pImgBufferSrc )
	{
		readfn( (void*)pImgBufferSrc, 1, filelen, (void*)fp );
		ImgBufferSrc_Size = filelen;
		readFunc_FpOffset = 0;
		ImgBufferSrc = pImgBufferSrc;
		gif_read2( NULL, pwidth, pheight, image_data, bgcolor );
	}
	else
	{
		pImgBufferSrc = malloc( IMAGEVIEW_MEMDEST_SIZE );
		if( !pImgBufferSrc )
		{
			ErrorCode = ERR_MEM_LACK;
			goto _gif_read_in_zip_Exit;
		}

		fp_sw = fopen_imgZipSwapfile( "swapfile.gif", "w" );
		if( !fp_sw )
		{
			ErrorCode = ERR_FILE_OPEN;
			goto _gif_read_in_zip_Exit;
		}

		len = filelen;
		while( len > 0 )
		{
			len_w = len;
			if( len_w > IMAGEVIEW_MEMDEST_SIZE )
				len_w = IMAGEVIEW_MEMDEST_SIZE;
			readfn( (void*)pImgBufferSrc, 1, len_w, (void*)fp );
			fwrite( pImgBufferSrc, 1, len_w, fp_sw );
			len -= len_w;
		}
		if( fp_sw )
		{
			fclose( fp_sw );
			fp_sw = NULL;
		}

		fp_sw = fopen_imgZipSwapfile( "swapfile.gif", "r" );
		if( !fp_sw )
		{
			ErrorCode = ERR_FILE_OPEN;
			goto _gif_read_in_zip_Exit;
		}

		gif_read2( fp_sw, pwidth, pheight, image_data, bgcolor );
	}

_gif_read_in_zip_Exit:

	if( pImgBufferSrc )
	{
		if( ImgBufferSrc == pImgBufferSrc )
		{
			ImgBufferSrc = NULL;
		}
		free( pImgBufferSrc );
		pImgBufferSrc = NULL;
	}

	if( ImgBufferSrc )
	{
		free( ImgBufferSrc );
		ImgBufferSrc = NULL;
	}

	if( fp_sw )
	{
		fclose( fp_sw );
		fp_sw = NULL;
	}

//	char imgdat_name[IMGDAT_NAME_LEN];
//	STRCPY_S( imgdat_name, CONFIG_EBOOK_ROOTDIR );
//	STRCAT_S( imgdat_name, "swapfile.gif" );

	remove( imgFileName );//ɾļ

	return ErrorCode;
}
