/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config_ebook.h"

#if defined(ENABLE_IMAGE) || defined(ENABLE_BG)

#include <string.h>
#include <png.h>
#include <gif_lib.h>
#include <bmplib.h>
#include <chm_lib.h>
#include <unzip.h>
#include <unrar.h>
#include "common/utils.h"
#include "win.h"
#include "buffer.h"
#include "conf.h"
#include "fs.h"
#include "scene.h"

#include <bmp.h>
#include <plug_gif.h>
#include <plug_jpeg.h>
#include <tiff.h>
#include <png_headfile.h>
#include <mystring.h>
#include <DrvMemMgr.h>
#include <datatype.h>
#include <msgbox.h>
#include <language.h>
#include <fs_api.h>
#include <scene_image.h>
#include <uart.h>
#include <debugoff.h>

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
extern int jpeg_read_in_zip( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn );



//----------------------------------------------------------------------------
/*
#define PB  (1.0f/3.0f)
#define PC  (1.0f/3.0f)
#define P0  ((  6.0f- 2.0f*PB       )/6.0f)
#define P2  ((-18.0f+12.0f*PB+ 6.0f*PC)/6.0f)
#define P3  (( 12.0f- 9.0f*PB- 6.0f*PC)/6.0f)
#define Q0  ((       8.0f*PB+24.0f*PC)/6.0f)
#define Q1  ((     -12.0f*PB-48.0f*PC)/6.0f)
#define Q2  ((       6.0f*PB+30.0f*PC)/6.0f)
#define Q3  ((     - 1.0f*PB- 6.0f*PC)/6.0f)

__inline float sinc():
	if (x < -1.0f)
		return(Q0-x*(Q1-x*(Q2-x*Q3)));
	if (x < 0.0f)
		return(P0+x*x*(P2-x*P3));
	if (x < 1.0f)
		return(P0+x*x*(P2+x*P3));
	return(Q0+x*(Q1+x*(Q2+x*Q3)));
*/

/* You can replace default sinc() with following anyone for filter changing

__inline float sinc(float x)
{
	if (x < -1.0f)
		return(0.5f*(4.0f+x*(8.0f+x*(5.0f+x))));
	if (x < 0.0f)
		return(0.5f*(2.0f+x*x*(-5.0f-3.0f*x)));
	if (x < 1.0f)
		return(0.5f*(2.0f+x*x*(-5.0f+3.0f*x)));
	return(0.5f*(4.0f+x*(-8.0f+x*(5.0f-x))));
}

__inline float sinc(float x)
{
	if (x < 0.1f)
		return((2.0f+x)*(2.0f+x)*(2.0f+x)/6.0f);
	if (x < 0.0f)
		return((4.0f+x*x*(-6.0f-3.0f*x))/6.0f);
	if (x < 1.0f)
		return((4.0f+x*x*(-6.0f+3.0f*x))/6.0f);
	return((2.0f-x)*(2.0f-x)*(2.0f-x)/6.0f);
}

__inline float sinc(float x)
{
	float s = (x < 0) ? -x : x;
	if (s <= 1.0f)
		return 1.0f - 2.0f * x * x + x * x * s;
	else
		return 4.0f - 8.0f * s + 5.0f * x * x - x * x * s;
}
*/
#if 0
__inline float sinc_n2(float x)
{
	return (2.0f + x) * (2.0f + x) * (1.0f + x);
}
__inline float sinc_n1(float x)
{
	return (1.0f - x - x * x) * (1.0f + x);
}
__inline float sinc_1(float x)
{
	return (1.0f + x - x * x) * (1.0f - x);
}
__inline float sinc_2(float x)
{
	return (2.0f - x) * (2.0f - x) * (1.0f - x);
}

__inline pixel bicubic(pixel i1, pixel i2, pixel i3, pixel i4, float u1, float u2, float u3, float u4)
{
	int r, g, b;

	r = u1 * RGB_R(i1) + u2 * RGB_R(i2) + u3 * RGB_R(i3) + u4 * RGB_R(i4) + 0.5f;
	if (r > COLOR_MAX)
		r = COLOR_MAX;
	else if (r < 0)
		r = 0;

	g = u1 * RGB_G(i1) + u2 * RGB_G(i2) + u3 * RGB_G(i3) + u4 * RGB_G(i4) + 0.5f;
	if (g > COLOR_MAX)
		g = COLOR_MAX;
	else if (g < 0)
		g = 0;

	b = u1 * RGB_B(i1) + u2 * RGB_B(i2) + u3 * RGB_B(i3) + u4 * RGB_B(i4) + 0.5f;
	if (b > COLOR_MAX)
		b = COLOR_MAX;
	else if (b < 0)
		b = 0;

	return RGB2(r, g, b);
}

extern void image_zoom_bicubic( pixel * src, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight )
{
	pixel *temp1, *temp2, *temp3, *temp4, *tempdst;
	float u, v, u1[destwidth], u2[destwidth], u3[destwidth], u4[destwidth];
	int x = 0, y, x2, y1, y2, y3, y4, i, j;

	for (i = 0; i < destheight; i++)
	{
		x2 = x / destheight;
		temp2 = src + x2 * srcwidth;
		if (x2 == 0)
			temp1 = temp2;
		else
			temp1 = temp2 - srcwidth;
		if (x2 + 2 > srcheight)
		{
			temp3 = temp2;
			if (x2 + 3 > srcheight)
				temp4 = temp3;
			else
				temp4 = temp3 + srcwidth;
		}
		else
		{
			temp3 = temp2 + srcwidth;
			temp4 = temp3 + srcwidth;
		}
		tempdst = dest;

		v = ((float) x / destheight) - x2;
		float v1 = sinc_2(v + 1.0f), v2 = sinc_1(v),
		v3 = sinc_n1(v - 1.0f), v4 = sinc_n2(v - 2.0f);
		y = 0;

		if (i == 0)
		{
			for (j = 0; j < destwidth; j++)
			{
				y2 = y / destwidth;
				y1 = y2 - 1;
				y3 = y2 + 1;
				y4 = y2 + 2;
				if (y1 < 0)
					y1 = 0;
				if (y3 > srcwidth - 1)
					y3 = srcwidth - 1;
				if (y4 > srcwidth - 1)
					y4 = srcwidth - 1;

				u = ((float) y / destwidth) - y2;
				u1[j] = sinc_2(u + 1.0f), u2[j] = sinc_1(u), u3[j] =
					sinc_n1(u - 1.0f), u4[j] = sinc_n2(u - 2.0f);
				tempdst[j] =
					bicubic(bicubic
							(temp1[y1], temp1[y2], temp1[y3], temp1[y4], u1[j],
							 u2[j], u3[j], u4[j]), bicubic(temp2[y1], temp2[y2],
														   temp2[y3], temp2[y4],
														   u1[j], u2[j], u3[j],
														   u4[j]),
							bicubic(temp3[y1], temp3[y2], temp3[y3], temp3[y4],
									u1[j], u2[j], u3[j], u4[j]),
							bicubic(temp4[y1], temp4[y2], temp4[y3], temp4[y4],
									u1[j], u2[j], u3[j], u4[j]), v1, v2, v3,
							v4);
				y += srcwidth;
			}
		}
		else
		{
			for (j = 0; j < destwidth; j++)
			{
				y2 = y / destwidth;
				y1 = y2 - 1;
				y3 = y2 + 1;
				y4 = y2 + 2;
				if (y1 < 0)
					y1 = 0;
				if (y3 > srcwidth - 1)
					y3 = srcwidth - 1;
				if (y4 > srcwidth - 1)
					y4 = srcwidth - 1;

				tempdst[j] =
					bicubic(bicubic
							(temp1[y1], temp1[y2], temp1[y3], temp1[y4], u1[j],
							 u2[j], u3[j], u4[j]), bicubic(temp2[y1], temp2[y2],
														   temp2[y3], temp2[y4],
														   u1[j], u2[j], u3[j],
														   u4[j]),
							bicubic(temp3[y1], temp3[y2], temp3[y3], temp3[y4],
									u1[j], u2[j], u3[j], u4[j]),
							bicubic(temp4[y1], temp4[y2], temp4[y3], temp4[y4],
									u1[j], u2[j], u3[j], u4[j]), v1, v2, v3,
							v4);
				y += srcwidth;
			}
		}
		dest += destwidth;
		x += srcheight;
	}
}
#endif

__inline pixel bilinear(pixel i1, pixel i2, int u, int s)
{
	int r1, g1, b1, r2, g2, b2;

	r1 = RGB_R(i1);
	g1 = RGB_G(i1);
	b1 = RGB_B(i1);
	r2 = RGB_R(i2);
	g2 = RGB_G(i2);
	b2 = RGB_B(i2);
	return RGB2( (r1 + u * (r2 - r1) / s), (g1 + u * (g2 - g1) / s), (b1 + u * (b2 - b1) / s) );
}

extern void image_zoom_bilinear( pixel * src, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight )
{
	pixel *temp1, *temp2, *tempdst;
	int x = 0, y, u, v;
	int x2, y1, y2, i, j;

	for (i = 0; i < destheight; i++)
	{
		x2 = x / destheight;
		if (x2 < srcheight - 1)
		{
			temp1 = src + x2 * srcwidth;
			temp2 = temp1 + srcwidth;
		}
		else
			temp1 = temp2 = src + x2 * srcwidth;
		tempdst = dest;

		v = x - x2 * destheight;
		y = 0;

		for (j = 0; j < destwidth; j++)
		{
			y1 = y / destwidth;
			if (y1 < srcwidth - 1)
				y2 = y1 + 1;
			else
				y2 = y1 = srcwidth - 1;

			u = y - y1 * destwidth;
			tempdst[j] = bilinear( bilinear(temp1[y1], temp1[y2], u, destwidth), bilinear(temp2[y1], temp2[y2], u, destwidth), v, destheight );
			y += srcwidth;
		}
		dest += destwidth;
		x += srcheight;
	}
}

//--------------------------------------------------------------------------------------------------------
//أ´ŲԴʼк
//--------------------------------------------------------------------------------------------------------
extern int image_zoom_bilinear_Line_FromBuffer( pixel * src1, pixel * src2, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight, int *dst_done_h, int *start_x )
{
	pixel *temp1, *temp2, *tempdst;
	int x = *start_x, y, u, v;
	int x2, y1, y2, j;

	{
		x2 = x / destheight;

		if (x2 < srcheight - 1)
		{
			temp1 = src1;
			temp2 = src2;
		}
		else
			temp1 = temp2 = src1;
		tempdst = dest;

		v = x - x2 * destheight;
		y = 0;

		for (j = 0; j < destwidth; j++)
		{
			y1 = y / destwidth;
			if (y1 < srcwidth - 1)
				y2 = y1 + 1;
			else
				y2 = y1 = srcwidth - 1;

			u = y - y1 * destwidth;
			tempdst[j] = bilinear( bilinear(temp1[y1], temp1[y2], u, destwidth), bilinear(temp2[y1], temp2[y2], u, destwidth), v, destheight );
			y += srcwidth;
		}

		x += srcheight;
	}
	*start_x = x;//
	*dst_done_h += 1;//ѾĿͼ

	x2 = x / destheight;

	return x2;
}

//--------------------------------------------------------------------------------------------------------
//start_pixelX:Ҫŵʼx
//end_pixelX:ҪŵĽx
//أ´ŲԴʼк
//--------------------------------------------------------------------------------------------------------
extern int image_zoom_bilinear_Line_FromBuffer2( pixel * src1, pixel * src2, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight, int start_pixelX, int end_pixelX, int *dst_done_h, int *start_x )
{
	pixel *temp1, *temp2, *tempdst;
	int x = *start_x, y, u, v;
	int x2, y1, y2, j;

	{
		if( srcwidth != destwidth || srcheight != destheight )
		{
			x2 = x / destheight;

			if (x2 < srcheight - 1)
			{
				temp1 = src1;
				temp2 = src2;
			}
			else
				temp1 = temp2 = src1;
			tempdst = dest;

			v = x - x2 * destheight;
#if 1
			y = srcwidth * start_pixelX;

			for (j = 0; j <= (end_pixelX-start_pixelX) && j < destwidth; j++)
#else
			y = 0;
			for (j = 0; j < destwidth; j++)
#endif
			{
				y1 = y / destwidth;
				if (y1 < srcwidth - 1)
					y2 = y1 + 1;
				else
					y2 = y1 = srcwidth - 1;

				u = y - y1 * destwidth;
				tempdst[j] = bilinear( bilinear(temp1[y1], temp1[y2], u, destwidth), bilinear(temp2[y1], temp2[y2], u, destwidth), v, destheight );
				y += srcwidth;
			}
		}
		else
		{
			memcpyword( dest, src1+srcwidth * start_pixelX / destwidth, end_pixelX-start_pixelX+1 );
		}

		x += srcheight;
	}
	*start_x = x;//
	*dst_done_h += 1;//ѾĿͼ

	x2 = x / destheight;

	return x2;
}

extern void image_screenSizeTosrcSize( int curleft, int curtop, int paintw, int painth, int *srcleft, int *srctop, int *srcw, int *srch, int srcwidth, int destwidth )
{
	*srcleft = curleft * srcwidth / destwidth;
	*srctop = curtop * srcwidth / destwidth;
	*srcw = paintw * srcwidth / destwidth;
	*srch = painth * srcwidth / destwidth;
}

extern void image_zoom_bilinear_FromBuffer( int curleft, int curtop, int paintw, int painth, int paintleft, int painttop, int srcwidth, int srcheight, int destwidth, int destheight, pixel *buffer, int bufferwidth, int bufferheight,t_conf_rotate rotate, pixel *ImgBuffer )
{
	pixel *temp1, *temp2, *tempdst;
	int x = 0, y, u, v;
	int x2, y1, y2, i, j;
	int srcleft, srctop;
	int src_offset;
	int line_cur;
	int srcw, srch;
	bool scale100Flag;
	pixel *src = NULL;
	pixel *dest = NULL;
	pixel *pBuffer = NULL;

	if( ((dword)rotate & 0x1) )
	{
		ExchangeValue( &paintw, &painth );
		ExchangeValue( &destwidth, &destheight );
	}

	srcw = paintw * srcwidth / destwidth;
	srch = painth * srcwidth / destwidth;
	src = memalign( PIXEL_BYTES, srcw << 2 );
	if( src == NULL )return;

	pBuffer = memalign( PIXEL_BYTES, paintw << 1 );
	if( pBuffer == NULL )return;

	if( rotate == conf_rotate_0 )
	{
		srcleft = curleft * srcwidth / destwidth;
		srctop = curtop * srcwidth / destwidth;
		dest = buffer + painttop * bufferwidth + paintleft;//Դһ׵ַ
	}
	else if( rotate == conf_rotate_90 )
	{
		srcleft = curtop * srcwidth / destwidth;
		srctop = srcheight - curleft * srcwidth / destwidth - srch;
		dest = buffer + painttop * bufferwidth + paintleft + painth - 1;//Դһ׵ַ
	}
	else if( rotate == conf_rotate_180 )
	{
		srcleft = srcwidth - curleft * srcwidth / destwidth - srcw;
		srctop = srcheight - curtop * srcwidth / destwidth - srch;
		dest = buffer + (painttop+painth-1) * bufferwidth + paintleft + paintw - 1;//Դһһַ
	}
	else if( rotate == conf_rotate_270 )
	{
		srcleft = srcwidth - curtop * srcwidth / destwidth - srcw;
		srctop = curleft * srcwidth / destwidth;
		dest = buffer + (painttop+paintw-1) * bufferwidth + paintleft;//Դһһַ
	}
	else
	{
		return;
	}

	if( srcleft < 0 )
		srcleft = 0;
	else if( srcleft + srcw > srcwidth )
		srcleft = srcwidth - srcw;
	if( srctop < 0 )
		srctop = 0;
	else if( srctop + srch > srcheight )
		srctop = srcheight - srch;

	x = 0;
	line_cur = -2;
	temp1 = src;
	temp2 = temp1 + srcw;
	src_offset = srctop * srcwidth+srcleft;//Ϊλ
	scale100Flag = ( (srcwidth == destwidth) && (srcheight == destheight) ) ? true : false;
	for (i = 0; i < painth; i++)
	{
		x2 = x / painth;
		if( x2 > line_cur )
		{
			if( srctop + x2 < srcheight - 1 )
			{
				temp1 = &ImgBuffer[(srctop + x2)*srcwidth+srcleft];
				temp2 = temp1 + srcwidth;
			}
			else
			{
				temp1 = temp2 = &ImgBuffer[(srcheight - 1)*srcwidth+srcleft];	
			}	
			line_cur = x2;
		}

		tempdst = dest;

		if( scale100Flag == false )
		{
			v = x - x2 * painth;
			y = 0;

			for (j = 0; j < paintw; j++)
			{
				y1 = y / paintw;
				if (y1 < srcw - 1)
				{
					y2 = y1 + 1;
				}
				else
				{
					y2 = y1 = srcw- 1;
				}

				u = y - y1 * paintw;
				pBuffer[j] = bilinear( bilinear(temp1[y1], temp1[y2], u, paintw), bilinear(temp2[y1], temp2[y2], u, paintw), v, painth );
				y += srcw;
			}
		}
		else
		{
			for (j = 0; j < paintw; j++)
			{
				pBuffer[j] = temp1[j];
			}
		}

		if( rotate == conf_rotate_0 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst += 1;
			}
			dest += bufferwidth;
		}
		else if( rotate == conf_rotate_90 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst += bufferwidth;
			}
			dest -= 1;
		}
		else if( rotate == conf_rotate_180 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst -= 1;
			}
			dest -= bufferwidth;
		}
		else if( rotate == conf_rotate_270 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst -= bufferwidth;
			}
			dest += 1;
		}

		x += srch;
	}

	free( src );
	free( pBuffer );
}

extern void image_zoom_bilinear_FromFile( int curleft, int curtop, int paintw, int painth, int paintleft, int painttop, int srcwidth, int srcheight, int destwidth, int destheight, pixel *buffer, int bufferwidth, int bufferheight,t_conf_rotate rotate )
{
	pixel *temp1, *temp2, *tempdst, *temp;
	int x = 0, y, u, v;
	int x2, y1, y2, i, j;
	int srcleft, srctop;
	int src_offset;
	int line_cur;
	int srcw, srch;
	bool scale100Flag;
	pixel *src = NULL;
	pixel *dest = NULL;
	pixel *pBuffer = NULL;
	FILE *fp = NULL;
	
	if( ((dword)rotate & 0x1) )
	{
		ExchangeValue( &paintw, &painth );
		ExchangeValue( &destwidth, &destheight );
	}
	
	srcw = paintw * srcwidth / destwidth;
	srch = painth * srcwidth / destwidth;
	src = memalign( PIXEL_BYTES, srcw << 2 );
	if( src == NULL )return;

	pBuffer = memalign( PIXEL_BYTES, paintw << 1 );
	if( pBuffer == NULL )return;

	if( rotate == conf_rotate_0 )
	{
		srcleft = curleft * srcwidth / destwidth;
		srctop = curtop * srcwidth / destwidth;
		dest = buffer + painttop * bufferwidth + paintleft;//Դһ׵ַ
	}
	else if( rotate == conf_rotate_90 )
	{
		srcleft = curtop * srcwidth / destwidth;
		srctop = srcheight - curleft * srcwidth / destwidth - srch;
		dest = buffer + painttop * bufferwidth + paintleft + painth - 1;//Դһ׵ַ
	}
	else if( rotate == conf_rotate_180 )
	{
		srcleft = srcwidth - curleft * srcwidth / destwidth - srcw;
		srctop = srcheight - curtop * srcwidth / destwidth - srch;
		dest = buffer + (painttop+painth-1) * bufferwidth + paintleft + paintw - 1;//Դһһַ
	}
	else if( rotate == conf_rotate_270 )
	{
		srcleft = srcwidth - curtop * srcwidth / destwidth - srcw;
		srctop = curleft * srcwidth / destwidth;
		dest = buffer + (painttop+paintw-1) * bufferwidth + paintleft;//Դһһַ
	}
	else
	{
		return;
	}

	if( srcleft < 0 )
		srcleft = 0;
	else if( srcleft + srcw > srcwidth )
		srcleft = srcwidth - srcw;
	if( srctop < 0 )
		srctop = 0;
	else if( srctop + srch > srcheight )
		srctop = srcheight - srch;

	fp = fopen_imgSwapfile( "rb" );
	if( fp == NULL )return;

	x = 0;
	line_cur = -2;
	temp1 = src;
	temp2 = temp1 + srcw;
	src_offset = srctop * srcwidth+srcleft;//Ϊλ
	scale100Flag = ( (srcwidth == destwidth) && (srcheight == destheight) ) ? true : false;
	for (i = 0; i < painth; i++)
	{
		x2 = x / painth;
		if( x2 > line_cur )
		{
			if( srctop + x2 <= srcheight - 1 )
			{
				if( x2 == line_cur + 1 )
				{
					temp = temp1;
					temp1 = temp2;
					temp2 = temp;
					fseek( fp, src_offset<<1, SEEK_SET );
					fread( temp2, 2, srcw, fp );
									
					src_offset += srcwidth;
				}
				else
				{
					j = x2 - line_cur;
					for( ; j > 2; j-- )
					{
						src_offset += srcwidth;
					}
					if( srcw == srcwidth )
					{
						fseek( fp, src_offset<<1, SEEK_SET );
						fread( src, 2, srcwidth<<1, fp );
						src_offset += srcwidth << 1;
					}
					else
					{
						for( j = 0; j < 2; j++ )
						{
							fseek( fp, src_offset<<1, SEEK_SET );
							fread( src + j * srcw, 2, srcw<<1, fp );
							src_offset += srcwidth;
						}
					}
					
					temp1 = src;
					temp2 = temp1 + srcw;
				}
			}
			if( srctop + x2 >= srcheight - 1 )
				temp2 = temp1; 
			line_cur = x2;
		}

		tempdst = dest;

		if( scale100Flag == false )
		{
			v = x - x2 * painth;
			y = 0;

			for (j = 0; j < paintw; j++)
			{
				y1 = y / paintw;
				if (y1 < srcw - 1)
				{
					y2 = y1 + 1;
				}
				else
				{
					y2 = y1 = srcw- 1;
				}

				u = y - y1 * paintw;
				pBuffer[j] = bilinear( bilinear(temp1[y1], temp1[y2], u, paintw), bilinear(temp2[y1], temp2[y2], u, paintw), v, painth );
				y += srcw;
			}
		}
		else
		{
			for (j = 0; j < paintw; j++)
			{
				pBuffer[j] = temp1[j];
			}
		}

		if( rotate == conf_rotate_0 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst += 1;
			}
			dest += bufferwidth;
		}
		else if( rotate == conf_rotate_90 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst += bufferwidth;
			}
			dest -= 1;
		}
		else if( rotate == conf_rotate_180 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst -= 1;
			}
			dest -= bufferwidth;
		}
		else if( rotate == conf_rotate_270 )
		{
			for (j = 0; j < paintw; j++)
			{
				*tempdst = pBuffer[j];
				tempdst -= bufferwidth;
			}
			dest += 1;
		}

		x += srch;
	}

	fclose( fp );
	free( src );
	free( pBuffer );
}

void ExchangeValue( int *x, int *y )
{
	int tempw;
	tempw = *x;
	*x = *y;
	*y = tempw;
}

extern void image_rotate( dword * pwidth, dword * pheight, dword organgle, dword newangle )
{
	dword ca;
	int temp;

	if (newangle < organgle)
	{
		ca = newangle + 360 - organgle;
	}
	else
		ca = newangle - organgle;
	if (ca == 0)
		return;

	switch (ca)
	{
		case 90:
		case 270:
			temp = *pheight;
			*pheight = *pwidth;
			*pwidth = temp;
			break;
		case 180:
			break;
		default:
			return;
	}
}

static unsigned image_zip_fread(void *buf, unsigned r, unsigned n, void *stream)
{
	int size = unzReadCurrentFile( (unzFile)stream, buf, r * n);

	if (size < 0)
		return 0;
	else
		return n;
}

int image_zip_fseek(void *stream, long offset, int origin)
{
	if ( origin != SEEK_SET )
		return 0;

	int size = offset - unztell((unzFile) stream);

	if (size <= 0)
		return 0;
	byte buf[size];

	unzReadCurrentFile((unzFile) stream, buf, size);
	return 0;
}

/* PNG processing */
extern int image_readpng(const char *filename, dword * pwidth, dword * pheight,
						 pixel ** image_data, pixel * bgcolor)
{
	int result = -1;
	result = png_read( filename, pwidth, pheight, image_data, bgcolor );
	return result;
}

extern int image_readpng_in_zip(const char *zipfile, const char *filename,
								dword * pwidth, dword * pheight,
								pixel ** image_data, pixel * bgcolor)
{
	unzFile unzf = NULL;

	unzf = unzOpen(zipfile);
	if (unzf == NULL)
	{
		return -1;
	}
	if (unzLocateFile(unzf, filename, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return -1;
	}
	int result =
		png_read_in_zip((void *) unzf, pwidth, pheight, image_data, bgcolor, image_zip_fread );//image_png_zip_read

	unzCloseCurrentFile(unzf);
	unzClose(unzf);
	return result;
}

static int image_readgif2(void *handle, dword * pwidth, dword * pheight,
						  pixel ** image_data, pixel * bgcolor,
						  t_image_fread readfn)
{
	int result;

	result = gif_read_in_zip( handle, pwidth, pheight, image_data, bgcolor,readfn );
	return result;
}

extern int image_readgif(const char *filename, dword * pwidth, dword * pheight,
						 pixel ** image_data, pixel * bgcolor)
{
	int result = gif_read( filename, pwidth, pheight, image_data, bgcolor );
	return result;
}

extern int image_readgif_in_zip(const char *zipfile, const char *filename,
								dword * pwidth, dword * pheight,
								pixel ** image_data, pixel * bgcolor)
{
	unzFile unzf = unzOpen(zipfile);

	if (unzf == NULL)
		return -1;
	if (unzLocateFile(unzf, filename, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return -1;
	}
	int result =
		image_readgif2((void *) unzf, pwidth, pheight, image_data, bgcolor, image_zip_fread);

	unzCloseCurrentFile(unzf);
	unzClose(unzf);

	return result;
}

extern int image_readjpg(const char *filename, dword * pwidth, dword * pheight,pixel ** image_data, pixel * bgcolor)
{
#if (ENABLE_JPEG|ENABLE_JPEG6B)
	return jpeg_read( filename, pwidth, pheight, image_data, bgcolor );
#else
	return -1;
#endif
}

extern int image_readjpg_in_zip(const char *zipfile, const char *filename,
								dword * pwidth, dword * pheight,
								pixel ** image_data, pixel * bgcolor)
{
	unzFile unzf = unzOpen(zipfile);

	if (unzf == NULL)
	{
		return -1;
	}
	if (unzLocateFile(unzf, filename, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return -1;
	}
	int result = jpeg_read_in_zip( (FILE *) unzf, pwidth, pheight, image_data, bgcolor, image_zip_fread );

	unzCloseCurrentFile(unzf);
	unzClose(unzf);
	return result;
}

static int image_readbmp2(void *handle, dword * pwidth, dword * pheight,
						  pixel ** image_data, pixel * bgcolor,
						  t_image_fread readfn)
{
	int result;

	result = bmp_read_dib_file( handle, pwidth, pheight, image_data, bgcolor,readfn );
	return result;
}

extern int image_readbmp(const char *filename, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor)
{
	int result = read_bmp( filename, pwidth, pheight, image_data, bgcolor );
	return result;
}

extern int image_readbmp_in_zip(const char *zipfile, const char *filename,
								dword * pwidth, dword * pheight,
								pixel ** image_data, pixel * bgcolor)
{
	unzFile unzf = unzOpen(zipfile);
	if (unzf == NULL)
		return -1;
	if (unzLocateFile(unzf, filename, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return -1;
	}
	int result =
		image_readbmp2( (FILE *) unzf, pwidth, pheight, image_data, bgcolor, image_zip_fread );

	unzCloseCurrentFile(unzf);//עⲻҪظرղ
	unzClose(unzf);
	return result;
}

extern int image_readtif(const char *filename, dword * pwidth, dword * pheight, pixel **image_data, pixel * bgcolor)
{
	int result = -1;
	result = tif_read( filename, pwidth, pheight, image_data, bgcolor );
	return result;
}


extern int image_readtif_in_zip(const char *zipfile, const char *filename,
								dword * pwidth, dword * pheight,
								pixel ** image_data, pixel * bgcolor)
{
	unzFile unzf = unzOpen(zipfile);

	unz_s* s;

	s=(unz_s*)unzf;

	if (unzf == NULL)
		return -1;
	if (unzLocateFile(unzf, filename, 0) != UNZ_OK || unzOpenCurrentFile(unzf) != UNZ_OK)
	{
		unzClose(unzf);
		return -1;
	}

	int result =
		tif_read_in_zip( (FILE *) unzf, pwidth, pheight, image_data, bgcolor, image_zip_fread );

	unzCloseCurrentFile(unzf);//עⲻҪظرղ
	unzClose(unzf);
	return result;
}




/**
 * ѹͼļͨļ汾
 * @param filename ļ·
 * @param ft ļ
 * @param pWidth [out] ͼ
 * @param pHeight [out] ͼ߶
 * @param ppImageData [out] ͼָ
 * @note  ִгɹ*ppImageDataָڴ
 * @param pBgColor [out] ͼ񱳾ɫ
 * @return
 * - !=0 ʧ
 * - =0 ɹ
 */
int image_open_normal( const char *filename, t_fs_filetype ft, dword * pWidth, dword * pHeight, pixel **ppImageData, pixel * pBgColor )
{
	int result = -1;

	if( filename == NULL || pWidth == NULL || pHeight == NULL || pBgColor == NULL )
		return -1;

	switch (ft)
	{
		case fs_filetype_png:
			result =
				image_readpng(filename, pWidth, pHeight, ppImageData, pBgColor);
			break;
		case fs_filetype_gif:
			result =
				image_readgif(filename, pWidth, pHeight, ppImageData, pBgColor);
			break;
		case fs_filetype_jpg:
			result =
				image_readjpg(filename, pWidth, pHeight, ppImageData, pBgColor);
			break;
		case fs_filetype_bmp:
			result =
				image_readbmp(filename, pWidth, pHeight, ppImageData, pBgColor);
			break;
		case fs_filetype_tif:
			result =
				image_readtif(filename, pWidth, pHeight, ppImageData, pBgColor);
			break;
		default:
			result = -1;
			break;
	}
	return result;
}

/**
 * ѹͼļļ汾
 * @param filename ļ·
 * @param archname ·
 * @param ft ļ
 * @param where ļ
 * @param pWidth [out] ͼ
 * @param pHeight [out] ͼ߶
 * @param ppImageData [out] ͼָ
 * @note  ִгɹ*ppImageDataָڴ
 * @param pBgColor [out] ͼ񱳾ɫ
 * @return
 * - !=0 ʧ
 * - =0 ɹ
 * @note ļΪa.zipеb.jpgfilenameΪb.jpg, archnameΪa.zip
 */
int image_open_archive(const char *filename, const char *archname,
					   t_fs_filetype ft, dword * pWidth, dword * pHeight,
					   pixel ** ppImageData, pixel * pBgColor, int where)
{
	int result = -1;

	// archname may be NULL
	if (filename == NULL || pWidth == NULL || pHeight == NULL || pBgColor == NULL)
		return -1;

	if (where == scene_in_dir)
	{
		result = image_open_normal( filename, ft, pWidth, pHeight, ppImageData, pBgColor );
		return result;
	}

	switch (ft)
	{
		case fs_filetype_png:
			switch (where)
			{
				case scene_in_zip:
					result =
						image_readpng_in_zip(archname, filename, pWidth,
											 pHeight, ppImageData, pBgColor);
					break;
				case scene_in_chm:
					result = -1;
					break;
				case scene_in_rar:
					result = -1;
					break;
				default:
					break;
			}
			break;
		case fs_filetype_gif:
			switch (where)
			{
				case scene_in_zip:
					result =
						image_readgif_in_zip(archname, filename, pWidth,
											 pHeight, ppImageData, pBgColor);
					break;
				case scene_in_chm:
					result = -1;
					break;
				case scene_in_rar:
					result = -1;
					break;
			}
			break;
		case fs_filetype_jpg:
			switch (where)
			{
				case scene_in_zip:
					result =
						image_readjpg_in_zip(archname, filename, pWidth,
											 pHeight, ppImageData, pBgColor);
					break;
				case scene_in_chm:
					result = -1;
					break;
				case scene_in_rar:
					result = -1;
					break;
			}
			break;
		case fs_filetype_bmp:
			switch (where)
			{
				case scene_in_zip:
					result =
						image_readbmp_in_zip(archname, filename, pWidth,
											 pHeight, ppImageData, pBgColor);
					break;
				case scene_in_chm:
					result = -1;
					break;
				case scene_in_rar:
					result = -1;
					break;
			}
			break;

		case fs_filetype_tif:
			switch (where)
			{
				case scene_in_zip:
					result =
						image_readtif_in_zip(archname, filename, pWidth,
											 pHeight, ppImageData, pBgColor);
					break;
				case scene_in_chm:
					result = -1;
					break;
				case scene_in_rar:
					result = -1;
					break;
			}
			break;

		default:
			result = -1;
	}

	return result;
}

int image_read_sys( const char *filename, t_fs_filetype ft, dword * pWidth, dword * pHeight, pixel ** ppImageData, pixel * pBgColor )
{
	int result = -1;
	char fileDir[PATH_MAX2];

	if( filename == NULL || filename[0] == '\0' )
		return -1;

	result = image_open_archive( filename, CONFIG_LOGO_ARCHNAME, ft, pWidth, pHeight, ppImageData, pBgColor, scene_in_zip );
	if( result != 0 )
	{
		fileDir[0] = '\0';
		STRCAT_S( fileDir, CONFIG_EBOOK_ROOTDIR );
		STRCAT_S( fileDir, filename );
		result = image_open_normal( fileDir, ft, pWidth, pHeight, ppImageData, pBgColor );
	}
	return result;
}

#endif
