/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef __IMAGE_H
#define __IAMGE_H

#ifdef __cplusplus
extern "C" {
#endif

#include "fs.h"
#include <gdi.h>
#include <config_ebook.h>
#include <ds2io.h>

#ifndef t_image_fread_type
#define	t_image_fread_type
typedef unsigned (*t_image_fread)( void *buf, unsigned r, unsigned n, void *stream );
#endif

extern int image_open_normal( const char *filename, t_fs_filetype ft, dword * pWidth, dword * pHeight, pixel **ppImageData, pixel * pBgColor );

extern int image_open_archive(const char *filename, const char *archname,
					   t_fs_filetype ft, dword * pWidth, dword * pHeight,
					   pixel ** ppImageData, pixel * pBgColor, int where);

extern void image_zoom_bilinear( pixel * src, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight );
extern void image_zoom_bicubic( pixel * src, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight );

extern void image_zoom_bilinear_FromFile( int curleft, int curtop, int paintw, int painth, int paintleft, int painttop, int srcwidth, int srcheight, int destwidth, int destheight, pixel *buffer, int bufferwidth, int bufferheight,t_conf_rotate rotate );
extern void image_zoom_bilinear_FromBuffer( int curleft, int curtop, int paintw, int painth, int paintleft, int painttop, int srcwidth, int srcheight, int destwidth, int destheight, pixel *buffer, int bufferwidth, int bufferheight,t_conf_rotate rotate, pixel *ImgBuffer );

extern int image_zoom_bilinear_Line_FromBuffer2( pixel * src1, pixel * src2, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight, int start_pixelX, int end_pixelX, int *dst_done_h, int *start_x );
extern int image_zoom_bilinear_Line_FromBuffer( pixel * src1, pixel * src2, int srcwidth, int srcheight, pixel * dest, int destwidth, int destheight, int *dst_done_h, int *start_x );

extern void image_rotate( dword * pwidth, dword * pheight, dword organgle, dword newangle );

void ExchangeValue( int *x, int *y );
extern void image_screenSizeTosrcSize( int curleft, int curtop, int paintw, int painth, int *srcleft, int *srctop, int *srcw, int *srch, int srcwidth, int destwidth );

int image_read_sys( const char *filename, t_fs_filetype ft, dword * pWidth, dword * pHeight, pixel ** ppImageData, pixel * pBgColor );

int image_zip_fseek(void *stream, long offset, int origin);

#define	image_zoom_bilinear_FromFileToBuffer( srcwidth, srcheight, buffer, bufferwidth, bufferheight, rotate ) \
		image_zoom_bilinear_FromFile( 0, 0, bufferwidth, bufferheight, 0, 0, srcwidth, srcheight, bufferwidth, bufferheight, buffer, bufferwidth, bufferheight, rotate )
		
#define	image_zoom_bilinear_FromBufferToBuffer( srcwidth, srcheight, buffer, bufferwidth, bufferheight, rotate, ImgBuffer ) \
		image_zoom_bilinear_FromBuffer( 0, 0, bufferwidth, bufferheight, 0, 0, srcwidth, srcheight, bufferwidth, bufferheight, buffer, bufferwidth, bufferheight, rotate, ImgBuffer )		

#ifdef __cplusplus
}
#endif

#endif
