#include "ds2_timer.h"
#include "ds2io.h"
#include <ds2io2.h>
#include <key.h>
#include <datatype.h>
#include <debugoff.h>


#define KEY_REPEAT_TIME		200		//5 times/second
#define KEY_REPEAT_TIME_N	(KEY_REPEAT_TIME*1000000/SYSTIME_UNIT)

#define INPUT_REPEAT_TIME	200
#define INPUT_REPEAT_TIME_N (INPUT_REPEAT_TIME*1000000/SYSTIME_UNIT)

static unsigned int _last_key = 0;
static unsigned int _last_key_timestamp = 0;
static unsigned int _key_repeat_time_n = KEY_REPEAT_TIME_N;
static unsigned int _input_repeat_time_n = INPUT_REPEAT_TIME_N;

/*
*   Function: only detect the key pressed or not
*/
unsigned int getKey(void)
{
	struct key_buf input;
	unsigned int new_key, hold_key, ret_key, timestamp;
	int flag;

	ds2_getrawInput(&input);

	timestamp = getSysTime();
	flag = ((timestamp - _last_key_timestamp) >= _key_repeat_time_n) ? 1 : 0;

	input.key &= 0x3FFF;
	new_key = (_last_key ^ input.key) & input.key;
	hold_key = _last_key & input.key;

	ret_key = 0;
	if(hold_key) {
		if(flag)
		{
			ret_key = hold_key;
			_last_key_timestamp = timestamp;
		}
	}

	if(new_key)
	{
		ret_key |= new_key;
		_last_key_timestamp = timestamp;

		_last_key = input.key;
	}

	return ret_key;
}


U32 Proc_GetKey( U32 key_repeat_time )
{
	U32 ret;
	_key_repeat_time_n = (key_repeat_time*1000000/SYSTIME_UNIT);
	ret = getKey();
	_key_repeat_time_n = KEY_REPEAT_TIME_N;//ָĬ

	return ret;
}

static unsigned int _last_input = 0;
static unsigned int _last_input_timestamp = 0;

/*
*   Function: only detect the key pressed or not and touch position
*/
unsigned int getInput(struct key_buf *input) {
    struct key_buf rawin;
    unsigned int timestamp, newKey, hold;
    int flag, ret;

	ds2_getrawInput(&rawin);

	if( rawin.key == KEY_TOUCH )
	{
		*input = rawin;
		_last_input = rawin.key;
		return true;
	}

	timestamp = getSysTime();
	flag = ((timestamp - _last_input_timestamp) >= _input_repeat_time_n) ? 1 : 0;

    rawin.key &= 0x3FFF;
    newKey = (rawin.key ^ _last_input) & rawin.key;
    hold = rawin.key & _last_input;

    ret = 0;
    if(hold && flag)
    {
        ret = hold;
        input->x = rawin.x;
        input->y = rawin.y;

        _last_input_timestamp = timestamp;
    }

    if(newKey)
    {
        ret |= newKey;
        input->x = rawin.x;
        input->y = rawin.y;

        _last_input_timestamp = timestamp;
//        _last_input = rawin.key;
    }

     _last_input = rawin.key;

    input->key = ret;
    return ret > 0;
}

U32 Proc_GetInput( struct key_buf *input, U32 input_repeat_time )
{
	int ret;
	_input_repeat_time_n = 	(input_repeat_time*1000000/SYSTIME_UNIT);
	ret = getInput( input );
	_input_repeat_time_n = 	INPUT_REPEAT_TIME_N;//ָĬ

	return ret;
}

#define		INPUT_REPEAT_TIME2				400

static U16 KeyPress_old = 0;
static U32 KeyPressCount = 0;
static U32 input_repeat_time = INPUT_REPEAT_TIME2;

U32 Proc_GetInputAcc( KEY_BUF *input, U32 input_repeat_time_max, U32 input_repeat_time_min, U16 AccKey, U32 AccStartCount, bool AccFlag, bool Need_Reset_Key )
{
	int KeyPressFlag = false;

	KEY_BUF rawin;

	if( KeyPress_old == 0 && KeyPressCount == 0 )
	{
		KeyPress_old = 0;
		input_repeat_time = input_repeat_time_max;
	}

	if( AccFlag == false || Need_Reset_Key == true )
	{
		KeyPress_old = 0;
		KeyPressCount = 0;
		input_repeat_time = input_repeat_time_max;
	}

	_input_repeat_time_n = 	(input_repeat_time*1000000/SYSTIME_UNIT);
	KeyPressFlag = getInput( input );
	_input_repeat_time_n = 	INPUT_REPEAT_TIME_N;//ָĬ

	if( AccFlag == true && KeyPressFlag != false )
	{
		if( input->key & (AccKey) )
		{
			if( input->key == KeyPress_old )
			{
				KeyPressCount++;
				if( KeyPressCount >= AccStartCount && input_repeat_time > input_repeat_time_min )
				{
					if( input_repeat_time > 100 )
					{
						input_repeat_time = 100;
					}
					else
					{
						if( KeyPressCount >= 50 )
							input_repeat_time -= 5;
						else if( KeyPressCount >= 40 )
							input_repeat_time -= 4;
						else if( KeyPressCount >= 30 )
							input_repeat_time -= 3;
						else if( KeyPressCount >= 20 )
							input_repeat_time -= 2;
						else
							input_repeat_time -= 1;
					}
					if( input_repeat_time < input_repeat_time_min )
						input_repeat_time = input_repeat_time_min;
				}
			}
			else
			{
				KeyPress_old = input->key;
				KeyPressCount = 0;
//				input_repeat_time = INPUT_REPEAT_TIME2;
				input_repeat_time = input_repeat_time_max;
			}
		}
		else
		{
			if( KeyPressCount != 0 )
			{
				KeyPress_old = input->key;
				KeyPressCount = 0;
				input_repeat_time = INPUT_REPEAT_TIME2;
			}
		}
	}

	if( KeyPressFlag == false )
	{
		if( KeyPress_old != 0 ||KeyPressCount != 0 )
		{
			ds2_getrawInput(&rawin);
			if( rawin.key == 0 )
			{
				KeyPress_old = 0;
				KeyPressCount = 0;
				input_repeat_time = input_repeat_time_max;
			}
		}
	}

	return KeyPressFlag;
}
