#ifndef __KEY_H__
#define __KEY_H__

#include <ds2io2.h>
#include <datatype.h>

#define KEY_PRESS(key, key_id)	(!(key & (key_id<<16)) && (key & key_id))
#define KEY_HOLD(key, key_id)	((key & (key_id<<16)) && (key & key_id))
#define KEY_RELEASE(key, key_id)	((key & (key_id<<16)) && !(key & key_id))

/*
*   Function: only detect the key pressed or not
*/
unsigned int getKey(void);

/*
*   Function: can get the detail information about key pressed, hold, or release
*/
unsigned int getKey1(void);

/*
*   Function: detect the key pressed or not and touched position
*/
extern unsigned int getInput(struct key_buf *input);


//----------------------------------------------------------------------------------------------------------------------------------------
//Add by
//----------------------------------------------------------------------------------------------------------------------------------------
U32 Proc_GetKey( U32 key_repeat_time );
extern U32 Proc_GetInput( struct key_buf *input, unsigned int input_repeat_time );
//extern U32 Proc_GetInputAcc( struct key_buf *input, U32 input_repeat_time_max, U32 input_repeat_time_min, U16 AccKey, U32 AccStartCount, bool AccFlag );
extern U32 Proc_GetInputAcc( KEY_BUF *input, U32 input_repeat_time_max, U32 input_repeat_time_min, U16 AccKey, U32 AccStartCount, bool AccFlag, bool Need_Reset_Key );

#endif //__KEY_H__
