#include <string.h>
#include "language.h"
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <strsafe.h>
#include "common/utils.h"
#include "charsets.h"
#include <scene.h>
#include <conf.h>
#include <font.h>
#include <Macro.h>
#include <debugoff.h>

#define strnicmp strncasecmp

typedef struct{
//	U32 index;
	char *lang_dir;
}LANG_INDEX_t;

LANG_INDEX_t lang_index_table[SUPPORT_LANG_MAX_COUNT];

int LANG_INDEX_EN = 0;
int LANG_INDEX_CN = 1;
int LANG_INDEX_TW = 2;
int LANG_INDEX_JP = 3;

static int code_type = UTF8;//only support UTF8 and UNICODE

static int language_read( const char *filename, char ** ppTxtData, int *len );
static int language_find_seg( const char *srcstr, const char *cmpstr_seg, char **pptr_seg, U32 *len_seg, U32 lang_len );
static int language_find_item_In_seg_deunicode( const char *ptr_seg, U32 len_seg, const char *cmpstr_item, char **ppdststr );
static int language_find_item_In_seg( const char *ptr_seg, U32 len_seg, const char *cmpstr_item, char **ppdststr );

static char *lang_path = NULL;

const char default_lang_str = '\0';
const char *lang_ok = NULL;
const char *lang_cancel = NULL;
const char *lang_Notice = NULL;
const char *lang_Help = NULL;
const char *lang_Exit = NULL;

char *lang_item[LANG_ID_COUNT];
int	LANG_OK_ID = 0;
int	LANG_CANCEL_ID = 0;
int	LANG_NOTICE_ID = 0;
int	LANG_HELP_ID = 0;
int	LANG_EXIT_ID = 0;
int LANG_SELECT_ID = 0;
int	LANG_EXITIREADER_ID = 0;
int	LANG_EXITITXT_ID = 0;
int	LANG_OPENFILEERROR_ID = 0;
int	LANG_FILEEMPTY_ID = 0;
int	LANG_FILEENCODE_ID = 0;

int	LANG_CATALOG_ALL_ID = 0;
int	LANG_CATALOG_BOOK_ID = 0;
int	LANG_CATALOG_PICTURE_ID = 0;

int	LANG_FONT_MENU_ID = 0;
int	LANG_FONT_TITLE_ID = 0;
int	LANG_FONTSIZE_ID = 0;
int	LANG_ROWSPACE_ID = 0;
int	LANG_WORDSPAC_ID = 0;
int	LANG_FONTCOLOR_ID = 0;
int	LANG_FONTBGCOLOR_ID = 0;

int	LANG_STYLE_MENU_ID = 0;
int	LANG_STYLE_TITLE_ID = 0;

int	LANG_READMODE_MENU_ID = 0;
int	LANG_READMODE_TITLE_ID = 0;
int	LANG_READMODE_ITEM0_ID = 0;
int	LANG_READMODE_ITEM1_ID = 0;
int	LANG_HORIZONTAL_ID = 0;
int	LANG_VERTICAL_ID = 0;
int	LANG_UPPERSCREEN_ID = 0;
int	LANG_LOWERSCREEN_ID = 0;
int	LANG_DOUBLECREEN_ID = 0;

int	LANG_BRIGHTNESS_MENU_ID = 0;
int	LANG_BRIGHTNESS_TITLE_ID = 0;
int	LANG_BRIGHTNESS_ID = 0;

int LANG_LANGUAGE_ID = 0;
int LANG_LANG0_ID = 0;
int LANG_LANG1_ID = 0;
int LANG_LANG2_ID = 0;
int LANG_LANG3_ID = 0;
int LANG_BRIGHTNESS_NOTE_ID = 0;

int	LANG_JUMP_MENU_ID = 0;
int	LANG_JUMP_TITLE_ID = 0;
int	LANG_JUMP_ITEM0_ID = 0;

int	LANG_BM_MENU_ID = 0;
int	LANG_BM_TITLE_ID = 0;
int	LANG_ADDBM_ID = 0;
int	LANG_VIEWBMLIST_ID = 0;
int	LANG_DELETE_ID = 0;
int	LANG_DELETEALL_ID = 0;
int	LANG_BM_JUMP_ID = 0;
int	LANG_BM_RETURN_ID = 0;
int	LANG_BM_DEL_ID = 0;
int	LANG_BM_EMPTY_ID = 0;
int	LANG_SAVEBM_ID = 0;
int	LANG_SAVEBM_OK_ID = 0;

int	LANG_HELP_MENU_ID = 0;

int	LANG_SIZE_ID = 0;
int	LANG_FILESIZE_ID = 0;
int	LANG_ZOOM_ID = 0;
int	LANG_ORIGSIZE_ID = 0;
int	LANG_ADAPTH_ID = 0;
int	LANG_ADAPTW_ID = 0;
int	LANG_IMG_LOAD_FAIL_ID = 0;
int	LANG_IMG_ZOOM_FAIL_ID = 0;
int	LANG_IMG_ROTATE_FAIL_ID = 0;
int	LANG_IMG_FAIL_REASON_ID = 0;
int	LANG_WFORMAT_ID = 0;
int	LANG_MEMLACK_ID = 0;
int	LANG_ERRFILEOPEN_ID = 0;
int	LANG_ERRFILERW_ID = 0;
int	LANG_UNKNOWN_REASON_ID = 0;

int	LANG_FBH_TITLE_ID = 0;
int	LANG_FBH_UP_ID = 0;
int	LANG_FBH_DOWN_ID = 0;
int	LANG_FBH_LEFT_ID = 0;
int	LANG_FBH_RIGHT_ID = 0;
int	LANG_FBH_L_R_ID = 0;
int	LANG_FBH_A_ID = 0;
int	LANG_FBH_B_ID = 0;
int	LANG_FBH_SELECT_ID = 0;
int	LANG_FBH_START_ID = 0;

int	LANG_TXTRH_TITLE_ID = 0;
int	LANG_TXTRH_UP_ID = 0;
int	LANG_TXTRH_DOWN_ID = 0;
int	LANG_TXTRH_LEFT_ID = 0;
int	LANG_TXTRH_RIGHT_ID = 0;
int	LANG_TXTRH_RLEFT_ID = 0;
int	LANG_TXTRH_RRIGHT_ID = 0;
int	LANG_TXTRH_X_ID = 0;
int	LANG_TXTRH_Y_ID = 0;
int	LANG_TXTRH_B_ID = 0;


int	LANG_PBH_TITLE_ID = 0;
int	LANG_PBH_UP_ID = 0;
int	LANG_PBH_DOWN_ID = 0;
int	LANG_PBH_LEFT_ID = 0;
int	LANG_PBH_RIGHT_ID = 0;
int	LANG_PBH_L_ID = 0;
int	LANG_PBH_R_ID = 0;
int	LANG_PBH_AUP_Y_ID = 0;
int	LANG_PBH_ADOWN_X_ID = 0;
int	LANG_PBH_ALEFT_ID = 0;
int	LANG_PBH_ARIGHT_ID = 0;
int	LANG_PBH_AL_ID = 0;
int	LANG_PBH_AR_ID = 0;


int	LANG_PDFH_TITLE_ID = 0;
int	LANG_PDF_PAGE_ID = 0;
int	LANG_PDF_CURPAGE_ID = 0;

int GetlanguageCodingType( void )
{
	int fontCoding_type;
	if( config.cur_lang_index == LANG_INDEX_CN )
	{
		fontCoding_type = GBK;
	}
	else if( config.cur_lang_index == LANG_INDEX_JP )
	{
		fontCoding_type = SJIS;
	}
	else if( config.cur_lang_index == LANG_INDEX_TW )
	{
		fontCoding_type = BIG5;
	}
	else// if( config.cur_lang_index == LANG_INDEX_EN )
	{
		fontCoding_type = ASCII;
	}
	return fontCoding_type;
}

static void UnicodeSwap( byte *unicode_Big, U32 count )
{
	U32 i;
	byte tmp;

	count &= ~1;
	for( i=0; i<count; i += 2 )
	{
		tmp = unicode_Big[i];
		unicode_Big[i] = unicode_Big[i+1];
		unicode_Big[i+1] = tmp;
	}
}

static int Proc_Fontdecode( byte **out, int *outLength, const byte *in, int inLength, t_conf_encode encode )//output utf8
{
	byte *Buffer = NULL;
	byte *Buffer2 = NULL;
	byte *outBuffer = *out;
	int outLen = *outLength;
	int offset;
	int len;

	if( ( out == NULL ) || /*( *out == NULL ) || */( in == NULL ) || ( outLength <= 0 ) || ( inLength <=0 ) )
		return false;

	if( encode == conf_encode_gbk )
	{
		outLen = Get_gbk2ucs_Len( in, inLength );
		outLen += 2;
		Buffer = (byte*)memalign( 2, outLen );

		if( Buffer == NULL )
			return false;

		outLen = gbk_to_ucs_Fast( (U16*)Buffer, outLen, in, inLength );
		encode = conf_encode_ucs;
	}
	else if( encode == conf_encode_big5 )
	{
		outLen = Get_big52ucs_Len( in, inLength );
		outLen += 2;
		Buffer = (byte*)memalign( 2, outLen );

		if( Buffer == NULL )
			return false;

		outLen = big5_to_ucs_Fast( (U16*)Buffer, outLen, in, inLength );
		encode = conf_encode_ucs;
	}
	else if( encode == conf_encode_sjis )
	{
		outLen = Get_sjis2ucs_Len( in, inLength );
		outLen += 2;
		Buffer = (byte*)memalign( 2, outLen );

		if( Buffer == NULL )
			return false;

		outLen = sjis_to_ucs_Fast( (U16*)Buffer, outLen, in, inLength );
		encode = conf_encode_ucs;
	}
	else if( encode == conf_encode_utf8 )
	{
		outBuffer = (byte*)in;
		outLen = inLength;
	}
	else if( encode == conf_encode_ucs )
	{
		Buffer = (byte*)in;
		outLen = inLength;
	}
	else if( encode == conf_encode_ucs_bigendian )
	{
		UnicodeSwap( (byte*)in, inLength );
		encode = conf_encode_ucs;
		Buffer = (byte*)in;
		outLen = inLength;
	}
	else
	{
		return false;
	}

	if( encode == conf_encode_ucs )
	{
		if( Buffer[0] == 0xFF && Buffer[1] == 0xFE )
			offset = 2;
		else
			offset = 0;
		len = GetUnicode2Utf8LenFast( (const U16*)(Buffer+offset), outLen );
		len += 1;

		Buffer2 = (byte*)memalign( 2, len );
		if( Buffer2 == NULL )
		{
			if( (Buffer != NULL) && ((U32)Buffer != (U32)in) )
				free( Buffer );
			Buffer = NULL;
			return false;
		}
		outLen = Unicode2Utf8Fast( Buffer2, len, (const U16*)(Buffer+offset), outLen );

		if( (Buffer != NULL) && ((U32)Buffer != (U32)in) )
			free( Buffer );
		Buffer = NULL;

		outBuffer = (byte*)Buffer2;
	}

	*outLength = outLen;
	*out = outBuffer;

	return true;
}

static bool CheckLineEndMark( const char *str )
{
	if( !str )
		return false;
//	return ( ( str[0] == 0x0D && str[1] == 0x00 && str[2] == 0x0A && str[3] == 0x00 ) ? true : false );
	return ( ( str[0] == 0x0D && str[1] == 0x0A ) ? true : false );
}

static bool CheckFileEndMark( const char *str )
{
	if( !str )
		return false;
	return ( ( str[0] == 0x00 ) ? true : false );
}

int Curlang_config_save( int cur_lang_index )
{
	int result;
	char lang_path[256];
	char *lang_buf = NULL;
	int lang_len;

	char *ptr_seg = NULL;
	U32 len_seg;
	char *Buffer = NULL;
	int len;

	char *ptr;
	FILE *fp=NULL;

	if( (cur_lang_index < 0) || (cur_lang_index >= SUPPORT_LANG_MAX_COUNT) )
	{
		return -1;
	}

	STRCPY_S( lang_path, CONFIG_EBOOK_ROOTDIR );
	STRCAT_S( lang_path, CONFIG_LANGUAGE_DIR );
	STRCAT_S( lang_path, "config_lang.txt" );

	if( language_read( lang_path, &lang_buf, &lang_len ) == 0 )
	{
		result = language_find_seg( lang_buf, CUR_LANG_DIR_INDEX_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			len = strlen( LANG_DIR_INDEX_ITEM );
			ptr = strstr( ptr_seg, LANG_DIR_INDEX_ITEM );
			
			ptr = ptr + len;
			*ptr = cur_lang_index + '0';

			fp = fopen( lang_path, "w" );
			if( fp )
			{
				fwrite( lang_buf, 1, lang_len, fp );
				fclose( fp );
			}
			result = 0;
		}
	}
	else
	{
		result = -1;
	}

_Curlang_config_save_Exit:

	if( lang_buf )
		free( lang_buf );

	if( Buffer )
		free( Buffer );

	return result;
}

static void GetlangIndex()
{
	int i;

	for( i=0; i<SUPPORT_LANG_MAX_COUNT; i++ )
	{
		if( strcmp( "lang_en", lang_index_table[i].lang_dir	) == 0 )
			LANG_INDEX_EN = i;
		else if( strcmp( (const char*)"lang_cn", (const char*)lang_index_table[i].lang_dir ) == 0 )
			LANG_INDEX_CN = i;
		else if( strcmp( (const char*)"lang_tw", (const char*)lang_index_table[i].lang_dir ) == 0 )
			LANG_INDEX_TW = i;
		else if( strcmp( (const char*)"lang_jp", (const char*)lang_index_table[i].lang_dir ) == 0 )
			LANG_INDEX_JP = i;
	}
}

static int GetlangDir_Index( char *dirname )
{
	char lang_path[256];
	int result = -1;
	char *ptr_seg = NULL;
	U32 len_seg;
	char *lang_buf = NULL;
	int lang_len;
	int idx = 0,i;
	char *item = NULL;

	STRCPY_S( lang_path, CONFIG_EBOOK_ROOTDIR );
	STRCAT_S( lang_path, CONFIG_LANGUAGE_DIR );
	STRCAT_S( lang_path, "config_lang.txt" );

	if( language_read( lang_path, &lang_buf, &lang_len ) == 0 )
	{
		if( language_find_seg( lang_buf, LANG_DIR_INDEX_TABLE_SEG, &ptr_seg, &len_seg, lang_len ) == 0 )
		{
			idx = 0;
			result = language_find_item_In_seg( ptr_seg, len_seg, LANG_ITEM_IDX0, &lang_index_table[idx].lang_dir );
			if( result == -2 )
			{
			}

			result = language_find_item_In_seg( ptr_seg, len_seg, LANG_ITEM_IDX1, &lang_index_table[++idx].lang_dir );
			if( result == -2 )
			{
			}

			result = language_find_item_In_seg( ptr_seg, len_seg, LANG_ITEM_IDX2, &lang_index_table[++idx].lang_dir );
			if( result == -2 )
			{
			}

			result = language_find_item_In_seg( ptr_seg, len_seg, LANG_ITEM_IDX3, &lang_index_table[++idx].lang_dir );
			if( result == -2 )
			{
			}
		}
		result = -1;
		if( language_find_seg( lang_buf, CUR_LANG_DIR_INDEX_SEG, &ptr_seg, &len_seg, lang_len ) == 0 )
		{
			if( language_find_item_In_seg( ptr_seg, len_seg, LANG_DIR_INDEX_ITEM, &item ) == 0 )
			{
				i = 0;
				idx = 0;
				while( item[i] != 0 )
				{
					if( item[i] >= '0' && item[i] <= '9' )
					{
						idx = idx * 10;
						idx = idx + (item[i]-'0');
					}
					else
					{
						break;
					}
					i++;
				}

				free( (void*)item );
				item = NULL;

				if( idx < 0 || idx >= SUPPORT_LANG_MAX_COUNT )
					idx = 0;
				strcpy( dirname, lang_index_table[idx].lang_dir );
				result = 0;
			}
		}
		if( result != 0 )
		{
			if( language_find_seg( lang_buf, DEFAULT_LANG_DIR_INDEX_SEG, &ptr_seg, &len_seg, lang_len ) == 0 )
			{
				if( language_find_item_In_seg( ptr_seg, len_seg, LANG_DIR_INDEX_ITEM, &item ) == 0 )
				{
					i = 0;
					idx = 0;
					while( item[i] != 0 )
					{
						if( item[i] >= '0' && item[i] <= '9' )
						{
							idx = idx * 10;
							idx = idx + (item[i]-'0');
						}
						else
						{
							break;
						}
						i++;
					}
	
					free( (void*)item );
					item = NULL;
	
					if( idx < 0 || idx >= SUPPORT_LANG_MAX_COUNT )
						idx = 0;
					strcpy( dirname, lang_index_table[idx].lang_dir );
					result = 0;
				}
			}
			
		}
	}

	if( lang_buf )
	{
		free( lang_buf );
	}

	return result;
}

static int GetlangPath( char *lang_path )
{
	int result = 0;
	char dirname[64];
	const byte *pstr = NULL;

	strcpy( lang_path, CONFIG_EBOOK_ROOTDIR );
	strcat( lang_path, CONFIG_LANGUAGE_DIR );

	result = GetlangDir_Index( dirname );
	if( result != 0 )
	{
		strcpy( dirname, "lang_en" );
		config.cur_lang_index = LANG_INDEX_EN;
	}
	else
	{
		GetlangIndex();
	}

	strcat( lang_path, dirname );
	strcat( lang_path, "/language.txt" );

	pstr = dirname + 5;
	if( !strnicmp( pstr, "cn", 2 ) )
	{
		config.cur_lang_index = LANG_INDEX_CN;
	}
	else if( !strnicmp( pstr, "jp", 2 ) )
	{
		config.cur_lang_index = LANG_INDEX_JP;
	}
	else if( !strnicmp( pstr, "tw", 2 ) )
	{
		config.cur_lang_index = LANG_INDEX_TW;
	}
	else //if( !strnicmp( pstr, "en", 2 ) )
	{
		config.cur_lang_index = LANG_INDEX_EN;
	}
	return result;
}

static int language_read( const char *filename, char ** ppTxtData, int *len )
{
	int result = 0;
	const byte *p = NULL;
	byte *p2 = NULL;
	U16 unicode_mark;
	CodeType strCodeType=CODETYPE_DEFAULT;
	char lang_path[256];
	byte *outBuffer = NULL;
	int outLength = 0;

	if( result == 0 )
	{
		result = text_read_sys( (const char *)filename, ppTxtData, len );
		if( result == 0 )
		{
			p = *ppTxtData;

			strCodeType = CheckCodeType( (const byte*)(*ppTxtData), (U32)(*len) );
			if( Proc_Fontdecode( (byte**)(&outBuffer), &outLength, (const byte*)(*ppTxtData), *len,  strCodeType ) == false )
				result = -1;
			else
			{
				result = 0;
				if( strCodeType != UTF8 )
				{
					free( *ppTxtData );
					*ppTxtData = outBuffer;
				}
				code_type = UTF8;
			}
#if 0
			unicode_mark = (p[1] << 8) | p[0];
			switch( unicode_mark )
			{
				case 0xFFFE:
					UnicodeSwap( p, *len );
				case 0xFEFF://UNICODE little endian
					code_type = UNICODE;
					p2 = malloc( (*len) << 1 );
					if( p2 == NULL )
					{
						free( *ppTxtData );
						*ppTxtData = NULL;
						result = -1;
						goto _language_read_Exit;
					}
					*len = UnicodeToUtf8( (const byte*)p, (byte*)p2 );
					free( p );
					*ppTxtData = p2;
					break;
				default:
					code_type = UTF8;
					break;
			}
#endif
		}
	}

_language_read_Exit:

	return result;
}

static int language_find_seg( const char *srcstr, const char *cmpstr_seg, char **pptr_seg, U32 *len_seg, U32 lang_len )//*pptr_seg:εַ *len_seg:γ
{
	char *ptr;
	const char *lang_end = srcstr + lang_len;
	if( !srcstr || !cmpstr_seg || !pptr_seg || !len_seg || lang_len == 0 )
		return -1;

	ptr = strstr( srcstr, cmpstr_seg );
	if( !ptr )
		return -1;

	ptr += strlen( cmpstr_seg );//϶ƫƣutf8*1, unicode*2

	while( 1 )//
	{
		if( ptr >= lang_end )
			return -1;
		if( CheckFileEndMark( ptr ) )
			return -1;
		if( CheckLineEndMark( (const char*)ptr ) )//ǰлسзΪλ"["ͬ
		{
			ptr += 2;//سз
			break;
		}
		ptr++;
	}

	*pptr_seg = ptr;
	while( 1 )//һʼλ
	{
		if( ptr >= lang_end )
			return -1;
		if( CheckFileEndMark( ptr ) )
			return -1;
		if( *ptr == '[' )
		{
			if( CheckLineEndMark( (const char*)(ptr - 2) ) )//ǰлسзΪλ"["ͬ
			{
				ptr += 2;//سз
				break;
			}
		}
		ptr++;
	}

	*len_seg = (U32)(ptr - *pptr_seg);

	return 0;
}

static int language_find_item_In_seg( const char *ptr_seg, U32 len_seg, const char *cmpstr_item, char **ppdststr )//*pptr_seg:εַ
{
	char item[256];
	int i;
	char *ptr;
	char *pdststr = *ppdststr;
	char *ptr_Nextseg = (char*)ptr_seg + len_seg;
	if( !ptr_seg || !cmpstr_item || !ppdststr )
		return -1;

	ptr = strstr( ptr_seg, cmpstr_item );
	if( !ptr )
		goto _language_find_item_In_seg_Fail;

	ptr += strlen( cmpstr_item );//Թ

	i = 0;
	while( ptr < ptr_Nextseg )//ֵ
	{
		if( CheckLineEndMark( (const char *)ptr ) )
			break;
		item[i++] = *ptr++;//utf8
	}
	item[i++] = 0x00;

	if( pdststr == NULL )
	{
		pdststr = malloc( i );
		if( pdststr == NULL )
			goto _language_find_item_In_seg_Fail;

		*ppdststr = pdststr;
	}

	memcpy( pdststr, item, i );

	return 0;

_language_find_item_In_seg_Fail:

	return -1;
}

static int language_find_item_In_seg_deunicode( const char *ptr_seg, U32 len_seg, const char *cmpstr_item, char **ppdststr )//*pptr_seg:εַ
{
	int result;
	int item_len,len;
	char *item = NULL;
	char item_ucs[512];

	result = language_find_item_In_seg( ptr_seg, len_seg, cmpstr_item, ppdststr );
	if( result != 0 )
		return -1;

	if( (*ppdststr) == NULL )
		return -1;

	len = strlen( *ppdststr );

	item_len = utf8_to_ucs( (byte*)item_ucs, 512, (const byte*)(*ppdststr), len );
	item = malloc( item_len + 2 );
	if( item== NULL )
		return -1;

	memcpy( item, item_ucs, item_len );

	item[item_len] = 0x00;
	item[item_len+1] = 0x00;

	free( (void*)(*ppdststr) );
	*ppdststr = item;

	return 0;
}

void language_load_utf8( void )
{
	char *lang_buf = NULL;
	int lang_len;
	int result;
	U32 idx = 0;

	char *ptr_seg = NULL;
	U32 len_seg;

	char filename[256];

	for( idx = 0; idx < LANG_ID_COUNT; idx++ )
		lang_item[idx] = NULL;

	if( GetlangPath( filename ) != 0 )
		return;

	idx = 0;
	result = language_read( (const char*)filename, &lang_buf, &lang_len );//lang_path_tab[config.cur_lang_index]
	if( result == 0 )
	{
		//---------------------------ʾ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_MSG_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_OK, &lang_item[idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			lang_ok = lang_item[idx];
			LANG_OK_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_CANCEL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			lang_cancel = lang_item[idx];
			LANG_CANCEL_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_NOTICE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			lang_Notice = lang_item[idx];
			LANG_NOTICE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_HELP, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			lang_Help = lang_item[idx];
			LANG_HELP_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_EXIT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			lang_Exit = lang_item[idx];
			LANG_EXIT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_SELECT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_SELECT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_EXITIREADER, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_EXITIREADER_ID = idx;

				result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_EXITITXT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_EXITITXT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_OPENFILEERROR, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_OPENFILEERROR_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_FILEEMPTY, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FILEEMPTY_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_FILEENCODE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FILEENCODE_ID = idx;


		}

   	    //---------------------------Ŀ¼-------------------------------------------
		result = language_find_seg( lang_buf, LANG_CATALOG_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_CATALOG_ALL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_CATALOG_ALL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_CATALOG_BOOK, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_CATALOG_BOOK_ID = idx;

				result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_CATALOG_PICTURE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_CATALOG_PICTURE_ID = idx;
		}

		//---------------------------------------------------------------------
		result = language_find_seg( lang_buf, LANG_FONT_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FONT_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FONT_TITLE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FONTSIZE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ROWSPACE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM2, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_WORDSPAC_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM3, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FONTCOLOR_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM4, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FONTBGCOLOR_ID = idx;
		}

		//---------------------------ʽ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_STYLE_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_STYLE_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_STYLE_TITLE_ID = idx;
		}

		//---------------------------Ķʽ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_READMODE_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_READMODE_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_READMODE_TITLE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_READMODE_ITEM0_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_READMODE_ITEM1_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_HORIZONTAL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_HORIZONTAL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_VERTICAL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_VERTICAL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_UPPERSCREEN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_UPPERSCREEN_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LOWERSCREEN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LOWERSCREEN_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_DOUBLECREEN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_DOUBLECREEN_ID = idx;
		}

		//----------------------------------------------------------------------
		result = language_find_seg( lang_buf, LANG_BRIGHTNESS_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BRIGHTNESS_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BRIGHTNESS_TITLE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BRIGHTNESS_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LANGUAGE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LANG0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LANG0_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LANG1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LANG1_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LANG2, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LANG2_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LANG3, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_LANG3_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_BRIGHTNESS_NOTE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BRIGHTNESS_NOTE_ID = idx;
		}


		//---------------------------ת-------------------------------------------
		result = language_find_seg( lang_buf, LANG_JUMP_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_JUMP_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_JUMP_TITLE_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_JUMP_ITEM0_ID = idx;
		}

		//---------------------------ǩ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_BM_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_MENU_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_TITLE_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ADDBM_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_VIEWBMLIST_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM2, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_DELETE_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ITEM3, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_DELETEALL_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_BM_JUMP, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_JUMP_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RETURN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_RETURN_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_BM_DEL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_DEL_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_BM_EMPTY, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_BM_EMPTY_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_SAVEBM, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_SAVEBM_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_SAVEBM_OK, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_SAVEBM_OK_ID = idx;
		}

		//----------------------------------------------------------------------
		result = language_find_seg( lang_buf, LANG_HELP_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MENU, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_HELP_MENU_ID = idx;
		}

		//---------------------------ͼƬ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_PCITURE_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_SIZE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_SIZE_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_FILESIZE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FILESIZE_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ZOOM, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ZOOM_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ORIGSIZE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ORIGSIZE_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ADAPTH, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ADAPTH_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ADAPTW, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ADAPTW_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG0, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_IMG_LOAD_FAIL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG1, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_IMG_ZOOM_FAIL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG2, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_IMG_ROTATE_FAIL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG3, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_IMG_FAIL_REASON_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG4, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_WFORMAT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG5, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_MEMLACK_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG6, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ERRFILEOPEN_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG7, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_ERRFILERW_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_MSG8, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_UNKNOWN_REASON_ID = idx;

		}

		//---------------------------ļ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_FBH_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_TITLE_ID = idx;//FBH:file Browse Helpд


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_UP, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_UP_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_DOWN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_DOWN_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LEFT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_LEFT_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RIGHT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_RIGHT_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_L_R, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_L_R_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_A, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_A_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_B, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_B_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_SELECT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_SELECT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_START, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_FBH_START_ID = idx;
		}

		//---------------------------ıĶ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_TXTRH_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_TITLE_ID = idx;//TXTRHH:TEXT reading Helpд


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_UP, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_UP_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_DOWN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_DOWN_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LEFT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_LEFT_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RIGHT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_RIGHT_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RLEFT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_RLEFT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RRIGHT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_RRIGHT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_X, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_X_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_Y, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_Y_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_B, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_TXTRH_B_ID = idx;
		}


		//---------------------------ıĶ-------------------------------------------
		result = language_find_seg( lang_buf, LANG_PBH_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_TITLE_ID = idx;//PBHH:TEXT reading Helpд


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_UP, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_UP_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_DOWN, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_DOWN_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_LEFT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_LEFT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_RIGHT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_RIGHT_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_L, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_L_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_R, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_R_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_AUP_Y, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_AUP_Y_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ADOWN_X, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_ADOWN_X_ID = idx;


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ALEFT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_ALEFT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_ARIGHT, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_ARIGHT_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_AL, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_AL_ID = idx;

			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_AR, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PBH_AR_ID = idx;
		}

		//---------------------------PDF-------------------------------------------
		result = language_find_seg( lang_buf, LANG_PDFH_SEG, &ptr_seg, &len_seg, lang_len );
		if( result == 0 )
		{
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_TITLE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PDFH_TITLE_ID = idx;//PDFH:PDF Helpд


			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_PDF_PAGE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PDF_PAGE_ID = idx;

#if 0
			result = language_find_item_In_seg_deunicode( ptr_seg, len_seg, LANG_PDF_CURPAGE, &lang_item[++idx] );
			if( result == -2 )
			{
				lang_item[idx] = (char *)(&default_lang_str);
			}
			LANG_PDF_CURPAGE_ID = idx;
#endif
		}
	}

	if( lang_buf )
		free( lang_buf );
}

void language_free()
{
	int i;

	for( i=0; i<LANG_ID_COUNT; i++ )
	{
		if( lang_item[i] )
		{
			free( lang_item[i] );
			lang_item[i] = NULL;
		}
	}
}
