#include "_const.h"
#include "plugin.h"
#include "png.h"
#include <plug_png_interface.h>
#include <image.h>
#include <memory_png.h>
#include <MemMgr.h>
#include <fs_api.h>
#include <DrvMemMgr.h>
#include <Macro.h>
#include <scene_image.h>
#include <scene.h>
#include <string.h>
#include <mystring.h>
#include <unzip.h>
#include <debugoff.h>

#define			IMAGEVIEW_MEMDEST_SIZE			( 1024 * 1024 )//1MBytes

static bool ImgBufferHold = true;
//-------------------------------------------------------------------------------------------
static	int zoom_w, zoom_h;
static	int zoom_w_org, zoom_h_org;
static	int BufferDstLine_Out = 0;//Ѿн
static	pixel *imgzoomsrc = NULL;//Ų

//----------------------------
static	pixel *Vram = NULL;
static	pixel *VramLinePtr = NULL;
static	pixel *VramPtr = NULL;
static	int start_x_up = 0;
static	int dst_done_h_up = 0;
static	int dst_done_h_old_up = 0;
static	int dst_done_h_old_prev_up = 0;
static	int dst_done_h_up_max = 0;
static	int src_do_h_up = 0;
static	int srcstart_line_up = 0;//ŵԭʼʼ
static	int srcstart_line_old_up = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr_up[2] = { NULL, NULL };//ŵָ(2)
static	int start_pixelX = 0;
static	int end_pixelX = 0;
static	PAINT_RECT Prect;

//----------------------------
static	pixel *Thumbimg = NULL;
static	int start_x = 0;
static	int dst_done_h = 0;
static	int dst_done_h_old = 0;
static	int dst_done_h_old_prev = 0;
static	int src_do_h = 0;
static	int srcstart_line = 0;//ŵԭʼʼ
static	int srcstart_line_old = 0;//ŵԭʼʼ
static	pixel *imgzoomsrcptr[2] = { NULL, NULL };//ŵָ(2)
//static  pixel *pThumbLine = NULL;

static	dword Thumbw, Thumbh;
static	dword Thumbw_org, Thumbh_org;
static	RECT ThumbR, ThumbSR;


//------------------------------------------------------------------------------
static unsigned int png_readp = 0;//fseek
/*static*/ unsigned int png_zip_len = 0;
int png_in_zip_Flag = false;
static int ErrorCode = ERR_UNKNOWN;

static s32 imgWidth=0,imgHeight=0;


//------------------------------------------------------------------------------
extern FILE *fpin;

// -----------------
BOOL LoadPNG( const char *filename )
{
  	imgWidth=0;
  	imgHeight=0;

  	if( PNGINT_Init(filename)==False )
  	{
    	return(False);
  	}
  	imgWidth=PNGINT_GetWidth();
  	imgHeight=PNGINT_GetHeight();//-1;
  	return(true);
}

// ------------------------------------------------------------------------------------

// ------------------------------------------------------------------------------------
static void Free_png(void)
{
  PNGINT_Free();

  imgWidth=0;
  imgHeight=0;
}

static void GetBitmap24(U32 LineY,U8 *pBM)
{
  if(imgHeight<=LineY) return;
  PNGINT_GetNextLine(pBM);
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
//------------------------------------------------------------------
//עʵͳһ壬ȻٸҪӦڴ
//2009-11-10 17:17:38 by LHM
//------------------------------------------------------------------
FILE* fopenzip_png( unsigned int size )
{
	unsigned char *buffer = NULL;

	if( size == 0 )
		return (FILE*)0;

	buffer = (unsigned char*)zmalloc( size + 1 );

	png_in_zip_Flag = true;//
	png_zip_len = size;
	png_readp = 0;

	return (FILE*)buffer;
}

void fclosezip_png( FILE *stream )
{
	if( stream )
	{
		free( (void*)stream );
		stream = NULL;
	}
}
//----------------------------------------------
//ֵ: ɹ0򷵻ֵ
//----------------------------------------------
int fseekzip_png( FILE *stream, long int offset, int fromwhere )
{
	if( fromwhere == 0 )
	{
		if( offset >= png_zip_len )
		{
			return -1;
		}
		png_readp = offset;
	}
	else if( fromwhere == 1 )
	{
		png_readp += offset;
	}
	else if( fromwhere == 2 )
	{
		if( offset > 0 || (offset + png_zip_len - 1 ) < 0 )
		{
			return -1;
		}
		else if( offset <= 0 )
		{
			png_readp = png_zip_len - 1 + offset;
		}
	}
	return 0;
}

int freadzip_png(void *ptr, int size, int nitems, FILE *stream)
{
	unsigned int nb = size * nitems;

	if( !stream || !ptr )
	{
		return 0;
	}

	if( png_readp >= png_zip_len )
		png_readp = png_zip_len - 1;

	if( nb > ( png_zip_len - png_readp ) )
		nb = png_zip_len - png_readp;

	memcpy( ptr, (void*)stream + png_readp, nb );
	png_readp += nb;

	if( png_readp >= png_zip_len )
		png_readp = png_zip_len - 1;
	return nb;
}


static void ShowImgGradual_Init( dword width, dword height )
{
		dword w;
//----------------------------
		Thumbimg = image_getthumbbuffer();
		start_x = 0;
		dst_done_h = 0;
		dst_done_h_old = 0;
		dst_done_h_old_prev = 0;
		src_do_h = 0;
		srcstart_line = 0;//ŵԭʼʼ
		srcstart_line_old = 0;//ŵԭʼʼ
		BufferDstLine_Out = 0;//Ѿн
		imgzoomsrc = (pixel*)memalign( PIXEL_BYTES, width * PIXEL_BYTES );//Ų
		imgzoomsrcptr[0] = NULL;//ŵָ(2)
		imgzoomsrcptr[1] = NULL;//ŵָ(2)

		GetThumbwh( &Thumbw, &Thumbh, width, height, config.rotate );
		image_GetZoomwh( width, height, &zoom_w, &zoom_h );

		if( ((dword)config.rotate & 0x1) == 0 )
		{
			zoom_w_org = zoom_w;
			zoom_h_org = zoom_h;

			Thumbw_org = Thumbw;
			Thumbh_org = Thumbh;
		}
		else
		{
			zoom_w_org = zoom_h;
			zoom_h_org = zoom_w;

			Thumbw_org = Thumbh;
			Thumbh_org = Thumbw;
		}

		GetThumbPos( &ThumbR, &ThumbSR, 0, 0, Thumbw, Thumbh, zoom_w, zoom_h );

		memsetword( Thumbimg, COLOR_BLACK, CONFIG_THUMBW * CONFIG_THUMBH );
		scene_printthumbimgBg( COLOR_BLACK );

//----------------------------
		Vram = GetVram( UP_SCREEN );
		VramLinePtr = Vram;
		VramPtr = Vram;
		start_x_up = 0;
		dst_done_h_up = 0;
		dst_done_h_old_up = 0;
		dst_done_h_old_prev_up = 0;
		dst_done_h_up_max = 0;
		src_do_h_up = 0;
		srcstart_line_up = 0;//ŵԭʼʼ
		srcstart_line_old_up = 0;//ŵԭʼʼ
		imgzoomsrcptr_up[0] = NULL;//ŵָ(2)
		imgzoomsrcptr_up[1] = NULL;//ŵָ(2)
		start_pixelX = 0;
		end_pixelX = 0;

		GetScreenPos( &Prect, zoom_w, zoom_h );
		start_pixelX = 0;
		end_pixelX = SCREEN_W - 1;
		if( end_pixelX > width - 1 )
			end_pixelX = width - 1;

		if( (config.rotate & 0x1) == 0 )
			w = Prect.w;
		else
			w = Prect.h;

		if( (config.rotate & 0x1) == 0 )
		{
			dst_done_h_up_max = SCREEN_H;
		}
		else
		{
			dst_done_h_up_max = SCREEN_W;
		}
		if( dst_done_h_up_max > height )
			dst_done_h_up_max = height;

		VramLinePtr += Prect.painttop * SCREEN_W;//ʼָ
		memsetword( Vram, COLOR_BLACK, SCREEN_W * SCREEN_H );
}

static void ShowImgGradual_Free()
{
	if( imgzoomsrc )
	{
		free( imgzoomsrc );
		imgzoomsrc = NULL;
	}
}


#define			DISPLAY_COUNT_MAX_UP			8
static void ShowImgGradual_up( dword width, dword height, int imgline_out, pixel *pImgLine, int *endFlag )
{
	static int dis_count = 0;
	if( pImgLine == NULL || *endFlag == true )
		return;

	if( src_do_h_up < 2 )
	{
		if( dst_done_h_up < dst_done_h_up_max && BufferDstLine_Out >= srcstart_line_up )
		{
			if( BufferDstLine_Out - srcstart_line_up == src_do_h_up )
				imgzoomsrcptr_up[src_do_h_up++] = pImgLine;
			else
			{
				imgzoomsrcptr_up[0] = imgzoomsrcptr_up[1];
				imgzoomsrcptr_up[1] = pImgLine;
				src_do_h_up = 2;
			}
		}
	}
	if( src_do_h_up == 2 )
	{
		//-------------------------------------
		if( (dst_done_h_up < dst_done_h_up_max) && src_do_h_up == 2 )
		{
			src_do_h_up = 0;
			do{
				VramPtr = VramLinePtr + Prect.paintleft;
				srcstart_line_old_up = srcstart_line_up;
				dst_done_h_old_prev_up = dst_done_h_up;

				srcstart_line_up = image_zoom_bilinear_Line_FromBuffer2( imgzoomsrcptr_up[0], imgzoomsrcptr_up[1], width, height, VramPtr, zoom_w_org, zoom_h_org, start_pixelX, end_pixelX, &dst_done_h_up, &start_x_up );

				VramLinePtr += SCREEN_W;

				if( dst_done_h_up >= dst_done_h_up_max )
				{
					*endFlag = true;
					F2( "UpperScreen end!\n" );
					break;
				}
			}while( srcstart_line_up == srcstart_line_old_up );

			if( (++dis_count >= DISPLAY_COUNT_MAX_UP) || (*endFlag == true) )
			{
				Flush( UP_SCREEN );
				dis_count = 0;
			}
		}
	}
}

#define			DISPLAY_COUNT_MAX_DOWN			4
static void ShowImgGradual_down( dword width, dword height, int imgline_out, pixel *pImgLine )
{
//	return;

	static int dis_count = 0;

	if( pImgLine == NULL )
		return;

	if( src_do_h < 2 )
	{
		if( BufferDstLine_Out >= srcstart_line )
		{
			if( BufferDstLine_Out - srcstart_line == src_do_h )
				imgzoomsrcptr[src_do_h++] = pImgLine;
			else
			{
				imgzoomsrcptr[0] = imgzoomsrcptr[1];
				imgzoomsrcptr[1] = pImgLine;
				src_do_h = 2;
			}
		}
	}
	if( src_do_h == 2 || BufferDstLine_Out == height )
	{
		src_do_h = 0;
		dst_done_h_old = dst_done_h;

		pixel *ThumbimgPtr = NULL;
		do{
			srcstart_line_old = srcstart_line;
			dst_done_h_old_prev = dst_done_h;

			ThumbimgPtr = Thumbimg + dst_done_h_old_prev * Thumbw;
			srcstart_line = image_zoom_bilinear_Line_FromBuffer( imgzoomsrcptr[0], imgzoomsrcptr[1], width, height, ThumbimgPtr, Thumbw_org, Thumbh_org, &dst_done_h, &start_x );

		}while( srcstart_line == srcstart_line_old );

#if 1
		scene_printthumbimgline( ThumbR, ThumbSR, dst_done_h_old, dst_done_h - dst_done_h_old );
#else
		scene_printthumbimg( 0, 0, Thumbw, Thumbh, zoom_w, zoom_h, Thumbimg );
#endif

		if( ++dis_count >= DISPLAY_COUNT_MAX_DOWN )
		{
			Flush( DOWN_SCREEN );
			dis_count = 0;
		}
	}
}


extern int png_read2( dword *pwidth, dword *pheight, pixel **image_data, pixel *bgcolor )
{
	int x,y,m,xt;
	U8 *pic_png = NULL;
	U8 r,g,b;
	FILE * fp_w = NULL;
	dword bufferSize_Byte, BufferDstPixel_Max;
	pixel *bufferDstPtr = NULL;
	pixel *ImgBufPtr = NULL;
	pixel *ImgBuf = NULL;
	dword BufferDstPixel_Cur = 0;
	int x_width = 0;
	int RetValue = -1;

	int UpendFlag = false;
	pixel *pImgZoomLine = NULL;

	ImgBufferHold = false;

	pic_png = (U8*)malloc( imgWidth*3 );//һһеĽ⣬ֻһеڴ
	if( !pic_png )
  	{
  		ErrorCode = ERR_MEM_LACK;
  		goto _PNG_READ_EXIT;
  	}

	bufferSize_Byte = imgWidth * imgHeight * PIXEL_BYTES;
	ImgBuf = (pixel*)memalign( PIXEL_BYTES, bufferSize_Byte );
	if( ImgBuf == NULL )
	{
		if( bufferSize_Byte > IMAGEVIEW_MEMDEST_SIZE )
			bufferSize_Byte = IMAGEVIEW_MEMDEST_SIZE;
		ImgBuf = (pixel*)memalign( PIXEL_BYTES, bufferSize_Byte );
		if( ImgBuf == NULL )
		{
			ErrorCode = ERR_MEM_LACK;
  			goto _PNG_READ_EXIT;
  		}
	}
	else
	{
		ImgBufferHold = true;	
	}
	
	if( ImgBufferHold == false )
	{
		fp_w = fopen_imgSwapfile( "wb" );
		if( fp_w == NULL )
		{
			ErrorCode = ERR_FILE_OPEN;
    		goto _PNG_READ_EXIT;
		}
	}

	BufferDstPixel_Max = bufferSize_Byte >> (PIXEL_BYTES>>1);

	if( ImageViewFlag == true )
	{
		scene_printimgInfo( imgWidth, imgHeight );
		ShowImgGradual_Init( imgWidth, imgHeight );
	}

	bufferDstPtr = ImgBuf;
	for( y=0;y<imgHeight;y++ )
  	{
    	ImgBufPtr = bufferDstPtr;
    	GetBitmap24( y, pic_png );
    	if( BufferDstPixel_Cur+imgWidth > BufferDstPixel_Max )
		{
			x_width = (BufferDstPixel_Max - BufferDstPixel_Cur);
		}
		else
		{
			x_width = imgWidth;
		}

   		for( x=0, m=0;x<x_width;x++ )
		{
			r = pic_png[m++];
 			g = pic_png[m++];
 			b = pic_png[m++];

 			if( PIXEL_BYTES == 2 )
 			{
 				r >>= 3;
 				g >>= 3;
 				b >>= 3;
 				bufferDstPtr[x] = RGB15( r,g,b );
 			}
 			else if( PIXEL_BYTES == 4 )
 			{
 				bufferDstPtr[x] = RGB24( r,g,b );
 			}
		}

		bufferDstPtr += x_width;
		BufferDstPixel_Cur += x_width;

		if( ImageViewFlag == true )
		{
			if( x_width == imgWidth )
			{
				pImgZoomLine = ImgBufPtr;
			}
			else
			{
				memcpyword( imgzoomsrc, ImgBufPtr, x_width );
			}
		}

		if( ImgBufferHold == false )
		{
			if( BufferDstPixel_Cur >= BufferDstPixel_Max )
			{
				fwrite(  ImgBuf, PIXEL_BYTES, BufferDstPixel_Max, fp_w );

				BufferDstPixel_Cur -= BufferDstPixel_Max;
				bufferDstPtr = ImgBuf + BufferDstPixel_Cur;
			}
		}

		if( x_width < imgWidth )
		{
			ImgBufPtr = bufferDstPtr;
			for( xt=0;x<imgWidth;x++,xt++ )
			{
				r = pic_png[m++];
				g = pic_png[m++];
				b = pic_png[m++];

				if( PIXEL_BYTES == 2 )
				{
					r >>= 3;
					g >>= 3;
					b >>= 3;
					bufferDstPtr[xt] = RGB15( r,g,b );
				}
				else if( PIXEL_BYTES == 4 )
				{
					bufferDstPtr[xt] = RGB24( r,g,b );
				}
			}
			bufferDstPtr += imgWidth - x_width;
			BufferDstPixel_Cur += imgWidth - x_width;

			if( ImageViewFlag == true )
			{
				memcpyword( imgzoomsrc + x_width, ImgBufPtr, imgWidth - x_width );
				pImgZoomLine = imgzoomsrc;
			}
		}

		if( ImageViewFlag == true )
		{
			ShowImgGradual_up( imgWidth, imgHeight, BufferDstLine_Out, pImgZoomLine, &UpendFlag );
			ShowImgGradual_down( imgWidth, imgHeight, BufferDstLine_Out, pImgZoomLine );
		}
		BufferDstLine_Out++;
	}

	if( ImgBufferHold == false && BufferDstPixel_Cur > 0 )
	{
		fwrite(  ImgBuf, PIXEL_BYTES, BufferDstPixel_Cur, fp_w );
		BufferDstPixel_Cur = 0;
	}

  	*pwidth = imgWidth;
  	*pheight = imgHeight;
  	*bgcolor = COLOR_BLACK;//ɫΪɫ
	RetValue = 0;

	if( ImgBufferHold )
	{
		*image_data = ImgBuf;
	}
_PNG_READ_EXIT:
  	if( pic_png )
  		free( (void*)pic_png );
  		
	if( ImgBufferHold == false )
	{
  		if( ImgBuf )
  			free( ImgBuf );
  		
  		if( fp_w )
  			fclose( fp_w );
	}
	
	if( ImageViewFlag )
  		ShowImgGradual_Free();

  	Free_png();//дơ//һͷžͻ //2009-11-4 17:08:50 쳣Ѿ
 	return RetValue;
}

extern int png_read( const char *filename, dword *pwidth, dword *pheight, pixel **image_data, pixel *bgcolor )
{
//---------------------------ֲ------------------------------------
	int ret = -1;

//-------------------------------------------
#if MEM_RECORD
	mem_con_init( PNG_MEM_ID );//ڴ
#endif

	png_in_zip_Flag = false;
	if(LoadPNG( filename )==False)
	{
    return -1;
  }
	ret = png_read2( pwidth, pheight, image_data, bgcolor );

#if MEM_RECORD
	mem_con_free( png_sfree2, PNG_MEM_ID  );//ڴ
#endif

	return ret;
}


extern int png_read_in_zip( void *fp, dword * pwidth, dword * pheight, pixel ** image_data, pixel * bgcolor, t_image_fread readfn )
{
//------------------ֲ----------------------------
	int ret = -1;
	dword filelen = 0;

//-------------------------------------------------------------
	if( !fp )
	{	
		ErrorCode = ERR_FILE_OPEN;
		return ErrorCode;
	}
	
	filelen = unztellsize( fp );

	fpin = fopenzip_png( filelen );
	if( !fpin )
	{	
		ErrorCode = ERR_MEM_LACK;
		return ErrorCode;
	}

	image_zip_fseek( fp, 0, SEEK_SET );
	readfn( (void*)fpin, 1, filelen, (void*)fp );

//--------------------------------------------------------------
#if MEM_RECORD
	mem_con_init( PNG_MEM_ID );//ڴ
#endif

	if(LoadPNG( NULL )==False)
	{
    return -1;
  }
	ret = png_read2( pwidth, pheight, image_data, bgcolor );

#if MEM_RECORD
	mem_con_free( png_sfree2, PNG_MEM_ID  );//ڴ
#endif

	return ret;
}
