/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */
#include <string.h>
#include "config.h"
#include <MemMgr.h>
#include <Macro.h>
#include <datatype.h>
#include <ctype.h>
#include <unistd.h>
#include <string.h>
#include "display.h"
#include "win.h"
#include "ctrl.h"
#include "fs.h"
#include "image.h"
#include "bookmark.h"
#include "conf.h"
#include "charsets.h"
#include "fat_ebook.h"
#include "text.h"
#include "bg.h"
#include "version.h"
#include "common/qsort.h"
#include "common/utils.h"
#include "scene_impl.h"

#include <mystring.h>
#include <msgbox.h>
#include <StyleSet.h>
#include <MainMenuSettings.h>
#include <ExitMessageBox.h>
#include <mmc_api.h>
#include <HelpMenu_FileBrowse.h>
#include <ds2io2.h>
#include <key.h>
#include <scene_text.h>
#include <ds2_timer.h>
#include <fs_api.h>
#include <language.h>
#include <DrvMemMgr.h>
#include <font.h>

#include <debugoff.h>

//------------------------------------------------------------------------
#define strnicmp strncasecmp

//------------------------------------------------------------------------
char appdir[PATH_MAX2];
dword drperpage, rowsperpage, pixelsperrow;
p_bookmark bm = NULL;
p_text fs = NULL;
t_conf config;
p_win_menuitem filelist = NULL, copylist = NULL, cutlist = NULL;
dword filecount = 0, copycount = 0, cutcount = 0;

#ifdef ENABLE_BG
BOOL repaintbg_main = true;
BOOL repaintbg_sub = true;
#endif
BOOL imgreading = false, locreading = false;
BOOL prx_loaded = false;
int locaval[10];
t_fonts fonts[5], bookfonts[21];
int fontcount = 0, fontindex = 0, bookfontcount = 0, bookfontindex = 0, ttfsize = 0;
int bookfontindex_cur = 0;
int offset = 0;


static int config_num = 0;

//-----------------------ȫֱ-------------------------------
extern BOOL use_prx_power_save;
extern BOOL img_needrf, img_needrp, img_needrc;
extern pixel * bufferMain;
extern pixel * bufferSub;
extern int menuwin_h;
extern int menuwin_w;

extern BOOL swap_infowin;


//---------------------------------------------------------------
//
//---------------------------------------------------------------
extern int stricmp(const char *s1,const char * s2);
extern int pdf_main( dword selidx );

//---------------------------------------------------------------
//---------------------ʼ----------------------------------
//---------------------------------------------------------------
BOOL scene_load_font( int Fontindex )
{
	char fontzipfile[PATH_MAX2], efontfile[PATH_MAX2], localfontfile[PATH_MAX2];

	fontindex = Fontindex;
	if (fontindex >= fontcount)
		fontindex = 0;
	config.fontsize = fonts[fontindex].size;
	STRCPY_S(fontzipfile, appdir);
	STRCAT_S(fontzipfile, "fonts.zip");
	SPRINTF_S(efontfile, "ASC%02d", config.fontsize);

#if USE_UNICODE_FONTLIB
	SPRINTF_S(localfontfile, "unicode%02d", config.fontsize);
#else
	if( config.cur_lang_index == LANG_INDEX_JP )
		SPRINTF_S(localfontfile, "SJIS%02d", config.fontsize);
	else if( config.cur_lang_index == LANG_INDEX_TW )
		SPRINTF_S(localfontfile, "BIG5_%02d", config.fontsize);
	else
		SPRINTF_S(localfontfile, "GBK%02d", config.fontsize);
#endif

	if (!disp_load_zipped_font(fontzipfile, efontfile, localfontfile))
	{
		SPRINTF_S(efontfile, "%sfonts/fonts_en/ASC%02d", appdir, config.fontsize);

#if USE_UNICODE_FONTLIB
		SPRINTF_S(localfontfile, "%sfonts/unicode%02d", appdir, config.fontsize);
#else
		if( config.cur_lang_index == LANG_INDEX_JP )
			SPRINTF_S(localfontfile, "%sfonts/fonts_jp/SJIS%02d", appdir, config.fontsize);
		else if( config.cur_lang_index == LANG_INDEX_TW )
			SPRINTF_S(localfontfile, "%sfonts/fonts_tw/BIG5_%02d", appdir, config.fontsize);
		else
			SPRINTF_S(localfontfile, "%sfonts/fonts_cn/GBK%02d", appdir, config.fontsize);
#endif

		if (!disp_load_font(efontfile, localfontfile))
		{
			return false;
		}
	}
	disp_set_fontsize(config.fontsize);
	return true;
}

BOOL scene_load_book_font( int bookfontidx )
{
	int bookfontsize;
//------------------------------------------------------------------------------
	char fontzipfile[PATH_MAX2], efontfile[PATH_MAX2], localfontfile[PATH_MAX2];
	BOOL loaded = true;//Сһһ಻Ҫټ

//------------------------------------------------------------------------------
	if (bookfontidx >= bookfontcount)
		bookfontidx = 0;

	bookfontindex_cur = bookfontidx;

	if (config.usettf)
		bookfontsize = ttfsize;
	else
	{
		config.bookfontsize = bookfonts[bookfontidx].size;
		bookfontsize = bookfonts[bookfontidx].size;

		if (bookfontsize == config.fontsize) //Сһһ಻Ҫټ
		{
			disp_assign_book_font();
			disp_set_book_fontsize(bookfontsize);
			if( bookfontsize == 10 )
				memset(disp_ewidth, (bookfontsize / 2) + 0, 0x80);//128ĸʾĿȣ趨ΪСһ
			else
				memset(disp_ewidth, bookfontsize / 2, 0x80);//128ĸʾĿȣ趨ΪСһ
			return true;
		}
	}
	loaded = false;//СһһҪټ

	if (!loaded)
	{
		STRCPY_S(fontzipfile, appdir);
		STRCAT_S(fontzipfile, "fonts.zip");
		SPRINTF_S(efontfile, "ASC%02d", config.bookfontsize);

#if USE_UNICODE_FONTLIB
		SPRINTF_S(localfontfile, "unicode%02d", config.bookfontsize);
#else
		if( config.cur_lang_index == LANG_INDEX_JP )
			SPRINTF_S(localfontfile, "SJIS%02d", config.bookfontsize);
		else if( config.cur_lang_index == LANG_INDEX_TW )
			SPRINTF_S(localfontfile, "BIG5_%02d", config.bookfontsize);
		else
			SPRINTF_S(localfontfile, "GBK%02d", config.bookfontsize);
#endif
		if (!disp_load_zipped_book_font(fontzipfile, efontfile, localfontfile))
		{
			SPRINTF_S(efontfile, "%sfonts/fonts_en/ASC%02d", appdir, config.bookfontsize);

#if USE_UNICODE_FONTLIB
			SPRINTF_S(localfontfile, "%sfonts/unicode%02d", appdir, config.bookfontsize);
#else
			if( config.cur_lang_index == LANG_INDEX_JP )
				SPRINTF_S(localfontfile, "%sfonts/fonts_jp/SJIS%02d", appdir, config.bookfontsize);
			else if( config.cur_lang_index == LANG_INDEX_TW )
				SPRINTF_S(localfontfile, "%sfonts/fonts_tw/BIG5_%02d", appdir, config.bookfontsize);
			else
				SPRINTF_S(localfontfile, "%sfonts/fonts_cn/GBK%02d", appdir, config.bookfontsize);
#endif

			if (!disp_load_book_font(efontfile, localfontfile))
			{
				return false;
			}
		}
		if( config.bookfontsize == 10 )
			memset(disp_ewidth, (config.bookfontsize / 2) + 0, 0x80);//128ĸʾĿȣ趨ΪСһ
		else
			memset(disp_ewidth, config.bookfontsize / 2, 0x80);//128ĸʾĿȣ趨ΪСһ
	}
	disp_set_book_fontsize(config.bookfontsize);
	return true;
}

int scene_get_book_fontsize( int bookfontidx )
{
	return bookfonts[bookfontidx].size;
}

static const char *GetFileExt(const char *filename)
{
	const char *strExt = strrchr(filename, '.');

	if (strExt == NULL)
		return "";
	else
		return strExt;
}

int scene_filelist_compare_ext(void *data1, void *data2)
{
	if (((p_win_menuitem) data1)->name == NULL
		|| ((p_win_menuitem) data2)->name == NULL) {
		return 0;
	}
	const char *fn1 = ((p_win_menuitem) data1)->name,
			   *fn2 = ((p_win_menuitem) data2)->name;
	int cmp = stricmp(GetFileExt(fn1), GetFileExt(fn2));

	if (cmp)
		return cmp;
	return stricmp(fn1, fn2);
}

int scene_filelist_compare_name( void *data1, void *data2 )
{
	if ( ((p_win_menuitem) data1)->name == NULL || ((p_win_menuitem) data2)->name == NULL )
	{
		return 0;
	}
	t_fs_filetype ft1 = (t_fs_filetype) ((p_win_menuitem) data1)->data, ft2 = (t_fs_filetype) ((p_win_menuitem) data2)->data;
	if (ft1 == fs_filetype_dir)
	{
		if (ft2 != fs_filetype_dir)
			return -1;
	}
	else if (ft2 == fs_filetype_dir)
		return 1;
	return stricmp( ((p_win_menuitem) data1)->name, ((p_win_menuitem) data2)->name );
}

int scene_filelist_compare_size(void *data1, void *data2)
{
	t_fs_filetype ft1 = (t_fs_filetype) ((p_win_menuitem) data1)->data, ft2 =
		(t_fs_filetype) ((p_win_menuitem) data2)->data;
	if (ft1 == fs_filetype_dir) {
		if (ft2 != fs_filetype_dir)
			return -1;
	} else if (ft2 == fs_filetype_dir)
		return 1;
	return (int) ((p_win_menuitem) data1)->data3 -
		(int) ((p_win_menuitem) data2)->data3;
}

int scene_filelist_compare_ctime(void *data1, void *data2)
{
	t_fs_filetype ft1 = (t_fs_filetype) ((p_win_menuitem) data1)->data, ft2 =
		(t_fs_filetype) ((p_win_menuitem) data2)->data;
	if (ft1 == fs_filetype_dir) {
		if (ft2 != fs_filetype_dir)
			return -1;
	} else if (ft2 == fs_filetype_dir)
		return 1;
	return (((int) ((p_win_menuitem) data1)->data2[0]) << 16) +
		(int) ((p_win_menuitem) data1)->data2[1] -
		((((int) ((p_win_menuitem) data2)->data2[0]) << 16) +
		 (int) ((p_win_menuitem) data2)->data2[1]);
}

int scene_filelist_compare_mtime(void *data1, void *data2)
{
	t_fs_filetype ft1 = (t_fs_filetype) ((p_win_menuitem) data1)->data, ft2 =
		(t_fs_filetype) ((p_win_menuitem) data2)->data;
	if (ft1 == fs_filetype_dir) {
		if (ft2 != fs_filetype_dir)
			return -1;
	} else if (ft2 == fs_filetype_dir)
		return 1;
	return (((int) ((p_win_menuitem) data1)->data2[2]) << 16) +
		(int) ((p_win_menuitem) data1)->data2[3] -
		((((int) ((p_win_menuitem) data2)->data2[2]) << 16) +
		 (int) ((p_win_menuitem) data2)->data2[3]);
}

qsort_compare compare_func[] =
{
	scene_filelist_compare_ext,
	scene_filelist_compare_name,
	scene_filelist_compare_size,
	scene_filelist_compare_ctime,
	scene_filelist_compare_mtime
};

/*static*/
void recalcSize( dword * drperpage, dword * rowsperpage, dword * pixelsperrow )
{
	int borderspace_x_w;
	int borderspace_y_w;
	int t = config.vertread;

	if (t >= 3)
		t = 0;

	if( t )//
	{
		borderspace_x_w = config.edge_distance_y << 1;
		borderspace_y_w = config.borderspace << 1;
	}
	else //
	{
		borderspace_x_w = config.borderspace << 1;
		borderspace_y_w = config.edge_distance_y << 1;
	}

	*drperpage = ( (t ? SCREEN_W : SCREEN_H) - borderspace_x_w + DISP_BOOK_FONTSIZE * 2 - 2 ) /
				   (config.rowspace + DISP_BOOK_FONTSIZE);

	*rowsperpage = ( (t ? SCREEN_W : SCREEN_H) -
					 (config.infobar != conf_infobar_none ? DISP_BOOK_FONTSIZE : 0) -
					 borderspace_y_w + config.rowspace) /
					(config.rowspace + DISP_BOOK_FONTSIZE);

	*pixelsperrow = (t ? (config.scrollbar ? (SCREEN_H-3) : SCREEN_H) : (config.scrollbar ? (SCREEN_W-5) : SCREEN_W)) - borderspace_x_w;


	*drperpage -= 1; //һҳļʾһһڴ쳣

	if( t ){ //
	}
	else//
	{
		int h = ( SCREEN_H - *rowsperpage * ( DISP_BOOK_FONTSIZE + config.rowspace ) + config.rowspace );
		if( h == 1 )
		{
			TopMargin = 1;
			BottomMargin = 0;
		}
		else if( h == 2 )
		{
			TopMargin = 1;
			BottomMargin = 1;
		}
		else
		{
			BottomMargin = h >> 1;
			TopMargin = h - BottomMargin;
		}
		if( TopMargin >= DISP_BOOK_FONTSIZE )
			TopMargin = 0;

		if( BottomMargin >= DISP_BOOK_FONTSIZE )
			BottomMargin = 0;
	}
}

t_win_menu_op scene_filelist_menucb( KEY_BUF inputkey, p_win_menuitem item, dword * count, dword max_item_num, dword * topindex, dword * index )
{
	int i, result;
	t_win_menu_op op = win_menu_op_continue;
	AJUST_KEY_BUF AjustKey;
	dword key = inputkey.key;
	dword orgidx = * index;;

	if( (key & (~(KEY_X|KEY_Y|KEY_SELECT|KEY_START|KEY_B|KEY_L|KEY_R|KEY_TOUCH))) != 0 )
	{
		op = win_menu_defcb( key, item, count, max_item_num, topindex, index);
	}
	else
	{
		switch( key )
		{
			case KEY_X: //֧ ѡУ˳ Ŀ¼  ɾ  
				return win_menu_op_continue;
			case KEY_Y:
				return win_menu_op_continue;
			case KEY_SELECT:
				HelpMenuDisplay_FileBrowse();
				return win_menu_op_continue;
			case KEY_START:
				return win_menu_op_continue;

			case KEY_B: //B˵һ㣬ػ,ѾϲĿ¼ʲôҲ
			{
			  	if( stricmp( config.Upath, CONFIG_ROOTDIR ) == 0 )
			  	{
			  		//
					if( ExitMessage() )
						scene_exit();
			  		return win_menu_op_force_redraw;
			  	}
				else if( *index != 0 /*|| stricmp( config.path, CONFIG_ROOTDIR ) == 0*/ )
				{
					*index = 0;
					ctrl_waitrelease( key );
					return win_menu_op_force_redraw;
				}
				else
				{
					ctrl_waitrelease( key );
					return win_menu_op_back;
				}
			}
			case KEY_L:
				if( config.CategoryFlag == 0 )
					 config.CategoryFlag = 2;
				else
					config.CategoryFlag--;
				return win_menu_op_force_redraw_bg;
			case KEY_R:
				if( config.CategoryFlag >= 2 )
					 config.CategoryFlag = 0;
				else
					config.CategoryFlag++;
				return win_menu_op_force_redraw_bg;

			case KEY_TOUCH:
			{
				dword idx;

				//
				AjustKey.Min_x = FL_SLIDE_X - 10;
				AjustKey.Max_x = SCREEN_W - 1;

				AjustKey.Min_y = FL_SLIDE_Y - 5;
				AjustKey.Max_y = FL_SLIDE_MAX_Y + FL_SLIDE_H + 5;
				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					if( inputkey.y < FL_SLIDE_Y )
						inputkey.y = FL_SLIDE_Y;
					else if( inputkey.y > FL_SLIDE_MAX_Y )
						inputkey.y = FL_SLIDE_MAX_Y;
					idx = ( inputkey.y -  FL_SLIDE_Y ) * (*count - 1) / (FL_SLIDE_MAX_Y - FL_SLIDE_Y);
					if( idx >= *count )
						idx = *count - 1;
					*index = idx;
					op = win_menu_op_force_redraw;
					goto _PROCESS_NEXT;
				}
				//жǷ˷ѡ
				for( i = 0; i < 3; i++ )//0ȫ; 1; 2ͼƬ
				{
					AjustKey.Min_x = FL_CATEGORY_X0 + ( FL_CATEGORY_W + FL_CATEGORY_BANK ) * i;
					AjustKey.Max_x = AjustKey.Min_x + FL_CATEGORY_W;

					AjustKey.Min_y = FL_CATEGORY_Y;
					AjustKey.Max_y = FL_CATEGORY_Y + FL_CATEGORY_H;

					result = CheckValidxy( AjustKey, inputkey );
					if( result == 0 )
					{
						if( config.CategoryFlag != i )
					 	{
					 		config.CategoryFlag = i;
					 		return win_menu_op_force_redraw_bg;
					 	}
					 	else
					 	{
					 		break;
					 	}
					}
				}
				break;
			}
		}
	}
_PROCESS_NEXT:

	if( (*index != orgidx && *index - *topindex > max_item_num ) )
	{
		return win_menu_op_force_redraw;
	}
	return op;
}

void scene_filelist_predraw( void )
{
//---------------------ֲ-----------------------------
	char showDir[STR_DEFAULT_LEN];
	U8 *pos;
	dword w;
	bool IsCN = false;
	int x;

//--------------------------------------------------------------
#ifdef ENABLE_BG
	if (repaintbg_main)
	{
		bg_display( DOWN_SCREEN ); //ʾڳʼʱѾ
		repaintbg_main = false;
	}

	if ( repaintbg_sub )
	{
		bg_display( UP_SCREEN ); //ʾڳʼʱѾ
		repaintbg_sub = false;
	}

#endif

	//ǰĿ¼(·)
	showDir[0] = '\0';
//	STRCAT_S( showDir, "mmc" );//ñ䣬ʾ

#if USE_UNICODE_FONTLIB
	utf8_to_ucs( (const byte*)showDir, STR_DEFAULT_LEN, (const byte*)(config.Upath + 5), INVALID_LEN );
#else
//	STRCAT_S( showDir, config.path + 5 );//4fat1:ĳ
#endif

	x = FL_CATALOG_FONT_X;//FILE_DIR_X

	pos = (U8*)showDir;
	w = x + DISP_FONTSIZE * 2;
	while( *pos != 0 )
	{
		if( w > SCREEN_W )//һ߶ֽڵĿ
		{
			if( IsCN )//
			{
				pos -= 2;
			}
			else
			{
				pos--;
			}
			*pos++ = '.';
			*pos++ = '.';
			*pos++ = CONFIG_DIR_SEPERATOR;
			*pos = 0;
			break;
		}
		if ( *(pos) > 0x80 )
		{
			w += DISP_FONTSIZE;
			pos += 2;
			IsCN = true;
		}
		else
		{
			w += DISP_FONTSIZE / 2;
			pos++;
			IsCN = false;
		}
	}

	CB_putnstringhorz_sys( x, FILE_DIR_Y, 0, (const byte *)showDir, INVALID_LEN, FL_DIR_FONT_COLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
}

void scene_filelist_postdraw(p_win_menuitem item, dword index, dword topindex,  dword botindex)
{
	return;
}

void scene_filelist()
{
	dword idx = 0;

	where = scene_in_dir;
	if( /*strlen(config.shortpath) == 0 || strlen(config.path) == 0 || */strlen(config.Upath) == 0 )
	{
//		STRCPY_S( config.path, CONFIG_ROOTDIR );
		STRCPY_S( config.Upath, CONFIG_ROOTDIR );
//		STRCPY_S( config.shortpath, CONFIG_ROOTDIR );
	}

	dword plen = strlen(config.Upath);
	if (plen > 0 && config.Upath[plen - 1] == '/')//ִ
	{
		filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown );
	}
	else
	{
		switch ( fs_file_get_type(config.Upath) )
		{
			case fs_filetype_zip:
				{
					where = scene_in_zip;
					filecount =
						fs_zip_to_menu( config.Upath, &filelist );
					break;
				}
			case fs_filetype_chm:
			case fs_filetype_rar:
				break;
			default:
//				STRCPY_S(config.path, CONFIG_ROOTDIR);
				STRCPY_S(config.Upath, CONFIG_ROOTDIR);
//				STRCPY_S(config.shortpath, CONFIG_ROOTDIR);
				filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown);
				break;
		}
	}
	if ( filecount == 0 )
	{
//		STRCPY_S(config.path, CONFIG_ROOTDIR);
		STRCPY_S(config.Upath, CONFIG_ROOTDIR);
//		STRCPY_S(config.shortpath, CONFIG_ROOTDIR);

		filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown);
	}

	quicksort( filelist,
			  (filecount > 0 && filelist[0].name[0] == '.') ? 1 : 0,
			  filecount - 1,
			  sizeof(t_win_menuitem), compare_func[(int) config.arrange] );
	while (idx < filecount && stricmp(filelist[idx].Uname, config.lastfile) != 0)
	{
		idx++;
	}
	if (idx >= filecount)
	{
		config.isreading = false;
		idx = 0;
	}

	config.isreading = false; //2010-5-17 15:55:19 by LHM

	while (1)
	{
		if (!config.isreading && !locreading)//صǰĶļ load current reading
		{
			if (filelist == 0 || filecount == 0)
			{
				// empty directory ?
				while( !(Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
				scene_exit();
				while( 1 );
			}
			else
			{
				idx =
						win_menu( FL_LINE_FONT_START_X,
							   	 FL_LINE_FONT_START_Y, WRR,
								 HRR, filelist, filecount, idx, 0,
								 config.menubcolor, false, scene_filelist_predraw,
								 scene_filelist_postdraw,
								 scene_filelist_menucb);
			}
		}
		else
		{
			config.isreading = false;
			locreading = false;
		}

		if (idx == INVALID)
		{
			switch (where)
			{
				case scene_in_zip:
					filecount =
						fs_zip_to_menu( config.Upath, &filelist );
					break;
				case scene_in_chm:
					break;
				case scene_in_rar:
					break;
				default:
					filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown );
			}
			if (filelist == 0)
			{
//				STRCPY_S(config.path, CONFIG_ROOTDIR);
				STRCPY_S(config.Upath, CONFIG_ROOTDIR);
//				STRCPY_S(config.shortpath, CONFIG_ROOTDIR);
				filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown );
			}
			quicksort(filelist, (filecount > 0 && filelist[0].name[0] == '.') ? 1 : 0,
					  filecount - 1, sizeof(t_win_menuitem),
					  compare_func[(int) config.arrange]);
			idx = 0;
			while ( idx < filecount && stricmp(filelist[idx].Uname, config.lastfile) != 0 )
				idx++;
			if (idx >= filecount)
			{
				config.isreading = false;
				idx = 0;
			}
			continue;
		}
		switch ( (t_fs_filetype) filelist[idx].data )
		{
			{
			case fs_filetype_prog:
				break;
			case fs_filetype_dir:
			{
				char pdir[PATH_MAX2];
				BOOL isup = false;
				U16 *dest = 0;

				pdir[0] = 0;
				if( filelist[idx].Uname[0] == '.' && filelist[idx].Uname[1] == '.' )
				{
					if (where == scene_in_dir)
					{
						int ll;

						if ((ll = strlen(config.Upath) - 1) >= 0)
						{
							while( config.Upath[ll] == CONFIG_DIR_SEPERATOR && ll >= 0 )
							{
								config.Upath[ll] = 0;
								ll--;
							}
						}
					}
					char *lps;

					isup = true;
					if ((lps = strrchr(config.Upath, CONFIG_DIR_SEPERATOR)) != NULL)
					{
						lps++;
						STRCPY_S(pdir, lps);
						*lps = 0;

//						dest = (U16*)memalign( 2, PATH_MAX2 );
//						if( dest )
//						{
//							utf8_ucs2( config.Upath, dest );
//		  					charsets_ucs_conv( (const unsigned char*)dest, (byte*)config.path );//unicode to gbk
//		  					free( dest );
//						}
					}
					else
						config.Upath[0] = 0;

				}
				else if (where == scene_in_dir)//update display path
				{
					STRCAT_S(config.Upath, filelist[idx].Uname);//ļʾʹõ·(UTF8)
					STRCAT_S( config.Upath, CONFIG_DIR_SEPERATORS );
				}

				if (config.Upath[0] == 0) //Ѿ˸Ŀ¼ˣ
				{
				}
				else if (strnicmp( config.Upath, CONFIG_ROOTDIR, 5 ) == 0)
				{
					filecount = fs_dir_to_menu( config.Upath, &filelist, config.showhidden, config.showunknown );
				}
				else
				{
				}
				quicksort(filelist,
						  (filecount > 0 && filelist[0].name[0] == '.') ? 1 : 0,
						  filecount - 1, sizeof(t_win_menuitem),
						  compare_func[(int) config.arrange]);
				if (isup)//ǷҪ is update
				{
					for ( idx = 0; idx < filecount; idx++ )//һѡļ,Ϊεĵǰָԭʼѡ״̬
					{
						if (stricmp(filelist[idx].Uname, pdir) == 0)
						{
							break;
						}
					}
					if (idx == filecount)
					{
						idx = 0;
					}
				}
				else
					idx = 0;
				where = scene_in_dir;
				break;
			}
			case fs_filetype_gz:
				break;
			case fs_filetype_zip:
			{
				where = scene_in_zip;

//				STRCPY_S( config.shortpath, config.path );
				STRCAT_S(config.Upath, filelist[idx].Uname);

//				STRCAT_S( config.path, filelist[idx].name );
//				STRCAT_S( config.path, CONFIG_DIR_SEPERATORS );

				idx = 0;
				filecount =
					fs_zip_to_menu( config.Upath, &filelist );

				quicksort(filelist,
						  (filecount > 0 && filelist[0].name[0] == '.') ? 1 : 0,
						  filecount - 1, sizeof(t_win_menuitem),
						  compare_func[(int) config.arrange]);

				break;
			}
			case fs_filetype_chm:
			case fs_filetype_rar:
				break;

#ifdef ENABLE_IMAGE
{
			case fs_filetype_png:
				config.isreading = true;
				idx = scene_readimage(idx);
				config.isreading = false;
				repaintbg_sub = true;
				break;
			case fs_filetype_gif:
				config.isreading = true;
				idx = scene_readimage(idx);
				config.isreading = false;
				repaintbg_sub = true;
				break;
			case fs_filetype_jpg:
				config.isreading = true;
				idx = scene_readimage(idx);
				config.isreading = false;
				repaintbg_sub = true;
				break;
			case fs_filetype_bmp:
				config.isreading = true;
				idx = scene_readimage(idx);

				config.isreading = false;
				repaintbg_sub = true;
				break;
			case fs_filetype_tif:
				config.isreading = true;
				idx = scene_readimage(idx);
				config.isreading = false;
				repaintbg_sub = true;
				break;
}
#endif
			case fs_filetype_ebm:
				break;

#if ENABLE_PDF
			case fs_filetype_pdf:
			{
				char filename[256];

				STRCPY_S( filename, config.Upath );
				STRCAT_S( filename, filelist[idx].name );

				idx = pdf_main( idx );
				repaintbg_sub = true;
			}
			break;
#endif
			}
			case fs_filetype_html:
			case fs_filetype_txt:
				config.isreading = true;
				idx = scene_readbook(idx);
				config.isreading = false;
				repaintbg_sub = true;

				break;

			default:
				config.isreading = false;
				locreading = false;

				break;

		}//switch ((t_fs_filetype) filelist[idx].data)
	} //while (1)
	if (filelist != NULL)
	{
		free((void *) filelist);
		filelist = NULL;
		filecount = 0;
	}
}

int scene_hw_init( void )
{
	int result = -1;
	result = GDIInit();
	if( result < 0 )
		goto err_exit;
	disp_init();//GDIInit()֮

	return 0;
err_exit:
	return -1;
}

extern void scene_init()
{
	int result = -1;
	result = scene_hw_init();
	if( result < 0 )
	{
		scene_exit();
		return;
	}

	pixel *imgdata = 0;
	dword width, height;
	pixel bgc;
	pixel *Vram = GetVram( UP_SCREEN );

	//Loading LOGO
	result = image_read_sys( CONFIG_IREADERLOADING, fs_file_get_type( CONFIG_IREADERLOADING ), &width, &height, &imgdata, &bgc );
	if( result == 0 )
	{
		bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, MAINMENU_BG_X, MAINMENU_BG_Y );
		free((void *) imgdata);
		imgdata = NULL;
	}
	Vram = GetVram( DOWN_SCREEN );//Ϊ
	memcpyword( Vram, COLOR_BLACK, SCREEN_W * SCREEN_H );
	Flush( DUAL_SCREEN );

	appdir[0] = '\0';
	STRCAT_S( appdir, CONFIG_EBOOK_ROOTDIR );

	char conffile[PATH_MAX2], bmfile[PATH_MAX2];

//	STRCPY_S(config.path, CONFIG_ROOTDIR);
	STRCPY_S(config.Upath, CONFIG_ROOTDIR);
//	STRCPY_S(config.shortpath, CONFIG_ROOTDIR);
	STRCPY_S(conffile, appdir);
	char conffilename[80];

	SPRINTF_S(conffilename, "%s%d%s", "config", config_num, ".ini");

	STRCAT_S(conffile, conffilename);
	conf_set_file(conffile);//ļ
	conf_load( &config );
#if 1
//	config.cur_lang_index = LANG_INDEX_JP;//
	ProcFont_CallBackInit();
#if 0
	switch( config.cur_lang_index )//Ժָ
	{
		case LANG_INDEX_JP:
			ProcFontjp_SetCallBack( SJIS );
			break;

		case LANG_INDEX_TW:
			ProcFonttw_SetCallBack( BIG5 );
			break;

		default:
			ProcFontcn_SetCallBack();
			break;
	}
#else
	result = ProcFontUcs2_SetCallBack( conf_encode_ucs );
	if( result == false )
	{
		while( !(Proc_GetKey( CONFIG_KEY_REPEAT_TIME_N )) );
		scene_exit();
		while( 1 );
	}
#endif
#endif
	ds2_setBrightness( config.brightness );

//---------ֿ-----------------------
	fontlib_load( appdir );//ֿ

	recalcSize(&drperpage, &rowsperpage, &pixelsperrow);

	STRCPY_S(bmfile, appdir);
	STRCAT_S(bmfile, CONFIG_EBOOK_BM_NAME );
	
	bookmark_init(bmfile);//ñǩļ
	disp_init();
	
	language_load_utf8();//Լ
	bg_load();

	scene_filelist();
}

extern void scene_exit()
{
	TA();
	ds2_plug_exit();
}
