/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#ifndef _SCENE_H_
#define _SCENE_H_

#include "common/datatype.h"
#include "win.h"
#include "conf.h"
#include "text.h"

enum
{
	scene_in_dir = 0,
	scene_in_zip,
	scene_in_chm,
	scene_in_rar
} where;

typedef struct
{
	int size;
	BOOL zipped;
} t_fonts;


extern BOOL repaintbg_main;
extern t_conf config;
extern p_win_menuitem filelist;
extern p_text fs;
extern int fontcount, fontindex, bookfontcount, bookfontindex, bookfontindex_cur, ttfsize;
extern t_fonts fonts[5], bookfonts[21];
extern dword drperpage, rowsperpage, pixelsperrow;
extern dword filecount;
extern BOOL repaintbg_sub;

extern void scene_init();
extern void scene_exit();
BOOL scene_load_book_font( int Bookfontindex );
BOOL scene_load_font( int Fontindex );
extern void scene_power_save(BOOL save);
extern void scene_exception();
extern const char *scene_appdir();

extern  void recalcSize( dword * drperpage, dword * rowsperpage, dword * pixelsperrow );

extern t_win_menu_op scene_filelist_menucb( KEY_BUF inputkey, p_win_menuitem item, dword * count, dword max_item_num, dword * topindex, dword * index );

extern int scene_get_book_fontsize( int bookfontidx );
extern void scene_filelist_predraw( void );



#endif
