/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ds2_timer.h>
#include "display.h"
#include "win.h"
#include "ctrl.h"
#include "fs.h"
#include "image.h"
#include "bookmark.h"
#include "conf.h"
#include "charsets.h"
#include "fat_ebook.h"

#include "text.h"
#include "bg.h"
#include "common/utils.h"
#include "scene_impl.h"

#include <gdi.h>
#include <plug_jpeg.h>
#include "scene_image.h"
#include <HelpMenu_Picture.h>
#include <msgbox.h>
#include <Macro.h>
#include <config_ebook.h>
#include <DrvMemMgr.h>
#include <MainMenuSettings.h>
#include <language.h>
#include <fs_api.h>
#include <key.h>
#include <debugoff.h>

#define		SCALE_T			1000

#ifdef ENABLE_IMAGE

extern bool ViewJpegZipFlag;
bool ImageViewFlag = false;

dword w_org_r, h_org_r, w2 = 0, h2 = 0;//w_org_r, h_org_r:ԭʼ(ת); w2,h2:ŴĿ(ת)
dword w_org,h_org,w2_org,h2_org;//w_org, h_org:ԭʼ(ת); w2_org,h2_org:ŴĿ(ת)
dword thumbw = 0, thumbh = 0, paintleft = 0, painttop = 0;// thumbw,thumbh:ͼ paintleft,painttop: ͼʱĻԭλ

int w2_old, h2_old;

RECT thumbR;//ͼؾβ
RECT thumbSR;//ͼѡؾβ
static bool thumbimg_needup = true;
bool Thumbimg_Needzoom = false;

static pixel *Gimgdata = NULL;
pixel *imgshow = NULL;//Gimgdataԭʼ
pixel Bgcolor = 0, thumbimg[CONFIG_THUMBW * CONFIG_THUMBH];
pixel *pThumbimgV = NULL;

dword oldangle = 0;
char imgFileName[PATH_MAX2];
int curtop = 0, curleft = 0, xpos = 0, ypos = 0;
BOOL img_needrf = true, img_needrc = true, img_needrp = true;
static BOOL showinfo = false, thumb = false;

static volatile int secticks = 0;
static int load_image_count = 0;//ͼƬǷΪμ
static int load_image_count2 = 0;//ͼƬǷΪμ
static U32 scale_old = 0;
//static t_conf_rotate rotate_old;
static BOOL rotateFlag = false;

static BOOL needp_mainbg = true;
static BOOL needp_infobg = true;

int ImgFunKeyStatus = 0;

U16 neepr_oplogo = 0;//ǷҪͼƬ 0:ҪÿһλӦĸͼƬ
U16 neepr_oplogo2 = 0;//ǷҪͼƬ 0:ҪÿһλӦĸͼƬ
pixel *opLogoBuf[OPLOGO_COUNT]; //ָ飺0Ŵ 1С 2ʱ 3˳ʱ
pixel *opLogoBuf2[OPLOGO_COUNT]; //ָ飺0Ŵ 1С 2ʱ 3˳ʱ
const POS PrevNext[2] = { { 7, 51  }, { 222, 51 } };
pixel *imgTitleBarbuf = NULL;

U32 imgSize = 0;
static t_fs_filetype imgfiletype = 0;


int imgscaleNameId = 0;
const char imgscaleName[2][16] = {
	CONFIG_DIR_IMAGESCALE_BUF,
	CONFIG_DIR_IMAGESCALE_R_BUF,
};


const char oplogoname[OPLOGO_COUNT][10] = {
		"PrevImage",
		"NextImage",
		"ZoomIn",
		"ZoomOut",
		"RotationL",
		"RotationR",
	};

//--------------------------------ȫֱ-----------------------------------
extern BOOL repaintbg_sub;

//--------------------------------ȫֺ-----------------------------------

//----------------------------------------------------------------------------
FILE *fopen_imgSwapfile( const char * mode )
{
	char imgdat_name[IMGDAT_NAME_LEN];
	STRCPY_S( imgdat_name, CONFIG_EBOOK_ROOTDIR );
	STRCAT_S( imgdat_name, CONFIG_DIR_IMAGESRC_BUF );
	FILE *fp_imgsrc = fopen( imgdat_name, mode );
	return fp_imgsrc;
}

FILE *fopen_imgZipSwapfile( const char *path, const char * mode )
{
	char imgdat_name[IMGDAT_NAME_LEN];
	STRCPY_S( imgdat_name, CONFIG_EBOOK_ROOTDIR );
	STRCAT_S( imgdat_name, path );
	STRCPY_S( imgFileName, imgdat_name );//
	FILE *fp_imgsrc = fopen( imgdat_name, mode );
	return fp_imgsrc;
}

pixel *image_getthumbbuffer()
{
	return thumbimg;
}

void image_GetZoomwh( int width, int height, int *zoom_w, int *zoom_h  )//width/height:ԭʼ *zoom_w/*zoom_h:ת
{
	int w,h;
	w = width * config.scale / 100;
	h = height * config.scale / 100;
	if( config.rotate & 0x1 )
	{
		*zoom_w = h;
		*zoom_h = w;
	}
	else
	{
		*zoom_w = w;
		*zoom_h = h;
	}
}

int open_image(dword selidx)
{
	int result = -1;

	ImageViewFlag = true;
	Thumbimg_Needzoom = false;

	config.rotate = conf_rotate_0;

	if( Gimgdata )
	{
		free( Gimgdata );
		Gimgdata = NULL;
	}

	result = image_open_archive( imgFileName, config.Upath, imgfiletype, &w_org, &h_org, &Gimgdata, &Bgcolor, where );//imgFileName,where: ȫֱ

	w_org_r = w_org;
	h_org_r = h_org;

	imgscaleNameId = 0;
	ImageViewFlag = false;

	return result;
}

void reset_image_ptr(void)//ͷimgshowimgdataÿ
{
	return;
}

void report_image_error( int error_event, int status )
{
	char infomsg[128];
	const char *erreventstr;
	const char *errstr;

	switch( error_event )
	{
		case EVENT_LOAD:
			erreventstr = lang_item[LANG_IMG_LOAD_FAIL_ID];//"ͼ޷װ, ԭ: %s"
			break;

		case EVENT_ZOOM:
			erreventstr = lang_item[LANG_IMG_ZOOM_FAIL_ID];//"ͼ޷Ŵ, ԭ: %s"
			break;

		case EVENT_ROTATE:
			erreventstr = lang_item[LANG_IMG_ROTATE_FAIL_ID];//"ͼ޷ת, ԭ: %s"
			break;

		default:
			return;
	}

	switch (status) {
		case ERR_FORMAT:
		case ERR_FORMAT_NOT_SUPPORTED:
			errstr = lang_item[LANG_WFORMAT_ID];//"ʽ"
			break;

		case ERR_MEM_INVALID:
		case ERR_MEM_LACK:
			errstr = lang_item[LANG_MEMLACK_ID];//"ڴ治"
			break;

		case ERR_FILE_OPEN:
			errstr = lang_item[LANG_ERRFILEOPEN_ID];//"ļ򿪴"
			break;

		case ERR_FILE_RW:
			errstr = lang_item[LANG_ERRFILERW_ID];//"ļд"
			break;

		case ERR_UNKNOWN:
		case ERR_OTHER:
		default:
			errstr = lang_item[LANG_UNKNOWN_REASON_ID];//""
			break;
	}


	STRCPY_S( infomsg, erreventstr );

	if( config.cur_lang_index == LANG_INDEX_CN )
		STRCAT_S( infomsg, "" );
	else
		STRCAT_S( infomsg, "," );

	STRCAT_S( infomsg, lang_item[LANG_IMG_FAIL_REASON_ID] );
	STRCAT_S( infomsg, errstr );

	DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char*)infomsg, DOWN_SCREEN, MB_OK | MB_CANCEL, TRUE );

	if( error_event == EVENT_LOAD )
	{
		imgreading = false;
		reset_image_ptr();
	}
}

// TODO: use GU to improve speed...
void recalc_brightness()
{
	return;//ʱ
}

int scene_reloadimage(dword selidx)
{
	reset_image_ptr();
	if (where == scene_in_zip || where == scene_in_chm || where == scene_in_rar)
	{
		STRCPY_S( imgFileName, filelist[selidx].Uname );
	}
	else
	{
		STRCPY_S(imgFileName, config.Upath);
		STRCAT_S(imgFileName, filelist[selidx].Uname );
	}
	int result = open_image( selidx );
	if (result != 0)
	{
		report_image_error( EVENT_LOAD, result);
		return -1;
	}
	if (config.imgbrightness != 100)
	{
		recalc_brightness();
	}
	STRCPY_S( config.lastfile, filelist[selidx].Uname );
	oldangle = 0;

	curtop = 0;//2009-8-29 12:00:13
	curleft = 0;//2009-8-29 12:00:13

	return 0;
}

void GetZoomPara( dword width, dword height, dword *zoom_w, dword *zoom_h )//width/heightΪԭʼȣzoom_w/zoom_hΪת
{
	dword w2 = *zoom_w;
	dword h2 = *zoom_h;

	if( ((dword)config.rotate & 0x1) )
	{
		ExchangeValue( (int*)&width, (int*)&height );
	}
	{
		if (config.fit > 0 && (config.fit != conf_fit_custom || config.scale != 100))
		{
			if (config.fit == conf_fit_custom)
			{
				if( config.scale > ZOOMIN_MAX )
					config.scale = ZOOMIN_MAX;
				w2 = width * config.scale / 100;
				h2 = height * config.scale / 100;
			}
			else if (config.fit == conf_fit_width)//Ӧ
			{
				config.scale = 100 * SCREEN_W / width;
				if (config.scale > ZOOM_LEVEL_200)
					config.scale = (config.scale / ZOOM_STEP_100) * ZOOM_STEP_100;
				else if (config.scale > ZOOM_LEVEL_100)
					config.scale = (config.scale / ZOOM_STEP_50) * ZOOM_STEP_50;
				else
				{
					config.scale = (config.scale / ZOOM_LEVEL_25) * ZOOM_LEVEL_25;
					if (config.scale < ZOOMIN_MIN)
						config.scale = ZOOMIN_MIN;
				}

				w2 = SCREEN_W;
				h2 = height * SCREEN_W / width;
			}
			else//Ӧ߶
			{
				config.scale = 100 * SCREEN_H / height;
				if (config.scale > ZOOM_LEVEL_200)
					config.scale = (config.scale / ZOOM_STEP_100) * ZOOM_STEP_100;
				else if (config.scale > ZOOM_LEVEL_100)
					config.scale = (config.scale / ZOOM_STEP_50) * ZOOM_STEP_50;
				else
				{
					config.scale = (config.scale / ZOOM_LEVEL_25) * ZOOM_LEVEL_25;
					if (config.scale < ZOOMIN_MIN)
						config.scale = ZOOMIN_MIN;
				}

				h2 = SCREEN_H;
				w2 = width * SCREEN_H / height;
			}
		}
		else
		{
			config.scale = 100;
			w2 = width;
			h2 = height;
		}
	//-----------------------------------------------------
	}
	*zoom_w = w2;
	*zoom_h = h2;
}

dword scene_rotateimage( int selidx )
{
	w2_old = w2;
	h2_old = h2;

	image_rotate( &w_org_r, &h_org_r, oldangle, (dword) config.rotate * 90 );

	oldangle = (dword) config.rotate * 90;
	GetZoomPara( w_org, h_org, &w2, &h2 );
	GetImagePos( &curleft, &curtop, w2, h2 );

	//-----------------------------ͼ-------------------------------
	if( thumbimg_needup == true )
	{
		thumbimg_needup = false;
		GetThumbwh( &thumbw, &thumbh, w_org, h_org, config.rotate );

		if( imgfiletype != fs_filetype_jpg )
		{
			if( load_image_count > 0 || Thumbimg_Needzoom == true )
			{
				if( Gimgdata )//from buffer
				{
					image_zoom_bilinear_FromBufferToBuffer( w_org, h_org, thumbimg, thumbw, thumbh, config.rotate, Gimgdata );
				}
				else//from file
				{
					image_zoom_bilinear_FromFileToBuffer( w_org, h_org, thumbimg, thumbw, thumbh, config.rotate );
				}
			}
			else
			{
				load_image_count++;
			}
		}
		else
		{
			if( load_image_count > 0 ){
			}
			else
			{
				load_image_count++;
			}
		}
	}
	return 0;
}

float get_text_len(const unsigned char *str)
{
	if (!str)
		return 0.0;

	float f = 0.0;

	while (*str != '\0') {
		if (*str >= 0x80 && *(str + 1) != '\0') {
			f++;
			str += 2;
		} else {
			f += 0.5;
			str++;
		}
	}
	return f;
}

void GetScreenPos( PAINT_RECT *rect, int zoom_w, int zoom_h )//zoom_w/zoom_h:w2/h2һתĿ
{
	if( zoom_w >= SCREEN_W )
	{
		rect->w = SCREEN_W;
		rect->paintleft = 0;
	}
	else
	{
		rect->w = zoom_w;
		rect->paintleft = ( SCREEN_W - zoom_w ) / 2;
	}

	if( zoom_h >= SCREEN_H )
	{
		rect->h = SCREEN_H;
		rect->painttop = 0;
	}
	else
	{
		rect->h = zoom_h;
		rect->painttop = ( SCREEN_H - zoom_h ) / 2;
	}
}

void GetImagePos( int *_curleft, int *_curtop, dword w2, dword h2 )
{
	if( load_image_count == 0 )
	{
		xpos = (int) config.viewpos % 3;
		ypos = (int) config.viewpos / 3;
		if (w2 <= SCREEN_W)
		{
			*_curleft = 0;
		}
		else
		{
			switch (xpos)
			{
				case 1:
					*_curleft = (w2 - SCREEN_W) / 2;
					break;
				case 2:
					*_curleft = w2 - SCREEN_W;
					break;
				default:
					*_curleft = 0;
					break;
			}
		}

		if (h2 <= SCREEN_H)
		{
			*_curtop = 0;
		}
		else
		{
			switch (ypos)
			{
				case 1:
					*_curtop = (h2 - SCREEN_H) / 2;
					break;
				case 2:
					*_curtop = h2 - SCREEN_H;
					break;
				default:
					*_curtop = 0;
					break;
			}
		}
	}
	else
	{
		int w,h;
		if( rotateFlag == false || (imgfiletype != fs_filetype_jpg) )
		{
			if( w2 > SCREEN_W )
			{
				if( w2_old <= SCREEN_W )
				{
					*_curleft = ( w2 - SCREEN_W ) >> 1;
				}
				else
				{
					w = ( *_curleft + SCREEN_W / 2 )  * config.scale / scale_old ;
					*_curleft = w - SCREEN_W / 2;
					if( *_curleft < 0 )
					{
						*_curleft = 0;
					}
					else if( *_curleft + SCREEN_W > w2 )
					{
						*_curleft = w2 - SCREEN_W;
					}
				}
			}
			else
			{
				*_curleft = 0;
			}
			if( h2 > SCREEN_H )
			{
				if( h2_old <= SCREEN_H )
				{
					*_curtop = ( h2 - SCREEN_H ) >> 1;
				}
				else
				{
					h = ( *_curtop + SCREEN_H / 2 ) *  config.scale / scale_old;
					*_curtop  = h - SCREEN_H / 2;
					if( *_curtop < 0 )
					{
						*_curtop = 0;
					}
					else if( *_curtop + SCREEN_H > h2 )
					{
						*_curtop = h2 - SCREEN_H;
					}
				}
			}
			else
			{
				*_curtop = 0;
			}
		}
		else
		{
			*_curleft = 0;
			*_curtop = 0;
		}
	}

	if( scale_old != config.scale )
		scale_old = config.scale;
}
void GetThumbwh( dword *_thumbw, dword *_thumbh, dword width, dword height, t_conf_rotate rotate )//width/height:ԭʼ(ת), 봦תĿ
{
	if( rotate & 0x1 )
	{
		ExchangeValue( (int*)&width, (int*)&height );
	}
//-----------------------------ͼ-------------------------------
	if( width > CONFIG_THUMBW && height > CONFIG_THUMBH )
	{
		if( CONFIG_THUMBW * height < CONFIG_THUMBH * width )
		{
			*_thumbw = CONFIG_THUMBW;//ͼ
			*_thumbh = height * CONFIG_THUMBW / width;//ͼ
		}
		else
		{
			*_thumbh = CONFIG_THUMBH;
			*_thumbw = width * CONFIG_THUMBH / height;
		}
	}
	else if( width > CONFIG_THUMBW )
	{
		*_thumbw = CONFIG_THUMBW;//ͼ
		*_thumbh = height * CONFIG_THUMBW / width;//ͼ
	}
	else if( height > CONFIG_THUMBH )
	{
		*_thumbh = CONFIG_THUMBH;
		*_thumbw = width * CONFIG_THUMBH / height;
	}
	else
	{
		*_thumbw = width;
		*_thumbh = height;
	}
}

void GetThumbPos( RECT *thumbR, RECT *thumbSR, int curleft, int curtop, int thumbw, int thumbh, int zoom_w, int zoom_h )
{
	int x, y;
	int x1,y1, w1,h1;

	x = ( SCREEN_W - thumbw ) / 2;

	y = CONFIG_THUMB_Y + ( CONFIG_THUMBH - thumbh ) / 2;

	if( zoom_w <= SCREEN_W )
	{
		x1 = 0;
		w1 = thumbw;
	}
	else
	{
		x1 = curleft * thumbw / zoom_w;
		w1 = SCREEN_W * thumbw / zoom_w;
	}

	if( zoom_h <= SCREEN_H )
	{
		y1 = 0;
		h1 = thumbh;
	}
	else
	{
		y1 = curtop * thumbh / zoom_h;
		h1 = SCREEN_H * thumbh / zoom_h;
	}

	thumbR->x = x;
	thumbR->y = y;
	thumbR->w = thumbw;
	thumbR->h = thumbh;

	thumbSR->x = x1;
	thumbSR->y = y1;
	thumbSR->w = w1;
	thumbSR->h = h1;
}

void scene_printthumbimg( int curleft, int curtop, int thumbw, int thumbh, int zoom_w, int zoom_h, pixel *ThumbimgPtr )//ͼƬתĿ: zoom_w zoom_h
{
	pixel R,G,B,R1,G1,B1,R2,G2,B2,bgcolor;
	pixel *Vram = (pixel*)GetVram( DOWN_SCREEN );
	int x,y;
	int xt,yt;

	if( ThumbimgPtr == NULL )
	{
		scene_printthumbimgBg( Bgcolor );
		return;
	}

	GetThumbPos( &thumbR, &thumbSR, curleft, curtop, thumbw, thumbh, zoom_w, zoom_h );

	R2 = RGB_R( COLOR_BLACK );
	G2 = RGB_G( COLOR_BLACK );
	B2 = RGB_B( COLOR_BLACK );

#define		T0		( 1000 ) //1000
#define		T1		( 500 ) //1000 //ɫռ
#define		T2		( T0 - T1 ) //1000 //ǰɫռ
#define		LINE_W	3 //ѡ߿

	if( config.rotate == conf_rotate_0 || config.rotate == conf_rotate_90 || imgfiletype != fs_filetype_jpg )
	{
		for( y = 0; y < thumbR.h; y++ )//thumbh
		{
			for( x = 0; x < thumbR.w; x++ )//thumbw
			{
				if( x >= thumbSR.x && x <= (thumbSR.x+thumbSR.w-1) && y >= thumbSR.y && y <= (thumbSR.y+thumbSR.h-1) )
				{
					Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = ThumbimgPtr[y*thumbR.w+ x];
				}
				else
				{
					bgcolor = ThumbimgPtr[y*thumbR.w+ x];
					R1 = RGB_R( bgcolor );
					G1 = RGB_G( bgcolor );
					B1 = RGB_B( bgcolor );

					R = (R1 * T1 + R2 * T2) / T0;
					G = (G1 * T1 + G2 * T2) / T0;
					B = (B1 * T1 + B2 * T2) / T0;
					Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = RGB15( R,G,B );
				}
			}
		}
	}
	else
	{
		for( y = 0, yt = thumbR.h-1; y < thumbR.h; y++, yt-- )//thumbh
		{
			for( x = 0, xt = thumbR.w - 1; x < thumbR.w; x++, xt-- )//thumbw
			{
				if( x >= thumbSR.x && x <= (thumbSR.x+thumbSR.w-1) && y >= thumbSR.y && y <= (thumbSR.y+thumbSR.h-1) )
				{
					Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = ThumbimgPtr[yt*thumbR.w + xt];
				}
				else
				{
					bgcolor = ThumbimgPtr[yt*thumbR.w + xt];
					R1 = RGB_R( bgcolor );
					G1 = RGB_G( bgcolor );
					B1 = RGB_B( bgcolor );

					R = (R1 * T1 + R2 * T2) / T0;
					G = (G1 * T1 + G2 * T2) / T0;
					B = (B1 * T1 + B2 * T2) / T0;
					Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = RGB15( R,G,B );
				}
			}
		}
	}
}

void scene_printthumbimgline( RECT thumbR, RECT thumbSR, int start_y, int h )//ԭʼͼƬźĿ: zoom_w zoom_h
{
	pixel R,G,B,R1,G1,B1,R2,G2,B2;
	pixel bgcolor;
	pixel *Vram = (pixel*)GetVram( DOWN_SCREEN );
	int x,y;
	int end_y = start_y + h;

	R2 = RGB_R( COLOR_BLACK );
	G2 = RGB_G( COLOR_BLACK );
	B2 = RGB_B( COLOR_BLACK );

#define		T0		( 1000 ) //1000
#define		T1		( 500 ) //1000 //ɫռ
#define		T2		( T0 - T1 ) //1000 //ǰɫռ
#define		LINE_W	3 //ѡ߿

	for( y = start_y; y < end_y && y < thumbR.h; y++ )//thumbh
	{
		for( x = 0; x < thumbR.w; x++ )//thumbw
		{
			if( x >= thumbSR.x && x <= (thumbSR.x+thumbSR.w-1) && y >= thumbSR.y && y <= (thumbSR.y+thumbSR.h-1) )
			{
				Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = thumbimg[y*thumbR.w+ x];
			}
			else
			{
				bgcolor = thumbimg[y*thumbR.w+ x];
				R1 = RGB_R( bgcolor );
				G1 = RGB_G( bgcolor );
				B1 = RGB_B( bgcolor );

				R = (R1 * T1 + R2 * T2) / T0;
				G = (G1 * T1 + G2 * T2) / T0;
				B = (B1 * T1 + B2 * T2) / T0;
				Vram[(thumbR.y*SCREEN_W + thumbR.x) + (y*SCREEN_W+x)] = RGB15( R,G,B );
			}
		}
	}


}

void scene_printthumbimgBg( pixel bgcolor )
{
	FillRect( CONFIG_THUMB_X, CONFIG_THUMB_Y, CONFIG_THUMBW, CONFIG_THUMBH, bgcolor, DOWN_SCREEN );
}

//--------------------------------------------------------------------------------------
//ӡͼƬϢ
//--------------------------------------------------------------------------------------
void scene_printimgInfo( dword width, dword height )//width/height: ԭʼȣת
{
	int len;
	dword w = 0;
	pixel *Vram = (pixel*)GetVram( DOWN_SCREEN );
	char str[12];//ַı䣬Ÿı
#define		IMGINFO_LEN				128
	char infostr[IMGINFO_LEN];
#if USE_UNICODE_FONTLIB
	byte utf8[IMGINFO_LEN];
#endif
	if( config.rotate & 0x1 )
	{
		ExchangeValue( (int*)&width, (int*)&height );//תԭʼ
	}

	if (config.imginfobar || showinfo || needp_infobg)
	{
		needp_infobg = false;
		if( imgTitleBarbuf )
		{
			bitBlt1( imgTitleBarbuf, IMAGE_TITLEBAR_W, IMAGE_TITLEBAR_H, Vram, SCREEN_W, SCREEN_H, 0, 0 );
		}
		else
		{
			FillRect( 0, 0, SCREEN_W, IMAGE_TITLEBAR_H, COLOR_BLACK, DOWN_SCREEN );
		}

		if (config.imginfobar || showinfo)
		{
			switch( (dword)config.fit )
			{
				case conf_fit_none:
					STRCPY_S( str, lang_item[LANG_ORIGSIZE_ID] );//"ԭʼС"
					break;
				case conf_fit_width:
					STRCPY_S( str, lang_item[LANG_ADAPTW_ID] );//"Ӧ"
					break;
				case conf_fit_height:
					STRCPY_S( str, lang_item[LANG_ADAPTH_ID] );// "Ӧ߶"
					break;
			}

			int m,n;
			char strtemp[12];
			char strfsize[10];

			if( imgSize >= 1024 * 1024 )
			{
				m = imgSize >> 20;
				n = ((imgSize & 0xFFFFF) * 100) >> 20;
				SPRINTF_S( strfsize, "%d.%dMB ", m, n );
			}
			else if( imgSize >= 1024 )
			{
				m = imgSize >> 10;
				n = ((imgSize & 0x03FF) * 10) >> 10;
				SPRINTF_S( strfsize, "%d.%dKB ", m, n );
			}
			else
			{
				SPRINTF_S( strfsize, "%dB ", imgSize );
			}

#if USE_UNICODE_FONTLIB
			UnicodeToUtf8( lang_item[LANG_SIZE_ID], infostr );
#else
			STRCPY_S( infostr, lang_item[LANG_SIZE_ID] );
#endif
			SPRINTF_S( strtemp, "%dx%d ", (int) width, (int) height );
			STRCAT_S( infostr, strtemp );
#if USE_UNICODE_FONTLIB
			UnicodeToUtf8( lang_item[LANG_FILESIZE_ID], utf8 );
			STRCAT_S( infostr, utf8 );
#else
			STRCAT_S( infostr, lang_item[LANG_FILESIZE_ID] );
#endif
			
			STRCAT_S( infostr, strfsize );
#if USE_UNICODE_FONTLIB
			UnicodeToUtf8( lang_item[LANG_ZOOM_ID], utf8 );
			STRCAT_S( infostr, utf8 );
#else
			STRCAT_S( infostr, lang_item[LANG_ZOOM_ID] );
#endif			

			if( config.fit != conf_fit_custom )
			{
				STRCAT_S( infostr, str );
			}
			else
			{
				SPRINTF_S( strtemp, "%d%%", (int) config.scale );
				STRCAT_S( infostr, strtemp );
			}

#if USE_UNICODE_FONTLIB
			utf8_to_ucs( utf8, IMGINFO_LEN, (const byte*)infostr, IMGINFO_LEN );
			w = CB_text_get_string_width_sys( (const byte*)utf8, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
			if( w <= SCREEN_W )
				CB_putnstringhorz_sys( (SCREEN_W - w)>>1 , IMAGE_INFO_Y, 0, (const byte*)utf8, INVALID_LEN, IMAGE_INFO_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#else
			w = CB_text_get_string_width_sys( (const byte*)infostr, 0, CONFIG_FONTW_SYS, GetlanguageCodingType() );
			if( w <= SCREEN_W )
				CB_putnstringhorz_sys( (SCREEN_W - w)>>1 , IMAGE_INFO_Y, 0, (const byte*)infostr, INVALID_LEN, IMAGE_INFO_FCOLOR, DOWN_SCREEN, DISP_FONTSIZE, DISP_FONTSIZE );
#endif
		}
	}
}

int scene_printimage( int selidx )
{
	dword paintw = 0,painth = 0;
	pixel *Vram = (pixel*)GetVram( UP_SCREEN );
	PAINT_RECT Prect;
	dword paintleft, painttop;

//----------------------------------------
	GetScreenPos( &Prect, w2, h2 );

	paintleft = Prect.paintleft;
	painttop = Prect.painttop;
	paintw = Prect.w;
	painth = Prect.h;

	if( imgfiletype == fs_filetype_jpg )
	{
		PlugJpeg_GetBitmap( imgFileName, curleft, curtop );
	}
	else
	{
		FillVram( Bgcolor, UP_SCREEN );
		if( Gimgdata )//from buffer
		{
			image_zoom_bilinear_FromBuffer( curleft, curtop, paintw, painth, paintleft, painttop, w_org, h_org, w2, h2, Vram, SCREEN_W, SCREEN_H, config.rotate, Gimgdata );
		}
		else//from file
		{
			image_zoom_bilinear_FromFile( curleft, curtop, paintw, painth, paintleft, painttop, w_org, h_org, w2, h2, Vram, SCREEN_W, SCREEN_H, config.rotate );
		}
	}

//-------------------------------------
	pixel *ThumbimgPtr = NULL;
	scene_printimgInfo( w_org, h_org );
	if( needp_mainbg )
	{
		scene_printthumbimgBg( Bgcolor );
	}
	needp_mainbg = false;
	if( imgfiletype != fs_filetype_jpg )
		ThumbimgPtr = thumbimg;
	else
	{
		if( config.rotate == conf_rotate_0 || config.rotate == conf_rotate_180 )
			ThumbimgPtr = thumbimg;
		else if( config.rotate == conf_rotate_90 || config.rotate == conf_rotate_270 )
			ThumbimgPtr = pThumbimgV;
	}
	scene_printthumbimg( curleft, curtop, thumbw, thumbh, w2, h2, ThumbimgPtr );

	Flush( DOWN_SCREEN );
	Flush( UP_SCREEN );
	return 0;
}

void image_up(void)
{
	if (curtop > 0)
	{
		curtop -= (int) config.imgmvspd * 2;
		if (curtop < 0)
			curtop = 0;
		img_needrp = true;
	}
}

void image_down(void)
{
	if (h2 > SCREEN_H && curtop < h2 - SCREEN_H) {
		curtop += (int) config.imgmvspd * 2;
		if (curtop > h2 - SCREEN_H)
			curtop = h2 - SCREEN_H;
		img_needrp = true;
	}
}

void image_left(void)
{
	if (curleft > 0)
	{
		curleft -= (int) config.imgmvspd * 2;
		if (curleft < 0)
			curleft = 0;
		img_needrp = true;
	}
}

void image_right(void)
{
	if (w2 > SCREEN_W && curleft < w2 - SCREEN_W)
	{
		curleft += (int) config.imgmvspd * 2;
		if (curleft > w2 - SCREEN_W)
			curleft = w2 - SCREEN_W;
		img_needrp = true;
	}
}

void image_move(dword key)
{
	if (key & KEY_LEFT && !(key & KEY_RIGHT))
	{
		image_left();
	}
	if (key & KEY_RIGHT && !(key & KEY_LEFT)) {
		image_right();
	}
	if (key & KEY_UP && !(key & KEY_DOWN)) {
		image_up();
	}
	if (key & KEY_DOWN && !(key & KEY_UP)) {
		image_down();
	}
}

//---------------------------------------------------------------
//---------------------------------------------------------------
int image_handle_input( dword * selidx, KEY_BUF inputkey )
{
//------------ֲ-----------------------
	dword orgidx = *selidx;
	AJUST_KEY_BUF AjustKey;
	dword key = inputkey.key;
	int i,result;
	int x=0,y=0;
	int w=0,h=0;

//-----------------------------------------------
	if (key == 0)
	{
		goto next;
	}
	else if( key == KEY_B )
	{
		ctrl_waitrelease( key );
		return -2;
	}
	else if (key == (KEY_SELECT | KEY_START))
	{
	}
	else if( ( key & KEY_A ) && ( key & KEY_R ) &&  !( key & ~(KEY_A | KEY_R) ) )//else if( key == KEY_SELECT )//ǷʾͼƬϢлѾ
	{
		config.imginfobar = !config.imginfobar;
		if (h2 > SCREEN_H && curtop > h2 - SCREEN_H)
			curtop = h2 - SCREEN_H;
		img_needrc = (config.fit == conf_fit_height);
		img_needrp = needp_mainbg = needp_infobg = true;
		ctrl_waitrelease( key );
	}
	else if (key == KEY_START)
	{
	}
	else if ( key & (KEY_LEFT | KEY_RIGHT | KEY_UP | KEY_DOWN) && !(key & ~(KEY_LEFT | KEY_RIGHT | KEY_UP | KEY_DOWN)) )
	{
		image_move(key);
	}
	else if( key & KEY_L && !(key & ~KEY_L ) )//һͼƬ
	{
_PREV_IMAGE:
		do
		{
			if (*selidx > 0)
				(*selidx)--;
			else
				*selidx = filecount - 1;
		} while (!fs_is_image((t_fs_filetype) filelist[*selidx].data));
		if (*selidx != orgidx)
			img_needrf = img_needrc = img_needrp = needp_mainbg = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_R && !(key & ~KEY_R ) )//һͼƬ
	{
_NEXT_IMAGE:
		do
		{
			if (*selidx < filecount - 1)
				(*selidx)++;
			else
			{
				if (config.img_no_repeat == false)
				{
					*selidx = 0;
				}
				else //ظͼƬ˳
				{
					return *selidx;
				}
			}
		} while (!fs_is_image((t_fs_filetype) filelist[*selidx].data));
		if (*selidx != orgidx)
			img_needrf = img_needrc = img_needrp = needp_mainbg = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_X && !(key & ~KEY_X ) )//Ŵ
	{
		goto _ZOOMIN_OP;
	}
	else if( key & KEY_Y && !(key & ~KEY_Y ) )//С
	{
		goto _ZOOMOUT_OP;
	}
	else if( ( key & KEY_A ) && ( key & KEY_L ) &&  !( key & ~(KEY_A | KEY_L) ) )//лʾģʽԳɹ
	{
		if (config.fit == conf_fit_custom)
			config.fit = conf_fit_none;
		else
			config.fit++;

		if( config.fit == conf_fit_custom )
			config.scale = 50;

		img_needrc = img_needrp = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_SELECT && !(key & ~KEY_SELECT ) )//
	{
		if( config.cur_lang_index == LANG_INDEX_CN )
		{
			font_in_book = false;
		}
		HelpMenuDisplay_Picture();
		ctrl_waitrelease( key );
		if( config.cur_lang_index == LANG_INDEX_CN )
		{
			font_in_book = true;
		}
	}
	else if( key & KEY_A && key & KEY_LEFT &&  (!( key & ~(KEY_A | KEY_LEFT)) ) )//ʱתϼA+Left
	{
_ROTATIONL_OP:
		if (config.rotate == conf_rotate_0)
			config.rotate = conf_rotate_270;
		else
			config.rotate--;

		rotateFlag = true;
		thumbimg_needup = true;
		img_needrc = img_needrp = needp_mainbg = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_A && key & KEY_RIGHT &&  (!( key & ~(KEY_A | KEY_RIGHT) )) )//˳ʱתϼA+Right
	{
_ROTATIONR_OP:
		if (config.rotate == conf_rotate_270)
			config.rotate = conf_rotate_0;
		else
			config.rotate++;

		rotateFlag = true;
		thumbimg_needup = true;
		img_needrc = img_needrp = needp_mainbg = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_A && key & KEY_UP && !( key & ~(KEY_A|KEY_UP) ) )//СϼA+Up
	{
_ZOOMOUT_OP:
		if (config.scale > ZOOM_LEVEL_200)
			config.scale -= ZOOM_STEP_100;
		else if (config.scale > ZOOM_LEVEL_100)
			config.scale -= ZOOM_STEP_50;
		else if (config.scale > ZOOMIN_MIN)
			config.scale -= ZOOM_STEP_25;
		else
		{
			goto next;
		}
		config.fit = conf_fit_custom;
		img_needrc = img_needrp = true;
		ctrl_waitrelease( key );
	}
	else if( key & KEY_A && key & KEY_DOWN && !( key & ~(KEY_A|KEY_DOWN) ) )//ŴϼA+Down
	{
_ZOOMIN_OP:
		if( config.scale < ZOOMIN_MAX )
		{
			if (config.scale < ZOOM_LEVEL_100)
				config.scale += ZOOM_STEP_25;
			else if (config.scale < ZOOM_LEVEL_200)
				config.scale += ZOOM_STEP_50;
			else if (config.scale < ZOOMIN_MAX)
				config.scale += ZOOM_STEP_100;
			else
			{
				goto next;
			}
			config.fit = conf_fit_custom;
			img_needrc = img_needrp = true;
			ctrl_waitrelease( key );
		}
	}
	else if( key == KEY_TOUCH )
	{
		if( w2 > SCREEN_W || h2 > SCREEN_H )
		{
			AjustKey.Min_x = thumbR.x;
			AjustKey.Max_x = AjustKey.Min_x + thumbR.w - 1;

			AjustKey.Min_y = thumbR.y;
			AjustKey.Max_y = AjustKey.Min_y + thumbR.h - 1;

			result = CheckValidxy( AjustKey, inputkey );
			if( result == 0 )
			{
				AjustKey.Min_x = thumbSR.x;
				AjustKey.Max_x = AjustKey.Min_x + thumbSR.w - 1;

				AjustKey.Min_y = thumbSR.y;
				AjustKey.Max_y = AjustKey.Min_y + thumbSR.h - 1;

				result = CheckValidxy( AjustKey, inputkey );
				if( result == 0 )
				{
					int x_old = inputkey.x;
					int y_old = inputkey.y;
					inputkey = ctrl_waitmove();

					if( inputkey.key == KEY_TOUCH )
					{
						if( inputkey.x < thumbR.x )
							inputkey.x = thumbR.x;
						if( inputkey.x > thumbR.x + thumbR.w - 1 )
							inputkey.x = thumbR.x + thumbR.w - 1;
						if( inputkey.x - x_old > 0 )
						{
							curleft += (inputkey.x - x_old) * w2 / thumbw;;
						}
						else
						{
							curleft -= (x_old - inputkey.x) * w2 / thumbw;;
						}

						if( inputkey.y < thumbR.y )
							inputkey.y = thumbR.y;
						if( inputkey.y > thumbR.y + thumbR.h - 1 )
							inputkey.y = thumbR.y + thumbR.h - 1;

						if( inputkey.y - y_old > 0 )
							curtop += (inputkey.y - y_old) * h2 / thumbh;
						else
							curtop -= (y_old-inputkey.y) * h2 / thumbh;;
					}
					else
						goto _VK_TOUCH_NEXT;
				}
				else
				{
					if( w2 > SCREEN_W )
					{
						if( (inputkey.x - thumbR.x) <= (thumbSR.w >> 1) )
							x = thumbR.x;
						else if( (inputkey.x + (thumbSR.w >> 1)) >= (thumbR.x + thumbR.w - 1) )
							x = thumbR.x + thumbR.w - thumbSR.w;
						else
							x = inputkey.x - (thumbSR.w >> 1);
						curleft = (x - thumbR.x) * w2 / thumbw;
					}
					else
					{
						curleft = 0;
					}

					if( h2 > SCREEN_H )
					{
						if( (thumbR.y + (thumbSR.h >> 1)) >= inputkey.y )
							y = thumbR.y;
						else if( (inputkey.y + (thumbSR.h >> 1)) >= (thumbR.y + thumbR.h - 1) )
							y = thumbR.y + thumbR.h - thumbSR.h;
						else
							y = inputkey.y - (thumbSR.h >> 1);
						curtop = (y - thumbR.y) * h2 / thumbh;
					}
					else
					{
						curtop = 0;
					}
				}
				if( curleft < 0 )
					curleft = 0;
				else if( curleft > w2 - SCREEN_W )
					curleft = w2 - SCREEN_W;

				if( curtop < 0 )
					curtop = 0;
				else if( curtop > h2 - SCREEN_H )
					curtop = h2 - SCREEN_H;

				img_needrp = true;
				goto _VK_TOUCH_EXIT;
			}
		}

_VK_TOUCH_NEXT:
		//жǷĸŴ С ʱת ˳ʱת
		for( i = 0; i < OPLOGO_COUNT; i++ )
		{
			if( i <= 1 )
			{
				x = PrevNext[i].x;
				y = PrevNext[i].y;
				w = OPLOGO_W2;
				h = OPLOGO_H2;
			}
			else if( i == 2 )
			{
				x = OPLOGO_X;
				y = OPLOGO_Y;
				w = OPLOGO_W;
				h = OPLOGO_H;
			}
			else
			{
				x += OPLOGO_W;
			}

			AjustKey.Min_x = x;
			AjustKey.Max_x = AjustKey.Min_x + w;

			AjustKey.Min_y = y;
			AjustKey.Max_y = AjustKey.Min_y + h;

			result = CheckValidxy( AjustKey, inputkey );
			if( result == 0 )
			{
				if( ImgFunKeyStatus == 0 )
				{
					image_draw_opLogo( BIT( i ), BIT( i ) );
					ImgFunKeyStatus = BIT( i );
					Flush( DOWN_SCREEN );
				}

				if( ImgFunKeyStatus & ( ~(BIT( 2 )| BIT( 3 )) ) )
				{
					ctrl_waitrelease( key );
					image_draw_opLogo( BIT( i ), 0 );
					ImgFunKeyStatus = 0;
				}

				switch( i )
				{
					case 0:
						goto _PREV_IMAGE;
						break;

					case 1:
						goto _NEXT_IMAGE;
						break;

					case 2:
						goto _ZOOMIN_OP;
						break;

					case 3:
						goto _ZOOMOUT_OP;
						break;

					case 4:
						goto _ROTATIONL_OP;
						break;

					case 5:
						goto _ROTATIONR_OP;
						break;
				}
			}
		}
_VK_TOUCH_EXIT:;
	}
	else
	{
		img_needrf = img_needrc = false;
	}

next:
	return -1;
}

dword scene_readimage(dword selidx)
{
//------------ֲ-----------------------
	int i;
	dword orgidx = selidx;
	KEY_BUF inputkey;
	dword key;
	dword w,h;
	pixel bgc;
	int ret;

//-----------------------------------------------
	w2 = 0, h2 = 0, thumbw = 0, thumbh = 0, paintleft = 0, painttop = 0;
	oldangle = 0;
	curtop = 0, curleft = 0, xpos = 0, ypos = 0;
	img_needrf = true, img_needrc = true, img_needrp = true, showinfo = false, thumb = false;
	imgreading = true;
	imgscaleNameId = 0;
	rotateFlag = false;

	if( bookfontindex_cur != 0 )
	{
		scene_load_book_font( 0 );//ָ
	}
	font_in_book = true;

	needp_mainbg = true;
	FillVram( COLOR_BLACK, DOWN_SCREEN );//ʾɫ

	image_draw_opLogo( 0x03F, 0x00 );

	if( imgTitleBarbuf == NULL )
	{
		(void)image_read_sys( CONFIG_IMAGETITLEBAR, fs_file_get_type( CONFIG_IMAGETITLEBAR ), &w, &h, &imgTitleBarbuf, &bgc );
	}

	while (1)
	{
		if ( img_needrf )
		{
			imgfiletype = (t_fs_filetype) filelist[selidx].data;
			if( imgfiletype == fs_filetype_jpg )
				free_mcu_rows_info();
			imgSize = (U32)filelist[selidx].data3;
			load_image_count = 0;//μ
			load_image_count2 = 0;//μ
			thumbimg_needup = true;
			ret = scene_reloadimage(selidx);
			if (ret == -1)
				break;
			img_needrf = false;
		}
		if (img_needrc)
		{
			scene_rotateimage( selidx );
			img_needrc = false;
		}
		if (img_needrp)
		{
			scene_printimage(selidx);
			img_needrp = false;
		}

		do{
			if( ImgFunKeyStatus == 0 )
			{
				do{
					ds2_getrawInput( &inputkey );
				}while( !inputkey.key );
			}
			else
			{
				ds2_getrawInput( &inputkey );
				
				if( inputkey.key != KEY_TOUCH )
				{
					image_draw_opLogo( ImgFunKeyStatus, 0 );
					ImgFunKeyStatus = 0;
					Flush( DOWN_SCREEN );
				}
			}
			Proc_SysKeyCheck( inputkey.key );
			key = inputkey.key;
		}while( key == 0 );

		ret = image_handle_input( &selidx, inputkey );
		if (ret != -1)
			break;

		if( selidx != orgidx )
		{
			repaintbg_sub = true;
		}
	}//while (1)
	imgreading = false;
	reset_image_ptr();
	if( imgfiletype == fs_filetype_jpg )
		free_mcu_rows_info();
	if( pThumbimgV )
	{
		free( pThumbimgV );
		pThumbimgV = NULL;
	}

//--------------------------------------------
	for( i = 0; i < OPLOGO_COUNT; i ++ )
	{
		if( neepr_oplogo & BIT( i ) )
		{
			free( opLogoBuf[i] );
			opLogoBuf[i] = NULL;
		}

		if( neepr_oplogo2 & BIT( i ) )
		{
			free( opLogoBuf2[i] );
			opLogoBuf2[i] = NULL;
		}
	}

	neepr_oplogo = 0;
	neepr_oplogo2 = 0;

	if( imgTitleBarbuf )
	{
		free( imgTitleBarbuf );
		imgTitleBarbuf = NULL;
	}

	if( Gimgdata )
	{
		free( Gimgdata );
		Gimgdata = NULL;
	}

	font_in_book = false;

	ImageViewFlag = false;

#if 1
	STRCPY_S( imgFileName, CONFIG_EBOOK_ROOTDIR );
	STRCAT_S( imgFileName, CONFIG_DIR_IMAGESRC_BUF );
	remove( imgFileName );

	if( ViewJpegZipFlag )
	{
		ViewJpegZipFlag = false;
		STRCPY_S( imgFileName, CONFIG_EBOOK_ROOTDIR );
		STRCAT_S( imgFileName, CONFIG_DIR_JPEGZIP_BUF );
		remove( imgFileName );
	}
#else
	FILE *fp = fopen_imgSwapfile( "w" );//սļ
	if( fp )
		fclose( fp );
#endif

	return selidx;
}

void image_draw_opLogo( U32 mask, U32 maskFocus )
{
	int i;
	pixel *imgdata = NULL;
	dword width, height;
	pixel bgc;
	int result;
	char logoname[20];//ע⣺ļ޸ģﳤҲҪű仯
	pixel *Vram = GetVram( DOWN_SCREEN );
	int x=0,y=0,w=OPLOGO_W2,h=OPLOGO_W2;

//----------------------------------------------------------------------------------------------
	if( neepr_oplogo == 0 )
	{
		for( i = 0; i < OPLOGO_COUNT; i++ )
		{
			opLogoBuf[i] = NULL;
		}
	}

	if( neepr_oplogo2 == 0 )
	{
		for( i = 0; i < OPLOGO_COUNT; i++ )
		{
			opLogoBuf2[i] = NULL;
		}
	}
	for( i=0; i<OPLOGO_COUNT; i++ )
	{
		if( mask == 0 )
			break;

		if( i <= 1 )
		{
			x = PrevNext[i].x;
			y = PrevNext[i].y;
			w = OPLOGO_W2;
			h = OPLOGO_H2;
		}
		else if( i == 2 )
		{
			x = 0;
			y = SCREEN_H - OPLOGO_H;
			w = OPLOGO_W;
			h = OPLOGO_H;
		}
		else
		{
			x += OPLOGO_W;
		}
		if( mask & 0x1 )
		{
			if( maskFocus & 0x1 )
			{
				if( neepr_oplogo2 & BIT( i ) )
				{
					bitBlt2( opLogoBuf2[i], w, h, 0, 0, Vram, SCREEN_W, SCREEN_H, x, y );
				}
				else
				{
					STRCPY_S( logoname, oplogoname[i] );
					STRCAT_S( logoname, "Press.bmp" );
					result = image_read_sys( logoname, fs_file_get_type( logoname ), &width, &height, &imgdata, &bgc );
					if( result == 0 )
					{
						bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, y );
						opLogoBuf2[i] = imgdata;
						if( opLogoBuf[i] )
						{
							bitBlt2( imgdata, width, height, 0, 0, opLogoBuf2[i], width, height, 0, 0 );//
							neepr_oplogo2 |= BIT( i );
						}
						imgdata = NULL;
					}
				}
			}
			else
			{
				if( neepr_oplogo & BIT( i ) )
				{
					bitBlt2( opLogoBuf[i], w, h, 0, 0, Vram, SCREEN_W, SCREEN_H, x, y );
				}
				else
				{
					STRCPY_S( logoname, oplogoname[i] );
					STRCAT_S( logoname, ".bmp" );
					result = image_read_sys( logoname, fs_file_get_type( logoname ), &width, &height, &imgdata, &bgc );
					if( result == 0 )
					{
						bitBlt1( imgdata, width, height, Vram, SCREEN_W, SCREEN_H, x, y );
						opLogoBuf[i] = imgdata;
						if( opLogoBuf[i] )
						{
							bitBlt2( imgdata, width, height, 0, 0, opLogoBuf[i], width, height, 0, 0 );//
							neepr_oplogo |= BIT( i );
						}
						imgdata = NULL;
					}
				}
			}
		}

		mask >>= 1;
		maskFocus >>= 1;
	}
}

#endif //ENABLE_IMAGE
