/* vim:set ts=4 sw=4 cindent ignorecase enc=gbk: */

#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <ds2_timer.h>
#include "display.h"
#include "win.h"
#include "ctrl.h"
#include "fs.h"
#include "image.h"
#include "bookmark.h"
#include "conf.h"
#include "charsets.h"
#include "fat_ebook.h"
#include "text.h"
#include "bg.h"
#include "common/utils.h"
#include "scene_impl.h"
#include "scene_text.h"
#include <MainMenuSettings.h>
#include <HelpMenu_Text.h>
#include <BacklightSet.h>
#include <ReadingMode.h>
#include <StyleSet.h>
#include <msgbox.h>
#include <key.h>
#include <language.h>
#include <gdi.h>
#include <DrvMemMgr.h>
#include <Macro.h>
#include <ds2io2.h>
#include <debugoff.h>

#define		BUFFER_LEN		(256)//ֽ

static int fontcolor_show;
static int fontbgcolor_show;
t_conf_encode Text_encode_cur = conf_encode_default;//ǰıʹñ
dword ctlkey[13], ctlkey2[13], ku, kd, kl, kr;
static volatile int ticks = 0, secticks = 0;
char g_titlename[256];
BOOL scene_readbook_in_raw_mode = false;

BookViewData cur_book_view, prev_book_view;

static int Cur_Pos_start = 0;
static POS SlideCurTouchPos;
static pixel *SlideBufMain = NULL;
static pixel *SlideBufSub = NULL;

static bool mscrf;//޸ı־
static BOOL mbodyf;//(ı)޸ı־(Ҳı)
static s32 mbodyy;//(ı)޸y(Ҳı)
static s32 mbodyx;//(ı)޸y(Ҳı)
static BOOL mf;
static s32 mx,my;
static s32 ShowLineHeight;

U32 LeftMargin;
U32 RightMargin;
U32 TopMargin;
U32 BottomMargin;

static bool EnterMenuFlag = false;

char FilenameCur[255];

BOOL up_sw = ON;
BOOL down_sw = ON;
BOOL updatetime_flag = true;
BOOL updateup_flag = true;//
BOOL updatedown_flag = true;//
static pixel *VramTemp = NULL;

static dword Key_LEFT,Key_RIGHT, Key_UP, Key_DOWN;

SLIDE_t Slide[10] = {
	{ STYLE1_SLIDEBAR_COLOR, STYLE1_SLIDE_COLOR },
	{ STYLE2_SLIDEBAR_COLOR, STYLE2_SLIDE_COLOR },
	{ STYLE3_SLIDEBAR_COLOR, STYLE3_SLIDE_COLOR },
	{ STYLE4_SLIDEBAR_COLOR, STYLE4_SLIDE_COLOR },
	{ STYLE5_SLIDEBAR_COLOR, STYLE5_SLIDE_COLOR },
	{ STYLE6_SLIDEBAR_COLOR, STYLE6_SLIDE_COLOR },
	{ STYLE7_SLIDEBAR_COLOR, STYLE7_SLIDE_COLOR },
	{ STYLE8_SLIDEBAR_COLOR, STYLE8_SLIDE_COLOR },
	{ STYLE9_SLIDEBAR_COLOR, STYLE9_SLIDE_COLOR },
	{ STYLE10_SLIDEBAR_COLOR, STYLE10_SLIDE_COLOR }
};

//--------------------------------ȫֱ-----------------------------------
extern BOOL repaintbg_sub;

//----------------------------------------------------------------------------------
static void CB_MouseDown(s32 x,s32 y);
static void CB_MouseMove(s32 x,s32 y);
static void CB_MouseUp(s32 x,s32 y);
static void Proc_TouchPad( KEY_BUF inputkey );
static U32 GetCurrentLineIndex(void);
static void SetCurrentLineIndex(s32 lineidx);
static void RedrawSubScreen(void);
static void DrawCurrentText_Main(void);
static void ScreenMain_Flip_ProcFadeEffect(s32 x,s32 y);


//---------------------------------------------------------------------------
void copy_book_view(PBookViewData dst, const PBookViewData src)
{
	if (!dst || !src)
		return;

	memcpy(dst, src, sizeof(BookViewData));
}

PBookViewData new_book_view(PBookViewData p)
{
	if (!p)
	{
		p = malloc( sizeof(BookViewData) );
		if( !p )
			return NULL;
	}

	p->rrow = INVALID;
	p->rowtop = 0;
	memset(p->tr, 0, 8);
	p->trow = NULL;
	p->text_needrf = p->text_needrp = true;
	p->text_needrb = false;
	p->filename[0] = p->archname[0] = p->bookmarkname[0] = '\0';

	return p;
}

int scene_book_reload( PBookViewData pView, dword selidx )
{
	if (where == scene_in_zip || where == scene_in_chm || where == scene_in_rar)
	{
		STRCPY_S( pView->filename, filelist[selidx].Uname );
		STRCPY_S(pView->bookmarkname, config.Upath);
		STRCPY_S( pView->archname, config.Upath );

		if ( config.Upath[strlen(config.Upath) - 1] != CONFIG_DIR_SEPERATOR && pView->filename[0] != CONFIG_DIR_SEPERATOR )
			STRCAT_S(pView->bookmarkname, CONFIG_DIR_SEPERATORS );
		STRCAT_S(pView->bookmarkname, pView->filename);
	}
	else
	{
		STRCPY_S(pView->filename, config.Upath);//ǰ·
		STRCAT_S(pView->filename, filelist[selidx].Uname);
		STRCPY_S(pView->archname, pView->filename);
		STRCPY_S(pView->bookmarkname, pView->filename);
	}
	if (pView->rrow == INVALID)
	{
		// disable binary file type text's bookmark
		if ( config.autobm && (t_fs_filetype) filelist[selidx].data != fs_filetype_unknown )
		{
			pView->rrow = bookmark_autoload(pView->bookmarkname);
			pView->text_needrb = true;//ǷҪȡǩ
		}
		else
			pView->rrow = 0;
	}
	if (fs != NULL)
	{
		text_close(fs);
		fs = NULL;
	}
	fs = text_open_archive(pView->filename, pView->archname,
						   (t_fs_filetype) filelist[selidx].data,
						   pixelsperrow + 1, config.wordspace, config.encode,
						   config.reordertxt, where, config.vertread);

	if (fs == NULL)
	{
		DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char*)lang_item[LANG_OPENFILEERROR_ID], DOWN_SCREEN, MB_OK | MB_CANCEL, TRUE );
		return 1;
	}
	if( fs->size <= 0 )
		goto _scene_book_reload_Exti;
	if( pView->text_needrb && (t_fs_filetype) filelist[selidx].data != fs_filetype_unknown )
	{
		pView->rowtop = 0;
		fs->crow = 1;
		while ( fs->crow < fs->row_count && (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf <= pView->rrow )//ͨǩļļƫҵǰк
			fs->crow++;
		fs->crow--;
		pView->text_needrb = false;
	}
	else if( Cur_Pos_start != 0 )
	{
		fs->crow = 1;
		while ( fs->crow < fs->row_count && (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf <= Cur_Pos_start )//ͨǩļļƫҵǰк
			fs->crow++;
		fs->crow--;
		Cur_Pos_start = 0;
	}
	else
	{
		fs->crow = pView->rrow;
	}

	if (fs->crow >= fs->row_count)//ǰкС
		fs->crow = (fs->row_count > 0) ? fs->row_count - 1 : 0;

	pView->trow = &pView->tr[utils_dword2string(fs->row_count, pView->tr, 7)];///?????

_scene_book_reload_Exti:
	STRCPY_S( config.lastfile, filelist[selidx].Uname );
	return 0;
}

int Proc_Fontdecode( byte **out, int *outLength, const byte *in, int inLength )
{
	byte *outBuffer = *out;
	int outLen = *outLength;
	if( ( out == NULL ) || ( *out == NULL ) || ( in == NULL ) || ( outLength <= 0 ) || ( inLength <=0 ) )
		return false;
	if( Text_encode_cur == conf_encode_ucs )
	{
		outBuffer = (byte*)in;
		outLen = inLength;
	}
	else if( Text_encode_cur == conf_encode_gbk )
	{
		outLen = gbk_to_ucs_Fast( (U16*)outBuffer, outLen, in, inLength );
	}
	else if( Text_encode_cur == conf_encode_big5 )
	{
		outLen = big5_to_ucs_Fast( (U16*)outBuffer, outLen, in, inLength );
	}
	else if( Text_encode_cur == conf_encode_sjis )
	{
		outLen = sjis_to_ucs_Fast( (U16*)outBuffer, outLen, in, inLength );
	}
	else if( Text_encode_cur == conf_encode_utf8 )
	{
		outLen = utf8_to_ucs_Fast( (U16*)outBuffer, outLen, in, inLength );
	}
	else
	{
		return false;
	}
	*outLength = outLen;
	*out = outBuffer;

	return true;
}

static void scene_printtext_reversal(PBookViewData pView)
{
	int cidx;
	p_textrow tr = fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF);

	disp_putnstringreversal(config.borderspace, config.borderspace,
							config.forecolor, (const byte *) tr->start,
							(int) tr->count, config.wordspace,
							pView->rowtop,
							DISP_BOOK_FONTSIZE - pView->rowtop, 0);
	for (cidx = 1; cidx < drperpage && fs->crow + cidx < fs->row_count; cidx++) {
		tr = fs->rows[(fs->crow + cidx) >> 10] + ((fs->crow + cidx) & 0x3FF);
		disp_putnstringreversal(config.borderspace,
								config.borderspace +
								(DISP_BOOK_FONTSIZE +
								 config.rowspace) * cidx -
								pView->rowtop, config.forecolor,
								(const byte *) tr->start,
								(int) tr->count, config.wordspace, 0,
								DISP_BOOK_FONTSIZE,
								config.infobar ? SCREEN_H -
#ifdef ENABLE_TTF
								(config.infobar_use_ttf_mode ?
								 DISP_BOOK_FONTSIZE : DISP_FONTSIZE) :
#else
	  							DISP_FONTSIZE:
#endif
								SCREEN_H);
	}
}

static void scene_printtext_rvert(PBookViewData pView)
{
	int cidx;
	p_textrow tr;
	SCREEN_ID engine;
	U32 edge_distance_y_adjust;

	const byte *pstr = NULL;
	U16 buffer[BUFFER_LEN>>1];
	int count;

	if( config.ScreenUse == SCREEN_DOWN )
		engine = DOWN_SCREEN;
	else
		engine = UP_SCREEN;

	edge_distance_y_adjust = ( SCREEN_W - config.edge_distance_y - config.borderspace - (DISP_BOOK_FONTSIZE + config.rowspace) * rowsperpage + config.rowspace ) >> 1;
	if( edge_distance_y_adjust > DISP_BOOK_FONTSIZE )
		edge_distance_y_adjust = 0;

	int n = config.ScreenUse == SCREEN_DOUBLE ? 2 : 1;
	int m = 0;
	for (cidx = 0; cidx < ( rowsperpage * n ) && fs->crow + cidx < fs->row_count; cidx++, m++ )
	{

		if( cidx == rowsperpage )
		{
			engine = DOWN_SCREEN;
			m = 0;
		}

		tr = fs->rows[(fs->crow + cidx) >> 10] + ((fs->crow + cidx) & 0x3FF);
#if DEBUG_LHM
		char test_str[1024];
		memset( test_str, 0x00, 1024 );
		memcpy( test_str, tr->start, (int) tr->count );
#endif

		pstr = (byte*)buffer;
		count = BUFFER_LEN;
		if( Proc_Fontdecode( (byte**)(&pstr), &count, (const byte*)tr->start, tr->count ) == false )
			return;

		CB_disp_putnstringrvert( (SCREEN_W - 1) - (DISP_BOOK_FONTSIZE + config.rowspace) * m - config.edge_distance_y - edge_distance_y_adjust,
							   config.edge_distance_y,
							   config.wordspace,
//							   (const byte *) tr->start,
//							   (int) tr->count,
								pstr,
								count,
							    fontcolor_show,
							    engine,
							    DISP_BOOK_FONTSIZE,
							    DISP_BOOK_FONTSIZE );
	}
}



static void scene_printtext_lvert( PBookViewData pView )
{
	int cidx;

	p_textrow tr;
	SCREEN_ID engine;

	if( config.ScreenUse == SCREEN_UP )
		engine = UP_SCREEN;
	else
		engine = DOWN_SCREEN;

	int n = config.ScreenUse == SCREEN_DOUBLE ? 2 : 1;
	int m = 0;
	for (cidx = 0; cidx < ( rowsperpage * n ) && fs->crow + cidx < fs->row_count; cidx++, m++ )
	{

		if( cidx == rowsperpage )
		{
			engine = UP_SCREEN;
			m = 0;
		}

		tr = fs->rows[(fs->crow + cidx) >> 10] + ((fs->crow + cidx) & 0x3FF);

		disp_putnstringlvert2( (DISP_BOOK_FONTSIZE + config.rowspace) * m + config.borderspace,
							 (SCREEN_H - 1) - config.borderspace, fontcolor_show,
							 (const byte *) tr->start,
							 (int) tr->count,
							 config.wordspace, engine );
	}
}

static void scene_printtext_horz( PBookViewData pView )
{
	int cidx;
	SCREEN_ID ScreenPan;
	p_textrow tr;
	U32 edge_distance_y_adjust;
	const byte *pstr = NULL;
	U16 buffer[BUFFER_LEN>>1];
	int count;

	if( config.ScreenUse == SCREEN_DOWN )
		ScreenPan = DOWN_SCREEN;
	else
		ScreenPan = UP_SCREEN;

	edge_distance_y_adjust = ( SCREEN_H - config.edge_distance_y * 2 - rowsperpage * (DISP_BOOK_FONTSIZE + config.rowspace) + config.rowspace ) >> 1;
	if( edge_distance_y_adjust > DISP_BOOK_FONTSIZE )
		edge_distance_y_adjust = 0;

	//=========================
//	fs->crow = 0; //
	//=========================

	int n = config.ScreenUse == SCREEN_DOUBLE ? 2 : 1;
	int m = 0;
	for( cidx = 0; cidx < ( rowsperpage * n ) && fs->crow + cidx < fs->row_count; cidx++, m++ ) //drperpage:display row perpageÿҳʾ
	{

		if( cidx == rowsperpage )
		{
			ScreenPan = DOWN_SCREEN;
			m = 0;
		}

		tr = fs->rows[(fs->crow + cidx) >> 10] + ((fs->crow + cidx) & 0x3FF);

#if 1
		char test_str[1024];
		memset( test_str, 0x00, 1024 );
		memcpy( test_str, tr->start, (int) tr->count );
#endif

		pstr = (byte*)buffer;
		count = BUFFER_LEN;
		if( Proc_Fontdecode( (byte**)(&pstr), &count, (const byte*)tr->start, tr->count ) == false )
			return;

		disp_putnstringhorz(config.borderspace,
							TopMargin + (DISP_BOOK_FONTSIZE + config.rowspace) * m,
							fontcolor_show,
//							(const byte *) tr->start,
							(const byte*)pstr,
							(int) count, config.wordspace, 0,
							DISP_BOOK_FONTSIZE,
							config.infobar ? (SCREEN_H - 1) - DISP_FONTSIZE : SCREEN_H-1,
							ScreenPan );
	}
}


static void scene_printtext_horz_vram( PBookViewData pView, int crow, int mrow )
{
	p_textrow tr;
	U32 edge_distance_y_adjust;

	const byte *pstr = NULL;
	U16 buffer[BUFFER_LEN>>1];
	int count;

	font_in_book = true;
	edge_distance_y_adjust = ( SCREEN_H - config.edge_distance_y * 2 - rowsperpage * (DISP_BOOK_FONTSIZE + config.rowspace) + config.rowspace ) >> 1;
	if( edge_distance_y_adjust > DISP_BOOK_FONTSIZE )
		edge_distance_y_adjust = 0;


	int line = 0;
	int row_start = crow;
	int row_end  = crow + rowsperpage;

	if( mrow > 0 )
		row_end += mrow;
	else if( mrow < 0 )
		row_start += mrow;

	if( row_end > fs->row_count )
		row_end = fs->row_count;

	while( row_start < row_end )
	{
		tr = fs->rows[row_start >> 10] + (row_start & 0x3FF);


		pstr = (byte*)buffer;
		count = BUFFER_LEN;
		if( Proc_Fontdecode( (byte**)(&pstr), &count, (const byte*)tr->start, tr->count ) == false )
		{
			break;
		}

		disp_putnstringhorz(config.borderspace,
							TopMargin + (DISP_BOOK_FONTSIZE + config.rowspace) * line,
							fontcolor_show,
//							(const byte *) tr->start,
							(const byte *)pstr,
							(int) count, config.wordspace, 0,
							DISP_BOOK_FONTSIZE,
							config.infobar ? (SCREEN_H - 1) - DISP_FONTSIZE : SCREEN_H-1,
							VRAMTEMP );
		row_start++;
		line++;

	}
	font_in_book = false;
}

static void scene_printtext_rvert_vram( PBookViewData pView, int crow, int mrow )
{
	p_textrow tr;
	U32 edge_distance_y_adjust;

	const byte *pstr = NULL;
	U16 buffer[BUFFER_LEN>>1];
	int count;

	edge_distance_y_adjust = ( SCREEN_W - config.edge_distance_y - config.borderspace - (DISP_BOOK_FONTSIZE + config.rowspace) * rowsperpage + config.rowspace ) >> 1;
	if( edge_distance_y_adjust > DISP_BOOK_FONTSIZE )
		edge_distance_y_adjust = 0;

	int line = 0;
	int row_start = crow;
	int row_end  = crow + rowsperpage;

	if( mrow > 0 )
		row_end += mrow;
	else if( mrow < 0 )
		row_start += mrow;

	if( row_end > fs->row_count )
		row_end = fs->row_count;

	while( row_start < row_end )
	{
		tr = fs->rows[row_start >> 10] + (row_start & 0x3FF);

		pstr = (byte*)buffer;
		count = BUFFER_LEN;
		if( Proc_Fontdecode( (byte**)(&pstr), &count, (const byte*)tr->start, tr->count ) == false )
		{
			break;
		}

		CB_disp_putnstringrvert( (SCREEN_W - 1) - (DISP_BOOK_FONTSIZE + config.rowspace) * line - config.edge_distance_y - edge_distance_y_adjust,
							   config.edge_distance_y,
							   config.wordspace,
//							   (const byte *) tr->start,
							   (const byte *) pstr,
							   (int) count,
							    fontcolor_show,
							    VRAMTEMP,
							    DISP_BOOK_FONTSIZE,
							    DISP_BOOK_FONTSIZE );

		row_start++;
		line++;

	}
	font_in_book = false;
}

int scene_printbook( PBookViewData pView, dword selidx )
{
	int result;
	dword width,height;
	pixel *imgdata = NULL,bgc;
	char logoname[64];

	pixel *Vram = NULL;;
	font_in_book = true;
	if( config.StyleIndex < STYLELOGO_COUNT )
	{
_FILL_BGCOLOR:
		if( config.ScreenUse == SCREEN_UP || config.ScreenUse == SCREEN_DOUBLE || updateup_flag == true )
		{
//			disp_fillvram( Style[config.StyleIndex].bcolor, UP_SCREEN );
			disp_fillvram( fontbgcolor_show, UP_SCREEN );
		}
		if( config.ScreenUse == SCREEN_DOWN || config.ScreenUse == SCREEN_DOUBLE || updatedown_flag == true )
		{
//			disp_fillvram( Style[config.StyleIndex].bcolor, DOWN_SCREEN );
			disp_fillvram( fontbgcolor_show, DOWN_SCREEN );
		}
	}
	else
	{
		if( neeprlogo & BIT( config.StyleIndex ) )
		{
			if( config.ScreenUse == SCREEN_UP || config.ScreenUse == SCREEN_DOUBLE || updateup_flag == true )
			{
				Vram = GetVram( UP_SCREEN );
				bitBlt( StyleBuf, SCREEN_W, SCREEN_H, Vram, SCREEN_W, SCREEN_H );
			}
			if( config.ScreenUse == SCREEN_DOWN || config.ScreenUse == SCREEN_DOUBLE || updatedown_flag == true )
			{
				Vram = GetVram( DOWN_SCREEN );
				bitBlt( StyleBuf, SCREEN_W, SCREEN_H, Vram, SCREEN_W, SCREEN_H );
			}
		}
		else
		{
			if( config.StyleIndex >= STYLELOGO_COUNT )
			{
				if( StyleBuf == NULL )
				{
					StyleBuf = memalign( sizeof( pixel ), SCREEN_W * SCREEN_H * sizeof( pixel ) );
				}
				imgdata = StyleBuf;

				if( imgdata == NULL )
					goto _FILL_BGCOLOR;

				SPRINTF_S( logoname, "%s%d%s", "Style", config.StyleIndex + 1, ".bmp" );
				result = image_read_sys( logoname, fs_file_get_type( logoname ), &width, &height, &imgdata, &bgc );
				if( result == 0 )
				{
					if( config.ScreenUse == SCREEN_UP || config.ScreenUse == SCREEN_DOUBLE || updateup_flag == true )
					{
						Vram = GetVram( UP_SCREEN );
						bitBlt( StyleBuf, width, height, Vram, width, height );
					}
					if( config.ScreenUse == SCREEN_DOWN || config.ScreenUse == SCREEN_DOUBLE || updatedown_flag == true )
					{
						Vram = GetVram( DOWN_SCREEN );
						bitBlt( StyleBuf, width, height, Vram, width, height );
					}
					neeprlogo = BIT( config.StyleIndex );
				}
				else
				{
					goto _FILL_BGCOLOR;
				}
			}
		}
	}

	switch (config.vertread)
	{
		case conf_vertread_reversal:
			scene_printtext_reversal(pView);
			break;
		case conf_vertread_lvert:
			scene_printtext_lvert(pView);
			break;
		case conf_vertread_rvert:
			scene_printtext_rvert(pView);
			break;
		case conf_vertread_horz:
			scene_printtext_horz(pView);
			break;
		default:
			break;
	}

#if !DRAW_NAVIGATION_IN_TEXT
	if( config.ScreenUse == SCREEN_DOWN || config.ScreenUse == SCREEN_DOUBLE || updatedown_flag == true )//֧˫ʾıĻʾɫ
	{
		Flush( DOWN_SCREEN );
		updatedown_flag = false;
	}
	if( config.ScreenUse == SCREEN_UP || config.ScreenUse == SCREEN_DOUBLE || updateup_flag == true )//֧˫ʾıĻʾɫ
	{
		Flush( UP_SCREEN );
		updateup_flag = false;
	}
#endif

	font_in_book = false;
	return 0;
}

void move_line_up(PBookViewData pView, int line)
{
	pView->rowtop = 0;
	if (fs->crow > line)
		fs->crow -= line;
	else
		fs->crow = 0;
	pView->text_needrp = true;
}

void move_line_down(PBookViewData pView, int line)
{

	pView->rowtop = 0;
	fs->crow += line;//ʼмlines
	if (fs->crow >= fs->row_count - 1)//ʼѾһ
		fs->crow = (fs->row_count > 0) ? fs->row_count - 1 : 0;
	pView->text_needrp = true;
}

void move_line_to_start(PBookViewData pView)
{
	pView->rowtop = 0;
	if (fs->crow != 0) {
		fs->crow = 0;
		pView->text_needrp = true;
	}
}

void move_line_to_end(PBookViewData pView)
{
	pView->rowtop = 0;
	if (fs->row_count > 0)
	{
		if (fs->crow != fs->row_count - 1)
		{
			fs->crow = fs->row_count - 1;
			pView->text_needrp = true;
		}
	}
	else
	{
		fs->crow = 0;
	}
}

void move_line_smooth(PBookViewData pView, int inc)
{
	pView->rowtop += inc;
	if (pView->rowtop < 0) {
		while (fs->crow > 0 && pView->rowtop < 0) {
			pView->rowtop += DISP_BOOK_FONTSIZE;
			fs->crow--;
		}
		// prevent dither when config.autopage < 5
		if (config.autopagetype == 1 && abs(config.autopage) < 5)
			pView->rowtop = DISP_BOOK_FONTSIZE + 1;
	} else if (pView->rowtop >= DISP_BOOK_FONTSIZE + config.rowspace) {
		while (fs->crow < fs->row_count - 1
			   && pView->rowtop >= DISP_BOOK_FONTSIZE + config.rowspace) {
			pView->rowtop -= DISP_BOOK_FONTSIZE;
			fs->crow++;
		}
		// prevent dither when config.autopage < 5
		if (config.autopagetype == 1 && abs(config.autopage) < 5)
			pView->rowtop = 0;
	}
	if (pView->rowtop < 0
		|| pView->rowtop >= DISP_BOOK_FONTSIZE + config.rowspace)
		pView->rowtop = 0;
	pView->text_needrp = true;
}

void move_line_analog(PBookViewData pView, int x, int y)
{
	switch (config.vertread) {
		case conf_vertread_reversal:
			move_line_smooth(pView, -y / 8);
			break;
		case conf_vertread_lvert:
			move_line_smooth(pView, x / 8);
			break;
		case conf_vertread_rvert:
			move_line_smooth(pView, -x / 8);
			break;
		case conf_vertread_horz:
			move_line_smooth(pView, y / 8);
			break;
		default:
			break;
	}
}

int move_page_up( PBookViewData pView, dword * selidx, dword n_page )
{
	pView->rowtop = 0;
	if (fs->crow == 0)
	{
		if (config.pagetonext && fs_is_txtbook((t_fs_filetype) filelist[*selidx].data))//ѾһҳϷĻǷҪһıļ
		{
			dword orgidx = *selidx;

			do {
				if (*selidx > 0)
					(*selidx)--;
				else
					*selidx = filecount - 1;
			} while (!fs_is_txtbook((t_fs_filetype) filelist[*selidx].data));//һֱңֱҵһıļ

			if (*selidx != orgidx) //ѡļŲԭȵļţҪļǩ洦
			{
				if (config.autobm)
					bookmark_autosave(pView->bookmarkname,
									  (fs->rows[fs->crow >> 10] +
									   (fs->crow & 0x3FF))->start - fs->buf);
				pView->text_needrf = pView->text_needrp = true;
				pView->text_needrb = false;
				pView->rrow = INVALID;
			}
		}
		else
		{
		}
		return 1;
	}

	if( config.ScreenUse == SCREEN_DOUBLE )
	{
		if (fs->crow > (config.rlastrow ? (rowsperpage * (n_page+1) - 1) : (rowsperpage * (n_page+1))))
			fs->crow -= ( config.rlastrow ? (rowsperpage * (n_page+1) - 1) : (rowsperpage * (n_page+1)) );
		else if (fs->crow > (config.rlastrow ? (rowsperpage * n_page - 1) : (rowsperpage * n_page)))
			fs->crow -= ( config.rlastrow ? (rowsperpage * n_page - 1) : (rowsperpage * n_page) );
		else
			fs->crow = 0;
	}
	else
	{
		if (fs->crow > (config.rlastrow ? (rowsperpage * n_page - 1) : (rowsperpage * n_page)))
			fs->crow -= ( config.rlastrow ? (rowsperpage * n_page - 1) : (rowsperpage * n_page) );
		else
			fs->crow = 0;
	}
	pView->text_needrp = true;
	return 0;
}

int move_page_down( PBookViewData pView, dword * selidx, dword n_page )//* selidx:ļ
{
	pView->rowtop = 0;

	if ( fs->crow >= fs->row_count - 1 )
	{
		if (config.pagetonext && fs_is_txtbook((t_fs_filetype) filelist[*selidx].data))//config.pagetonext:ǰļѾһҳٰһҳǷһıļ?
		{
			dword orgidx = *selidx;
			do
			{
				if (*selidx < filecount - 1)
					(*selidx)++;
				else
					*selidx = 0;
			} while (!fs_is_txtbook((t_fs_filetype) filelist[*selidx].data));//һֱңֱҵһıļ

			if (*selidx != orgidx)
			{
				if (config.autobm)
				{
					bookmark_autosave( pView->bookmarkname, (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf );
				}
				pView->text_needrf = pView->text_needrp = true;
				pView->text_needrb = false;
				pView->rrow = INVALID;
			}
		}
		else
			fs->crow = (fs->row_count > 0) ? fs->row_count - 1 : 0;
		return 1;
	}
	else if ( (!config.pagetonext) && (((fs->row_count - 1) - fs->crow) <= rowsperpage) )
	{
		return 1;
	}


	if( config.ScreenUse != SCREEN_DOUBLE )
	{
		fs->crow += (config.rlastrow ? (rowsperpage * n_page - 1) : (rowsperpage * n_page));//fs->crow: ǰʼк
	}
	else
	{
		if ( (!config.pagetonext) && (((fs->row_count - 1) - fs->crow) > rowsperpage * 2) )
			fs->crow += (config.rlastrow ? (rowsperpage * (n_page+1) - 1) : ( rowsperpage * (n_page+1) ));//fs->crow: ǰʼк
		else if ( (!config.pagetonext) && (((fs->row_count - 1) - fs->crow) > rowsperpage) )
			fs->crow += (config.rlastrow ? (rowsperpage * n_page - 1) : ( rowsperpage * n_page ) );//fs->crow: ǰʼк
	}


	if (fs->crow > fs->row_count - 1)//fs->crow: ǰʼк
		fs->crow = (fs->row_count > 0) ? fs->row_count - 1 : 0;
	pView->text_needrp = true;
	return 0;
}

int book_handle_input( PBookViewData pView, dword * selidx, KEY_BUF *inputkey )
{
	int result;
	U32 Ret = 0;
	U32 tempw = 0;
	dword key = inputkey->key;
	U32 bookmarkrowCur;
	MENUSETTINGS_s settings;
	BMSETTINGS_s bmsettings;

	if (key == KEY_B)//˳
	{
		if( down_sw == OFF )
		{
			ctrl_waitrelease( key );
			TurnOn_down();//
			updatetime_flag = true;
			goto _book_handle_input_Exit;
		}

		result = DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char *)lang_item[LANG_EXITITXT_ID], DOWN_SCREEN, MB_OK | MB_CANCEL, true );
		if( result )
		{
			return -2;
		}
		else
		{
			updatedown_flag = true;
			pView->text_needrp = true;
		}
	}
	else if (key == (KEY_SELECT | KEY_START))
	{
	}
	else if (key == KEY_START)
	{
		updatetime_flag = true;
	}
	else if( key == KEY_SELECT )//
	{
		if( down_sw == OFF )
		{
			TurnOn_down();//
			updatetime_flag = true;
		}
		EnterMenuFlag = true;
		HelpMenuDisplay_Text( true, true );
	}
	else if( key == KEY_TOUCH )
	{
	}
	else if( key == KEY_Y )
	{
		if( down_sw == OFF )
		{
			ctrl_waitrelease( key );
			TurnOn_down();//
			updatetime_flag = true;
			goto _book_handle_input_Exit;
		}

		EnterMenuFlag = true;
		bookmarkrowCur = (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf;
		bmsettings.row = bookmarkrowCur;
		bmsettings.bm_name = pView->bookmarkname;
		result = BookmarkManage( &bmsettings, false  );

		if( result >= 0 )//صresult: к
		{
			if( result < fs->row_count && result != fs->crow )
			{
				fs->crow = result;
			}
			EnterMenuFlag = false;
		}

		updatedown_flag = true;
		pView->text_needrp = true;//ػ
	}
	else if( key == KEY_X )
	{
		if( down_sw == OFF )
		{
			TurnOn_down();//
			updatetime_flag = true;
			ctrl_waitrelease( key );
			goto _book_handle_input_Exit;
		}

		EnterMenuFlag = true;

		{
			//óʼ
			settings.Font.bookfontindex = bookfontindex;
			settings.Font.rowspace = config.rowspace;
			settings.Font.wordspace = config.wordspace;
			settings.Font.stylefcolor_inUse = config.stylefcolor_inUse;
			settings.Font.stylefontbgcolor_inUse = config.stylefontbgcolor_inUse;
			
			if( config.fontcolor < 0 )
			{	
				settings.Font.fontcolor = RGB_16To24( Style[config.StyleIndex].fcolor );//ɫ
			}
			else
			{	
				settings.Font.fontcolor = config.fontcolor;//ɫ
			}
			
			if( config.fontbgcolor < 0 )
			{	
				settings.Font.fontbgcolor = RGB_16To24( Style[config.StyleIndex].fcolor );//ɫ
			}
			else
			{	
				settings.Font.fontbgcolor = config.fontbgcolor;//ֱɫ
			}
			
			//óʼ
			settings.StyleIndex = config.StyleIndex;

			//Ķʽóʼ
			settings.ReadMode.vertread = config.vertread;
			settings.ReadMode.ScreenUse = config.ScreenUse;

			//ȱóʼ
			settings.backlight.brightness = config.brightness;
			settings.backlight.BacklightUp = config.BacklightUp;
			settings.backlight.BacklightDown = config.BacklightDown;

			//תʼ
			settings.Percentage = scene_book_GetPercentage( fs->crow, ROWMODE );//10000

			//ǩ(ǰк)ʼ
			bookmarkrowCur = (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf;
			bmsettings.row = bookmarkrowCur;
			bmsettings.bm_name = pView->bookmarkname;
			settings.bmsettings = bmsettings;

			Ret = MenuSettings( &settings );
			
			if( Ret & bmBOOKMARK )//صsettings.row: к
			{
				if( settings.bmsettings.row < fs->row_count && settings.bmsettings.row != fs->crow )
				{
					fs->crow = settings.bmsettings.row;
					pView->text_needrp = true;//ػ
				}
			}

			if( Ret & bmJUMPTO )
			{
				 tempw = fs->row_count * settings.Percentage / 10000;
				if( tempw < fs->row_count && tempw != fs->crow )
				{
					fs->crow = tempw;
					pView->text_needrp = true;//ػ
				}
			}

			if( Ret & bmFONTSIZE )
			{
				bookfontindex = settings.Font.bookfontindex;
				if( scene_load_book_font( bookfontindex ) )//
				{
					recalcSize(&drperpage, &rowsperpage, &pixelsperrow);
					ShowLineHeight = scene_get_book_fontsize( bookfontindex ) + config.rowspace;
				}

				pView->text_needrf = true;//ض
				pView->text_needrp = true;//ػ
				cur_book_view.text_needrb = false;//ǩĵǰ
				Cur_Pos_start = (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf;
			}

			if( Ret & bmROWSPACE )
			{
				config.rowspace = settings.Font.rowspace;
				recalcSize( &drperpage, &rowsperpage, &pixelsperrow );
				ShowLineHeight = scene_get_book_fontsize( bookfontindex ) + config.rowspace;
				pView->text_needrp = true;//ػ
			}

			if( Ret & bmWORDSPACE )
			{
				config.wordspace = settings.Font.wordspace;
//				recalcSize( &drperpage, &rowsperpage, &pixelsperrow );
				pView->text_needrf = true;//ض
				pView->text_needrp = true;//ػ
				cur_book_view.text_needrb = false;//ǩĵǰ
				Cur_Pos_start = (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf;
			}

			if( Ret & bmFONTCOLOR )
			{
				config.fontcolor = settings.Font.fontcolor;

				if( settings.Font.stylefcolor_inUse != config.stylefcolor_inUse )
				{
					config.stylefcolor_inUse = settings.Font.stylefcolor_inUse;
				}
				
				if( config.stylefcolor_inUse )
					fontcolor_show = Style[config.StyleIndex].fcolor;
				else
					fontcolor_show = RGB_24To16( config.fontcolor );
						
				updateup_flag = true;
				updatedown_flag = true;

				pView->text_needrp = true;//ػ
			}
			
			if( Ret & bmFONTBGCOLOR )
			{
				config.fontbgcolor = settings.Font.fontbgcolor;

				if( settings.Font.stylefontbgcolor_inUse != config.stylefontbgcolor_inUse )
				{
					config.stylefontbgcolor_inUse = settings.Font.stylefontbgcolor_inUse;
				}
				
				if( config.stylefontbgcolor_inUse )
					fontbgcolor_show = Style[config.StyleIndex].bcolor;
				else
					fontbgcolor_show = RGB_24To16( config.fontbgcolor );
						
				updateup_flag = true;
				updatedown_flag = true;

				pView->text_needrp = true;//ػ
			}

			if( Ret & bmSTYLE )
			{
				updateup_flag = true;
				updatedown_flag = true;
				config.StyleIndex = settings.StyleIndex;
				
				if( config.stylefcolor_inUse )
				{	
					fontcolor_show = Style[config.StyleIndex].fcolor;
				}

				pView->text_needrp = true;//ػ
			}

			if( Ret & bmVERTREAD ) //Ķʽ
			{
				config.vertread = settings.ReadMode.vertread;
				recalcSize( &drperpage, &rowsperpage, &pixelsperrow );
				ShowLineHeight = scene_get_book_fontsize( bookfontindex ) + config.rowspace;
				updateup_flag = true;
				updatedown_flag = true;
				pView->text_needrf = true;//ض
				pView->text_needrp = true;//ػ
				pView->text_needrb = false;//ǩĵǰ
				Cur_Pos_start = (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf;

				if( config.vertread == conf_vertread_rvert )
				{
					Key_LEFT = KEY_UP;
					Key_RIGHT = KEY_DOWN;
					Key_UP = KEY_RIGHT;
					Key_DOWN = KEY_LEFT;
				}
				else if( config.vertread == conf_vertread_lvert )
				{
					Key_LEFT = KEY_DOWN;
					Key_RIGHT = KEY_UP;
					Key_UP = KEY_LEFT;
					Key_DOWN = KEY_RIGHT;
				}
				else
				{
					Key_LEFT = KEY_LEFT;
					Key_RIGHT = KEY_RIGHT;
					Key_UP = KEY_UP;
					Key_DOWN = KEY_DOWN;
				}
			}

			if( Ret & bmSCREENSELECT )//Ļѡ
			{
				config.ScreenUse = settings.ReadMode.ScreenUse;
				if( config.ScreenUse == SCREEN_UP )
				{
					up_sw = ON;
					down_sw = OFF;
				}
				else if( config.ScreenUse == SCREEN_DOWN )
				{
					up_sw = OFF;
					down_sw = ON;
				}
				else if( config.ScreenUse == SCREEN_DOUBLE )
				{
					up_sw = ON;
					down_sw = ON;
				}
				DS2_setBacklight( up_sw, down_sw );//
				updatetime_flag = true;
				updateup_flag = true;
				updatedown_flag = true;
				pView->text_needrp = true;//ػ
			}

			if( Ret & bmBRIGHTNESS )
			{
				config.brightness = settings.backlight.brightness;
			}

			if( Ret & bmBACKLIGHT )
			{
				config.BacklightUp = settings.backlight.BacklightUp;
				config.BacklightDown = settings.backlight.BacklightDown;
			}

			if( Ret )//ñ޸
				conf_save( &config );//

			updatedown_flag = true;
			pView->text_needrp = true;//ػ
		}
		KEY_BUF inputkey2;
		ds2_getrawInput( &inputkey2 );
		if( inputkey2.key == 0 )
			EnterMenuFlag = 0;
	}
	else if (key == Key_UP) //(key == ku)
	{
		move_line_up(&cur_book_view, 1);
	}
	else if (key == Key_DOWN)//(key == kd)
	{
		move_line_down(&cur_book_view, 1);
	}
	else if (key == Key_LEFT) //(key == kl)
	{
		if (config.vertread == conf_vertread_reversal)
		{
			if (move_page_down(&cur_book_view, selidx, 1))
				goto _book_handle_input_Exit;
		}
		else
		{
			if (move_page_up(&cur_book_view, selidx, 1))
				goto _book_handle_input_Exit;
		}
	}
	else if (key == Key_RIGHT)//(key == kr)
	{
		if ( config.vertread == conf_vertread_reversal )
		{
			if (move_page_up(&cur_book_view, selidx, 1))
				goto _book_handle_input_Exit;
		}
		else
		{
			if ( move_page_down( &cur_book_view, selidx, 1 ) )
				goto _book_handle_input_Exit;
		}
	}
#if 0
	else if( key & KEY_X && key & Key_LEFT && !(key & ~(KEY_X | Key_LEFT) ) )//Ϸ10ҳ
	{
		if (config.vertread == conf_vertread_reversal)
			move_page_down( &cur_book_view, selidx, 10 );
		else
			move_page_up( &cur_book_view, selidx, 10 );
	}
	else if( key & KEY_X && key & Key_RIGHT && !(key & ~(KEY_X | Key_RIGHT) ) )//·10ҳ
	{
		if (config.vertread == conf_vertread_reversal)
			move_page_up( &cur_book_view, selidx, 10 );
		else
			move_page_down( &cur_book_view, selidx, 10 );
	}
	else if( key & KEY_X && key & Key_UP && !(key & ~(KEY_X | Key_UP) ) )//Ϸ100
	{
		if (config.vertread == conf_vertread_reversal)
			move_line_down(&cur_book_view, 100);
		else
			move_line_up(&cur_book_view, 100);
	}
	else if( key & KEY_X && key & Key_DOWN && !(key & ~(KEY_X | Key_DOWN) ) )//·100
	{
		if (config.vertread == conf_vertread_reversal)
			move_line_up(&cur_book_view, 100);
		else
			move_line_down(&cur_book_view, 100);
	}
#endif
	else if( key & KEY_R && key & Key_LEFT && !(key & ~(KEY_R | Key_LEFT) ) )//ıʼ
	{
		if (config.vertread == conf_vertread_reversal)
			move_line_to_end(&cur_book_view);
		else
			move_line_to_start(&cur_book_view);
	}
	else if( key & KEY_R && key & Key_RIGHT && !(key & ~(KEY_R | Key_RIGHT) ) )//ıĩβ
	{
		if (config.vertread == conf_vertread_reversal)
			move_line_to_start(&cur_book_view);
		else
			move_line_to_end(&cur_book_view);
	}
//-------------------------------------------------------------------------------
#if 0
	else if( key & KEY_L && !(key & ~KEY_L) )//һı
	{
		dword orgidx = *selidx;

		if (config.autobm)
			bookmark_autosave(pView->bookmarkname,
							  (fs->rows[fs->crow >> 10] +
							   (fs->crow & 0x3FF))->start - fs->buf);
		do
		{
			if (*selidx > 0)
				(*selidx)--;
			else
				*selidx = filecount - 1;
		} while (!fs_is_txtbook((t_fs_filetype) filelist[*selidx].data));

		if (*selidx != orgidx)
		{
			if (config.autobm)
				bookmark_autosave(pView->bookmarkname,
								  (fs->rows[fs->crow >> 10] +
								   (fs->crow & 0x3FF))->start - fs->buf);
			pView->text_needrf = pView->text_needrp = true;
			pView->text_needrb = false;
			pView->rrow = INVALID;
		}
		ctrl_waitrelease( key );
	}
	else if( key & KEY_R && !(key & ~KEY_R) )//һı
	{
		dword orgidx = *selidx;

		do
		{
			if (*selidx < filecount - 1)
				(*selidx)++;
			else
				*selidx = 0;
		} while (!fs_is_txtbook((t_fs_filetype) filelist[*selidx].data));

		if (*selidx != orgidx)
		{
			if (config.autobm)
				bookmark_autosave(pView->bookmarkname,
								  (fs->rows[fs->crow >> 10] +
								   (fs->crow & 0x3FF))->start - fs->buf);
			pView->text_needrf = pView->text_needrp = true;
			pView->text_needrb = false;
			pView->rrow = INVALID;
		}
		ctrl_waitrelease( key );
	}
#endif
	else if( key & KEY_R && !(key & ~KEY_R) && config.vertread == conf_vertread_rvert )//ʱR·ҳ
	{
		if ( move_page_down( &cur_book_view, selidx, 1 ) )
			goto _book_handle_input_Exit;
	}
//-------------------------------------------------------------------------------
	else
	{
		pView->text_needrp = pView->text_needrb = pView->text_needrf = false;
	}
_book_handle_input_Exit:
	return -1;
}

dword scene_readbook( dword selidx )
{
	//------------ֲ-----------------------
	RTC rtc;
	vu8 hours;		//0 to 11 for AM, 52 to 63 for PM
    vu8 minutes;	//0 to 59
    vu8 seconds;	//0 to 59
	BOOL Update_Navigation = false;
	BOOL Reupdate_Navigation_Time_Flag = 0;
	U8 Reupdate_Navigation_Time = 0;

	int ret = -1;
	KEY_BUF inputkey;
	bool KeyPressFlag = false;
	bool Need_Reset_Key = true;


#define		DELAY_GRADE_MAX			1000
#define		DELAY_COUNT_BASE		(600000 / 2 / DELAY_GRADE_MAX)

	new_book_view( &cur_book_view );

	if( SlideBufMain == NULL )
		SlideBufMain = memalign( sizeof( pixel ), sizeof( pixel ) * NAVIGATION_W * NAVIGATION_H );
	if( SlideBufSub == NULL )
		SlideBufSub = memalign( sizeof( pixel ), sizeof( pixel ) * NAVIGATION_W * NAVIGATION_H );

	if( VramTemp == NULL )
		VramTemp = memalign( sizeof( pixel ), sizeof( pixel ) * SCREEN_W * SCREEN_H * 2 );

	STRCPY_S( FilenameCur, filelist[selidx].name );

	ds2_getTime( &rtc );
	hours = rtc.hours;
	minutes = rtc.minutes;
	seconds = rtc.seconds;

	neeprlogo = 0;

	down_sw = ON;
	up_sw = ON;
	updateup_flag = true;
	updatedown_flag = true;
	updatetime_flag = true;
	Cur_Pos_start = 0;

	SlideCurTouchPos.x = -1;
	SlideCurTouchPos.y = -1;

	if( config.ScreenUse == SCREEN_UP )
	{
		down_sw = OFF;
	}
	else if( config.ScreenUse == SCREEN_DOWN )
	{
		up_sw = OFF;
	}
	DS2_setBacklight( up_sw, down_sw );
	updatetime_flag = true;

	if( bookfontindex != bookfontindex_cur )
	{
		if( scene_load_book_font( bookfontindex ) )//ָ
			recalcSize(&drperpage, &rowsperpage, &pixelsperrow);
	}

	if( config.vertread == conf_vertread_rvert )
	{
		Key_LEFT = KEY_UP;
		Key_RIGHT = KEY_DOWN;
		Key_UP = KEY_RIGHT;
		Key_DOWN = KEY_LEFT;
	}
	else if( config.vertread == conf_vertread_lvert )
	{
		Key_LEFT = KEY_DOWN;
		Key_RIGHT = KEY_UP;
		Key_UP = KEY_LEFT;
		Key_DOWN = KEY_RIGHT;
	}
	else
	{
		Key_LEFT = KEY_LEFT;
		Key_RIGHT = KEY_RIGHT;
		Key_UP = KEY_UP;
		Key_DOWN = KEY_DOWN;
	}

	ShowLineHeight = scene_get_book_fontsize( bookfontindex ) + config.rowspace;

	EnterMenuFlag = false;
//	memcpyword( bufferMain, COLOR_WHITE, SCREEN_W*SCREEN_H );
//	Flush( DOWN_SCREEN );

	if( config.fontcolor > 0 && config.stylefcolor_inUse == false )
	{
		fontcolor_show = RGB_24To16( config.fontcolor );
	}
	else
	{
		fontcolor_show = Style[config.StyleIndex].fcolor;
	}
	
	if( config.fontbgcolor > 0 && config.stylefontbgcolor_inUse == false )
	{
		fontbgcolor_show = RGB_24To16( config.fontbgcolor );
	}
	else
	{
		fontbgcolor_show = Style[config.StyleIndex].bcolor;
	}

	while (1)
	{
		if ( cur_book_view.text_needrf ) //ǷҪȡı
		{
			if( scene_book_reload(&cur_book_view, selidx) )
			{
				goto _scene_readbook_Exit;
			}
			cur_book_view.text_needrf = false;

			if( fs->size <= 0 )
			{
				scene_printbook(&cur_book_view, selidx);
				ret = DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char *)lang_item[LANG_FILEEMPTY_ID], DOWN_SCREEN, MB_OK, true );
				goto __scene_readbook_Exit0;
			}
			if( cur_code_type == CODETYPE_DEFAULT )
			{
				scene_printbook(&cur_book_view, selidx);
				ret = DrawMessageBox( lang_Notice, CENTER_ALIGN, (const char *)lang_item[LANG_FILEENCODE_ID], DOWN_SCREEN, MB_OK, true );
				goto __scene_readbook_Exit0;
			}
		}
		if (cur_book_view.text_needrp) //ǷҪӡı
		{
			scene_printbook(&cur_book_view, selidx);
			cur_book_view.text_needrp = false;

			Update_Scrollbar( 0 );
			Reupdate_Navigation_Time_Flag = true;
//-------------------------------------------------------------------------------------
		}
		do
		{
			ds2_getrawInput( &inputkey );

			if( inputkey.key == 0 )
			{	
				Need_Reset_Key = true;
			}

			Proc_SysKeyCheck( inputkey.key );
			Proc_TouchPad( inputkey );

			if( !inputkey.key && EnterMenuFlag == true )
				EnterMenuFlag = false;

			if( inputkey.key != KEY_TOUCH )
			{
				KeyPressFlag = Proc_GetInputAcc( &inputkey, 450, 10, KEY_UP|KEY_DOWN|KEY_LEFT|KEY_RIGHT|KEY_R, 5, true, Need_Reset_Key  );//input_repeat_time
				Need_Reset_Key = false;
			}
			else
			{
				KeyPressFlag = true;
			}


			ds2_getTime( &rtc );
			if( updatetime_flag )
			{
				seconds = rtc.seconds;
				updatetime_flag = false;
			}

			if( Reupdate_Navigation_Time_Flag )
			{
				Reupdate_Navigation_Time = rtc.seconds;
				Reupdate_Navigation_Time_Flag = false;
				Update_Navigation = true;
			}

			if( inputkey.key == 0 )
			{
				if( Update_Navigation )
				{
					if( ( (rtc.seconds < 57) && (rtc.seconds > ( (Reupdate_Navigation_Time + 3) % 60 )) ) || ( (rtc.seconds >= 57) && (rtc.seconds > (Reupdate_Navigation_Time + 3)) ) )
					{
						Update_Scrollbar( 1 );
						Update_Navigation = false;
					}
				}

				if( config.ScreenUse == SCREEN_UP )
				{
					if( ( (rtc.seconds < 57) && (rtc.seconds >= ( (seconds + 3) % 60 )) ) || ( (rtc.seconds >= 57) && (rtc.seconds >= (seconds + 3)) ) )
					{
						TurnOff_down();//
						updatetime_flag = true;
					}
				}
			}
			else if( ( inputkey.key & ( KEY_A || KEY_B || KEY_Y || KEY_SELECT || KEY_TOUCH ) ) && down_sw == OFF )
			{
				if( down_sw == OFF )
				{
					updatetime_flag = true;
				}
			}

		}while( inputkey.key == 0 || KeyPressFlag == false );

		if( EnterMenuFlag == true )
		{
			EnterMenuFlag = false;
			ctrl_waitrelease_anykey();
		}
		else
			ret = book_handle_input( &cur_book_view, &selidx, &inputkey );

		if( ret == -2 )
		{
			break;
		}
		updatetime_flag = true;
	}

	if ( config.autobm )
		bookmark_autosave( cur_book_view.bookmarkname, (fs->rows[fs->crow >> 10] + (fs->crow & 0x3FF))->start - fs->buf );//Ĳкŵַǵǰеַ0ַĲֵ

__scene_readbook_Exit0:
	text_close(fs);

	if( fs )
	{
		free( (void*)fs );
		fs = NULL;
	}

_scene_readbook_Exit:

	if( SlideBufMain )
	{
		free( SlideBufMain );
		SlideBufMain = NULL;
	}
	if( SlideBufSub == NULL )
	{
		free( SlideBufSub );
		SlideBufSub = NULL;
	}
	if( VramTemp == NULL )
	{
		free( VramTemp );
		VramTemp = NULL;
	}


	if( StyleBuf  )
	{
		free( StyleBuf );
		StyleBuf = NULL;
		neeprlogo = 0;
	}

	if( down_sw == OFF || up_sw == OFF )
	{
		down_sw = ON;
		up_sw = ON;
		DS2_setBacklight( up_sw, down_sw );//
	}

	if( gbk_ucs_tbl )
	{
		free( gbk_ucs_tbl );
		gbk_ucs_tbl = NULL;
	}

	if( big5_ucs_tbl )
	{
		free( big5_ucs_tbl );
		big5_ucs_tbl = NULL;
	}

	if( sjis_ucs_tbl )
	{
		free( sjis_ucs_tbl );
		sjis_ucs_tbl = NULL;
	}

	return selidx;
}

p_textrow scene_book_LookupBuffer( U32 row )
{
	int crow = 1;
	p_textrow tr;
	if( fs == NULL )
	{
		return NULL;
	}
	while ( crow < fs->row_count && (fs->rows[crow >> 10] + (crow & 0x3FF))->start - fs->buf <= row )//ͨǩļļƫҵǰк
		crow++;
	crow--;

	tr = fs->rows[crow >> 10] + (crow & 0x3FF);

	return tr;
}

U32 scene_book_WordToRow( U32 Wordoffset )
{
	int crow = 1;
	if( fs == NULL )
	{
		return 0;
	}

	while ( crow < fs->row_count && (fs->rows[crow >> 10] + (crow & 0x3FF))->start - fs->buf <= Wordoffset )//ͨǩļļƫҵǰк
		crow++;
	crow--;
	return crow;
}

U16 scene_book_GetPercentage( U32 RowCur, COMPAREMODE CmpMode ) //ȡٷֱȣ10000
{
	U16 percent;

	if( fs == NULL || fs->row_count == 0 )
		return 0;

	if( CmpMode == ROWMODE )//Ƚ
	{
		percent = ( RowCur ) * 10000 / fs->row_count; //100
	}
	else//Ƚϣβ֮Ŀո
	{
		p_textrow tr = fs->rows[( fs->row_count-1 ) >> 10] + ( (fs->row_count-1) & 0x3FF );
		U32 temp = tr->start - fs->buf + (U32)tr->count;
		percent = RowCur * 10000 / temp;
	}

	if( percent > 10000 )
		percent = 10000;
	return percent;
}

POS GetSlidePos( void )
{
	POS rect;


	if( config.vertread == conf_vertread_rvert )
	{
		rect.x = SCREEN_W - ( TXT_SLIDE_X + TXT_SLIDE_W );
	}
	else// if( config.vertread == conf_vertread_horz || config.vertread == conf_vertread_lvert )
	{
		rect.x = TXT_SLIDE_X;
	}

	if( config.vertread == conf_vertread_lvert )
	{
		if( SlideCurTouchPos.y == -1 )
		{
			if( fs->row_count != 0 )
				rect.y = TXT_SLIDE_MAX_Y - (TXT_SLIDE_MAX_Y - TXT_SLIDE_Y) * fs->crow / fs->row_count;
			else
				rect.y = TXT_SLIDE_Y;
		}
		else
		{
			rect.y = SlideCurTouchPos.y;
		}
	}
	else
	{
		if( SlideCurTouchPos.y == -1 )
		{
			if( fs->crow == 0 || fs->row_count == 0 )
				rect.y = 0;
			else
				rect.y = TXT_SLIDE_H + (TXT_SLIDE_MAX_Y - TXT_SLIDE_H) * fs->crow / fs->row_count;
		}
		else
		{
			rect.y = SlideCurTouchPos.y;
		}
	}

	if( rect.y > TXT_SLIDE_MAX_Y )
		rect.y = TXT_SLIDE_MAX_Y;
	else if( rect.y < (TXT_SLIDE_Y) )
		rect.y = TXT_SLIDE_Y ;

	SlideCurTouchPos.y = -1;

	return rect;
}


void DrawSlideBar( POS SlidePos, BOOL TransparentFlag, SCREEN_ID engine )//
{
#define		T1		( 600 ) //1000 //ǰɫϵ
#define		T2		( 500 ) //1000 //ǰɫϵ

#define		NAVIGATION_COLOR_IN_BLACKBG			RGB( 128, 255, 0 )//Ϊɫʱʹ
#define		SLIDE_COLOR_IN_BLACKBG				RGB( 0, 0, 255 )//Ϊɫʱʹ

#define		NAVIGATION_COLOR_IN_WHITEBG			RGB( 0, 0, 0 )//Ϊɫʱʹ
#define		SLIDE_COLOR_IN_WHITEBG				RGB( 128, 255, 128 )//Ϊɫʱʹ

#define		NAVIGATION_COLOR_IN_NORNAL			RGB( 0, 0, 0 )
#define		SLIDE_COLOR_IN_NORNAL				RGB( 255, 255, 255 )

	pixel *Vram = GetVram( engine );
	int x1,y1,x2,y2,x,y;
	pixel R,G,B,R1,G1,B1,R2,G2,B2;
	pixel SlideColor, SlideBarColor;

//	POS SlidePos = GetSlidePos();
	x = SlidePos.x;
	y = SlidePos.y;

	//
//	if( FLNavigationBuf_Ready == true )
	{
		for( y1 = TXT_NAVIGATION_Y, y2 = 0; y2 < NAVIGATION_H; y1++, y2++ )
		{
			for( x1 = x, x2 = 0; x2 < NAVIGATION_W; x1++, x2++ )
			{

				SlideBarColor = Slide[config.StyleIndex].SlideBarColor;

				if( TransparentFlag == true )
				{
					R1 = RGB_R( Vram[y1*SCREEN_W+x1] );
					G1 = RGB_G( Vram[y1*SCREEN_W+x1] );
					B1 = RGB_B( Vram[y1*SCREEN_W+x1] );

					R2 = RGB_R( SlideBarColor );
					G2 = RGB_G( SlideBarColor );
					B2 = RGB_B( SlideBarColor );

					R = ( R1 * T1 + R2 * ( 1000 - T1 ) )  / 1000;
					G = ( G1 * T1 + G2 * ( 1000 - T1 ) )  / 1000;
					B = ( B1 * T1 + B2 * ( 1000 - T1 ) )  / 1000;

					Vram[y1*SCREEN_W+x1] = RGB15( R,G,B );
				}
				else
				{
					Vram[y1*SCREEN_W+x1] = SlideBarColor;
				}
			}
		}
	}

	//
//	if( FLSlideBuf_Ready == true )
	{
		for( y1 = y, y2 = 0; y2 < TXT_SLIDE_H; y1++, y2++ )
		{
			for( x1 = x, x2 = 0; x2 < TXT_SLIDE_W; x1++, x2++ )
			{
				SlideColor = Slide[config.StyleIndex].SlideColor;

				if( TransparentFlag == true )
				{
					R1 = RGB_R( Vram[y1*SCREEN_W+x1] );
					G1 = RGB_G( Vram[y1*SCREEN_W+x1] );
					B1 = RGB_B( Vram[y1*SCREEN_W+x1] );

					R2 = RGB_R( SlideColor );
					G2 = RGB_G( SlideColor );
					B2 = RGB_B( SlideColor );

					R = ( R1 * T2 + R2 * ( 1000 - T2 ) )  / 1000;
					G = ( G1 * T2 + G2 * ( 1000 - T2 ) )  / 1000;
					B = ( B1 * T2 + B2 * ( 1000 - T2 ) )  / 1000;

					Vram[y1*SCREEN_W+x1] = RGB15( R,G,B );
				}
				else
				{
					Vram[y1*SCREEN_W+x1] = SlideColor;
				}
			}
		}
	}

	SlideCurTouchPos.x = -1;
	SlideCurTouchPos.y = -1;
}

void Update_Scrollbar( int flag )//0:ԭʼ沢(ݵǰк)޹ɫ1:ɫ
{
	pixel *Vram = NULL;
	POS SlidePos = GetSlidePos();
	if( SlidePos.x >= SCREEN_W )
		return;
//-------------------------------------------------------------------------------------
	if( flag == 0 )
	{
		if( (!(config.ScreenUse == SCREEN_UP && down_sw == OFF)) || updatedown_flag == true )
		{
			Vram = GetVram( DOWN_SCREEN );
			if( SlideBufMain )
				bitBlt2( Vram, SCREEN_W, SCREEN_H, SlidePos.x, TXT_NAVIGATION_Y, SlideBufMain, NAVIGATION_W, NAVIGATION_H, 0, 0 );
			DrawSlideBar( SlidePos, false, DOWN_SCREEN );
			Flush( DOWN_SCREEN );
		}

		if( config.ScreenUse == SCREEN_UP )//|| updateup_flag == true )
		{
			Vram = GetVram( UP_SCREEN );
			if( SlideBufSub )
				bitBlt2( Vram, SCREEN_W, SCREEN_H, SlidePos.x, TXT_NAVIGATION_Y, SlideBufSub, NAVIGATION_W, NAVIGATION_H, 0, 0 );
			DrawSlideBar( SlidePos, false, UP_SCREEN );
			Flush( UP_SCREEN );
		}

		if( config.ScreenUse == SCREEN_DOUBLE || updateup_flag == true )
			Flush( UP_SCREEN );

		updateup_flag = false;
		updatedown_flag = false;
	}

	if( flag == 1 )
	{
		if( config.ScreenUse == SCREEN_DOWN || config.ScreenUse == SCREEN_DOUBLE || down_sw == ON )
		{
			Vram = GetVram( DOWN_SCREEN );
			if( SlideBufMain )
				bitBlt1( SlideBufMain, NAVIGATION_W, NAVIGATION_H, Vram, SCREEN_W, SCREEN_H, SlidePos.x, TXT_NAVIGATION_Y );
			DrawSlideBar( SlidePos, true, DOWN_SCREEN );
			Flush( DOWN_SCREEN );
		}

		if( config.ScreenUse == SCREEN_UP )
		{
			Vram = GetVram( UP_SCREEN );
			bitBlt1( SlideBufSub, NAVIGATION_W, NAVIGATION_H, Vram, SCREEN_W, SCREEN_H, SlidePos.x, TXT_NAVIGATION_Y );
			DrawSlideBar( SlidePos, true, UP_SCREEN );
			Flush( UP_SCREEN );
		}
	}
}


void TurnOn_up( void )
{
	if( up_sw == OFF )
	{
		up_sw = ON;
		DS2_setBacklight( up_sw, down_sw );//
	}
}

void TurnOff_up( void )
{
	if( up_sw == ON )
	{
		up_sw = OFF;
		DS2_setBacklight( up_sw, down_sw );//
	}
}

void TurnOn_down( void )
{
	if( down_sw == OFF )
	{
		down_sw = ON;
		DS2_setBacklight( up_sw, down_sw );//
	}
}

void TurnOff_down( void )
{
	if( down_sw == ON )
	{
		down_sw = OFF;
		DS2_setBacklight( up_sw, down_sw );//
	}
}

static void ConvToRow( s32 y )
{
	if( y < TXT_SLIDE_Y )
		y = TXT_SLIDE_Y;
	else if( y > TXT_SLIDE_MAX_Y )
		y = TXT_SLIDE_MAX_Y;

	if( config.vertread == conf_vertread_lvert )
	{
		fs->crow = (TXT_SLIDE_MAX_Y - y) * fs->row_count / (TXT_SLIDE_MAX_Y - TXT_SLIDE_Y);
	}
	else
	{
		if( y < TXT_SLIDE_H )
			SlideCurTouchPos.y = 0;
		else if( y > TXT_SLIDE_MAX_Y )
			SlideCurTouchPos.y = TXT_SLIDE_MAX_Y;

		if( y < TXT_SLIDE_H )
			y = TXT_SLIDE_H;
		else if( y > TXT_SLIDE_MAX_Y )
			y = TXT_SLIDE_MAX_Y;
		fs->crow = (y - TXT_SLIDE_H) * fs->row_count / (TXT_SLIDE_MAX_Y - TXT_SLIDE_H);
	}
	if( fs->crow >= fs->row_count )
		fs->crow = fs->row_count - 1;
	cur_book_view.text_needrp = true;
	updatetime_flag = true;
}

static void CB_MouseDown(s32 x,s32 y)
{
	mbodyf=false;

//	if( key == KEY_TOUCH )
	{
		if( config.vertread == conf_vertread_rvert )
		{
			s32 xtemp = SCREEN_W - ( TXT_SLIDE_X + TXT_SLIDE_W );
			if( x <= (xtemp + TXT_SLIDE_W + 10) )
			{
				mscrf = true;
				ConvToRow( y );
				return;
			}
		}
		else// if( config.vertread == conf_vertread_horz || config.vertread == conf_vertread_lvert )
		{
			s32 xtemp = TXT_SLIDE_X;
			if( x >= (xtemp - 10) )
			{
				ConvToRow( y );
				mscrf = true;
				return;
			}
		}
	}
	mbodyf=true;
	mbodyy=y;
	mbodyx=x;
}

static void CB_MouseMove(s32 x,s32 y)
{
	if(mscrf==true)//⵼Ƿ񱻴
	{
		ConvToRow( y );
		return;
	}
	if(mbodyf==true)
	{
	    s32 h=ShowLineHeight/2;
	    s32 mv;
	    s32 v=0;
	    if( config.vertread == conf_vertread_rvert )
	    {
	    	mv=x-mbodyx;
	    	while(h<=mv)// ·
		   	{
				v++;
				mv-=h;//뵽
				mbodyx+=h;
		    }
		    while(mv<=-h)// Ϸ
		    {
				v--;
				mv+=h;//뵽
				mbodyx-=h;
		    }
	    }
	    else
	    {
	    	mv=y-mbodyy;
		    while(mv<=-h)//
		   	{
				v++;
				mv+=h;//뵽
				mbodyy-=h;
		    }
		    while(h<=mv)//
		    {
				v--;
				mv-=h;//뵽
				mbodyy+=h;
		    }
		}

	    if(v!=0)
	    {
	    	s32 CurrentLineIndex = GetCurrentLineIndex();

	    	if( v < 0 )
	    	{
				if( abs( v ) > CurrentLineIndex )
					return;
	    	}

			SetCurrentLineIndex(CurrentLineIndex+v);
			DrawCurrentText_Main();
			RedrawSubScreen();
			ScreenMain_Flip_ProcFadeEffect( x,y );
	    }
	}
}

static void CB_MouseUp(s32 x,s32 y)
{
	mscrf = false;
	mbodyf=false;
	mbodyx=0;
	mbodyy=0;
}

static void Proc_TouchPad( KEY_BUF inputkey )
{
	BOOL tpress;
  	s32 tx,ty;

  	SlideCurTouchPos.x = -1;
	SlideCurTouchPos.y = -1;

  	if( (inputkey.key & KEY_TOUCH) == 0 )
  	{
    	tpress=false;
    	tx=0;
    	ty=0;
   	}
   	else
   	{
   		if( down_sw == OFF )
		{
			ctrl_waitrelease( inputkey.key );
			TurnOn_down();//
			updatetime_flag = true;
			return;
		}

    	tpress=true;
    	tx=inputkey.x;
    	ty=inputkey.y;
  	}

  if(tpress==true){
    if(mf==false){
      mf=true;
      CB_MouseDown(tx,ty);
      mx=tx;
      my=ty;
      }else{
      s32 dx=abs(mx-tx);
      s32 dy=abs(my-ty);
      if((1<=dx)||(1<=dy)){
        CB_MouseMove(tx,ty);
        mx=tx;
        my=ty;
      }
    }
    }else{
    if(mf==true){
      mf=false;
      CB_MouseUp(mx,my);
    }
  }
}

static U32 GetCurrentLineIndex(void)
{
	return (fs->crow);
}

static void SetCurrentLineIndex(s32 lineidx)
{
	fs->crow = (U32)lineidx;
	if( fs->crow >= fs->row_count )
	{
	    fs->crow = fs->row_count - 1;
	}
}

static void DrawCurrentText_Main(void)
{
	if( config.StyleIndex < STYLELOGO_COUNT )
	{
		if( config.ScreenUse == SCREEN_DOUBLE )
		{
			bufferTemp = VramTemp;
//			disp_fillvram( Style[config.StyleIndex].bcolor, VRAMTEMP );
			disp_fillvram( fontbgcolor_show, VRAMTEMP );
			bufferTemp = VramTemp + SCREEN_H * SCREEN_W;
//			disp_fillvram( Style[config.StyleIndex].bcolor, VRAMTEMP );
			disp_fillvram( fontbgcolor_show, VRAMTEMP );
		}
		else
		{
			bufferTemp = VramTemp;
//			disp_fillvram( Style[config.StyleIndex].bcolor, VRAMTEMP );
			disp_fillvram( fontbgcolor_show, VRAMTEMP );
		}
	}
	else if( neeprlogo & BIT( config.StyleIndex ) )
	{
		if( VramTemp )
		{
			if( config.ScreenUse == SCREEN_DOUBLE )
			{
				bitBlt( StyleBuf, SCREEN_W, SCREEN_H, VramTemp, SCREEN_W, SCREEN_H );
				bitBlt( StyleBuf, SCREEN_W, SCREEN_H, VramTemp + SCREEN_H * SCREEN_W, SCREEN_W, SCREEN_H );
			}
			else
				bitBlt( StyleBuf, SCREEN_W, SCREEN_H, VramTemp, SCREEN_W, SCREEN_H );
		}
	}

	if( config.vertread == conf_vertread_rvert )
	{
		if( config.ScreenUse == SCREEN_DOUBLE )
		{
			bufferTemp = VramTemp;
			scene_printtext_rvert_vram( &cur_book_view, fs->crow, 0 );
			bufferTemp = VramTemp + SCREEN_H * SCREEN_W;
			scene_printtext_rvert_vram( &cur_book_view, fs->crow+rowsperpage, 0 );
		}
		else
		{
			bufferTemp = VramTemp;
			scene_printtext_rvert_vram( &cur_book_view, fs->crow, 0 );
		}
	}
	else
	{
		if( config.ScreenUse == SCREEN_DOUBLE )
		{
			bufferTemp = VramTemp;
			scene_printtext_horz_vram( &cur_book_view, fs->crow, 0 );
			bufferTemp = VramTemp + SCREEN_H * SCREEN_W;
			scene_printtext_horz_vram( &cur_book_view, fs->crow+rowsperpage, 0 );
		}
		else
		{
			bufferTemp = VramTemp;
			scene_printtext_horz_vram( &cur_book_view, fs->crow, 0 );
		}
	}
	bufferTemp = NULL;


	Update_Scrollbar( 0 );
}

static void RedrawSubScreen(void)
{


}

static void ScreenMain_Flip_ProcFadeEffect(s32 x,s32 y)
{
	if( config.ScreenUse == SCREEN_DOWN )
		LoadVram( VramTemp + 0 * SCREEN_W, DOWN_SCREEN );
	else if( config.ScreenUse == SCREEN_UP )
		LoadVram( VramTemp + 0 * SCREEN_W, UP_SCREEN );
	else
	{
		LoadVram( VramTemp + 0 * SCREEN_W, UP_SCREEN );
		LoadVram( VramTemp + SCREEN_H * SCREEN_W, DOWN_SCREEN );
	}
}
