#ifndef __SCENE_TEXT_H
#define __SCENE_TEXT_H

#include <datatype.h>
#include <scene_impl.h>
#include <MainMenuSettings.h>
#include <conf.h>

extern t_conf_encode Text_encode_cur;
extern BOOL up_sw;
extern BOOL down_sw;

//enum EProcFadeEffect {EPFE_None,EPFE_LeftToRight,EPFE_RightToLeft,EPFE_UpToDown,EPFE_DownToUp,EPFE_CrossFade,EPFE_FastCrossFade};
enum{
	EPFE_None = 0,
	EPFE_LeftToRight,
	EPFE_RightToLeft,
	EPFE_UpToDown,
	EPFE_DownToUp,
	EPFE_CrossFade,
	EPFE_FastCrossFade
};

typedef enum{
	ROWMODE = 0,
	WORDMODE
}COMPAREMODE;

typedef struct{
	pixel SlideBarColor;
	pixel SlideColor;
}SLIDE_t;

extern char FilenameCur[255];
extern char bookmarknameCur[255];
extern U32 bookmarkrowCur;
extern BookViewData cur_book_view;
extern U32 edge_distance_y;

extern U32 LeftMargin;
extern U32 RightMargin;
extern U32 TopMargin;
extern U32 BottomMargin;

void scene_book_Initbg();
p_textrow scene_book_LookupBuffer( U32 row );
U32 scene_book_WordToRow( U32 Wordoffset );
U16 scene_book_GetPercentage( U32 RowCur, COMPAREMODE CmpMode );
POS GetSlidePos( void );
void DrawSlideBar( POS SlidePos, BOOL TransparentFlag, SCREEN_ID engine );
void Update_Scrollbar( int flag );
//static void scene_printtext_horz_vram( PBookViewData pView, int crow, int mrow );
//static void scene_printtext_rvert_vram( PBookViewData pView, int crow, int mrow );

void TurnOn_up( void );
void TurnOff_up( void );
void TurnOn_down( void );
void TurnOff_down( void );

int Proc_Fontdecode( byte **out, int *outLength, const byte *in, int inLength );

//static void CB_MouseDown(s32 x,s32 y);
//static void CB_MouseMove(s32 x,s32 y);
//static void CB_MouseUp(s32 x,s32 y);	
//static void Proc_TouchPad( KEY_BUF inputkey );
//static U32 GetCurrentLineIndex(void);
//static void SetCurrentLineIndex(s32 lineidx);
//static void RedrawSubScreen(void);
//static void DrawCurrentText_Main(void);
//static void ScreenMain_Flip_ProcFadeEffect(s32 x,s32 y);

#endif //__SCENE_TEXT_H
